unit Dbwin32u; { 05-JUL-97 as/Frank Gamerdinger }
{ 16-Bit-Programm, das von 32-Bit-Programmen ausgegebene
  WM_SETTEXT-Botschaften ber outputDebugString an DBWin
  weiterleitet. Der Handle des programmeigenen Fensters ist
  ber eine Property des Desktop-Fensters erreichbar. }
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls;

type
  TDBWin32Form = class(TForm)
    NotifyTimer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure NotifyTimerTimer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  protected
    Initialized: Boolean; { True: WM_SETTEXT weiterleiten }
    procedure WMSetText(var Msg: TMessage); message WM_SETTEXT;
  end;

var DBWin32Form: TDBWin32Form;
const DBWin32PropName = 'DBWin32-Handle';

implementation

{$R *.DFM}

procedure TDBWin32Form.FormCreate(Sender: TObject);
begin
  if GetProp(GetDesktopWindow,DBWin32PropName) <> 0
    then Halt; { bereits geladen }
  { Minifensterchen fr drei Sekunden - weitere Hinweise
    auf das Vorhandensein dieses Programms gibt's nicht }
  BorderStyle := bsSingle; BorderIcons := [];
  SetBounds(Screen.Width-300,0,300,0);
  Caption := 'DBWin32 - Frank Gamerdinger/Arne Schpers';
  if not SetProp(GetDesktopWindow, DBWin32PropName, Handle) then
  begin
    ShowMessage('DesktopWindow-Property '+DBWin32PropName+
      ' lt sich nicht setzen!');
    Halt;
  end;
  Initialized := True; { WM_SETTEXT weiterleiten }
  NotifyTimer.Interval := 3000;
end;

procedure TDBWin32Form.NotifyTimerTimer(Sender: TObject);
begin
  NotifyTimer.Free;
  { Fenster komplett verschwinden lassen (auch aus ALT+TAB) }
  Visible := False;
  ShowWindow(Application.Handle,SW_HIDE);
end;

procedure TDBWin32Form.FormDestroy(Sender: TObject);
begin
  if Initialized then
    RemoveProp(GetDesktopWindow, DBWin32PropName);
end;

procedure TDBWin32Form.WMSetText(var Msg: TMessage);
begin
  if not Initialized then inherited  { Caption := '...' }
   else if Msg.lParam <> 0
     then outputDebugString(PChar(Msg.lParam));
end;

end.

