unit DBW32; { 05-AUG-97 as/Frank Gamerdinger }
{ 32-Bit-Variante von outputDebugString, die Meldungen ber
  das 16-Bit-Programm DBWin32 an DBWin sendet }

interface
uses Windows, SysUtils, Messages;

procedure outputDebugString(Msg: PChar);
procedure outputDebugFormat(Fmt: String; Data: Array of const);

implementation
{ Unter diesem Namen ist das (16-Bit-)Fenster von DBWin32
  als Property des Desktop-Fensters eingetragen }
const DBWin32PropName = 'DBWin32-Handle';
var DBWin32Window: HWnd;

procedure outputDebugString(Msg: PChar);
begin
  if DBWin32Window <> 0 then
    SendMessage(DBWin32Window,WM_SETTEXT,0,LongInt(Msg));
end;

procedure outputDebugFormat(Fmt: String; Data: Array of const);
begin
  outputDebugString(PChar(Format(Fmt,Data)));
end;

initialization
  { GetProp liefert 0, wenn die Property nicht vorhanden ist }
  DBWin32Window := GetProp(GetDesktopWindow,DBWin32PropName);
end.
 