library ShHook;  { Datei ShHook.DPR - 08-FEB-97, Arne Schpers
 DLL fr die Komponente THookedApplication:
 - Anmelden eines Hilfsfensters als Empfnger fr PostMessage
   bei WH_SHELL-Ereignissen. Die erste Anmeldung setzt den Hook.
 - Abmelden eines Hilfsfensters. Die letzte Abmeldung entfernt
   den Hook.
 - Rckruffunktion fr Shell-Hooks (InternalHookProc). Diese
   Funktion mu bei Win32 in einer DLL sein, wenn sie system-
   weit anwendbar sein soll. InternalHookProc reicht WH_SHELL-
   Ereignisse per PostMessage an die angemeldeten Fenster
   weiter.
}

uses
  SysUtils, Classes, WinProcs, WinTypes, Messages;

const
  MAXHOOKS = 200;  { Maximalzahl Rckruf-Fenster }
  { Win32: Name fr speicherbasierte Datei und Mutex }
  MapFileName = 'ShellHook.DTA';
  ListMutexName = MapFileName+'Mutex';

type  { Struktur des gemeinsamen Datenbereichs }
  TCommonData = record
    HookID: HHook;      { fr CallNextHookEx (global) }
    UsageCount: LongInt;  { Debugging (siehe Artikeltext) }
    HookCount: Integer; { Shell-Hook gesetzt, wenn > 0 }
    CallBackHandles: Array[0..MAXHOOKS] of HWnd;
  end;
var
  HMapFile, ListMutex: THandle;  { nur Win32 }
  CommonData: ^TCommonData; { hier sind die gemeinsamen Daten }
  WM_NotifyHook: Word;  { RegisterWindowMessage -> PostMessage }

{ Wird von Windows direkt fr Shell-Hooks aufgerufen.
  Win31: "Smart Callbacks" von Delphi 1.0 setzen das DSeg
   falsch - nmlich mit dem Stack des aktiven Prozesses
  Win32: DLL hat eigenen Adreraum und kommt deshalb nur ber
   das Mapping der speicherbasierten Datei an ProgWndHandle
   und ShellHookMsg heran. Kein direkter Callback mglich,
   weil das Shell-Programm sonst im Kontext (Adreraum) des
   aktiven Prozesses (Threads) laufen wrde! }
function InternalHookFunc(Code: Integer; wParam: Word;
     lParam: LongInt): LongInt; export;
{$IFDEF WIN32} stdcall; {$ENDIF}
var x: Integer;
begin
{$IFDEF NOT_IN_DLL}
  { Bei RR-Funktionen in einem Programm schlgt Delphi 16 zu
    und setzt DS falsch. In DLLs lt der Compiler den Unsinn. }
  {$IFDEF WIN32}
  Result := CallNextHookEx(CommonData^.HookID,Code,wParam,lParam);
  {$ELSE}
  asm mov ax,SEG @Data; mov ds,ax; end;  { "Smart Callbacks" }
  Result := CallNextHookEx(CommonData^.HookID,Code,wParam,lParam);
  asm mov ax,SEG @Data; mov ds,ax; end;  { "Smart Callbacks" }
  {$ENDIF}
{$ELSE}
  Result := CallNextHookEx(CommonData^.HookID,Code,wParam,lParam);
{$ENDIF}
  { Primitiv, aber wirksam: einfach jedes registrierte }
  with CommonData^ do               { Fenster anfunken }
    for x := 0 to MAXHOOKS do
      if CallbackHandles[x] <> 0 then
       PostMessage(CallbackHandles[x],WM_NotifyHook,Code,wParam);
end;

function HookDLLRegisterHelpWindow(CallbackWnd: HWnd): Boolean;
  export; {$IFDEF WIN32} stdcall; {$ENDIF}
var x: Integer;
begin  { Anmelden eines Hilfsfensters = Eintrag in die Liste }
  try
{$IFDEF WIN32} WaitForSingleObject(ListMutex,INFINITE); {$ENDIF}
    Result := False;
    with CommonData^ do
    begin
      { Noch Platz fr einen weiteren Callback-Handle? }
      if HookCount = MAXHOOKS then Exit;  {-> nein }
      { Handle an der nchsten freien Stelle eintragen }
      for x := 0 to MAXHOOKS do
        if CallbackHandles[x] = 0 then
        begin
          CallbackHandles[x] := CallbackWnd;
          Break;
        end;
      Inc(HookCount);
        { hInstance: DLL-Instanz; 0 = Hook fr alle Threads }
      if HookID = 0 then HookID :=
{$IFDEF WIN32}
      SetWindowsHookEx(WH_SHELL, @InternalHookFunc, hInstance, 0);
{$ELSE}
      SetWindowsHookEx(WH_SHELL, InternalHookFunc, hInstance, 0);
{$ENDIF}
      Result := HookID <> 0;  { True, wenn's geklappt hat }
    end;
  finally
{$IFDEF WIN32} ReleaseMutex(ListMutex); {$ENDIF}
  end;
end;

procedure HookDLLUnregisterHelpWindow(CallbackWnd: HWnd);
  export; {$IFDEF WIN32} stdcall; {$ENDIF}
var x: Integer;
begin
  try
{$IFDEF WIN32} WaitForSingleObject(ListMutex,INFINITE); {$ENDIF}
    with CommonData^ do
    begin  { Handle suchen und herausnehmen }
      for x := 0 to MAXHOOKS do
        if CallbackHandles[x] = CallbackWnd then
        begin
          CallbackHandles[x] := 0;
          Dec(HookCount);
          if HookCount = 0 then
          begin
            if HookID <> 0 then UnHookWindowsHookEx(HookID);
            HookID := 0;
          end;
          Break;
        end;
    end;
  finally
{$IFDEF WIN32} ReleaseMutex(ListMutex); {$ENDIF}
  end;
end;

procedure MapCommonData;
var FirstCall: Boolean;
begin
{$IFDEF WIN32}  { Initialisierung wird bei jeder Anforderung der
  DLL erneut aufgerufen. Speicherbasierte Datei fr gemeinsame
  Variablen und Mutex fr den Zugriff darauf }
  ListMutex := CreateMutex(nil,True,ListMutexName);
  HMapFile := OpenFileMapping(FILE_MAP_WRITE,False,MapFileName);
  FirstCall :=  HMapFile = 0;
  if FirstCall then  { gibt's das Dateiabbildungsobjekt noch nicht }
    HMapFile := CreateFileMapping($FFFFFFFF,nil,
        PAGE_READWRITE,0,SizeOf(TCommonData),MapFileName);
  CommonData := MapViewOfFile(HMapFile,FILE_MAP_WRITE,0,0,0);
  if FirstCall then FillChar(CommonData^,SizeOf(TCommonData),0);
{$ELSE}  { Win31: globale Variablen grundstzlich SHARED,
           Initialisierung wird nur ein einziges Mal aufgerufen }
  CommonData := GlobalLock(GlobalAlloc(GMEM_SHARE or GMEM_ZEROINIT,
      SizeOf(TCommonData)));
{$ENDIF}
  Inc(CommonData^.UsageCount); { Debugging, siehe Artikeltext }
{$IFDEF WIN32} ReleaseMutex(ListMutex);  {$ENDIF}
end;

{ Freigabe des globalen Speicherbereichs (Win31) bzw. der
  speicherbasierten Datei (Win32). Win31-Version wird nur
  beim physischen Unload der DLL aufgerufen, Win32-Version
  bei jedem UnloadLibrary }
procedure UnmapCommonData; {$IFNDEF WIN32} far; {$ENDIF}
begin
  Dec(CommonData^.UsageCount);
{$IFDEF DEBUG}  { physischer Hinauswurf: Piepton }
  if CommonData^.UsageCount = 0 then MessageBeep(0);
{$ENDIF}
{$IFDEF WIN32}
  UnmapViewOfFile(CommonData);
  CloseHandle(HMapFile);  { Herunterzhler }
  CloseHandle(ListMutex); { dito }
{$ELSE}
  FreeMem(CommonData,SizeOf(TCommonData));  { GlobalFree }
{$ENDIF}
end;

exports
  HookDLLRegisterHelpWindow       index 1,
  HookDLLUnregisterHelpWindow     index 2,
  InternalHookFunc                index 3;

begin
  MapCommonData;  { Speicherbereich fr alle Proze-Kontexte }
  { THookedApp holt sich dieselbe Botschafts-Kennziffer }
  WM_NotifyHook := RegisterWindowMessage('ShellHookNotify');
  AddExitProc(UnmapCommonData); { Aufrumarbeiten }
end.

