unit DBWin; { 30-APR-97 as }
{ Ersatz von OutputDebugString, der mit 16 und 32 Bit unter
  allen Windows-Versionen zusammen mit DBWin funktioniert.
  Vorausgesetzt werden: a) DBWin geladen, b) ShHook.DLL
  vorhanden. Falls nicht, bleibt die Routine einfach still. }

interface
uses WinTypes, WinProcs, Classes, Messages, Forms,
     SysUtils, HookApps, Dialogs;

procedure OutputDebugString(Text: PChar);

implementation

type
  TDummyObj = class(TComponent)
    procedure OnHookStateChange(Sender: TObject);
  end;

var
  DummyObj: TDummyObj;
  DBWinHook: THookedApp;
  DBWinEditWnd: HWnd;

procedure OutputDebugString(Text: PChar);
var TextLen, DBWinTextLen: Integer; Buf,P: PChar;
  procedure AppendText(TextPart: PChar);
  begin
  {$IFDEF WIN32}
    { Format von Win32, wird Windows-intern auf Win16 umgesetzt }
    SendMessage(DBWinEditWnd,EM_SETSEL,DBWinTextLen+1,DBWinTextLen+1);
  {$ELSE}
    SendMessage(DBWinEditWnd,EM_SETSEL,0,
                LongInt(DBWinTextLen+1) shl 16+DBWinTextLen+1);
  {$ENDIF}
    SendMessage(DBWinEditWnd,EM_REPLACESEL,0,LongInt(TextPart));
    Inc(DBWinTextLen,StrLen(TextPart));
  end;
begin
  if DBWinEditWnd = 0 then Exit;
  { GetWindowTextLength macht angeblich nichts anderes, liefert bei
    16-Bit-Fenstern aber beharrlich 0 zurck }
  DBWinTextLen := SendMessage(DBWinEditWnd,WM_GETTEXTLENGTH,0,0);
  { LF -> CR/LF. Kommt nicht ohne Schreibaktionen (#0) in den Text aus,
    weshalb der Text in einen Puffer umkopiert werden mu }
  TextLen := StrLen(Text)+1; GetMem(Buf,TextLen);
  StrCopy(Buf,Text); Text := Buf;
   repeat
    P := StrScan(Text,#10);  { Suche nach LF }
    if P <> nil then
    begin
      P^ := #0;           { String hier abschneiden, }
      AppendText(Text);    { anhngen, }
      AppendText(#13#10);  { CR/LF dran }
      Text := @P[1];        { und dahinter weitersuchen }
    end;
  until P = nil;
  AppendText(Text);        { kann auch ein Nullstring sein }
  FreeMem(Buf,StrLen(Text)+1);
 end;


procedure TDummyObj.OnHookStateChange(Sender: TObject);
begin
  with DBWinHook do
    if HookedAppState = hkRunning
     then DBWinEditWnd := GetWindow(AppWindowHandle,GW_CHILD)
     else
     begin
       DBWinEditWnd := 0;
       WaitFor(False);
     end;
end;

initialization
  DummyObj := TDummyObj.Create(Application);
  DBWinHook := THookedApp.Create(DummyObj);

  with DBWinHook do
  begin
    AppWindowClass := 'DBWin';
    TerminateAppOnDestroy := False;
    OnAppStateChange := DummyObj.OnHookStateChange;
    WaitFor(True);
  end;
end.

