// convlfn.c von Thomas Lauer, c't 5/97

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

CHAR szShortname1[]="C:\\WINDOWS\\STARTM~1\\PROGRA~1\\AUTOST~1\\";

INT WINAPI VxDCall0(VOID);  // Wird in VXDCALL.LIB aufgelst

// Benutzt die (undokumentierte) Funktion VxDCall0, um den VWIN32-VxD
// aufzurufen (Subfunktion 0x002a0010, VWIN32_Int21_Dispatch). Diese
// Funktion ermglicht es Win95-Programmen, INT-21h-Aufrufe abzusetzen.
// Die Subfunktion 0x7160 des INT 21h konvertiert 8.3-Namen in LFNs und
// umgekehrt (siehe MS-Dokumentation).
DWORD Short2LFNviaVxD(LPCTSTR lpszShort,LPSTR lpszLong);
DWORD Short2LFNviaVxD(LPCTSTR lpszShort,LPSTR lpszLong)
{
  DWORD dw=ERROR_INVALID_FUNCTION;  // VxDCall0 nicht unter Windows NT!
  OSVERSIONINFO ovi;
  ovi.dwOSVersionInfoSize=sizeof(ovi);
  GetVersionEx(&ovi);
  if (ovi.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS) { // Windows 95?
    __asm {
      mov esi,lpszShort  // Adresse des 8.3-Namens
      mov edi,lpszLong   // Adresse des LFN-Namens
      push 0x8002        // Wert des ECX-Registers
      push 0x7160        // Wert des EAX-Registers
      push 0x002a0010    // VxD-Code fr VWIN32_Int21_Dispatch
    }
    dw=VxDCall0();       // Aufruf in KERNEL32.DLL
    if (dw==0x6000)      // dw==0x6000 -> kein Fehler
      dw=ERROR_SUCCESS;
  }
  return dw;
}

// Diese Hilfsfunktion konvertiert ein 8.3-Directory ins LFN-Format.
// Sie untersucht den Pfad komponentenweise und ruft sich dabei
// rekursiv auf, bis der gesamte Pfad konvertiert ist.
VOID ConvertDirectory(LPSTR lpszDir);
VOID ConvertDirectory(LPSTR lpszDir)
{
  static CHAR szDrive[_MAX_DRIVE];
  static CHAR szPath[_MAX_PATH];
  static CHAR szName[_MAX_FNAME];
  static CHAR szExt[_MAX_EXT];
  WIN32_FIND_DATA wfd; // Nicht static wegen der Rekursion
  static HANDLE hfind;
  // Pfad in Komponenten aufteilen
  _splitpath(lpszDir,szDrive,szPath,szName,szExt);
  if (szPath[0]==0) { // bricht die Rekursion ab, wenn der Pfad nur
                      // noch eine Drive-Angabe enthlt
    strcpy(lpszDir,szDrive);
    return;
  }
  hfind=FindFirstFile(lpszDir,&wfd); // LFN des Directory holen
  FindClose(hfind);
  strcpy(lpszDir,szDrive);
  strcat(lpszDir,szPath);
  lpszDir[strlen(lpszDir)-1]=0;
  ConvertDirectory(lpszDir);         // Nchste Ebene erledigen
  strcat(lpszDir,"\\");              // LFN-Pfad zusammenbauen
  strcat(lpszDir,wfd.cFileName);
}

// Die Funktion konvertiert einen 8.3-Namen in einen LFN.
DWORD Short2LFNviaAPI(LPSTR lpszShort,LPSTR lpszLong);
DWORD Short2LFNviaAPI(LPSTR lpszShort,LPSTR lpszLong)
{
  CHAR szDrive[_MAX_DRIVE];
  CHAR szPath[_MAX_PATH];
  CHAR szName[_MAX_FNAME];
  CHAR szExt[_MAX_EXT];
  CHAR szCurrDir[MAX_PATH];
  CHAR szTempDir[MAX_PATH];
  CHAR szTempName[MAX_PATH];
  WIN32_FIND_DATA wfd;
  HANDLE hfind;
  DWORD dw=0;
  // Aktuelles Directory retten
  GetCurrentDirectory(sizeof(szCurrDir),szCurrDir);
  // Ggf. \ am Ende des Pfades lschen
  if (lpszShort[strlen(lpszShort)-1]=='\\')
    lpszShort[strlen(lpszShort)-1]=0;
  // Pfad in Komponenten aufteilen
  _splitpath(lpszShort,szDrive,szPath,szName,szExt);
  strcpy(szTempDir,szDrive); // temporren Pfad reassemblieren
  strcat(szTempDir,szPath);
  if (szName[0]!=0) { // Nur wenn es einen Namensbestandteil gibt
    SetCurrentDirectory(szTempDir); // Temporren Pfad setzen
    strcpy(szTempName,szName); // temporren Dateinamen reassemblieren
    strcat(szTempName,szExt);
    strcat(szTempDir,szTempName);
    hfind=FindFirstFile(szTempDir,&wfd); // LFN holen
    if (hfind==INVALID_HANDLE_VALUE) // Fehler?
      dw=GetLastError();
    else { // kein Fehler
      FindClose(hfind); // Handle schlieen
      // Theoretisch sollte das funktionieren...
      //GetCurrentDirectory(sizeof(szTempDir),szTempDir);
      // Praktisch wird die obige Hilfsfunktion benutzt, um
      // den Pfadanteil in einen LFN umzuwandeln
      strcpy(szTempDir,szDrive); // temporren Pfad reassemblieren
      strcat(szTempDir,szPath);
      szTempDir[strlen(szTempDir)-1]=0;
      ConvertDirectory(szTempDir); // Pfad konvertieren
      strcpy(lpszLong,szTempDir);  // Ergebnis zusammenbauen
      strcat(lpszLong,"\\");
      strcat(lpszLong,wfd.cFileName);
    }
  }
  else { // Es gab keine Namensbestandteile in lpszShort
    strcpy(lpszLong,szDrive); // Drive...
    strcat(lpszLong,"\\");    // und Root
  }
  SetCurrentDirectory(szCurrDir); // altes Directory wiederherstellen
  return dw;  // Fehler-Rckgabe
}

INT main(INT argc,CHAR *argv[])
{
  CHAR szLongname[MAX_PATH]="";
  DWORD dw;
  SetFileApisToOEM();

  printf("Versuch mit VxDCall:\n");
  dw=Short2LFNviaVxD(szShortname1,szLongname);
  if (dw==0) {
    printf(" 8.3:%s\n",szShortname1);
    printf(" LFN:%s\n",szLongname);
  }
  else printf(" Fehlgeschlagen! Resultat: %d\n",dw);

  printf("\nVersuch mit der API:\n");
  dw=Short2LFNviaAPI(szShortname1,szLongname);
  if (dw==0) {
    printf(" 8.3:%s\n",szShortname1);
    printf(" LFN:%s\n",szLongname);
  }
  else printf(" Fehlgeschlagen! Resultat: %d\n",dw);

  return 0;
}
