unit Scldemou;  { Scrolling-Techniken, 14-MAR-97 as }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls, StdCtrls, mmSystem;

type
  TSclForm = class(TForm)
    cSeparateUpdates: TCheckBox;
    Label1: TLabel;    { "X/Y-Offset:" }
    lXYOffset: TLabel; { XOffset, YOffset als Text }
    bFrontWindow1: TButton;      { Vordergrund-Fenster, }
    bFrontWindow2: TButton;      { der Typ ist einigermaen }
    bFrontWindow3: TRadioGroup;  { egal }
    rFrontWindows: TRadioGroup;  { Vordergrundfenster ein/aus }
    cSplitRects: TCheckBox;     { nur fr 1 Vordergrundfenster }
    cUseRgns: TCheckBox;         { Regions anstelle von Rects }
    cShowUpdates: TCheckBox;     { ungltige Flchen anzeigen }
    bRepaint: TButton;
    bHelp: TButton;           { schlichtes Invalidate }
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseDown(Sender: TObject;  { neues Objekt }
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);  { Prfung auf "Maus im Scrollbereich" }
    procedure rFrontWindowsClick(Sender: TObject);
    procedure cUseRgnsClick(Sender: TObject);
    procedure bRepaintClick(Sender: TObject);
    procedure bHelpClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    ObjList: TList;  { Liste der TComplexObj-Objekte }
    XOffset, YOffset: Integer; { relativer Ursprung PaintField }
    PaintField, ScrollField: TRect;  { Zeichen-, Scrollflche }
    Scrolling: Boolean;  { True: Scrolling luft }
    NextScrollTime, ScrollTimeStep: LongInt; { siehe OnIdle }
    UpdRgn: HRgn; UpdateBrush: TBrush;
    KeyScrollActive: Boolean; { Tastaturschnittstelle }
    dxKey, dyKey: Integer;
  protected
    procedure WMEraseBkGnd(var Msg: TWMEraseBkGnd);
                           message WM_ERASEBKGND;
    function ScrollPaintField(MousePos: TPoint): Boolean;
    procedure OnIdle(Sender: TObject; var Done: Boolean);
    procedure SetXYOffset(XOff,YOff: Integer); { wg. Anzeige }
    function MouseInScrollRect(MousePos: TPoint): Boolean;
  end;

var
  SclForm: TSclForm;

implementation

{$R *.DFM}
{ Pseudo-Objekt. Maximalgre 100x100, besteht aus 20..39
  Eckpunkten, die bei Paint alle miteinander verbunden werden
  (was entsprechend lange dauert). Eckpunkte entstehen bei
  Create per Random, Paint zeichnet auf dem Canvas der Form }
type
  TPaintObj = class(TObject)
  private
    FXOrg, FYOrg: Integer;  { linke obere Ecke }
    FWidth, FHeight: Integer; { Breite, Hhe }
    Points: TList;  { bei Create mit 20 .. 40 TPoints besetzt }
    FColor: TColor; { Linienfarbe }
  protected
    function GetBoundingBox: TRect;
  public
    constructor Create(XOrg,YOrg: Integer; Color: TColor);
    destructor Destroy; override;
    procedure Paint(Canvas: TCanvas; XRel,YRel: Integer);
    property BoundingBox: TRect read GetBoundingBox;
  end;

{ XOrg,YOrg: linke obere Ecke in der Zeichenflche. BoundingBox
  wird durch die per Random erzeugten Eckpunkte bei Bedarf
  aufgeblasen }
constructor TPaintObj.Create(XOrg,YOrg: Integer; Color: TColor);
var x, PCount: Integer; P: PPoint;
begin
  inherited Create;
  FXOrg := XOrg; FYOrg := YOrg; FWidth := 0; FHeight := 0;
  FColor := Color;
  Points := TList.Create;
  PCount := Random(20)+20;  { 20..39 Eckpunkte }
  for x := 1 to PCount do
  begin  { in die Liste eintragen, BoundingBox }
    New(P); Points.Add(P); { entsprechend aufblasen }
    P^.X := Random(100); P^.Y := Random(100);
    if P^.X > FWidth then FWidth := P^.X;
    if P^.Y > FHeight then FHeight := P^.Y;
  end;
end;

destructor TPaintObj.Destroy;
var x: Integer;
begin
  for x := 0 to Points.Count-1 do Dispose(PPoint(Points[x]));
  Points.Destroy;
end;

function TPaintObj.GetBoundingBox: TRect;
begin  { umschlieendes Rechteck, um 1 Pixel vergrert }
  Result := Rect(FXOrg,FYOrg,FXOrg+FWidth+1,FYOrg+FHeight+1);
end;

{ Verbindet smtliche Eckpunkte miteinander. Ergebnis sind
  (n+1)*n/2 = 210..780 Linien. XRel,YRel: Scroll-Offset+
  linke obere Ecke der Zeichenflche in der Form }
procedure TPaintObj.Paint(Canvas: TCanvas; XRel,YRel: Integer);
var x,y,XPos,YPos: Integer; P: TPoint; R: TRect;
begin
  Canvas.Pen.Color := FColor;
  { Ursprung der Zeichenaktion. Eckpunkte sind relativ dazu }
  XPos := FXOrg+XRel; YPos := FYOrg+YRel;
  for x := 0 to Points.Count-1 do
  begin
    P := PPoint(Points[x])^;
    Inc(P.X,XPos); Inc(P.Y,YPos);
    for y := x+1 to Points.Count-1 do
    begin  { alle Eckpunkte miteinander verbinden }
      Canvas.MoveTo(P.X,P.Y);
      with PPoint(Points[y])^ do Canvas.LineTo(XPos+X,YPos+Y);
    end;
  end;
end;

{ --------------------------------------------------- }

procedure TSclForm.bHelpClick(Sender: TObject);
begin
  ShowMessage('SclDemo, 14-MAR-97 as (Arne Schpers)'#13#10+
    'Linke Maustaste: Neues Objekt, '+
    'Rechte Maustaste: Objekt lschen'#13#10+
    'Maus zwischen den roten Rahmen, Pos1..BildAb: Bildlauf');
end;

procedure TSclForm.FormCreate(Sender: TObject);
var x: Integer;
begin
  ObjList := TList.Create;  { TComplexObj-Objekte }
  UpdRgn := CreateRectRgn(0,0,10,10);  { Gre ist egal }
  { Anzeige der ungltigen Bereiche (WMEraseBkGnd) }
  UpdateBrush := TBrush.Create; UpdateBrush.Color := clGreen;
  rFrontWindows.ItemIndex := 0;  { keine Vordergrundfenster }
  { Scrolling wird ber MouseMove angestoen und per OnIdle }
  Application.OnIdle := OnIdle;  { ausgefhrt }

  PaintField := Rect(20,20,ClientWidth-20,300); { Zeichenflche }
  ScrollField := Rect(0,0,ClientWidth,320);  { Scroll-Bereich }
  SetXYOffset(0,0);  { Scroll-Offset beim Start: 0,0 }

  { 5 per Pseudozufall erzeugte Objekte auf der Zeichenflche }
  Randomize;
  for x := 1 to 5 do
    ObjList.Add(TPaintObj.Create(
      Random(PaintField.Right-PaintField.Left-100),
      Random(PaintField.Bottom-PaintField.Top-100),
      RGB(Random(256),Random(256),Random(256))));
end;

procedure TSclForm.FormDestroy(Sender: TObject);
var x: Integer;
begin
  for x := 0 to ObjList.Count-1 do  { Zeichenobjekte raus }
    TPaintObj(ObjList[x]).Destroy;
  ObjList.Destroy;   { Liste raus }
  DeleteObject(UpdRgn);
  UpdateBrush.Destroy;
end;

procedure TSclForm.SetXYOffset(XOff,YOff: Integer);
begin { neue Scroll-Offsets eintragen und anzeigen }
  XOffset := XOff; YOffset := YOff;
  lXYOffset.Caption := Format('(%d,%d)',[XOffset,YOffset]);
end;

{ Zwischen 0 und 3 Vordergrundfenster sichtbar machen }
procedure TSclForm.rFrontWindowsClick(Sender: TObject);
var Index: Integer;
begin
  Index := rFrontWindows.ItemIndex;
  bFrontWindow1.Visible := Index > 0;
  bFrontWindow2.Visible := Index > 1;
  bFrontWindow3.Visible := Index > 2;
  { macht nur ohne Vordergrundfenster Sinn }
  cSeparateUpdates.Enabled := Index = 0;
  if Index <> 0 then cSeparateUpdates.Checked := False;
end;

procedure TSclForm.cUseRgnsClick(Sender: TObject);
begin  { Checked: Update-Region anstell von Rect }
  cSplitRects.Enabled := not cUseRgns.Checked;
  if cUseRgns.Checked then cSplitRects.Checked := False;
end;

procedure TSclForm.bRepaintClick(Sender: TObject);
begin { Nach cSplitRects.Checked bei > 1 Vordergrundfenstern }
  Invalidate;
end;

{ Objekte anlegen (linke) und Lschen (rechte Maustaste) }
procedure TSclForm.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var MousePos: TPoint; R: TRect; C: TPaintObj;

  procedure InvalidateBoundingRect(R: TRect; Erase: Boolean);
  begin  { BoundingBox auf Form-Koordinaten umrechnen }
    OffsetRect(R,PaintField.Left-XOffset,
                 PaintField.Top-YOffset);
    InvalidateRect(Handle,@R,Erase);
  end;

begin
  MousePos := Point(X,Y);
  if not PtInRect(PaintField,MousePos) then Exit;
  { Mausposition -> relativ zum PaintField (+/- Scrollposition }
  Inc(MousePos.X,XOffset-PaintField.Left);
  Inc(MousePos.Y,YOffset-PaintField.Top);

  if Button = mbRight then  { Objekt an Mauspos. lschen }
    for x := 0 to ObjList.Count-1 do
    begin
      R := TPaintObj(ObjList[x]).BoundingBox;
      if PtInRect(R,MousePos) then
      begin  { Maus (PaintField-relativ) auf einem Objekt }
        TPaintObj(ObjList[x]).Destroy;
        ObjList.Delete(x);
        InvalidateBoundingRect(R,True); { in PaintField lschen }
        Break;
      end;
    end
  else  { linke Maustaste: neues Objekt erzeugen }
  begin
    C := TPaintObj.Create(MousePos.X,MousePos.Y,
      RGB(Random(256),Random(256),Random(256)));
    ObjList.Add(C);
    InvalidateBoundingRect(C.BoundingBox,False); { zeichnen }
  end;
end;

{ ---------- Paint ---------------------- }
{ Zeigt bei Bedarf die ungltigen Rechtecke/Flchen an }
procedure TSclForm.WMEraseBkGnd(var Msg: TWMEraseBkGnd);
var WaitEnd: LongInt;
begin
  if cShowUpdates.Checked then
  begin
    FillRect(Msg.DC,PaintField,UpdateBrush.Handle);
    WaitEnd := timeGetTime+250;
    while timeGetTime < WaitEnd do
       ;   { hartes Delay }
  end;
  inherited;
end;

procedure TSclForm.FormPaint(Sender: TObject);
var ClipBox, R: TRect; x: Integer; PaintThisObj: Boolean;
begin
  with Canvas do
  begin  { einen roten Rahmen um das PaintField herum zeichnen }
    Brush.Style := bsClear; Pen.Color := clRed;
    R := PaintField; InflateRect(R,1,1);
    with R do Rectangle(Left,Top,Right,Bottom);
    with ScrollField do Rectangle(Left,Top,Right,Bottom);
  end;
  { Umschlieendes Rechteck fr den neu zu zeichnenden Bereich }
  GetClipBox(Canvas.Handle,ClipBox);
  { Ausgaben auf das PaintField begrenzen }
  with PaintField do
     IntersectClipRect(Canvas.Handle,Left,Top,Right,Bottom);
  { Die Paint-Methode der Objekte wird nur dann aufgerufen, wenn
    ihre BoundingBox in den neu zu zeichnenden Bereich fllt }
  for x := 0 to ObjList.Count-1 do
  begin
    R := TPaintObj(ObjList[x]).BoundingBox;
    OffsetRect(R,PaintField.Left-XOffset,PaintField.Top-YOffset);
    if Scrolling and cUseRgns.Checked then
    begin  { Update-Regionen gibt es nur whrend Scrolling }
      PaintThisObj := RectInRegion(UpdRgn,R);
    end else
    begin
      IntersectRect(R,ClipBox,R);
      PaintThisObj := not IsRectEmpty(R);
    end;
    if PaintThisObj then TPaintObj(ObjList[x]).Paint(Canvas,
        PaintField.Left-XOffset,PaintField.Top-YOffset);
  end;
end;

{ ----------- Scrolling ------------------ }
function TSclForm.MouseInScrollRect(MousePos: TPoint): Boolean;
begin  { Maus innerhalb ScrollRect und auerhalb PaintField? }
  Result := PtInRect(ScrollField,MousePos) and
    not PtInRect(PaintField,MousePos);
end;

procedure TSclForm.FormMouseMove(Sender: TObject;
   Shift: TShiftState; X, Y: Integer);
begin
  if not Application.Active then Exit;
  if MouseInScrollRect(Point(X,Y)) and not Scrolling then
  begin { Initialisierung fr OnIdle }
    Scrolling := True;
    NextScrollTime := timeGetTime+300;
    ScrollTimeStep := 50;
  end; { else ist die Maus auerhalb des Scrollbereichs
         oder OnIdle bereits an der Arbeit }
end;

procedure TSclForm.OnIdle(Sender: TObject; var Done: Boolean);
var MousePos: TPoint;
begin
  Done := not Scrolling;
  if Done or (timeGetTime < NextScrollTime) then Exit;
  { Scrolling luft. Berechnung des nchsten Zeitschritts }
  if ScrollTimeStep > 5 then Dec(ScrollTimeStep);
  NextScrollTime := timeGetTime+ScrollTimeStep;
  { Mausposition wird direkt abgeholt -> Client-Koordinaten }
  GetCursorPos(MousePos); MousePos := ScreenToClient(MousePos);
  Scrolling := ScrollPaintField(MousePos);
  Done := not Scrolling;
end;

const XAmount = 3; YAmount = 2;  { Scroll-Schrittweiten }

procedure TSclForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var dX,dY: Integer;
begin
  dX := 0; dY := 0;
  case Key of
    VK_PRIOR: begin dX := XAmount; dY := -YAmount; end;
    VK_NEXT:  begin dX := XAmount; dY := YAmount; end;
    VK_HOME:  begin dX := -XAmount; dY := -YAmount; end;
    VK_END:   begin dX := -XAmount; dY := YAMount; end;
    { Die normalen Pfeiltasten fehlen hier - das ginge besser
      in einer eigenen Komponente, die dann auf WM_GETDLGCODE
      reagieren mu }
  end;
  if (dX <> 0) or (dY <> 0) then
  begin
    dxKey := dX; dyKey := dY;
    if not Scrolling then
    begin
      Scrolling := True;
      NextScrollTime := timeGetTime+300;
      ScrollTimeStep := 50;
    end;
    KeyScrollActive := True;
  end;
end;

procedure TSclForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if KeyScrollActive then
  begin  { bremst auch die Maus }
    KeyScrollActive := False; Scrolling := False;
  end;
end;

function TSclForm.ScrollPaintField(MousePos: TPoint): Boolean;
var dX,dY: Integer; R, InvRectX, InvRectY: TRect;
begin
 { Annahme: Maus auerhalb des Scrollbereichs, keine Taste
   gedrckt oder keine weitere Bewegung notwendig }
  Result := False;
  dX := 0; dY := 0;
  if KeyScrollActive then
  begin  { Tastaturschnittstelle hat Vorrang }
    dX := dXKey; dY := dYKey;
  end else
  begin
    if not MouseInScrollRect(MousePos) then Exit;
    { An welcher Ecke ist die Maus auerhalb? }
    if MousePos.X >= PaintField.Right then dX := XAmount
      else if MousePos.X <= PaintField.Left then dX := -XAmount;
    if MousePos.Y >= PaintField.Bottom then dY := YAmount
     else if MousePos.Y <= PaintField.Top then dY := -YAmount;
  end;
  { Linke obere Ecke erreicht? }
  if XOffset+dX < 0 then dX := -XOffset;
  if YOffset+dY < 0 then dY := -YOffset;
  { Eine Begrenzung auf eine rechte untere Ecke fehlt hier.
    Fr MAXX = Breite der Zeichenflche-Breite von PaintField:
  if XOffset+dX > MAXX then dX := MAXX-XOffset; }

  { Anschlag erreicht? -> Keine weitere Bewegung }
  if (dX = 0) and (dY = 0) then Exit;
  { Neue linke obere Ecke von PaintField }
  SetXYOffset(XOffset+dX,YOffset+dY);
  { Bildlauf in PaintField. Bei Schrgbewegungen kme ein un-
    gltiges Rechteck fr das gesamte PaintField heraus, weshalb
    hier zwei Operationen hintereinander ausgefhrt werden }
  if cUseRgns.Checked then
  begin
    ScrollDC(Canvas.Handle,-dX,-dY,PaintField,
             PaintField,UpdRgn,nil);
    InvalidateRgn(Handle,UpdRgn,True);
  end else
  begin { Rechtecke. Zuerst die beiden Scrolls mit separaten }
    if dX <> 0 then ScrollDC(Canvas.Handle,-dX,0, { Upd-Rects }
      PaintField,PaintField,0,@InvRectX);
    if dY <> 0 then ScrollDC(Canvas.Handle,0,-dY,
      PaintField,PaintField,0,@InvRectY);
    if dX <> 0 then
    begin
      if (InvRectX.Right-InvRectX.Left > XAmount)
          and cSplitRects.Checked then
      begin  { Kleinrechnen des Rechtecks  }
        with InvRectX do R := Rect(Left,Top,Left+XAmount,Bottom);
        InvalidateRect(Handle,@R,True); Update;
        with InvRectX do R := Rect(Right-XAmount,Top,Right,Bottom);
        InvalidateRect(Handle,@R,True); Update;
      end else
      begin  { gesamtes Rechteck als ungltig eintragen }
        InvalidateRect(Handle,@InvRectX,True);
        if cSeparateUpdates.Checked then Update;
      end;
    end;
    if dY <> 0 then
    begin  { daselbe in der Vertikalen }
      if (InvRectY.Right-InvRectY.Left > YAmount)
          and cSplitRects.Checked then
      begin
        with InvRectY do R := Rect(Left,Top,Right,Top+YAmount);
        InvalidateRect(Handle,@R,True); Update;
        with InvRectY do R := Rect(Left,Bottom-YAMount,Right,Bottom);
        InvalidateRect(Handle,@R,True); Update;
      end else
      begin
        InvalidateRect(Handle,@InvRectY,True);
      end;
    end;
  end;
  { Faulheit. Korrekt wre eine vollstndige Prfung, ob in
    der aktuellen Richtung noch weitere Bewegungen mglich sind }
  Result := True;
end;

end.
