unit Lousybxu; { Bildlauf in einer TScrollBox mit Zhlung
der dabei erzeugten, berflssigen Paint-Operationen }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls, MMSystem;

type
  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;  { Range der ScrollBars: 1000 }
    PaintBox1: TPaintBox;  { Child von ScrollBox1, alClient }
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lInsideCount: TLabel;
    lOutsideCount: TLabel;
    procedure PaintBox1Paint(Sender: TObject);
  end;

var
  Form1: TForm1;
  UpdateRect: TRect;
  PaintBoxDC: HDC;
  InsideCount, OutSideCount: Integer;

implementation

{$R *.DFM}

{ Aufruf ber LineDDA von PaintBox1Paint aus zum Zeichnen
  einer schrg verlaufenden Linie. Zhlt dabei mit,
  wie viele der Pixel tatschlich innerhalb des Update-
  Rechtecks landen (und wie viele auerhalb) }
procedure LineProc(x,y: Integer; P: Pointer); export;
{$IFDEF WIN32} stdcall; {$ENDIF}
begin
  if PtInRect(UpdateRect,Point(x,y)) then Inc(InsideCount)
    else Inc(OutsideCount);
  SetPixel(PaintBoxDC,x,y,0);
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
var WaitEnd: LongInt;
begin
  InsideCount := 0; OutsideCount := 0;
  with PaintBox1 do
  begin
    PaintBoxDC := Canvas.Handle;
    GetClipBox(PaintBoxDC,UpdateRect);
    { Update-Bereich fr 200 msec in Rot darstellen }
    Canvas.Brush.Color := clRed;
    Canvas.FillRect(UpdateRect);
    WaitEnd := timeGetTime+200;
    while timeGetTime < WaitEnd do ;
    Canvas.Brush.Color := Color;
    Canvas.FillRect(UpdateRect);
    { Schrge Linie von links oben nach rechts unten }
{$IFDEF WIN32}
    LineDDA(0,0,Width,Height,@LineProc,0);
{$ELSE}
    LineDDA(0,0,Width,Height,@LineProc,nil);
{$ENDIF}
  end;
  lInsideCount.Caption := IntToStr(InsideCount);
  lOutsideCount.Caption := IntToStr(OutsideCount);
end;

end.
