Program CreateHardLink;     // 1997 by Matthias Withopf / c't
{$APPTYPE CONSOLE}

Uses
  Windows,SysUtils;

  Procedure Str2WStr(Source : PChar;Dest : PWChar);
  Begin
    While Source^ <> #0 do
      Begin
        Dest^ := WChar(Source^);
        Inc(Dest); Inc(Source);
      End;
    Dest^ := WChar(0);
  End;

  Function CreateLink(FileName,LinkName : PChar) : Boolean;
  Var
    f           : THandle;
    SI          : TWin32StreamId;
    P           : Pointer;
    LinkName1,
    LinkName2   : Array[0..1024] of WChar;
    p1          : PWChar;
    NameLen,Res : DWord;
  Begin
    Result := False;
    f := CreateFile(FileName,GENERIC_WRITE,FILE_SHARE_READ Or FILE_SHARE_WRITE,Nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
    If f = INVALID_HANDLE_VALUE then Exit;
    Str2WStr(LinkName,LinkName1);
    NameLen := GetFullPathNameW(LinkName1,MAX_PATH,LinkName2,p1);
    If NameLen = 0 then Exit;
    NameLen := (NameLen + 1) * SizeOf(WChar);
    P := Nil;
    FillChar(SI,SizeOf(SI),0);
    SI.dwStreamId := BACKUP_LINK;
    SI.Size.LowPart := NameLen;
    If BackupWrite(f,@SI,PChar(@SI.cStreamName) - PChar(@SI),Res,False,False,P) then
      If BackupWrite(f,@LinkName2[0],NameLen,Res,False,False,P) then
        Result := True;
    BackupWrite(f,Nil,0,Res,True,False,P);
    CloseHandle(f);
  End;

Var
  tmp1,tmp2 : String[255];
Begin
  If ParamCount < 2 then
    Begin
      WriteLn('Usage: ',ParamStr(0),' <filename> <linkname>');
      Halt(10);
    End;
  tmp1 := ParamStr(1) + #0;
  tmp2 := ParamStr(2) + #0;
  If Not(CreateLink(@tmp1[1],@tmp2[1])) then
    WriteLn('Error creating link!');
End.
