Program MultipleNTFSStreams; // 1997 by Matthias Withopf / c't
{$APPTYPE CONSOLE}

Uses
  Windows,SysUtils;

Const
  NTFSStreamSep = ':';
  ShowSecurity  = False;

  Function ShowFileInfo(FileName : PChar) : Boolean;
  Var
    f          : THandle;
    SI         : TWin32StreamId;
    P          : Pointer;
    ReadRes    : DWord;
    SName      : Array[0..1023] of WChar;
    SName1,
    SName2     : Array[0..1023] of Char;
    StreamType : PChar;
    p1         : PChar;
    S1,S2      : DWord;
    i          : Integer;
    FI         : TByHandleFileInformation;
    A          : DWord;
    AStr       : Array[0..5] of Char;
    FileId     : Record
                   Case Boolean of
                     False : (d1,d2 : DWord);
                     True  : (l : Comp);
                 End;
  Begin
    Result := False;
    f := CreateFile(FileName,GENERIC_READ,FILE_SHARE_READ Or FILE_SHARE_WRITE,Nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
    If f = INVALID_HANDLE_VALUE then Exit;
    P := Nil;
    Result := True;
    Repeat
      If Not(BackupRead(f,@SI,SizeOf(SI) - SizeOf(SI.cStreamName),ReadRes,False,ShowSecurity,P)) then
        Begin
          Result := False;
          Break;
        End;
      If ReadRes = 0 then Break;
      p1 := @SName1[0];
      If SI.dwStreamNameSize > 0 then
        If Not(BackupRead(f,@SName,SI.dwStreamNameSize,ReadRes,False,ShowSecurity,P)) then
          Begin
            Result := False;
            Break;
          End;
      If SI.dwStreamNameSize > 0 then
        For i := 0 to SI.dwStreamNameSize Div SizeOf(WChar) - 1 do
          Begin
            If SName[i] = NTFSStreamSep then Break;
            p1^ := Char(SName[i]);
            Inc(p1);
          End;
      p1^ := #0;
      Case SI.dwStreamId of
        BACKUP_INVALID:        StreamType := 'INVALID';        // 0
        BACKUP_DATA:           StreamType := 'DATA';           // 1
        BACKUP_EA_DATA:        StreamType := 'EA_DATA';        // 2
        BACKUP_SECURITY_DATA:  StreamType := 'SECURITY_DATA';  // 3
        BACKUP_ALTERNATE_DATA: StreamType := 'ALTERNATE_DATA'; // 4
        BACKUP_LINK:           StreamType := 'LINK';           // 5
        BACKUP_PROPERTY_DATA:  StreamType := 'PROPERTY_DATA';  // 6
                             else
                               StreamType := '???';
      End;
      BackupSeek(f,-1,-1,S1,S2,@P);            // Skip stream data

      StrCopy(SName2,FileName);
      If SName1[0] <> #0 then
        Begin
          StrCat(SName2,NTFSStreamSep);
          StrCat(SName2,SName1);
        End;
      A := GetFileAttributes(SName2);
      If (A And FILE_ATTRIBUTE_READONLY)   <> 0 then AStr[0] := 'R' else AStr[0] := ' ';
      If (A And FILE_ATTRIBUTE_HIDDEN)     <> 0 then AStr[1] := 'H' else AStr[1] := ' ';
      If (A And FILE_ATTRIBUTE_SYSTEM)     <> 0 then AStr[2] := 'S' else AStr[2] := ' ';
      If (A And FILE_ATTRIBUTE_ARCHIVE)    <> 0 then AStr[3] := 'A' else AStr[3] := ' ';
      If (A And FILE_ATTRIBUTE_COMPRESSED) <> 0 then AStr[4] := 'C' else AStr[4] := ' ';
      AStr[5] := #0;
      Write(SI.Size.QuadPart:10:0,' ',StreamType:14,' ',AStr,' ',SName2);
      If GetFileInformationByHandle(f,FI) then
        If FI.nNumberOfLinks > 1 then
          Begin
            FileId.d1 := FI.nFileIndexLow;
            FileId.d2 := FI.nFileIndexHigh;
            Write(' [',FI.nNumberOfLinks,',',FileId.l:0:0,']');
          End;
      WriteLn;
    Until False;
    BackupRead(f,Nil,0,ReadRes,True,ShowSecurity,P);   // Free internal buffers
    CloseHandle(f);
  End;

Var
  tmp : String[255];
Begin
  If ParamCount < 1 then
    Begin
      WriteLn('Usage: ',ParamStr(0),' <filename>');
      Halt(10);
    End;
  tmp := ParamStr(1) + #0;
  If Not(ShowFileInfo(@tmp[1])) then
    WriteLn('Error opening file info!');
End.