// wav.cpp
// 
// Direkter Zugriff auf SCSI-CD-ROM.
// Funktionen zum Schreiben einer WAV Datei.
//
// Johannes Karanitsch, 01.12.1996

#include "cdrom.h"



WAVFILE::WAVFILE()
{
  hFile = NULL;
}



WAVFILE::~WAVFILE()
{
  if (hFile) close();
}



//
// ffnet die WAV Datei und schreibt den Kopf.
//
// Parameter:
// Filename - Name der WAV Datei.
// Length - Lnge der WAV Datei.
//
DWORD WAVFILE::open(char *Filename, MSF& Length)
{
  DWORD err;
  WAVEFORMATEX wfex;

  // Datei ffnen.
  hFile = mmioOpen(Filename, NULL, MMIO_CREATE | MMIO_READWRITE); 
  if (hFile == NULL) return GetLastError();

  // Erzeuge RIFF-WAVE Chunk.
  ZeroMemory(&ckRiff, sizeof(ckRiff));
  ckRiff.fccType = mmioFOURCC('W', 'A', 'V', 'E');
  ckRiff.cksize = sizeof(wfex) + 20 + AUDIO_BLOCK_LEN * Length.GetLbn();
  err = mmioCreateChunk(hFile, &ckRiff, MMIO_CREATERIFF);
  if (err != MMSYSERR_NOERROR) return err;

  // Erzeuge Format Chunk.
  ZeroMemory(&ckData, sizeof(ckData));
  ckData.ckid = mmioFOURCC('f', 'm', 't', ' ');
  ckData.cksize = sizeof(wfex);
  err = mmioCreateChunk(hFile, &ckData, 0);
  if (err != MMSYSERR_NOERROR) return err;
  wfex.wFormatTag = WAVE_FORMAT_PCM;
  wfex.nChannels = 2;
  wfex.nSamplesPerSec = 44100;
  wfex.nAvgBytesPerSec = 44100 * 4;
  wfex.nBlockAlign = 4;
  wfex.wBitsPerSample = 16;
  wfex.cbSize = 0;
  err = mmioWrite(hFile, (char *)&wfex, sizeof(wfex));
  if (err == -1) return GetLastError();

  // Schliee Format Chunk.
  err = mmioAscend(hFile, &ckData, 0);
  if (err != MMSYSERR_NOERROR) return err;

  // Erzeuge Daten Chunk.
  ZeroMemory(&ckData, sizeof(ckData));
  ckData.ckid = mmioFOURCC('d', 'a', 't', 'a');
  ckData.cksize = AUDIO_BLOCK_LEN * Length.GetLbn();
  return mmioCreateChunk(hFile, &ckData, 0);
}



//
// Schreibt Audio Daten.
//
// Parameter:
// Buffer - Zeiger zu den Audio Daten.
// Length - Lnge der Audio Daten.
//
DWORD WAVFILE::write(char *Buffer, long Length)
{
  DWORD err = mmioWrite(hFile, Buffer, Length);
  if (err == -1) return GetLastError();
  return 0;
}



//
// Schliet die WAV Datei.
//
// Parameter:
// Keine.
//
DWORD WAVFILE::close()
{
  DWORD err;

  // Schliee Daten Chunk.
  err = mmioAscend(hFile, &ckData, 0);
  // Schliee RIFF-WAVE Chunk.
  err = mmioAscend(hFile, &ckRiff, 0);
  // Schliee Datei.
  err = mmioClose(hFile, 0);
  hFile = NULL;
  return err;
}
