// scsi.c
// 
// Direkter Zugriff auf SCSI-CD-ROM 
//
// Johannes Karanitsch, 01.12.1996

#include "cdrom.h"



// --- global SCSI functions ------------------------------------

DWORD ScsiMaxBlocks(HANDLE fh, DWORD *mb)
{
  DWORD er, ol;
  IO_SCSI_CAPABILITIES ca;

  if (DeviceIoControl(fh, IOCTL_SCSI_GET_CAPABILITIES, NULL, 0,
                      &ca, sizeof(IO_SCSI_CAPABILITIES), &ol, NULL)) {
    *mb = ca.MaximumTransferLength / AUDIO_BLOCK_LEN;
    if (*mb > ca.MaximumPhysicalPages)
      *mb = ca.MaximumPhysicalPages;
    er = 0;
  }
  else {
    *mb = 0;
    er = GetLastError();
  }
  return er;
}



DWORD ScsiInquire(HANDLE fh, PSCSI_INQUIRY_DEVICE id)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(id, sizeof(SCSI_INQUIRY_DEVICE));
  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 6;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = sizeof(SCSI_INQUIRY_DEVICE);
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = id;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_INQUIRY;
  sb.sptd.Cdb[4] = sizeof(SCSI_INQUIRY_DEVICE);
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(fh, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}

/*

DWORD ScsiModeSense(HANDLE fh, BYTE PageCode, void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(db, dl);
  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 6;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_MODE_SENSE;
  sb.sptd.Cdb[2] = PageCode;
  sb.sptd.Cdb[4] = LOBYTE(LOWORD(dl));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(fh, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}

*/
