// cdrom3.cpp
// 
// Direkter Zugriff auf SCSI-CD-ROM.
// Funktionen fr Typ 3 Laufwerke (Toshiba)
//
// Johannes Karanitsch, 01.12.1996

#include "cdrom.h"



CDROM_TYPE_3::CDROM_TYPE_3(char *d)
  : CDROM(d)
{
  ZeroMemory(&SaveMode, sizeof(SaveMode));
}



CDROM_TYPE_3::~CDROM_TYPE_3()
{
  if (hFile) close();
}



DWORD CDROM_TYPE_3::open()
{
  DWORD er;
  UCHAR si[12] = {
    0x00,             // Density Code.
    0x00,             // Medium Type.
    0x00,             // Device Specific Parameter.
    0x08,             // Block Descriptor Length.
    0x82,             // Density Code=CDDA transfer over SCSI support mode.
    0x00, 0x00, 0x00, // Number of Blocks.
    0x00,             // reserved.
    0x00, 0x09, 0x30  // Block Length = 2352
  };

  if (er = CDROM::open())
    return er;
  if (er = ModeSense(&SaveMode, sizeof(SaveMode)))
    return er;
  er = ModeSelect(&si, sizeof(si));
  return er;
}



DWORD CDROM_TYPE_3::close()
{
  DWORD er;

  SaveMode[0] = 0x00;
  er = ModeSelect(&SaveMode, sizeof(SaveMode));
  return CDROM::close();
}



DWORD CDROM_TYPE_3::ModeSense(void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(db, dl);
  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 6;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_MODE_SENSE;
  sb.sptd.Cdb[4] = LOBYTE(LOWORD(dl));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}



DWORD CDROM_TYPE_3::ModeSelect(void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 6;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_OUT;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_MODE_SELECT;
  sb.sptd.Cdb[4] = LOBYTE(LOWORD(dl));

  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}
