
// cdrom.cpp
// 
// Direkter Zugriff auf SCSI-CD-ROM.
//
// Johannes Karanitsch, 01.12.1996

#include "cdrom.h"

// --- class MSF ------------------------------------------------

MSF::MSF()
{
  Minute = 0;
  Second = 0;
  Frame = 0;
}



MSF::MSF(unsigned l)
{
  SetLbn(l);
}



MSF::MSF(unsigned m, unsigned s, unsigned f)
{
  Minute = m;
  Second = s;
  Frame = f;
}



void MSF::SetLbn(unsigned l)
{
  Frame = l % 75;
  l /= 75;
  Second = l % 60;
  Minute = l / 60;
}



MSF MSF::operator+ (const MSF& msf) const
{
  unsigned l;
  l = GetLbn();
  l += msf.GetLbn();
  return MSF(l);
}



ostream& operator<< (ostream& os, MSF& msf)
{
  os.fill('0');
  os << setw(2) << msf.Minute << ':'
     << setw(2) << msf.Second << '.'
     << setw(2) << msf.Frame;
  return os;
}



// --- class TRACK ----------------------------------------------

TRACK::TRACK()
{
  Type = MCI_CDA_TRACK_AUDIO;
}



ostream& operator<< (ostream& os, TRACK& track)
{
  os << track.Start << "  " << track.Length;
  if (track.Type == MCI_CDA_TRACK_AUDIO)
    os << "  audio\n";
  else
    os << "  data\n";
  return os;
}



// --- class TOC ------------------------------------------------

TOC::TOC()
{
  MediaIdentity = NULL;
  Upc = NULL;
  NumTracks = 0;
  Tracks = NULL;
}



TOC::~TOC()
{
  free(MediaIdentity);
  free(Upc);
  delete [] Tracks;
}



int TOC::Read(char* d)
{
  MCIDEVICEID DeviceID;
  int err, i;
  TRACK* Track;
  MCI_OPEN_PARMS mciOpen;
  MCI_SET_PARMS mciSet;
  MCI_INFO_PARMS mciInfo;
  MCI_STATUS_PARMS mciStatus;
  char Info[64];

  free(MediaIdentity);
  free(Upc);
  delete [] Tracks;
  Tracks = NULL;
  NumTracks = 0;
  // ffne CD audio.
  ZeroMemory(&mciOpen, sizeof(mciOpen));
  mciOpen.lpstrDeviceType = (LPTSTR)MCI_DEVTYPE_CD_AUDIO;
  mciOpen.lpstrElementName = d;
  if (err = mciSendCommand(0, MCI_OPEN,
    MCI_OPEN_ELEMENT | MCI_OPEN_SHAREABLE |
    MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_WAIT,
    (DWORD)(LPVOID) &mciOpen)) {
    return err;
  }
  DeviceID = mciOpen.wDeviceID;
  // MSF Format einstellen.
  ZeroMemory(&mciSet, sizeof(mciSet));
  mciSet.dwTimeFormat = MCI_FORMAT_MSF;
  if (err = mciSendCommand(DeviceID, MCI_SET, 
      MCI_SET_TIME_FORMAT | MCI_WAIT, (DWORD) &mciSet)) {
    mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
    return err;
  }
  // Eindeutige CD Kennung lesen.
  ZeroMemory(&mciInfo, sizeof(mciInfo));
  ZeroMemory(&Info, sizeof(Info));
  mciInfo.lpstrReturn = Info;
  mciInfo.dwRetSize = sizeof(Info);
  if (err = mciSendCommand(DeviceID, MCI_INFO, 
      MCI_INFO_MEDIA_IDENTITY | MCI_WAIT, (DWORD) &mciInfo)) {
    mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
    return err;
  }
  MediaIdentity = strdup(Info);
  // Universal Product Code (UPC) lesen.
  ZeroMemory(&mciInfo, sizeof(mciInfo));
  ZeroMemory(&Info, sizeof(Info));
  mciInfo.lpstrReturn = Info;
  mciInfo.dwRetSize = sizeof(Info);
  err = mciSendCommand(DeviceID, MCI_INFO, 
		MCI_INFO_MEDIA_UPC | MCI_WAIT, (DWORD) &mciInfo);
  if (err == MCIERR_NO_IDENTITY) {
    strcpy(Info, "no identity");
  }
  else if (err) {
    mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
    return err;
  }
  Upc = strdup(Info);
  // Lnge der CD lesen.
  ZeroMemory(&mciStatus, sizeof(mciStatus));
  mciStatus.dwItem = MCI_STATUS_LENGTH;
  if (err = mciSendCommand(DeviceID, MCI_STATUS,
      MCI_STATUS_ITEM | MCI_WAIT, (DWORD) &mciStatus)) {
    mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
    return (err);
  }
  CDLength.SetMinute(MCI_MSF_MINUTE(mciStatus.dwReturn));
  CDLength.SetSecond(MCI_MSF_SECOND(mciStatus.dwReturn));
  CDLength.SetFrame(MCI_MSF_FRAME(mciStatus.dwReturn));
  // Anzahl der Tracks lesen.
  mciStatus.dwItem = MCI_STATUS_NUMBER_OF_TRACKS;
  if (err = mciSendCommand(DeviceID, MCI_STATUS, 
      MCI_STATUS_ITEM | MCI_WAIT, (DWORD) &mciStatus)) {
    mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
    return err;
  }
  NumTracks = mciStatus.dwReturn;
  Track = Tracks = new TRACK[NumTracks];
  for(i = 1; i <= NumTracks; i++, Track++) {
    // Startposition von Track i lesen.
    mciStatus.dwItem = MCI_STATUS_POSITION;
    mciStatus.dwTrack = i;
    if (err = mciSendCommand(DeviceID, MCI_STATUS,
        MCI_STATUS_ITEM | MCI_TRACK, (DWORD) &mciStatus)) {
      mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
      return (err);
    }
    Track->SetStart(MCI_MSF_MINUTE(mciStatus.dwReturn),
                    MCI_MSF_SECOND(mciStatus.dwReturn),
                    MCI_MSF_FRAME(mciStatus.dwReturn));

    // Lnge von Track i lesen.
    mciStatus.dwItem = MCI_STATUS_LENGTH;
    mciStatus.dwTrack = i;
    if (err = mciSendCommand(DeviceID, MCI_STATUS,
        MCI_STATUS_ITEM | MCI_TRACK, (DWORD) &mciStatus)) {
      mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
      return (err);
    }
    Track->SetLength(MCI_MSF_MINUTE(mciStatus.dwReturn),
                     MCI_MSF_SECOND(mciStatus.dwReturn),
                     MCI_MSF_FRAME(mciStatus.dwReturn));

    // Typ von Track i lesen.
    mciStatus.dwItem = MCI_CDA_STATUS_TYPE_TRACK;
    mciStatus.dwTrack = i;
    if (err = mciSendCommand(DeviceID, MCI_STATUS, 
      MCI_STATUS_ITEM | MCI_TRACK, (DWORD) &mciStatus)) {
      mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
      return (err);
    }
    Track->SetType(mciStatus.dwReturn);
  }
  err = mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
  return err;
}



TRACK* TOC::GetTrack(int t)
{
  if (t > 0 && t <= NumTracks)
    return &Tracks[t - 1];
  else
    return NULL;
}



ostream& operator<< (ostream& os, TOC& toc)
{
  int i;
  TRACK *Track = toc.Tracks;
  os << "Unique  CD  identifier: " << toc.MediaIdentity << endl;
  os << "Universal Product Code: " << toc.Upc << endl;
  os << "\nTrack Start     Length    Type\n";
  for (i = 1; i <= toc.NumTracks; i++, Track++) {
    os.fill('0');
    os << "  " << setw(2) << i << "  " << *Track;
  }
  os << "-------------------------------\n         Total: "
     << toc.CDLength << endl;
  return os;
}



// --- class CDROM ----------------------------------------------

CDROM::CDROM(char* d)
{
  hFile = NULL;
  DeviceID = NULL;
  Device = d;
}



CDROM::~CDROM()
{
  if (DeviceID) closemci();
  if (hFile) close();
}



DWORD CDROM::openmci()
{
  DWORD err;
  MCI_OPEN_PARMS mciOpen;

  // ffne CD audio.
  ZeroMemory(&mciOpen, sizeof(mciOpen));
  mciOpen.lpstrDeviceType = (LPTSTR)MCI_DEVTYPE_CD_AUDIO;
  mciOpen.lpstrElementName = &Device[4];
  err = mciSendCommand(0, MCI_OPEN,
    MCI_OPEN_ELEMENT | MCI_OPEN_SHAREABLE |
    MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_WAIT,
    (DWORD)(LPVOID) &mciOpen);
  if (err == MMSYSERR_NOERROR)
    DeviceID = mciOpen.wDeviceID;
  return err;
}



DWORD CDROM::playmci(MSF& Start, MSF& Length)
{
  DWORD err;
  MSF End;
  MCI_SET_PARMS mciSet;
  MCI_PLAY_PARMS mciPlay;

  // Setze Zeitformat auf MSF.
  ZeroMemory(&mciSet, sizeof(mciSet));
  mciSet.dwTimeFormat = MCI_FORMAT_MSF;
  err = mciSendCommand(DeviceID, MCI_SET, 
    MCI_SET_TIME_FORMAT | MCI_WAIT, (DWORD)(LPVOID) &mciSet);
  if (err != MMSYSERR_NOERROR) return err;
  End = Start + Length;

  // Starte das Abspielen.
  ZeroMemory(&mciPlay, sizeof(mciPlay));
  mciPlay.dwFrom = MCI_MAKE_MSF(Start.GetMinute(), Start.GetSecond(), Start.GetFrame());
  mciPlay.dwTo = MCI_MAKE_MSF(End.GetMinute(), End.GetSecond(), End.GetFrame());
  err = mciSendCommand(DeviceID, MCI_PLAY,
    MCI_FROM | MCI_TO | MCI_WAIT, (DWORD)(LPVOID) &mciPlay);
  return err;
}



DWORD CDROM::closemci()
{
  DWORD err = mciSendCommand(DeviceID, MCI_CLOSE, 0, 0);
  DeviceID = NULL;
  return err;
}



DWORD CDROM::open()
{
  DWORD er, ol;

  er = 0;
  hFile = CreateFile(Device, GENERIC_READ, FILE_SHARE_READ,
                  NULL, OPEN_EXISTING, 0, NULL);
  if (hFile == INVALID_HANDLE_VALUE) return GetLastError();
  if (er = ScsiMaxBlocks(hFile, &mb))
    return er;
  if (!DeviceIoControl(hFile, FSCTL_LOCK_VOLUME,
                      NULL, 0, NULL, 0, &ol, NULL)) {
    return GetLastError();
  }
  return er;
}



DWORD CDROM::close()
{
  DWORD er, ol;

  er = 0;
  if (!DeviceIoControl(hFile, FSCTL_UNLOCK_VOLUME,
                      NULL, 0, NULL, 0, &ol, NULL))
    er = GetLastError();
  if (!CloseHandle(hFile))
    er = GetLastError();
  hFile = NULL;
  return er;
}



//
// Liest Audio Daten von CD-Rom.
//
// Parameter:
// lb - Block der gelesen werden soll.
// bc - Anzahl zu lesender Blcke.
// db - Zeiger zu Datenbuffer.
// dl - Lnge des Datenbuffers.
//
DWORD CDROM::read(DWORD lb, DWORD bc, void *db, DWORD dl)
{
  DWORD er, il, ol;
  SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER sb;

  ZeroMemory(&sb, sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER));
  sb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
  sb.sptd.PathId = 0;
  sb.sptd.TargetId = 1;
  sb.sptd.Lun = 0;
  sb.sptd.CdbLength = 6;
  sb.sptd.DataIn = SCSI_IOCTL_DATA_IN;
  sb.sptd.SenseInfoLength = 32;
  sb.sptd.DataTransferLength = dl;
  sb.sptd.TimeOutValue = 4;
  sb.sptd.DataBuffer = db;
  sb.sptd.SenseInfoOffset =
     offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf);
  sb.sptd.Cdb[0] = SCSIOP_READ6;
  sb.sptd.Cdb[1] = LOBYTE(HIWORD(lb));
  sb.sptd.Cdb[2] = HIBYTE(LOWORD(lb));
  sb.sptd.Cdb[3] = LOBYTE(LOWORD(lb));
  sb.sptd.Cdb[4] = LOBYTE(LOWORD(bc));
  il = sizeof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER);
  if (DeviceIoControl(hFile, IOCTL_SCSI_PASS_THROUGH_DIRECT,
                      &sb, il, &sb, il, &ol, NULL)) {
    er = sb.sptd.ScsiStatus ? sb.sptd.ScsiStatus | 0x20000000 : 0;
  }
  else {
    er = GetLastError();
  }
  return er;
}



ostream& operator<< (ostream& os, CDROM& cdrom)
{
  os << cdrom.toc;
  return os;
}
