// cdinfo.cpp
// 
// Informationen ber SCSI-CD-ROM.
//
// Johannes Karanitsch 01.12.1996

#include "cdrom.h"

extern char ProgramPath[_MAX_PATH];

static char *TypeFileName = "CDRomTypes.txt";



//
// Sucht erstes CD-Rom Laufwerk.
//
// Parameter:
// Keine.
//
char GetFirstCDRom(void)
{
  int i, l;
  char *d;
  char b[128];

  l = GetLogicalDriveStrings(128, b);
  if (l == 0)
    return ' ';
  d = b; i = 0;
  while (*d && i < l) {
    if(GetDriveType(d) == DRIVE_CDROM)
      return *d;
    d += 4; i += 4;
  }
  return ' ';
}



//
// Ermittelt den Laufwerkstyp.
//
// Parameter:
// device - Zeiger zur Laufwerksbezeichnung.
// type - Zeiger zum Laufwerkstyp.
//
DWORD GetCDRomType(char *device, int *type)
{
  DWORD er;
  HANDLE fh;
  SCSI_INQUIRY_DEVICE id;
  ostrstream name;
  char pn[_MAX_PATH];

  fh = CreateFile(device, GENERIC_READ, FILE_SHARE_READ,
                  NULL, OPEN_EXISTING, 0, NULL);
  if (fh == INVALID_HANDLE_VALUE) return GetLastError();
  if (er = ScsiInquire(fh, &id)) return er;
  if (!CloseHandle(fh)) return GetLastError();
  name.write(id.VendorId, 8); name << " ";
  name.write(id.ProductId, 16); name << " ";
  name.write(id.ProductRevLevel, 4); name << ends;
  strcpy(pn, ProgramPath);
  strcat(pn, TypeFileName);
  *type = GetPrivateProfileInt(name.str(), "Type", 0, pn);
  if (!*type) {
    cout << "ERROR: unknown drive!\nInsert in " << pn
         << ":\n[" << name.str() << "]\n"
         << "Type=[1|2|3]" << endl;
  }
  else if (*type > 3) {
    cout << "ERROR: wrong type in " << TypeFileName
         << ":\n[" << name.str() << "]\n"
         << "Type=" << *type << endl;
    *type = 0;
  }
  return 0;
}
