// cdinfo.cpp
// 
// Liest Audio digital von SCSI-CD-ROM.
//
// Johannes Karanitsch 01.12.1996

#include "cdrom.h"

static const char *HelpText =
"syntax: cd2wav [option] WaveFile.wav\n"
"/l                 track listing of CD\n"
"/p                 play audio\n"
"/w                 write to WAVE file\n"
"/m=start,length    MSF format: MM:SS.FF\n"
"/t=number          track\n"
"/d=<drive>:        drive letter: A-Z\n"
"/v=<vendor>        vendor type: 1-3\n";

static const char *WrongOpt = "Wrong option: ";

static char *CdDevice = "\\\\.\\x:";
char ProgramPath[_MAX_PATH];
char AudioData[AUDIO_BLOCK_LEN];



//
// Gibt eine Fehlermeldung aus.
//
// Parameter:
// txt - Text wo der Fehler auftrat.
// err - Fehlernummer.
//
void PrintError(char *txt, DWORD err)
{
  DWORD l;
  char eb[128];

  l = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err,
                    0, eb, sizeof(eb), NULL);
  cout << "ERROR: " << txt << " ";
  if (l) cout << eb; else cout << err;
  cout << endl; 
}



//
// Hauptprogramm.
//
// Parameter:
// argc - Anzahl der Argumente.
// argv - Zeiger zu den Argumenten.
//
int main(int argc, char **argv)
{
  CDROM *cdrom = NULL;
  WAVFILE *wf = NULL;
  char *s, *fn = NULL;
  DWORD er, lb, eb;
  int i, l, cdType, TrackNr;
  MSF Start, Length, End;
  OPTION option = unknown;
  char cd;

  cout << "\ncd2wav 96 (Build 1201) (c) Johannes Karanitsch 1996\n" << endl; 
  if (argc < 2) {
    cout << HelpText << endl;
    return 1;
  }
  strcpy(ProgramPath, *argv);
  l = strlen(ProgramPath);
  for (s = ProgramPath + l; s >= ProgramPath && *s != '\\'; s--)
    *s = '\0';
  if (strlen(ProgramPath) < 3) {
    _getcwd(ProgramPath, sizeof(ProgramPath));
    strcat(ProgramPath, "\\");
  }
  cd = GetFirstCDRom();
  cdType = TrackNr = 0;
  for (i = 1; i < argc; i++) {
    argv++;
    s = *argv;
    if (*s == '/') {
      s++;
      l = strlen(s);
      switch(tolower(*s)) {

      case 'l': // track listing of CD
        option = list;
        break;
      
      case 'p': // play audio
        option = play;
        break;
      
      case 'w': // write to WAVE file
        option = record;
        break;
      
      case 'm': // MSF format
        if (l < 19) {
          cout << WrongOpt << *argv << endl;
          return 1;
        }
        s += 2;
        Start.SetMinute(atoi(s)); s += 3;
        Start.SetSecond(atoi(s)); s += 3;
        Start.SetFrame(atoi(s)); s += 3;
        Length.SetMinute(atoi(s)); s += 3;
        Length.SetSecond(atoi(s)); s += 3;
        Length.SetFrame(atoi(s));
        break;
      
      case 't': // track
        if (l < 3) {
          cout << WrongOpt << *argv << endl;
          return 1;
        }
        s += 2;
        TrackNr = atoi(s);
        break;
      
      case 'd': // drive letter
        if (l != 4) {
          cout << WrongOpt << *argv << endl;
          return 1;
        }
        s += 2;
        if(GetDriveType(s) == DRIVE_CDROM) {
          cd = *s;
        }
        else {
          cout << s <<" is no CD-ROM" << endl;
          return 1;
        }
        break;
      
      case 'v': // vendor type
        if (l < 3) {
          cout << WrongOpt << *argv << endl;
          return 1;
        }
        s += 2;
        cdType = atoi(s);
        if (cdType < 1 || cdType > 3) {
          cout << WrongOpt << *argv << endl;
          return 1;
        }
        break;
      
      default:
        cout << "unknown option: " << *argv << "\n\n" << HelpText << endl;
        return 1;
        break;
      }
    }
    else {
      fn = *argv;
    }
  }
  if (cd == ' ') {
    cout << "ERROR: no CD-drive found.\n" << endl; 
    return 2;
  }
  CdDevice[4] = cd;
  if (!cdType) {
    if (er = GetCDRomType(CdDevice, &cdType)) {
      PrintError(CdDevice, er);
      return 2;
    }
  }
  switch (cdType) {
  case 1:
    cdrom = new CDROM_TYPE_1(CdDevice);
    break;
  case 2:
    cdrom = new CDROM_TYPE_2(CdDevice);
    break;
  case 3:
    cdrom = new CDROM_TYPE_3(CdDevice);
    break;
  default:
    return 2;
    break;
  }
  if (er = cdrom->readtoc()) {
	PrintError("Read TOC", er);
	goto exitmain;
  }
  if (option == play || option == record) {
    if (TrackNr) {
      TRACK* Track = cdrom->GetTrack(TrackNr);
      if (Track) {
        if (Track->GetType() == MCI_CDA_TRACK_AUDIO) {
          Start = Track->GetStart();
          Length = Track->GetLength();
        }
        else {
          cout << "ERROR: no audio track #" << TrackNr << endl;
          goto exitmain;
        }
      }
      else {
        cout << "ERROR: no track #" << TrackNr << endl;
        goto exitmain;
      }
    }
    End = cdrom->GetTrack(1)->GetStart() + cdrom->GetCDLength();
    if (Start < cdrom->GetTrack(1)->GetStart() ||
        Start > End) {
      cout << "ERROR: wrong start position: " << Start << endl;
      er = 42;
      goto exitmain;
    }
    if (Length.GetLbn() < 1 || (Start + Length) > End) {
      cout << "ERROR: wrong length: " << Length << endl;
      er = 42;
      goto exitmain;
    }
  }
  switch (option) {
  case list:
    cout << *cdrom;
    break;

  case play:
    cout << "Playing ..." << endl;
    if (er = cdrom->openmci()) {
      PrintError("Open MCI", er);
      goto exitmain;
    }
    if (er = cdrom->playmci(Start, Length)) {
      PrintError("Play MCI", er);
      goto exitmain;
    }
    if (er = cdrom->closemci()) {
      PrintError("Close MCI", er);
      goto exitmain;
    }
    break;
  
  case record:
    if (fn == NULL) {
      cout << "ERROR: no output filename." << endl;
      er = 42;
      goto exitmain;
    }
    if (er = cdrom->open()) {
      PrintError("Open cdrom", er);
      goto exitmain;
    }
    wf = new WAVFILE;
    if (er = wf->open(fn, Length)) {
      PrintError("Open wav file", er);
      goto exitmain;
    }
    cout << "Writing ..." << endl;
    lb = Start.GetLbn() - cdrom->GetTrack(1)->GetStart().GetLbn();
    for (eb = lb + Length.GetLbn(); lb < eb; lb++){
      if (er = cdrom->read(lb, 1, AudioData, AUDIO_BLOCK_LEN)) {
        PrintError("Read cdrom", er);
        goto exitmain;
      }
      if (er = wf->write(AudioData, AUDIO_BLOCK_LEN)) {
        PrintError("Write wav", er);
        goto exitmain;
      }
    }
    if (er = wf->close()) {
      PrintError("Close wav file", er);
      goto exitmain;
    }
    if (er = cdrom->close()) {
      PrintError("Close cdrom", er);
      goto exitmain;
    }
    break;
  }
  er = 0;

exitmain:
  delete cdrom;
  delete wf;
  return er;
}
