#include <string.h>
#include <string>
#include <iostream.h>
#include <strstream.h>
#include "Handshaker.h"
#include <SIOUX.H>

Boolean gQuit=false;

void InitToolbox(void);  // Standard-Mac-Initialisierung
void InitToolbox(void) {
	MaxApplZone();
	MoreMasters();
	InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	InitCursor();
	FlushEvents(everyEvent,0);
}

const string long2string(const long l);  
// long-Zahl in string-Objekt konvertieren
const string long2string(const long l) {
	ostrstream oBuffer;
	oBuffer << l << ends;
	string s = string(oBuffer.str());
	oBuffer.freeze(0);
	return s;
}

void SysAlert(const string theMessage);	
// Botschaft ohne eigene Resourcen
void SysAlert(const string theMessage) {
	static const short System_Alert_rsc = -16411;// ALRT resource aus der Systemdatei,
	char c[256];  strcpy(c, theMessage.c_str()); // diese Nummer gibt's in jedem System
	ParamText(CtoPstr(c),nil,nil,nil);
	Alert(System_Alert_rsc,nil);
}

void ErrorExit(string theMessage, OSErr errorNumber = noErr); 
// Programmabbruch mit Begrndung
void ErrorExit(string theMessage, OSErr errorNumber) {
	if (errorNumber != noErr)
		theMessage = theMessage + ". Error: " + long2string(errorNumber);
	InitCursor();
	PenNormal();
	const RGBColor blackRGB={0,0,0}, whiteRGB={0xFFFF,0xFFFF,0xFFFF};
	RGBForeColor(&blackRGB);  RGBBackColor(&whiteRGB);
	TextFont(GetSysFont());
	TextFace(nil);
	TextMode(srcCopy);
	TextSize(12);
	SysAlert(theMessage);
	ExitToShell();
}

// Einige Apple-Event-Handler. Wenn wir keine haben, drfen wir auch keine senden.
// Zumindest tun wir so
pascal OSErr DummyAEHandler(AppleEvent *theAppleEvent, AppleEvent *reply, long refCon);
pascal OSErr DummyAEHandler(AppleEvent *theAppleEvent, AppleEvent *reply, long refCon) {
	#pragma unused (theAppleEvent,reply,refCon)
	return(errAEEventNotHandled);
}

pascal OSErr MyHandleOAPP(AppleEvent *theAppleEvent, AppleEvent *reply, long refCon);
pascal OSErr MyHandleOAPP(AppleEvent *theAppleEvent, AppleEvent *reply, long refCon) {
	#pragma unused (theAppleEvent,reply,refCon)
	return(errAEEventNotHandled);
}

pascal OSErr MyHandleQUIT(AppleEvent *theAppleEvent, AppleEvent *reply, long refCon);
pascal OSErr MyHandleQUIT(AppleEvent *theAppleEvent, AppleEvent *reply, long refCon) {
	#pragma unused (theAppleEvent,reply,refCon)
	gQuit = true;  return(noErr);
}

Boolean hasAppleEvents();	
// mglicherweise System zu alt oder Apple-Events abgestellt
Boolean hasAppleEvents() {
	long gSystemVersion, aGestaltFeature;
	if (Gestalt(gestaltSystemVersion, &gSystemVersion) == noErr)
		if (gSystemVersion >= 0x700) {
			if (Gestalt(gestaltAppleEventsAttr, &aGestaltFeature) == noErr)
				return ((aGestaltFeature & (1 << gestaltAppleEventsPresent)) != 0);
		}
	return false;
}

/*Das Ziel von Apple-Events kann man u.a. ber die 'ProcessSerialNumber' festlegen.
hier gehen wir davon aus, da ein kleines AppleScript namens 
'HSKiEventEmpfnger' als Application im "stay open"-Modus luft. 
Dieses Programm sollte im PPCBrowser-Dialog ausgewhlt werden.*/

ProcessSerialNumber GetReceiverPSN(void);
ProcessSerialNumber GetReceiverPSN(void) {
	PortInfoRec thePortInfo;  LocationNameRec theLocation;
	OSErr anErr = PPCBrowser("\pAn wen soll der Event verschickt werden?","\p'HSKiEventEmpfnger'",false,&theLocation,&thePortInfo,nil,nil);
	ProcessSerialNumber pPSN;
	GetProcessSerialNumberFromPortName(&thePortInfo.name, &pPSN);
	return pPSN;
}

void SendAppleEvent(ProcessSerialNumber pPSN, AEEventClass theClass, AEEventID theID);
void SendAppleEvent(ProcessSerialNumber pPSN, AEEventClass theClass, AEEventID theID) {
	AEDesc myAddressDesc;
	if (noErr != AECreateDesc(typeProcessSerialNumber,(Ptr) &pPSN, sizeof(pPSN), &myAddressDesc))
		return;
	AppleEvent aeEvent;
	OSErr anErr = AECreateAppleEvent (theClass, theID, &myAddressDesc,
		kAutoGenerateReturnID, kAnyTransactionID, &aeEvent);
	if (noErr == anErr) {
		anErr = AESend(&aeEvent, nil, kAENoReply+kAECanInteract+kAECanSwitchLayer,
				kAENormalPriority, kAEDefaultTimeout, nil, nil);
		AEDisposeDesc(&aeEvent);
	}
	AEDisposeDesc(&myAddressDesc);
}

void InstallStandardEventHandlers();
void InstallStandardEventHandlers() {
	OSErr anErr = PPCInit();
	anErr = AEInstallEventHandler(kCoreEventClass,kAEOpenApplication,NewAEEventHandlerProc(MyHandleOAPP), nil,false);
	if (anErr != noErr)	 ErrorExit("Error: InstallAppleEvt");
	anErr = AEInstallEventHandler(kCoreEventClass,kAEOpenDocuments,NewAEEventHandlerProc(DummyAEHandler), nil,false);
	if (anErr != noErr)	 ErrorExit("Error: InstallAppleEvt");
	anErr = AEInstallEventHandler(kCoreEventClass,kAEPrintDocuments,NewAEEventHandlerProc(DummyAEHandler), nil,false);
	if (anErr != noErr)	 ErrorExit("Error: InstallAppleEvt");
	anErr = AEInstallEventHandler(kCoreEventClass, kAEQuitApplication, NewAEEventHandlerProc(MyHandleQUIT), nil, false);
	if (anErr != noErr)	 ErrorExit("Error: InstallAppleEvt");
}

void TestHandshakeOut(void);
void TestHandshakeOut(void) {
	Handshaker *hsk = new Handshaker(handshakerModem);
	if (!hsk->Ok())
		ErrorExit("Handshaker-Objekt konnte nicht erstellt werden");
	cout << "Test des Ausgangs, Abbruch mit Maustaste." << endl
		<< "Modem am Modemanschlu? Dann mu jetzt DTR blinken." << endl;
	do {
		hsk->HSKtoggle();	
		cout << "." << flush;
		Delay(17, nil);
	} while (!Button());
	while (Button()) ;
	delete hsk;
}

void TestHandshakeIn(void);
void TestHandshakeIn(void) {
	Handshaker *hsk = new Handshaker(handshakerModem);
	if (!hsk->Ok())
		ErrorExit("Handshaker-Objekt konnte nicht erstellt werden");
	hsk->HSKout(false);	
// damit zum einfachen Testen negative Spannung vom Handshake-
// Ausgang an den Handshake-Eingang gelegt werden kann.
	cout << "Test des Handshake-Eingangs, Abbruch mit Maustaste." << endl
		<< "Modem am Modemanschlu? "
		<< "Aus/Einschalten ndert vielleicht den Pegel." << endl;
	do {
		if (hsk->HSKin()) 
		 	cout << "+" << flush;
		 else
		 	cout << "-" << flush;
	 	Delay(17, nil);	// 17 = 1 Sekunde
	} while (!Button());
	delete hsk;
}

void HandshakeInGeneratesAppleEvent(void);
void HandshakeInGeneratesAppleEvent(void) {
	if (!hasAppleEvents())
		ErrorExit("Bedauere, es stehen keine AppleEvents zur Verfgung");
	InstallStandardEventHandlers();
	Handshaker *hsk = new Handshaker(handshakerModem);
	if (!hsk->Ok())
		ErrorExit("Handshaker-Objekt konnte nicht erstellt werden");
// wer soll den Apple-Event bekommen? Interaktive Abfrage
	ProcessSerialNumber psn = GetReceiverPSN();
	if ((psn.highLongOfPSN == kNoProcess) && (psn.lowLongOfPSN == kNoProcess))
		ExitToShell();
	cout << "Ich warte jetzt darauf, da sich an der Handshake-Leitung vom Modem" << endl
	<< "der Pegel ndert (oder "e" gedrckt wird), dann lse ich ein Apple-Event aus." << endl
	<< endl << "Ende mit "q" oder Maustaste" << flush;
	Boolean oldState = hsk->HSKin(); // Ausgangszustand merken
	do {	// eine typische kleine Event-Schleife
		EventRecord myEvent;
		if (WaitNextEvent(everyEvent, &myEvent, 1, nil)) {
			if (myEvent.what == mouseDown)  gQuit=true;
			else if (myEvent.what == keyDown) {
				switch (char(myEvent.message & charCodeMask)) {
					case 'e':  SendAppleEvent(psn, 'HSHK', 'keye');  break;
					case 'q':  gQuit = true;  break;
				}
			}
		}
		Boolean theState = hsk->HSKin(); // Zustand abfragen
		if (theState != oldState) {	//Zustand verndert?
			oldState = theState;		
			SendAppleEvent(psn, 'HSHK', 'modi');
		}
	} while (!gQuit);
	delete hsk;  // damit wird der Modem- bzw. Printer-Anschlu wieder freigegeben
}

void main(void) {
	SIOUXSettings.asktosaveonclose = false;		
	SIOUXSettings.autocloseonquit = true;		
	SIOUXSettings.initializeTB = false; // das machen wir selber
	InitToolbox();
//	TestHandshakeIn();
//	TestHandshakeOut();
	HandshakeInGeneratesAppleEvent();
}