{
  VIDEO101.PAS - der Aufsatz auf VIDEO13H.PAS fr Mode 101h

  Borland Pascal 7.0

  Version 2.0

  Ansgar Scherp   ( Ansgar.Scherp@Informatik.Uni-Oldenburg.DE )
  Joachim Gelhaus ( J.Gelhaus@Flight.Gun.DE )

  Diese Routinen sind NUR im Protected Mode lauffhig.

  aus 'Patchwork' c't 4/97 S. 442

}

{$IFNDEF DPMI}Nur im Protected Mode lauffhig...{$ENDIF}

unit VI101LFB;

interface

uses VIDEO13;

type { der neue Datentyp fr die virtuellen Bildschirmseiten im Modus 101h }
  TPage101h = array[0..5] of pointer;

const
  Mode101h : word = $101; { der Bildschirmmodus 640x480x256 }

{ Baut einen Zeiger auf den LFB. In vidSize steht die Gre des
  bentigten Bildschirmspeiches }
Function makeLFBSelector(vidSize :longint):boolean;

{ Funktionalitten der Prozeduren und Funktionen nahezu analog
  zu Video13.PAS }

{ Initialisieren des VideoModus 101h }
procedure InitVideo101h;

{ festlegen der aktuellen virtuellen Seite; im Gegensatz zu den Video13h-
  Routinen ist es im Modus 101h jedoch AUSSCHLIESSLICH mglich in virtuellen
  Seiten direkt zu schreiben }
procedure ActivePage101h( var page : TPage101h );

{ setzten eines Videomodus }
procedure SetVideoMode101h( mode : word );

{ setzen des Fensterrahmens im Modus 640x580x256 }
procedure SetWindow101h( x1, y1, x2, y2 : longint );

{ kopieren einer virtuellen Seite in eine andere virtuellen Seite; SrcPage
  und DstPage sind Datentypen vom Typ TPage101h und MSSEN eine virtuelle
  Seite sein }
procedure CopyP2P101h( var DstPage, SrcPage : TPage101h);
{ kopieren einer virtuellen Bildschirmseite auf in den visuellenn, d.h.
  sichtbaren Grafikspeicher }
procedure CopyP2V101h( var page : TPage101h);

{ lschen einer virtuellen Seite }
procedure ClearPage101h( page : TPage101h);
{ lschen der visuellen Seite }
procedure ClearVisualPage101h;

{ initialisieren einer virtuellen Bildschirmseite fr den Modus 101h }
procedure InitPage101h( var page : TPage101h);
{ schliessen einer virtuellen Bildschirmseite des Modus 101h }
procedure ClosePage101h( var page : TPage101h);

{ PutSprite-Routine fr 640x480x256 }
procedure PutSprite101h( x, y : integer; sprite : TSprite );
{ GetSprite-Routine fr 640x480x256 }
procedure GetSprite101h( x, y : integer; sprite : TSprite );

{ Standard Put-/GetPixel-Routinen  }
procedure PutPixel101h( x, y : longint; c : byte );
function  GetPixel101h( x, y : longint ) : byte;

implementation

uses DPMI;

type
  Modes   = array[0..255] of word;
  PModes  = ^Modes;
  ASCII   = array[0..255] of char;
  PASCII  = ^PASCII;

  TVESAInfo = { allgemeine VESA-Informationen }
     record
       signature    : array[ 0 .. 3 ] of char; { VESA-Signatur: "VESA" }
       version      : array[ 0 .. 1 ] of byte; { Versionsnummer }
       OEMName      : PASCII;                  { Herstellername }
       capabilities : array[ 0 .. 3 ] of byte;
       vmodes       : PModes;
       reserved     : array[ 0 .. 237 ] of byte;
     end;

  TModeInfo = { diverse Infos zu den Videomodus }
    record
      attributes       : word;
      winA             : byte;
      winB             : byte;
      granularity      : word;
      size             : word;
      segA             : word;
      segB             : word;
      eqv4f05          : longint;
      bytesperscanline : word;
      width            : word;
      height           : word;
      characterwidth   : byte;
      characterheight  : byte;
      planes           : byte;
      bitsperpixel     : byte;
      banks            : byte;
      memorymodel      : byte;
      sizeofbank       : byte;
      NumberOfImagePages:byte;
      Reserved         : byte;
      RedMaskSize      : byte;
      RedFieldPos      : byte;
      GreenMaskSize    : byte;
      GreenFieldPos    : byte;
      BlueMaskSize     : byte;
      BlueFieldPos     : byte;
      RsvdMaskSize     : byte;
      RsvdFieldPos     : byte;
      DirectColorInfo  : byte;
      PhysBasePtr      : longint;
      OffScrMemOffset  : longint;
      OffScrMemSize    : longint;
      res              : array[ 0 .. 206 ] of byte;
    end;

    TSel        = Word;     { Selector     }

    TMemHandle  =
      Record    { Handle fr Speicherblock. }
        Sel     : TSel;
        Handle  : LongInt;  { fr DPMI-Verwaltung }
      End;

    TDescriptor =
      Record
        SegmentLimit0 : Word;
        BaseAddr0     : Word;
        BaseAddr1     : Byte;
        Flags1        : Byte;
        Flags2        : Byte;
        BaseAddr2     : Byte;
      End;

var
  ActVPage101h   : TPage101h; { aktive virtuelle Seite; Seite auf die sich
                                alle folgenden Operationen beziehen }
  RealRegs       : TRealModeRegs; { ein 'Satz' RealMode-Register }
  LowMemoryBlock : TLowMemoryBlock; { Speicherblock unterhalb des ersten MB }
  VesaInfo       : TVesaInfo;       { allgemeine VESA-Informationen }
  ModeInfo       : TModeInfo;       { Informationen zum Modus 101h }
  Granny         : byte;            { untersttzte Granularitt }
  BankNr         : byte;            { BankNr der Grafikkarte }
  LFBHandle      : tMemHandle;

const { die Fensterrahmen fr die 6 'kleinen' Blcke in Mode 101h }
  Windows101h : array[ 0..5 { Block 0 bis 5 } , 1..4 ] of integer = (
                  (0,319,0,199), (0,319,0,199), (0,319,0,199),
                  (0,319,0,199), (0,319,0,199), (0,319,0,199));

var { der Fensterrahmen des SVGA-Modus }
  GlobalWindowX1, GlobalWindowX2,
  GlobalWindowY1, GlobalWindowY2 : longint;

procedure GetModeInfo( mode : word );
var
  x : word;
begin
  { allozieren von 300 Byte Speicher, der unterhalb des ersten MB liegt,
    d.h. er ist sowohl im Real Mode als auch im Protected Mode ansprechbar }
  AllocateLowMem( LowMemoryBlock,300 );
  { zunchst mit Dummynullen fllen }
  FillChar( RealRegs, SizeOf( RealRegs ), 0 );
  { Real Mode Segment auf den LowMemoryBlock }
  RealRegs.es := LowMemoryBlock.RealModeSeg;
  RealRegs.cx := mode;
  RealRegs.ax := $4f01; { holt sich bezglich des Modus mode die VESA Info }
  if SimRealModeInt( $10, RealRegs ) = false then
    begin
      writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
      halt(1);
    end;
  { kopieren der Informationen aus dem LowMemoryBlock in die Variable
    VESAInfo, damit die Informationen anschliessend direkt im Protected Mode
    ausgelesen werden knnen }
  for x := 0 to sizeof( ModeInfo ) - 1 do
    mem[ seg( ModeInfo ) : ofs( ModeInfo ) + x ] :=
      mem[ LowMemoryBlock.ProtModeSel : x ];
  { freigeben des LowMemoryBlocks }
  FreeLowMem( LowMemoryBlock );
  { Berechnung der Granularitt }
  granny := 64 div ModeInfo.granularity;
end;

{ -------- LFB-Routinen (siehe auch c't 7/93 S. 204) --------- }

  Procedure GetDescriptor(Sel : TSel;Var Descr : TDescriptor);
  Begin
    Asm
      MOV   AX,$000B        { Get Descriptor (LDT)  }
      MOV   BX,Sel
      LES   DI,Descr
      INT   $31
    End;
  End;

  Procedure SetDescriptor(Sel : TSel;Var Descr : TDescriptor);
  Begin
    Asm
      MOV   AX,$000C        { Set Descriptor (LDT)  }
      MOV   BX,Sel
      LES   DI,Descr
      INT   $31
    End;
  End;


Function makeLFBSelector(vidSize :longint):boolean;
  Var
    tmpDescr : TDescriptor;
    baseAdrLow,baseAdrHigh :word;
  Begin
    If modeInfo.physBasePtr = 0 then Exit;
    baseAdrLow:=modeInfo.physBasePtr;
    baseAdrHigh:=modeInfo.physBasePtr shr 16;
    LFBHandle.Sel := 0;
    Asm
      MOV     CX,baseAdrLow
      MOV     BX,baseAdrHigh
      PUSH    CX
      PUSH    BX
      MOV     BX,OFFSET LFBHandle
      MOV     ES:[BX].2,DI { P.Handle }
      MOV     ES:[BX].4,SI
      MOV     AX,$0000     { Allocate LDT Descriptor }
      MOV     CX,1
      INT     $31
      MOV     ES:[BX].0,AX { Selector }
      POP     CX
      POP     DX           { Linear Address }
      MOV     BX,AX
      JC      @@Exit
      MOV     AX,$0007     { Set Segment Base Address }
      INT     $31
      JC      @@Exit
      MOV     @Result,1
@@Exit:
    End;

    If LFBHandle.Sel = 0 then Exit;
    GetDescriptor(LFBHandle.Sel,tmpDescr);
    With tmpDescr do
      Begin
        Dec(vidSize);
        If vidSize >= $100000 then     { > 1MB ? }
          Begin
            vidSize  := vidSize Shr 12;   { Granularity = 4KB }
            Flags2 := Flags2 or $80;
          End;
        SegmentLimit0 := Word(vidSize);
        Flags2 := Flags2 or (vidSize Shr 16);
      End;
    SetDescriptor(LFBHandle.Sel,tmpDescr);
  End;

procedure SetVideoMode101h( mode : word );
begin
  RealRegs.ax := $4f02; { set video mode }
  RealRegs.bx := mode;
  if SimRealModeInt($10,RealRegs)=false then
  begin { falls ein Fehler aufgetreten ist }
    writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
    halt(1);
  end;
end;

{ gibt zu einem absoluten x-Wert des 640x480 Bildschirms den relativen
  x-Wert der dazugehrdenen 320x200 Seite bzw. Block }
function CalcPageX( x : integer; bank : word ) : integer;
begin
  asm
    cmp bank, 0; je @ende
    cmp bank, 2; je @ende
    cmp bank, 4; je @ende
    sub x, 320 { Block 1,3,5 }
    @ende:
  end;
  CalcPageX := x;
end;

{ gibt zu einem absoluten y-Wert des 640x480 Bildschirms den relativen
  y-Wert der dazugehrdenen 320x200 Seite bzw. Block }
function CalcPageY( y : integer; bank : word) : integer;
begin
  asm
    cmp bank, 2
    jb @ende
      sub y, 200 { Block 2, 3 }
      cmp bank, 4
      jb @ende
      sub y, 200 { Block 4,5 }
    @ende:
  end;
  CalcPageY := y
end;

{ arbeitet wie CalcPageX/Y, erwartet jedoch als Argument sowohl X als
  auch Y Koordinate }
function GetPage( x, y : integer ) : word;
var
  SubPage : byte;
begin
  if x <= 319 then
      SubPage := 0
    else
      SubPage := 1;
  if y >= 400 then
      inc(SubPage,4)
    else
      if y >= 200 then
        inc(SubPage,2);
  GetPage := SubPage;
end;

procedure SetWindow101h( x1, y1, x2, y2 : longint );
var
  h     : longint;
  block : byte;
  rx1, rx2, ry1, ry2 : integer;
begin
  { wenn der Fensterrahmen ausserhalb des gltigen Bereiches liegt, dann
    begrenzen }
  if x1 < 0 then x1 := 0; if x1 > 639 then x1 := 639;
  if y1 < 0 then y1 := 0; if y1 > 479 then y1 := 479;
  { vertauschen der Grenzen links/rechts bzw. oben/unten falls ntig }
  if x1 > x2 then begin h := x2; x2 := x1; x1 := h; end;
  if y1 > y2 then begin h := y2; y2 := y1; y1 := h; end;
  { nun von Block 0 bis 5 den Fensterrahmen berechnen und festlegen }

  GlobalWindowX1 := x1;
  GlobalWindowX2 := x2;
  GlobalWindowY1 := y1;
  GlobalWindowY2 := y2;

  for block := 0 to 5 do
    begin
      rx1 := CalcPageX( x1, block ); ry1 := CalcPageY( y1, block );
      rx2 := CalcPageX( x2, block ); ry2 := CalcPageY( y2, block );
      SetWindow( rx1, ry1, rx2, ry2 ); { Rahmen des Blocks setzen }
      if ( WindowX1 = WindowX2 ) or ( WindowY1 = WindowY2 ) then
        begin { falls Breite oder Tiefe des Rahmens gleich Null ist }
          WindowX1 := 0; WindowX2 := 0; WindowY1 := 0; WindowY2 := 0;
        end;
    { den Rahmen jedes Blocks fr die anderen Routinen 'merken' }
    Windows101h[ block, 1 ] := WindowX1; Windows101h[ block, 2 ] := WindowX2;
    Windows101h[ block, 3 ] := WindowY1; Windows101h[ block, 4 ] := WindowY2;
  end;
end;

procedure SetBank( bank : byte );
begin
  RealRegs.ax := $4f05; RealRegs.bx := $0000; { set bank }
  RealRegs.dx := bank * granny;
  if SimRealModeInt( $10, RealRegs ) = false then
    begin { falls ein Fehler aufgetreten ist }
      writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
      halt(1);
    end;
end;

procedure GetVESAInfo;
var
  x : word;
begin
  { allozieren von 300 Byte Speicher, der unterhalb des ersten MB liegt,
    d.h. er ist sowohl im Real Mode als auch im Protected Mode ansprechbar }
  AllocateLowMem( LowMemoryBlock ,300 );
  { zunchst mit Dummynullen fllen }
  FillChar( RealRegs, SizeOf( RealRegs ), 0 );
  { Real Mode Segment auf den LowMemoryBlock }
  RealRegs.es := LowMemoryBlock.RealModeSeg;
  RealRegs.ax := $4f00; { get VESA info }
  if SimRealModeInt( $10, RealRegs ) = false then
    begin { falls ein Fehler aufgetreten ist }
      writeln( 'GetSimRealModeIntFehler: ', SimRealModeIntErrorCode );
      halt(1);
    end;
  { kopieren der Informationen aus dem LowMemoryBlock in die Variable
    VESAInfo, damit die Informationen anschliessend direkt im Protected Mode
    ausgelesen werden knnen }
  for x := 0 to sizeof( VesaInfo) - 1 do
    mem[ seg( VESAInfo ) : ofs( VESAInfo) + x ] :=
      mem[ LowMemoryBlock.ProtModeSel: x ];
  { freigeben des LowMemoryBlocks }
  FreeLowMem( LowMemoryBlock );
end;

procedure InitVideo101h;
begin
  SetWindow101h( 0, 0, 639, 479 );
  GetVESAInfo;
  if VesaInfo.Signature <> 'VESA' then { falls VESA-Signatur nicht gefunden }
    begin
      writeln('VESA VBE-Treiber nicht gefunden!'); halt(1);
    end;
  GetModeInfo( Mode101h );
  writeln( 'Granularitt   : ', ModeInfo.granularity, ' KBytes' );
  writeln( 'Bytes/Scanline : ', ModeInfo.bytesperscanline );
  writeln( 'Breite         : ', ModeInfo.width );
  writeln( 'Hhe           : ', ModeInfo.height );
end;

procedure ActivePage101h( var page : TPage101h );
begin
  ActVPage101h := page; { aktuelle Seite, auf der gearbeitet werden soll }
end;

procedure CopyP2P101h( var DstPage, SrcPage : TPage101h );
var
  b : byte;
  Src, Dst : pointer;
begin
  asm push ds end;
  for b := 0 to 5 do { kopier Block 0 bis 5 von SrcPage in die }
    begin            { entsprechenden Blcke von DstPage }
      Src := SrcPage[ b ];
      Dst := DstPage[ b ];
      asm
        les di, Src
        lds si, Dst
        mov cx, 16000
        db $66; rep movsw { movsd }
      end;
    end;
  asm pop ds end;
END;

{ Der Offset in off mu mit 16 erweitert werden (BP kann keine longints an
  Register bergeben }
procedure CopyLines(s1,s2:word;sel:word;off,lines:word);assembler;
asm
  db $66;pusha
  push ds
    db $66;xor ax,ax { eax:=0 }
    db $66;xor di,di { edi:=0 }
    db $66;xor si,si { esi:=0 }
    db $66;xor cx,cx { ecx:=0 }
    mov ax,lines         { Anzahl der zu kopierenden Zeilen }
    mov es,sel           { Selektor des Linear Frame Buffer }
    mov di,off           { Offset im LFB }
    db $66;shl di,4      { erweitern }
    mov ds,s1            { Segment von Block 1 }
    @loop1:              { linke Hlfte kopieren }
      mov cx,80
      db $66;db $67;rep movsw
      db $66;add di,320;dw 0
      dec ax
    jnz @loop1
    mov ax,lines         { Register neu initialisieren }
    mov si,0
    db $66;xor di,di
    mov di,off
    db $66;shl di,4
    db $66;add di,320;dw 0
    mov ds,s2
    @loop2:              { rechte Hlfte kopieren }
      mov cx,80
      db $66;db $67;rep movsw
      db $66;add di,320;dw 0
      dec ax
    jnz @loop2
  pop ds
  db $66;popa
end;

procedure CopyP2V101h(VAR page:TPage101h);
var s0, s1, s2, s3, s4, s5 : word;
begin
  s0 := seg(page[0]^); s1 := seg(page[1]^); s2 := seg(page[2]^);
  s3 := seg(page[3]^); s4 := seg(page[4]^); s5 := seg(page[5]^);
  CopyLines(s0,s1,LFBHandle.sel,0,200);             { Zeile 0  -199 }
  CopyLines(s2,s3,LFBHandle.sel,128000 div 16,200); { Zeile 200-399 }
  CopyLines(s4,s5,LFBHandle.sel,256000 div 16,80);  { Zeile 400-479 }
end;

procedure ClearPage101h( page : TPage101h );
var
  block : byte;
  ppage : pointer;
begin
  for block :=0 to 3 do        { Block 0 bis 3 }
    begin
      ppage := page[ block ];
      asm
        les di, ppage
        db $66; xor ax,ax { xor eax, eax }
        mov cx,64000 / 4  { volle 64000 Bytes lschen, d.h. 200 Zeilen }
        db $66; rep stosw { stosd }
      end;
    end;
  for block := 4 to 5 do      { Block 4 bis 5 }
    begin
      ppage := page[ block ];
      asm
        les di, ppage
        db $66; xor ax,ax { xor eax, eax }
        mov cx,25600 / 4  { 25600 Bytes lschen, d.h. 80 Zeilen }
        db $66; rep stosw { stosd }
      end;
    end;
end;

procedure ClearVisualPage101h;
begin
  asm
    mov es,LFBHandle.sel
    db $66;xor di,di
    db $66;xor ax,ax
    db $66;xor cx,cx
    mov cx,38400
    db $66;shl cx,1
    db $66;rep stosw
  end;
end;

procedure InitPage101h( var page : TPage101h );
var
  block : byte;
begin
  for block := 0 to 5 do InitPage( Page[ block ] );
  ActivePage101h( page );
end;

procedure ClosePage101h( var page : TPage101h );
var
  block : byte;
begin
  for block := 0 to 5 do
    ClosePage( Page[ block ] );
end;

procedure PutSprite101h( x, y : integer; sprite : TSprite );
var
  block      : word;
  posx, posy : integer;
begin
  block := 0;
  repeat
    { aktiven Block der 640x480 groen Seite auswhlen }
    ActVPage := ActVPage101h[ block ];
    { Rahmen fr den Block entsprechend des groen Rahmens festlegen }
    SetWindow( Windows101h[ block, 1 ], Windows101h[ block, 3 ],
               Windows101h[ block, 2 ], Windows101h[ block, 4 ] );
    { aus absoluten Koordinaten der 640x480 Seite die Koordinaten des
      Blocks berechnen, in dem gerade geschrieben werden soll }
    posx :=  CalcPageX( x, block ); posy :=  CalcPageY( y, block );
    { Sprite setzen; mit Hilfe der Routine fr die 320x200-Auflsung }
    PutSprite( posx, posy, sprite );
    inc( block ); { nchsten Block nehmen }
  until block > 5;
end;

procedure GetSprite101h( x, y : integer; sprite : TSprite );
var
  b       : byte;
  rx1,ry1 : longint;
  block   : word;
begin
  for block := 0 to 5 do
    begin
      rx1 := calcpagex( x, block );
      ry1 := calcpagey( y, block );
      ActVPage := ActVPage101h[ block ];
      SetWindow( Windows101h[ block, 1 ], Windows101h[ block, 3 ],
                 Windows101h[ block, 2 ], Windows101h[ block, 4 ] );
      GetSprite( rx1, ry1, sprite );
    end;
end;

procedure PutPixelHelp101h( x, y : integer; c : byte );
var
  block : word;
begin
  block := GetPage(x,y);
  ActVPage := ActVPage101h[ block ];
  PutPixel( x mod 320, y mod 200, c );
end;

function GetPixelHelp101h(x,y:integer ) : byte;
var
  block : word;
begin
  block := GetPage( x, y );
  ActVPage := ActVPage101h[ block ];
  GetPixelHelp101h := GetPixel( x mod 320, y mod 200 );
end;

procedure PutPixel101h( x, y : longint; c : byte );
begin
  if ( x >= GlobalWindowX1 ) and ( x <= GlobalWindowX2 ) and
     ( y >= GlobalWindowY1 ) and ( y <= GlobalWindowY2 ) then
    PutPixelHelp101h( x, y, c );
end;

function GetPixel101h( x, y : longint ) : byte;
begin
  GetPixel101h := 0; { wenn auerhalb des Fensters, dann Farbwert null }
  if ( x >= GlobalWindowX1 ) and ( x <= GlobalWindowX2 ) and
     ( y >= GlobalWindowY1 ) and ( y <= GlobalWindowY2 ) then
    GetPixel101h := GetPixelHelp101h( x, y );
end;

end.
