{ XFCN zur Kommunikation ber seriellen Port.  C. Meyer & ct 6/93 }
{ Think Pascal 4.0, Teile  1990 Symantec Corporation }
{ Libs und Interfaces: RSRCRuntime.Lib, Interface.lib, HyperXLib.lib, }
{ HyperXCmd.p, Serial.p  - Als XFCN Code Resource "HyperSerial" }
{ compilieren und mit ResEdit in gewnschten Stack kopieren }

unit DVM_Driver;
interface
	uses  { include the HyperCard interfaces in the XFCN/CMD }
		HyperXCmd, Serial;

	procedure main (paramPtr: XCmdPtr);		{ entry point }

implementation
	procedure main;
		label
			55;

		procedure Fail (errMsg: Str255);
		begin	{ Fehlermeldung an Parameterblock bergeben }
			paramPtr^.returnValue := PasToZero(paramPtr, errMsg);
			goto 55;		{ exit the routine }
		end;

		procedure DVMread (paramPtr: XCmdPtr);
			var
				aStr, bStr, RetStr: Str255;
				aInt: Integer;
				Data: packed array[0..1] of Byte;
				PortUsed: char;
				InPortrefNum, OutPortRefNum: Integer;
				alongInt, count: LongInt;
				Error: OSErr;
				serStat: SerStaRec;
				theBaudrate: Integer;
				BaudStr: Str15;
		begin
{ Anzahl der Parameter berprfen }
			if (paramPtr^.paramCount <> 2) then
				Fail('error - parameter count');
{ Erster Parameter: Command, zweiter: Port }
			ZeroToPas(paramPtr, paramPtr^.params[1]^, aStr);
			ZeroToPas(paramPtr, paramPtr^.params[2]^, bStr);
			PortUsed := bStr[1];
			RetStr := 'ok';
			if (PortUsed = 'P') or (PortUsed = 'p') then
				begin	{ Printerport }
					InPortrefNum := BinRefNum;
					OutPortRefNum := BoutRefNum;
				end
			else
				begin
					InPortrefNum := AinRefNum;
					OutPortRefNum := AoutRefNum;
				end;
			case aStr[1] of
				'o', 'O': 
					begin
						thebaudrate := baud1200;
						if (PortUsed = 'P') or (PortUsed = 'p') then
							begin	{ Printerport }
								Error := OpenDriver('.Bin', aInt);
								Error := OpenDriver('.BOut', aInt);
							end
						else
							begin
								Error := OpenDriver('.Ain', aInt);
								Error := OpenDriver('.AOut', aInt);
							end;
						Error := SerReset(InPortrefNum, (theBaudrate + stop20 + data7 + noParity));
						Error := SerReset(OutPortrefNum, (theBaudrate + stop20 + data7 + noParity));
					end;
				'c', 'C':	{ Driver schlieen }
					begin
						Error := CloseDriver(InPortrefNum);
						Error := CloseDriver(OutPortrefNum);
					end;
				'i', 'I':
{ Anzahl der im Input-Buffer stehenden Zeichen }
					begin
						Error := SerGetBuf(InPortrefNum, count);
						NumToString(count, RetStr);
					end;
				'd', 'D': 	{ Dump Data Command }
					begin
						Error := SerGetBuf(InPortrefNum, count);
						if (count > 0) and (Error = noErr) then
							Error := FSRead(InPortrefNum, count, @aStr[1]);
						count := 1;
						aStr := 'D';
						Error := FSWrite(OutPortrefNum, count, @aStr[1]);
					end;
				'r', 'R': 	{ Read DVM Data String }
					begin
						Error := SerGetBuf(InPortrefNum, count);
						RetStr := '';
						if count > 0 then
							if FSRead(InPortrefNum, count, @RetStr[1]) = noErr then
								RetStr[0] := char(count);
					end;
				otherwise
					Fail('error - unknown command');
			end;
			if Error <> noErr then
				Fail('error - driver not open');
			paramPtr^.PassFlag := FALSE;
			paramPtr^.ReturnValue := PasToZero(paramPtr, RetStr);
		end;		{ HyperSerial }
	begin 		{ main }
		DVMread(paramPtr);  {entry point }
55:			{ exit label for failure routine }
	end; 		{ main }
end.