unit Dragdrpu;
{ Ldt Dateien nicht nur ber Datei/ffnen, sondern
  auch ber Kommandozeilen-Parameter und stellt sowohl
  einen Client als auch einen Server fr WM_DROPFILES dar }
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, ShellAPI, StdCtrls, Menus;
type
  TDragDropForm = class(TForm)
    ListBox1: TListBox;  { Empfnger fr WM_DRAGDROP }
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem; { Datei }
    FileOpen: TMenuItem; { Datei/ffnen - Strg+O }
    FileQuit: TMenuItem; { Datei/Beenden }
    Label1: TLabel;      { "Geladene" Dateien }
    OpenDialog1: TOpenDialog;
    bLongFileNames: TButton;
    bRegister: TButton;  { Registrieren fr *.~PA }
    DragDropServer: TLabel; { DragDropServer }
    procedure FormCreate(Sender: TObject);
    procedure FileQuitClick(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure bLongFileNamesClick(Sender: TObject);
    procedure bRegisterClick(Sender: TObject);
    { Drag-Server: Start, Abbruch bei ESC, Mausbewegung }
    procedure DragDropServerMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  protected
    procedure LoadFile(FName: TFileName);
    procedure WMDropFiles(var Msg: TMessage); message WM_DROPFILES;
    { Drag-Server }
    procedure StopDragServer;  { Abbruch/Ende einer Ziehoperation }
    procedure OnDeactivateApp(Sender: TObject);
  private
    DragSrvActive: Boolean;    { True: Ziehaktion luft }
    DragTargetWnd: HWnd;{ <>0: Zielfenster mit WS_EX_ACCEPTFILES }
  end;

var DragDropForm: TDragDropForm;
{$IFNDEF WIN32}   { Diese Deklaration fehlt bei Delphi 16 }
function ExtractAssociatedIcon(Inst: THandle; lpIconPath: PChar;
  var lpiIcon: Word): HIcon;
{$ENDIF}
implementation
{$R *.DFM}
{$IFNDEF WIN32}
function ExtractAssociatedIcon; external 'SHELL'    index 36;
{$ENDIF}

procedure TDragDropForm.WMDropFiles(var Msg: TMessage);
var DropHandle: THandle;  x, FileCount: Integer;
    FName: Array[0..255] of Char;
begin
  DropHandle := Msg.wParam;
{$IFDEF WIN32}   { Index -1: Frage nach der Anzahl der Dateien }
  FileCount := DragQueryFile(DropHandle, -1,FName,255);
{$ELSE}
  FileCount := DragQueryFile(DropHandle, Word(-1),FName,255);
{$ENDIF}
  for x := 0 to FileCount-1 do
  begin
    DragQueryfile(DropHandle,x,FName,255);
    ListBox1.Items.Add(StrPas(FName));
  end;
  DragFinish(DropHandle);   { Abschlu: Freigabe des Handles }
  Msg.Result := 0;
end;

procedure TDragDropForm.FormCreate(Sender: TObject);
var x: Integer;
begin
  ListBox1.Clear;
  for x := 1 to ParamCount do   { Durcharbeiten der }
    LoadFile(ParamStr(x));    { Kommandozeilen-Parameter }
  { Listbox als Empfnger von Drag-Operationen mit Dateinamen }
  DragAcceptFiles(ListBox1.Handle,True);
  { Abbruch des Drag-Servers bei Task-Wechseln }
  Application.OnDeactivate := OnDeactivateApp;
  KeyPreview := True;  { damit ESC bei Drags durchkommt }
end;

{ FileOpenClick und die eigentliche (hier symbolische) Lade-
  routine sind voneinander getrennt. XRef fr die Laderoutine:
  FileOpenClick und FormCreate mit Kommandozeilen-Parametern }
procedure TDragDropForm.LoadFile(FName: TFileName);
begin
  ListBox1.Items.Add(FName);
end;

procedure TDragDropForm.FileOpenClick(Sender: TObject);
begin
  with OpenDialog1 do
  begin
    Title := 'Datei ffnen';  DefaultExt := 'PAS';
    Filter := 'Pascal-Quelltexte|*.PAS';
    if FileName = ''
      then InitialDir := ExtractFilePath(ParamStr(0))
      else InitialDir := ExtractFilePath(FileName);
    FileName := '*.PAS';
    if Execute then LoadFile(FileName);
  end;
end;

procedure TDragDropForm.FileQuitClick(Sender: TObject);
begin
  Close;
end;

{ -------- Umwandlung in lange Dateinamen ---------- }
{$IFDEF WIN32}
function LongFileName(const ShortName: TFileName): String;
var SName2: String; F: TSearchRec;
begin
  { NetBIOS-Name, Jokerzeichen oder kein Dateiname: Finger weg }
  if (Pos('\\',ShortName)+Pos('*',ShortName)+
    Pos('?',ShortName) <> 0) or not FileExists(ShortName) then
  begin
    Result := ShortName; Exit;
  end;
  SName2 := ShortName; Result := '';
  while FindFirst(SName2,$3F,F) = 0 do
  begin
    { jeweils nchsten Teil voranstellen }
    Result := '\'+F.Name+Result;
    SysUtils.FindClose(F);  { nicht WinProcs - Namensdoublette }
    { nchsthhere Verzeichnisebene (Absgen vor '\' }
    SetLength(SName2,Length(ExtractFilePath(SName2))-1);
    if Length(SName2) <= 2 then Break;  { nur noch 'X:' brig }
  end;
  Result := SName2+Result;
end;

{$ELSE}
function LongFileName(const ShortName: TFileName): String;
const SName2: Array[0..255] of Char = '';  { DSeg! }
begin
  StrPCopy(SName2, ShortName);  { ASCIIZ, Datensegment }
  Result := '';
  asm
    mov ax, $7160; mov cl, 2;  { "Get Long Path Name" }
    mov ch, 0;  { SUBST ersetzen. Alternative: $80 }
    mov si, OFFSET SName2  { DS:SI = Quelle }
    les di, @Result        { ES:DI = Ziel }
    int $21
    jnc @@1
    mov Byte Ptr @Result,0;  { '' als Anzeige fr Fehler }
   @@1:
  end;
  Result := StrPas(@Result[0]);
  if Result = '' then Result := ShortName;  { war kein Dateiname }
end;
{$ENDIF}

procedure TDragDropForm.bLongFileNamesClick(Sender: TObject);
var x: Integer;
begin  { Umwandlung aller Dateinamen in der Listbox }
  with ListBox1 do
    for x := 0 to Items.Count-1 do
      Items[x] := LongFileName(Items[x]);
end;

{ Verknpfung fr Explorer/Datei-Manager anlegen.
  Beispiel fr die Parameter des Aufrufs:
  ('.~pa','~pafile','PAS-Backups','C:\...DragDrop.exe "%1")  }
procedure RegisterLink(Ext, FType, FriendlyName, Cmd: PChar);
var Key: HKey; SZEntry: Array[0..255] of Char; SZSize: LongInt;
begin
  { Prfung, ob es die Dateierweiterung schon gibt }
  if RegOpenKey(HKEY_CLASSES_ROOT,Ext,Key) = ERROR_SUCCESS then
  begin  { gibt es bereits. Dateityp ermitteln }
    SZSize := SizeOf(SZEntry);
    RegQueryValue(Key,'',SZEntry,SZSize); { Dateityp }
    StrCat(SZEntry,'\Shell\Open\Command');
    if RegOpenKey(HKEY_CLASSES_ROOT,SZEntry,Key)
      = ERROR_SUCCESS then
    begin  { Open-Befehl existiert: Rckfrage  }
      SZSize := SizeOf(SZEntry);
      RegQueryValue(Key,'',SZEntry,SZSize);
      if (StrIComp(SZEntry,Cmd) <> 0) { Befehle ungleich } and
      (MessageDlg('Die Dateierweiterung "'+StrPas(Ext)+ '" ist '+
      'bereits mit dem Befehl '+StrPas(SZEntry)+' verknpft. '+
      'berschreiben?', mtConfirmation, [mbYes, mbNo],0) <> IDYES)
       then Exit;
    end;
  end;
  { HKEY_CLASSES_ROOT\.~pa  = '~pafile'}
  RegCreateKey(HKEY_CLASSES_ROOT,Ext,Key);
  RegSetValue(Key,'',REG_SZ,FType,StrLen(FType));
  { HKEY_CLASSES_ROOT\~pafile = "PAS-Backups" }
  RegCreateKey(HKEY_CLASSES_ROOT,FType,Key);
  RegSetValue(Key,'',REG_SZ,FriendlyName,StrLen(FriendlyName));
  { HKEY_CLASSES_ROOT\~pafile\Shell\Open\Command =
     C:\.... MyProg.exe "%1" }
  StrCat(StrCopy(SZEntry,FType),'\Shell\Open\Command');
  RegCreateKey(HKEY_CLASSES_ROOT,SZEntry,Key);
  RegSetValue(Key,'',REG_SZ,Cmd,StrLen(Cmd));
end;

procedure TDragDropForm.bRegisterClick(Sender: TObject);
var Cmd: Array[0..255] of Char;
begin
{$IFDEF WIN32}
  StrPCopy(Cmd,ParamStr(0)+' "%1"');
{$ELSE}
  StrPCopy(Cmd,ParamStr(0)+' %1');
{$ENDIF}
  RegisterLink('.~pa','~pafile','PAS-Backups', Cmd);
end;

{ ----- Server (d.h. Sender) fr WM_DRAGDROP ----- }
procedure TDragDropForm.StopDragServer;
begin { XRef: Druck auf ESC, Task-Wechsel, FormMouseUp }
  if DragSrvActive then
  begin
    DragSrvActive := False; MouseCapture := False;
{ DragAcceptFiles(Listbox1.Handle,True); } { vgl. MouseDown }
  end;
end;

procedure TDragDropForm.FormKeyPress(Sender: TObject; var Key: Char);
begin { Abbruch einer Ziehoperation beim Druck auf ESC }
  if Key = #27 then StopDragServer;
end;

procedure TDragDropForm.OnDeactivateApp(Sender: TObject);
begin { Abbruch einer Ziehoperation beim Task-Wechsel }
  StopDragServer;
end;

{ MouseDown auf dem Label startet die Aktion. Die restlichen
  Botschaften werden ber das Hauptfenster abgewickelt, weil
  ich nicht extra eine neue Komponente schnitzen wollte }
procedure TDragDropForm.DragDropServerMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    DragSrvActive := True; MouseCapture := True;
{ DragAcceptFiles(Listbox1.Handle,False); } { vgl. StopDragServer }
  end;
end;

procedure TDragDropForm.FormMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var MousePos: TPoint; ExStyle: LongInt;
    CapStr: String; TargetCap: Array[0..20]of Char;
    Cursor: TCursor;  { Variable - keine Eigenschaft }
begin
  CapStr := 'DropSrv ';
  if DragSrvActive then
  begin
    { GetCursorPos ginge hier genauso }
    MousePos := ClientToScreen(Point(X,Y));
    DragTargetWnd := WindowFromPoint(MousePos);
    if (DragTargetWnd <> 0) then
    begin
      ExStyle := GetWindowLong(DragTargetWnd, GWL_EXSTYLE);
      CapStr := CapStr + Format('ExStyle: %8.8x ',[ExStyle]);
      GetWindowText(DragTargetWnd,TargetCap,SizeOf(TargetCap));
      CapStr := CapStr + StrPas(TargetCap)+' ';
      if (ExStyle and WS_EX_ACCEPTFILES) = 0
        then DragTargetWnd := 0; { kein Empfnger }
    end;
    if DragTargetWnd = 0 then Cursor := crNoDrop
      else Cursor := crDrag;
    Caption := CapStr;  { Anzeige }
    { So lange die Maus eingefangen ist, erzeugt Windows keine
      Botschaften des Typs WM_SETCURSOR; der ausgewhlte
      Cursor mu also direkt eingesetzt werden }
    WinProcs.SetCursor(Screen.Cursors[Cursor]);
  end;
end;

{ Eine Struktur dieses Typs wird auf dem globalen Heap belegt
  und der entsprechende Handle bei WM_DROPFILES bergeben.
  Der Empfnger mu den Speicherbereich ber DragFinish wieder
  freigeben. }
type
  TDropFileStruct = record
    wSize: Word;   { Gre des Kopfs in Bytes }
    MPosX, MPosY: Word;  { Mausposition (Zielfenster-relativ) }
    InNCArea: Word;  { True: Maus auerhalb Anwendungsbereich }
    { Dateinamen im Format: Name1 #0 Name2 #0 .... #0#0 }
    FNames: Array[0..1] of Char;
  end;
  PDropFileStruct = ^TDropFileStruct;

procedure TDragDropForm.FormMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var HDrop: THandle;  { Heap-Handle fr den Datenblock }
    PDrop: PDropFileStruct; MousePos: TPoint;
    DropFileData: String; DropFileDataLen: Integer;
begin
  if Button <> mbLeft then Exit;
  if DragSrvActive then
  begin
    StopDragServer;
    if DragTargetWnd <> 0 then
    begin
      { Hier ist's nur ein Dateiname; mehrere mte man nach dem
        Schema FName1+#0#+FName2+#0#... aneinanderhngen }
      DropFileData := ParamStr(0)+#0;  { eigener .EXE-Name }
      DropFileDataLen := Length(DropFileData);
      HDrop := GlobalAlloc(GMEM_SHARE or GMEM_MOVEABLE
       or GMEM_ZEROINIT, SizeOf(TDropFileStruct)+DropFileDataLen);
      PDrop := GlobalLock(HDrop);
      with PDrop^ do
      begin
        wSize := 8; { SizeOf(TDropFileStruct)-2 wg. FNames }
        { DropSrv-Koordinaten -> Bildschirm }
        MousePos := ClientToScreen(Point(X,Y));
        InNCArea := Word(SendMessage(DragTargetWnd, WM_NCHITTEST,
          0, MakeLong(MousePos.X,MousePos.Y)) <> HTCLIENT);
        { Bildschirm-Koordinaten -> TargetWnd-Koordinaten }
        WinProcs.ScreenToClient(DragTargetWnd,MousePos);
        MPosX := MousePos.X; MPosY := MousePos.Y;
        {... und schlielich die Dateinamen selbst }
        StrPCopy(FNames,DropFileData);
      end;
      GlobalUnlock(HDrop);
      PostMessage(DragTargetWnd, WM_DROPFILES, HDrop, 0);
      { Speicherblock wird vom Empfnger wieder freigegeben }
    end;
  end;
end;
end.





