		TITLE	VESA8.ASM
		.386
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  Routinen fr Grafik in den 256-Farben Modi des VESA-Standards  ;
;  Aufrufbar von Turbo Pascal					  ;
;  Jrgen Petsch fr c't 2.97                                     ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  Inhalt: KONST
;	   DATA
;	     ModeInfoBlock
;	     VESAInfoBlock
;	   CODE
;	     PUBLIC-Deklarationen
;	     MACROs
;	     Von TP aus aufrufbare FUNCTIONs und PROCEDUREs (FAR CALLs)
;	     Prozeduren, die innerhalb der UNIT mit NEAR CALL aufgerufen werden.
;	     Zeichensatz 8*16
;
;KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
;KONST
;-------------------------------
True		EQU	0FFH
False		EQU	0
;-------------------------------

;DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
DATA		SEGMENT PARA PUBLIC 'DATA' USE16
;-------------------------------
VESAInfoBlock	LABEL	NEAR
;					  Offs
VESASignature	DD	0		; 00H
VESAVersion	DW	0		; 04H
OEMStringPtr	DD	0		; 06H
Capabilities	DD	0		; 0AH
VideoModePtr	DD	0		; 0EH
TotalMemory	DW	0		; 12H
		DB	242 DUP (0)
;-------------------------------
;  Der ModeInfoBlock befindet sich im DS.
;  Bei PROC, die das von TP gelieferte DS verndern, ist unbedingt darauf zu
;  achten, da vor dem Zugriff auf den ModeInfoBlock das DS wieder seinen
;  ursprnglichen Wert erhlt.
;
ModeInfoBlock	LABEL	NEAR
;					  Offs
ModeAttributes		DW	0	; 00H
WinAAttributes		DB	0	; 02H
WinBAttributes		DB	0	; 03H
WinGranularity		DW	0	; 04H  (kByte)
WinSize			DW	0	; 06H  (kByte)
WinASegment		DW	0	; 08H
WinBSegment		DW	0	; 0AH
WinFuncPtr		DD	0	; 0CH  (Pointer)
BytesPerScanLine	DW	0	; 10H
XResolution		DW	0	; 12H
YResolution		DW	0	; 14H
XCharSize		DB	0	; 16H
YCharSize		DB	0	; 17H
NumberOfPlanes		DB	0	; 18H
BitsPerPixel		DB	0	; 19H
NumberOfBanks		DB	0	; 1AH
MemoryModel		DB	0	; 1BH
BankSize		DB	0	; 1CH
NumberOfImagePages	DB	0	; 1DH
Reserved		DB	0	; 1EH
RedMaskSize		DB	0	; 1FH
RedFieldPosition	DB	0	; 20H
GreenMaskSize		DB	0	; 21H
GreenFieldPosition	DB	0	; 22H
BlueMaskSize		DB	0	; 23H
BlueFieldPosition	DB	0	; 24H
			DB	0DBH DUP (0)
;----------------
WinSizePerGranu 	DW	1	; WinSize / WinGranularity
;-------------------------------
Liste		DB	512 DUP (0)
;-------------------------------
XorMode 	DB	0
;-------------------------------
DATA		ENDS
;ddddddddddddddddddddddddddddddd

;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CODE		SEGMENT PARA PUBLIC USE16
		ASSUME	CS:CODE, DS:DATA
;-------------------------------
PUBLIC	WaitForSync	; Wartet auf pos. Flanke des Vertical-Sync-Impulses.
PUBLIC	GetScanCode	; Wartet auf eine Taste und liefert den Scancode
PUBLIC	VESAAvail	; Die FUNCTION kehrt mit True zurck und fllt den
			;  InfoBuffer, wenn ein VESA-BIOS vorhanden ist
PUBLIC	GetVESAInfo	; Liefert Teile des VESAInfoBlockes an TP
PUBLIC	SetVESAMode	; Schaltet einen VESA-Modus fr 256 Farben ein
PUBLIC	SetAlfaMode	; Schaltet zurck in den Textmode
PUBLIC	SetMovMode	; Setzt die lokale VAR XorMode:= FALSE
PUBLIC	SetXorMode	; Setzt die lokale VAR XorMode:= TRUE
PUBLIC	SetScreenOffs	; Setzt den sichtb. Bildsch. in bezug zum virt. Bildsch.
PUBLIC	SetBytesPerScanLine ; Setzt die Scanline-Lnge im VGA-Chip

PUBLIC	PutPixel	; Setzt ein Pixel an der Stelle X,Y mit Farbe
PUBLIC	GetPixel	; Liefert die Farbe eines Pixels an der Stelle X,Y

PUBLIC	PutLineH	; Horizontale von X,Y mit Lnge und Farbe
PUBLIC	PutLineV	; Vertikale von X,Y mit Lnge und Farbe
PUBLIC	PutLine		; Gerade von X,Y nach Xe,Ye mit Farbe
PUBLIC	PutRect 	; Rechteck X,Y obere linke Ecke
PUBLIC	PutCircle	; Kreis um X,Y mit Radius R und Farbe
PUBLIC	PutDisk 	; Disk um X,Y mit Radius R und Farbe
PUBLIC	PutChar 	; ASCII-Zeichen an X,Y mit Farbe

PUBLIC	FillSprite	; Fllt ein Sprite mit Farbe
PUBLIC	ZoomSprite	; Zoomt ein Rechteck auf doppelte Kantenlnge
PUBLIC	GetSprite	; Holt ein Sprite vom Video-Mem ins DOS-Mem
PUBLIC	PutSprite	; Bringt ein Sprite vom DOS-Mem zum Video-Mem
PUBLIC	File2Sprite	; Holt ein Sprite vom File in das Video-Mem
PUBLIC	Sprite2File	; Bringt ein Sprite vom Video-Mem in einen File
PUBLIC	Bmp2Sprite	; Holt ein Sprite vom .BMP-File in das Video-Mem
PUBLIC	Sprite2Bmp	; Bringt ein Sprite vom Video-Mem in einen Bmp-File

PUBLIC	ClearScreen	; Lscht den sichtbaren Bildschirmbereich
PUBLIC	ClearVGAMem	; Lscht das ganze Video-Mem
PUBLIC	ShowBanks	; Blendet die Bankgrenzen ein
;===============================
;  MACROs
;===============================
;-------------------------------
;  Berechnet die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;	ES:= [WinASegment]
;
GetScreenAddr	MACRO
		MOVZX	EAX,[BytesPerScanline]
		MOVZX	EDX,[Y]		; EDX = Y
		MUL	EDX		; EDXEAX := BytesPerScanLine * Y
;
		MOVZX	EBX,[X]			; EBX := X
		ADD	EAX,EBX
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10			; [Byte]
		DIV	EBX			; EDX := Offset   EAX := Segm
		MOV	DI,DX			; DI := Offset
		MOV	DX,AX			; DX := Segm
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		ENDM
;------------------------------
;  Setzt beide Windows := DX
;
SetBanks	MACRO
		PUSH	DX
		SUB	BX,BX		; BH:=0 Window setzen;	BL:=0 Window A
		CALL	[WinFuncPtr]
		POP	DX
		MOV	BL,1		; Window B
		CALL	[WinFuncPtr]
		ENDM
;==================================================
;  Von TP aus aufrufbare FUNCTIONs und PROCEDUREs
;==================================================
;------------------------------------
;  Wartet auf ansteigende Flanke des Vertical-Sync-Impulses.
;
WaitForSync     PROC   FAR
                MOV    DX,3DAH             ; DX-> STATUS-Register
                MOV    AH,8                ; AH-> SYNC-Bit
WaitForSync_2:
                IN     AL,DX               ; Hole STATUS
                TEST   AL,AH               ; SYNC = 0 ?
                JNZ    SHORT WaitForSync_2 ; Nein, warte
WaitForSync_4:
                IN     AL,DX               ; Hole STATUS
                TEST   AL,AH               ; SYNC = 1 ?
                JZ     SHORT WaitForSync_4 ; Nein, warte
                RET
WaitForSync     ENDP
;-------------------------------
;  Wartet auf ein Zeichen vom Keyboard und liefert den ScanCode der Taste
;  Aufruf: GetScanCode :BYTE;
;
GetScanCode	PROC	FAR
		MOV	AH,10H		; F16_GET_EXT_KEY
		INT	16H		; AH = SCAN_CODE  AL = ASCII-Zeichen
		MOV	AL,AH
		MOV	AH,0
		RET
GetScanCode	ENDP
;-------------------------------
;  Versucht den VESAInfoBlock zu laden.
;  Wenn ja, ist der VESAInfoBlock gefllt.
;
;  Aufruf: VESAAvail BOOLEAN;
;--------------
VESAAvail	PROC	FAR
		PUSH	BP
		MOV	BP,SP

		MOV	DI,OFFSET VESAInfoBlock	; ES:DI-> VESAInfoBlock
		MOV	AX,4F00h		; Return Super VGA Information
		INT	10h			; Video Interrupt
		CMP	AX,004Fh		; VESA BIOS vorhanden ?
		JZ	SHORT VESAAvail_0	;  Ja, True bleibt
		NOT	AX			; Nein, Ret mit False
VESAAvail_0:
		POP	BP
		RET
VESAAvail	ENDP
;-------------------------------
;  Liefert Teile des VESAInfoBlock an TP
;  Aufruf: GetVESAInfo (TpOEMString:STRING;
;			VAR MemSize, VAR Version:WORD);
TpOEMString	EQU	DWORD PTR [BP+14]
MemSizePtr	EQU	DWORD PTR [BP+10]
VESAVersionPtr	EQU	DWORD PTR [BP+6]
;...............
GetVESAInfo	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		PUSH	DS
;
;  Hole Version und wandle Nibbles B:A nach Dezimal
;
		MOV	AX,[VESAVersion]; AX:= X:C:B:A
		MOV	BL,AL		; BL:= B:A
		SHR	BL,4		; BL:= B
		MOV	BH,0		; BX:= B
		IMUL	BX,6		; BX:= 6*B
		SUB	AL,BL		; AL:= B:A - 6*B
		LES	DI,[VESAVersionPtr]; ES:DI-> TP-Variable
		MOV	ES:[DI],AX	; Lege Version ab
;
;  Hole TotalMemory und lege in der TP-Variablen ab
;
		MOV	AX,[TotalMemory]; Blcke a' 64k
		IMUL	AX,64		; Wandle in kByte
		LDS	DI,[MemSizePtr] ; DS:DI-> TP-Variable
		MOV	[DI],AX 	; Lege MemSize ab
;
;  bertrage den OEMString in die TP-Variable
;
		LES	DI,[TpOEMString]; ES:DI-> TP-Variable
		INC	DI		; Skip TP-Stringlnge
		LDS	SI,[OEMStringPtr]; DS:SI-> OEMString
		SUB	CL,CL		; Init Stringlnge:= 0
GetVESAInfo_2:	LODSB			; Hole vom OEMString
		CMP	AL,0		; Schluzeichen ?
		JZ	GetVESAInfo_4	;  Ja, fertig
		STOSB			; Bringe zum TP-OEMString
		INC	CL		; Stringlnge +1
		JMP	GetVESAInfo_2	; REPEAT UNTIL Zeichen = 0
;---------------
GetVESAInfo_4:	LDS	DI,[TPOEMString]; DS:DI-> TP-Variable
		MOV	[DI],CL 	; Lege Stringlnge ab
		POP	DS
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 3 POINTER
GetVESAInfo	ENDP
;-------------------------------
;  Schaltet einen bestimmten 8-Bit/Pixel-VESA-Modus ein
;  Aufruf: SetVESAMode (Xsoll,Ysoll:WORD; VAR VESAErr:WORD);
;	      VesaErr
;		0000 = kein Fehler
;		0001 = Modus wird nicht vom VESA-BIOS untersttzt
;		0002 = ModeInfoBlock konnte nicht gefllt werden
;		0003 = Einschalten des Modus fehlgeschlagen
;---------------
Xsoll		EQU	WORD PTR [BP+12]
Ysoll		EQU	WORD PTR [BP+10]
VESAErrPtr	EQU	DWORD PTR [BP+6]

ListenSegm	EQU	WORD PTR [BP-2]
ListenOffs	EQU	WORD PTR [BP-4]
Modus		EQU	WORD PTR [BP-6]
;---------------
SetVESAMode	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; 3 lokale WORDs
;
;  Der VESAInfoBlock mu geladen worden sein (VESAAvail).
;  VESAInfoBlock.VideoModePtr enthlt einen Pointer auf eine mit FFFFH
;  abgeschlossene Liste der untersttzten Modi.
;
		LES	SI,DWORD PTR [VESAInfoBlock+0EH]; ES:SI-> Liste
		MOV	[ListenOffs],SI
		MOV	[ListenSegm],ES
;
;  Hole den nchsten Modus aus der Liste
;
SetVESAMode_2:	MOV	ES,[ListenSegm]
		MOV	SI,[ListenOffs]
		ADD	[ListenOffs],2	; ListenOffs-> nchster Eintrag
		MOV	CX,ES:[SI]	; CX:= Modus aus der Liste
		MOV	[Modus],CX	; Modus fr spter
		MOV	DX,1		; Bereite VESAErr:= 1 vor
		CMP	CX,0FFFFH	; Letzter Eintrag?
		JZ	SetVESAMode_0	; Ja, ret mit VESAErr
;
;  Flle fr CX:=Modus den ModeInfoBlock
;
		MOV	AX,DS
		MOV	ES,AX		; ES:DI-> ModeInfoBlock
		MOV	DI,OFFSET ModeInfoBlock
		MOV	AX,4F01H	; Return Super VGA Mode Info
		INT	10H		; Video Interrupt
		MOV	DX,2		; Bereite VESAErr:= 2 vor
		CMP	AX,004Fh	; erfolgreich ?
		JNZ	SetVESAMode_0	;  Nein, Ret mit VESAErr
;
;  Wenn ModeInfoBlock.XResolution <> Xsoll, dann weitersuchen
;
		MOV	AX,[Xsoll]
		CMP	AX,[XResolution]
		JNZ	SetVESAMode_2
;
;  Wenn ModeInfoBlock.YResolution <> Ysoll, dann weitersuchen
;
		MOV	AX,[Ysoll]
		CMP	AX,[YResolution]
		JNZ	SetVESAMode_2
;
;  Wenn ModeInfoBlock.BitsPerPixel <> 8, dann weitersuchen
;
		CMP	[BitsPerPixel],8  ; BitsPerPixel=8 ?
		JNZ	SetVESAMode_2	  ;  Nein, weitersuchen
;
;  Jetzt wissen wir, da Modus zu Xsoll, Ysoll mit 8 Bit/Pixel gehrt.
;  Schalte den Modus ein.
;
SetVESAMode_4:	MOV	BX,[Modus]	; BX := Modus
		MOV	AX,4F02H	; Set Super VGA Video Mode
		INT	10H		; Video Interrupt
		MOV	DX,3		; Bereite VESAErr = 3 vor
		CMP	AX,004Fh	; erfolgreich ?
		JNZ	SetVESAMode_0	;  Nein, Ret mit VESAErr
;
;  Berechne WinSizePerGranu:= WinSize / WinGranularity
;
		MOV	AX,[WinSize]
		CWD
		DIV	[WinGranularity]
		MOV	[WinSizePerGranu],AX
;
;  Bereite Ablage des VESAErr:= 0 vor
;
		SUB	DX,DX
SetVESAMode_0:
		LES	DI,[VESAErrPtr]	; ES:DI-> VESAErr
		MOV	ES:[DI],DX	; Vorbereiteter VESAErr
		MOV	SP,BP
		POP	BP
		RET	8	; Entferne 2 WORDs und 1 POINTER
SetVESAMode	ENDP
;-------------------------------
;  Schaltet den VGA-Adapter auf 80 x 25 BW Alphanumeric Mode
;
;  Aufruf: SetAlfaMode;
;---------------
SetAlfaMode	PROC	FAR
		MOV	AL,03		; Mode:=3
		MOV	AH,0		; Set Video Mode
		INT	10H		; Video Interrupt
		RET
SetAlfaMode	ENDP
;-------------------------------
;  Setzt die VAR XorMode = TRUE, d.h. Pixel werden XOR mit dem Hintergrund
;  verknpft. Einige Prozeduren (PutPixel, PutLine, PutChar) richten sich danach.
;
;  Aufruf: SetXorMode
;---------------
SetXorMode	PROC	FAR
		MOV	[XorMode],True
		RET
SetXorMode	ENDP
;-------------------------------
;  Setzt die VAR XorMode = FALSE, d.h. Pixel berschreiben den Hintergrund.
;
;  Aufruf: SetMovMode
;---------------
SetMovMode	PROC	FAR
		MOV	[XorMode],False
		RET
SetMovMode	ENDP
;-------------------------------
;  Setzt den X/Y-Offset des sichtbaren Bildschirmes in bezug auf den
;  virt Bildschirm. XOffs,YOffs = obere linke Ecke des sichtbaren Bildschirmes.
;
;  Aufruf: SetVideo-MemOffs (XOffs,YOffs : WORD);
;---------------
XOffs		EQU	WORD PTR [BP+8]
YOffs		EQU	WORD PTR [BP+6]
;---------------
SetSCreenOffs	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		MOV	CX,[XOffs]
		MOV	DX,[YOffs]
		MOV	AX,4F07H	; Set/Get Display Start
		MOV	BX,0		; Set Display Start
		INT	10H
		POP	BP
		RET	4		; Entferne 2 WORDs vom Stack
SetScreenOffs	ENDP
;-------------------------------
;  Setzt die Scanlinelnge im VGA-Chip und die Variable.
;
;  Aufruf: SetBytesPerScanLine (BpSL : WORD);
;---------------
BpSL		EQU	WORD PTR [BP+6]
;---------------
SetBytesPerScanLine	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		MOV	CX,[BpSL]
		MOV	[BytesPerScanLine],CX
		MOV	AX,4F06H	; Set/Get Logical Scan Line Length
		MOV	BL,0		; Set Length
		INT	10H
		POP	BP
		RET	2		; Entferne ein WORD vom Stack
SetBytesPerScanLine	ENDP
;-------------------------------
;  Setzt ein Pixel an der Stelle X,Y mit Farbe.
;  Bercksichtigt XorMode
;
;  Aufruf: PutPixel (X,Y,Farbe:WORD)
;---------------
X		EQU	WORD PTR [BP+10]
Y		EQU	WORD PTR [BP+8]
Farbe		EQU	WORD PTR [BP+6]
;---------------
PutPixel	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks			; Setze beide Windows := DX
;
;  Bringe [Farbe] zum Video-Mem
;
		MOV	AX,[Farbe]		; AL := Farbe
		CMP	[XorMode],True		; XorMode ?
		JZ	SHORT PutPixelX 	; Ja, Xor mit Farbe

		STOSB
PutPixel_0:
		POP	BP
		RET	6			; Entferne 3 WORDs vom Stack
;---------------
PutPixelX:	XOR	ES:[DI],AL
		JMP	SHORT PutPixel_0
;...............
PutPixel	ENDP
;-------------------------------
;  Liefert die Farbe eines Pixels an der Stelle X,Y.
;
;  Aufruf: GetPixel (X,Y:WORD; VAR Farbe:WORD);
;---------------
X		EQU	WORD PTR [BP+12]
Y		EQU	WORD PTR [BP+10]
FarbAddr	EQU	DWORD PTR [BP+6]
;---------------
GetPixel	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks			; Setze beide Windows := DX
;
;  Hole die Farbe des Pixels vom Video-Mem
;
		MOV	AL,ES:[DI]		; AL := Farbe
;
;  Bringe die Farbe zur TP-Variablen
;
		LES	DI,[FarbAddr]		; ES:DI-> Farbe
		STOSB

		POP	BP
		RET	8	; Entferne 2 WORDs und ein Ptr vom Stack
;...............
GetPixel	ENDP
;-------------------------------
;  Zeichnet eine senkrechte Gerade beginnend am oberen Ende
;  Bercksichtigt XorMode
;
;  Aufruf: PutLineV (X,Y,Laenge,Farbe:WORD);
;---------------
X		EQU	WORD PTR [BP+12]
Y		EQU	WORD PTR [BP+10]
Laenge		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;---------------
PutLineV	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks			; Setze beide Windows := DX
;
		MOV	BX,[BytesPerScanline]	; Zeilenabstand
		MOV	AL,[Farbe]
		MOV	CX,[Laenge]

		CALL	DrawDo		; Zeichne von oben nach unten

		POP	BP
		RET	8		; Entferne 4 WORDs vom Stack
;...............
PutLineV	ENDP
;-------------------------------
;  Zeichnet eine Horizontale nach rechts
;  Bercksichtigt XORMode
;
;  Aufruf: PutLineH (X,Y,Laenge,Farbe:WORD);
;---------------
X		EQU	WORD PTR [BP+12]
Y		EQU	WORD PTR [BP+10]
Laenge		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;---------------
PutLineH	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
;  Bereite Farbe und Lnge vor
;
		MOV	AL,[Farbe]	; AL := Farbe
		MOV	AH,AL		; AH := Farbe
		MOV	CX,[Laenge]

		CALL	DrawRi		; Zeichne die Horizontale nach rechts

		POP	BP
		RET	8		; Entferne 4 WORDs vom Stack
;...............
PutLineH	ENDP
;-------------------------------
;  Zeichnet eine Gerade von X,Y nach XE,YE mit Farbe
;  Bercksichtigt XorMode.
;
;  Aufruf: PutLine (X,Y,XE,YE,Farbe:WORD);
;---------------
X		EQU	WORD PTR [BP+14]
Y		EQU	WORD PTR [BP+12]
XE		EQU	WORD PTR [BP+10]
YE		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;----------------
PutLine		PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne SI := DLTX
;
                MOV     SI,[XE]         ; XE
                SUB     SI,[X]          ; XE - X
;
;  Wenn DLTX < 0 , dann tausche X <-> XE und Y <-> YE
;
		JNS	SHORT PutLine_2
		MOV	AX,[XE]
		XCHG	AX,[X]
		MOV	[XE],AX
		MOV	AX,[YE]
		XCHG	AX,[Y]
		MOV	[YE],AX
		NEG	SI		; DLTX:= -DLTX
PutLine_2:
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
		MOV	AL,[Farbe]	; AL := Farbe
;
;  MOVE- oder XOR-Mode ?
;
		CMP	[XorMode],True
		JZ	PutLine_X
;
;  Wir haben MovMode.  Setze das 1. Pixel
;
		MOV	ES:[DI],AL
;
;  Berechne BX := DLTY
;
		MOV	BX,[YE]
		SUB	BX,[Y]
;
;  Wenn DLTY > 0, dann positive Steigung (Scanlineoffset = +BytePerLine)
;
		JNS	PutLine_8
		NEG	BX		; DLTY := -DLTY
;
;  Wenn DLTX > DLTY, dann berechne Y = f(X)
;
                CMP     SI,BX
		JG	SHORT PutLine_20
;...............
;  Wir berechnen X = f(Y) mit Scanlineoffset = -BytePerLine
;
		MOV	CX,BX		; Loopcount = DLTY
		JCXZ	PutLine_0	; Loopcount = 0 ?
                MOV     BP,BX
		NEG	BP		; SUM = - DLTY
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_12:
		SUB	DI,[BytesPerScanline]; Y := Y - 1
		JC	SHORT PutLine_13	; Achte auf Bankswitch
PutLine_14:
		ADD	BP,SI			; SUM := SUM + 2 DLTX
		JS	SHORT PutLine_16	; Skip, wenn SUM < 0
		SUB	BP,BX			; SUM = SUM - 2 DLTY
		INC	DI			; X := X + 1
		JZ	SHORT PutLine_15	; Achte auf Bankswitch
PutLine_16:
		MOV	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_12	; Loop mit DLTY
		JMP	SHORT PutLine_0
;...............
PutLine_13:	CALL	DecWrBank
		JMP	SHORT PutLine_14
;...............
PutLine_15:	CALL	IncWrBank
		JMP	SHORT PutLine_16
;............................
;  Wir berechnen Y = f(X) mit Scanlineoffset = -BytePerLine
;
PutLine_20:	MOV	CX,SI		; Loopcount = DLTX
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	BP,SI
		NEG	BP		; SUM = - DLTX
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_22:
		INC	DI			; X := X + 1
		JZ	SHORT PutLine_23	; Achte auf Bankswitch
PutLine_24:
		ADD	BP,BX			; SUM := SUM + 2 DLTY
		JS	SHORT PutLine_26	; Skip, wenn SUM < 0
		SUB	BP,SI			; SUM := SUM - 2DLTX
		SUB	DI,[BytesPerScanline]	; Y := Y - 1
		JC	SHORT PutLine_25	; Achte auf Bankswitch
PutLine_26:
		MOV	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_22	; Loop mit DLTX
PutLine_0:
		POP	BP
		RET	10			; Entferne 5 Words
;...............
PutLine_23:	CALL	IncWrBank
		JMP	SHORT PutLine_24
;...............
PutLine_25:	CALL	DecWrBank
		JMP	SHORT PutLine_26
;---------------
;  Wenn DLTX > DLTY, dann berechne Y = f(X)
;
PutLine_8:	CMP	SI,BX
		JG	SHORT PutLine_40
;............................
;  Wir berechnen X = f(Y) mit Scanlineoffset = +BytePerLine
;
		MOV	CX,BX		; Loopcount = DLTY
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	BP,BX
		NEG	BP		; SUM = - DLTY
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_32:
		ADD	DI,[BytesPerScanline]; Y := Y + 1
		JC	SHORT PutLine_33	; Achte auf Bankswitch
PutLine_34:
		ADD	BP,SI			; SUM := SUM + 2 DLTX
		JS	SHORT PutLine_36	; Skip, wenn SUM < 0
		SUB	BP,BX			; SUM := SUM - 2 DLTY
		INC	DI			; X := X + 1
		JZ	SHORT PutLine_35	; Achte auf Bankswitch
PutLine_36:
		MOV	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_32	; Loop mit DLTY
		JMP	SHORT PutLine_0
;...............
PutLine_33:	CALL	IncWrBank
		JMP	SHORT PutLine_34
;...............
PutLine_35:	CALL	IncWrBank
		JMP	SHORT PutLine_36
;...............
;  Wir berechnen Y = f(X) mit Scanlineoffset = +BytePerLine
;
PutLine_40:	MOV	CX,SI		; Loopcount = DLTX
		JCXZ	PutLine_0	; Loopcount = 0 ?
		MOV	BP,SI
		NEG	BP		; SUM = - DLTX
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLine_42:
		INC	DI			; X := X + 1
		JZ	SHORT PutLine_43	; Achte auf Bankswitch
PutLine_44:
		ADD	BP,BX			; SUM := SUM + 2 DLTY
		JS	SHORT PutLine_46	; Skip, wenn SUM < 0
		SUB	BP,SI			; SUM := SUM - 2 DLTX
		ADD	DI,[BytesPerScanline]; Y := Y + 1
		JC	SHORT PutLine_45	; Achte auf Bankswitch
PutLine_46:
		MOV	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLine_42	; Loop mit DLTX
		JMP	PutLine_0
;...............
PutLine_43:	CALL	IncWrBank
		JMP	SHORT PutLine_44
;...............
PutLine_45:	CALL	IncWrBank
		JMP	SHORT PutLine_46
;...............
;  Wir setzen die Pixel im XOR-Mode
;
PutLine_X:
;
;  Setze das 1. Pixel
;
		XOR	ES:[DI],AL
;
;  Berechne BX := DLTY
;
                MOV     BX,[YE]
		SUB	BX,[Y]
;
;  Wenn DLTY > 0, dann positive Steigung (Scanlineoffset = +BpSl)
;
		JNS	PutLinX_8
		NEG	BX		; DLTY := -DLTY
;
;  Wenn DLTX > DLTY, dann berechne Y = f(X)
;
                CMP     SI,BX
		JG	SHORT PutLinX_20
;..............
;  Wir berechnen X = f(Y) mit Scanlineoffset = -BytePerLine
;
		MOV	CX,BX		; Loopcount = DLTY
		JCXZ	PutLinX_0	; Loopcount = 0 ?
                MOV     BP,BX
		NEG	BP		; SUM = - DLTY
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLinX_12:
		SUB	DI,[BytesPerScanline]; Y := Y - 1
		JC	SHORT PutLinX_13	; Achte auf Bankswitch
PutLinX_14:
		ADD	BP,SI			; SUM := SUM + 2 DLTX
		JS	SHORT PutLinX_16	; Skip, wenn SUM < 0
		SUB	BP,BX			; SUM = SUM - 2 DLTY
		INC	DI			; X := X + 1
		JZ	SHORT PutLinX_15	; Achte auf Bankswitch
PutLinX_16:
		XOR	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLinX_12	; Loop mit DLTY
		JMP	SHORT PutLinX_0
;...............
PutLinX_13:	CALL	DecRdWrBank
		JMP	SHORT PutLinX_14
;...............
PutLinX_15:	CALL	IncRdWrBank
		JMP	SHORT PutLinX_16
;............................
;  Wir berechnen Y = f(X) mit Scanlineoffset = -BytePerLine
;
PutLinX_20:	MOV	CX,SI		; Loopcount = DLTX
		JCXZ	PutLinX_0	; Loopcount = 0 ?
                MOV     BP,SI
		NEG	BP		; SUM = - DLTX
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLinX_22:
		INC	DI			; X := X + 1
		JZ	SHORT PutLinX_23	; Achte auf Bankswitch
PutLinX_24:
		ADD	BP,BX			; SUM := SUM + 2 DLTY
		JS	SHORT PutLinX_26	; Skip, wenn SUM < 0
		SUB	BP,SI			; SUM := SUM - 2DLTX
		SUB	DI,[BytesPerScanline]; Y := Y - 1
		JC	SHORT PutLinX_25	; Achte auf Bankswitch
PutLinX_26:
		XOR	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLinX_22	; Loop mit DLTX
PutLinX_0:
		JMP	PutLine_0
;...............
PutLinX_23:	CALL	IncRdWrBank
		JMP	SHORT PutLinX_24
;...............
PutLinX_25:	CALL	DecRdWrBank
		JMP	SHORT PutLinX_26
;---------------
;  Wenn DLTX > DLTY, dann berechne Y = f(X)
;
PutLinX_8:	CMP	SI,BX
		JG	SHORT PutLinX_40
;...............
;  Wir berechnen X = f(Y) mit Scanlineoffset = +BytePerLine
;
		MOV	CX,BX		; Loopcount = DLTY
		JCXZ	PutLinX_0	; Loopcount = 0 ?
                MOV     BP,BX
		NEG	BP		; SUM = - DLTY
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLinX_32:
		ADD	DI,[BytesPerScanline]; Y := Y + 1
		JC	SHORT PutLinX_33	; Achte auf Bankswitch
PutLinX_34:
		ADD	BP,SI			; SUM := SUM + 2 DLTX
		JS	SHORT PutLinX_36	; Skip, wenn SUM < 0
		SUB	BP,BX			; SUM := SUM - 2 DLTY
		INC	DI			; X := X + 1
		JZ	SHORT PutLinX_35	; Achte auf Bankswitch
PutLinX_36:
		XOR	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLinX_32	; Loop mit DLTY
		JMP	SHORT PutLinX_0
;...............
PutLinX_33:	CALL	IncRdWrBank
		JMP	SHORT PutLinX_34
;...............
PutLinX_35:	CALL	IncRdWrBank
		JMP	SHORT PutLinX_36
;............................
;  Wir berechnen Y = f(X) mit Scanlineoffset = +BytePerLine
;
PutLinX_40:	MOV	CX,SI		; Loopcount = DLTX
		JCXZ	PutLinX_0	; Loopcount = 0 ?
                MOV     BP,SI
		NEG	BP		; SUM = - DLTX
		ADD	SI,SI		; 2 * DLTX
		ADD	BX,BX		; 2 * DLTY
		ALIGN	4
PutLinX_42:
		INC	DI			; X := X + 1
		JZ	SHORT PutLinX_43	; Achte auf Bankswitch
PutLinX_44:
		ADD	BP,BX			; SUM := SUM + 2 DLTY
		JS	SHORT PutLinX_46	; Skip, wenn SUM < 0
		SUB	BP,SI			; SUM := SUM - 2 DLTX
		ADD	DI,[BytesPerScanline]; Y := Y + 1
		JC	SHORT PutLinX_45	; Achte auf Bankswitch
PutLinX_46:
		XOR	ES:[DI],AL		; Setze Pixel
		DEC	CX
		JNZ	SHORT PutLinX_42	; Loop mit DLTX
		JMP	PutLinX_0
;...............
PutLinX_43:	CALL	IncRdWrBank
		JMP	SHORT PutLinX_44
;...............
PutLinX_45:	CALL	IncRdWrBank
		JMP	SHORT PutLinX_46
;...............
PutLine 	ENDP
;---------------------------------------
;  Zeichnet ein Rechteck mit Farbe.
;  Bercksichtigt XorMode.
;
;  Aufruf: PutRect (X,Y,Breite,Hoehe,Farbe:WORD);
;---------------
X		EQU	WORD PTR [BP+14]
Y		EQU	WORD PTR [BP+12]
Breite		EQU	WORD PTR [BP+10]
Hoehe		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;---------------
PutRect 	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
		MOV	AL,[Farbe]
		MOV	AH,AL		; AH := AL := Farbe
;
		MOV	BX,[BytesPerScanLine]
;
		MOV	CX,[Breite]
		CALL	DrawRi
;
		MOV	CX,[Hoehe]
		CALL	DrawDo
;
		MOV	CX,[Breite]
		CALL	DrawLe
;
		MOV	CX,[Hoehe]
		CALL	DrawUp

		POP	BP
		RET	10		; Entferne 5 WORDs vom Stack
;................
PutRect 	ENDP
;-------------------------------
;  Zeichnet einen Kreis ohne Verwendung von Winkelfunktionen.
;  Die Mitte des Kreises liegt auf einem Pixel. Deshalb belegt der Kreis in
;  X- und Y-Richtung 2*R +1 Pixel.
;  Das kleinste R betrgt 2.
;  Bercksichtigt XorMode.
;
;  Aufruf: PutCircle (XM, YM, R, Farbe:WORD)
;---------------
Xm		EQU	WORD PTR [BP+12]
Ym		EQU	WORD PTR [BP+10]
R		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
LastEntry	EQU	WORD PTR [BP-2]
FlagPixelPlus	EQU	BYTE PTR [BP-4] ; True, wenn zustzliches Pixel bentigt
;---------------
;  Lokale CALLs: GetListe, DrawRi, DrawDo, DrawLe, DrawUp
;---------------
PutCircle	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,4		; 2 lokale Word Var
;
;  Erzeuge eine Liste mit den Lngen der Geraden
;
		MOV	AX,[R]
		CALL	GetListe
		MOV	[LastEntry],DI	; Index-> letzten Eintrag
		MOV	AL,True 	; Zustzliches Pixel notwendig ?
		JNC	SHORT PutCircle_1 ; Ja, True bleibt
		MOV	AL,False	  ; Nein, kein zustzliches Pixel
PutCircle_1:
		MOV	[FlagPixelPlus],AL
;
;  Berechne die Adresse des 1. Byte (12 Uhr) im Video-Mem.
;  DXDI = BpSl * (Ym - R) + Xm
;
		MOVZX	EAX,[BytesPerScanline]	; EAX = BpSl

		SUB	EDX,EDX
		MOV	DX,[Ym] 	; EDX = Ym
		SUB	DX,[R]		; EDX = Ym - R
		MUL	EDX		; EDXEAX := BpSl * (Ym - R)
;
		MOVZX	EBX,[Xm]	; EBX := Xm
		ADD	EAX,EBX		; EDXEAX := BpSl * (Ym - R) + Xm
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10		; [Byte]
		DIV	EBX		; EDX := Offset EAX := Segm
		MOV	DI,DX		; DI := Offset
		MOV	DX,AX		; DX := Segm
;
		MOV	ES,[WinASegment]
;
		SetBanks		; Setze beide Banks:= DX
;
		MOV	AL,[Farbe]
		MOV	AH,AL
;
;  bertrage die Liste nach rechts in das Video-Mem
;  Es ist 12 Uhr
;
		MOV	SI,OFFSET Liste
		MOV	CH,0
		MOV	BX,[BytesPerScanLine]
		MOV	DX,1
PutCircle_2:
		MOV	CL,[SI]			; CX := Lnge

		CALL	DrawRi

		ADD	DI,BX			; + BytesPerScanLine
		JNB	SHORT PutCircle_8	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutCircle_8:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_2
;
;  bertrage die Liste rckwrts nach unten in das Video-Mem
;  Es ist 1 Uhr 30
;
PutCircle_10:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_12
		INC	SI
PutCircle_12:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_14
		DEC	CX
PutCircle_14:
		CALL	DrawDo
		DEC	SI
		CMP	SI,OFFSET Liste
		JB	SHORT PutCircle_20
		ADD	DI,DX			; ES:DI-> ein Pixel nach rechts
		JNC	SHORT PutCircle_12	; Achte auf Bankswitch
		CALL	IncRdWrBank
		JMP	SHORT PutCircle_12
;...............
;  bertrage die Liste vorwrts nach unten in das Video-Mem
;  Es ist 3 Uhr
;
PutCircle_20:	MOV	SI,OFFSET Liste
PutCircle_22:
		MOV	CL,[SI]			; CX := Lnge
		CALL	DrawDo
		SUB	DI,DX			; ES:DI-> ein Pixel nach links
		JNB	SHORT PutCircle_24	; Achte auf Bankswitch
		CALL	DecRdWrBank
PutCircle_24:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_22
;
;  bertrage die Liste rckwrts nach links in das Video-Mem
;  Es ist 4 Uhr 30
;
PutCircle_30:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_32
		INC	SI
PutCircle_32:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_34
		DEC	CX
PutCircle_34:
		CALL	DrawLe
		DEC	SI
		CMP	SI,OFFSET Liste
		JB	SHORT PutCircle_40

		ADD	DI,BX			; ES:DI-> nchste Scanline
		JNC	SHORT PutCircle_32	; Achte auf Bankswitch
		CALL	IncRdWrBank
		JMP	SHORT PutCircle_32
;...............
PutCircle_40:
;  bertrage die Liste vorwrts nach links in das Video-Mem
;  Es ist 6 Uhr
;
		MOV	SI,OFFSET Liste
PutCircle_42:
		MOV	CL,[SI]			; CX := Lnge

		CALL	DrawLe

		SUB	DI,BX			; ES:DI-> vorige Scanline
		JNB	SHORT PutCircle_48	; Achte auf Bankswitch
		CALL	DecRdWrBank
PutCircle_48:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_42
;
;  bertrage die Liste rckwrts nach oben in das Video-Mem
;  Es ist 7 Uhr 30
;
PutCircle_50:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_52
		INC	SI
PutCircle_52:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_54
		DEC	CX
PutCircle_54:
		CALL	DrawUp
		DEC	SI
		CMP	SI,OFFSET Liste
		JB	SHORT PutCircle_60

		SUB	DI,DX			; ES:DI-> ein Pixel nach links
		JNB	SHORT PutCircle_52	; Achte auf Bankswitch
		CALL	DecRdWrBank
		JMP	SHORT PutCircle_52
;...............
;  bertrage die Liste vorwrts nach oben in das Video-Mem
;  Es ist 9 Uhr
;
PutCircle_60:	MOV	SI,OFFSET Liste
PutCircle_62:
		MOV	CL,[SI]			; CX := Lnge
		CALL	DrawUp
		ADD	DI,DX			; ES:DI-> ein Pixel nach rechts
		JNC	SHORT PutCircle_64
		CALL	IncRdWrBank
PutCircle_64:
		INC	SI
		CMP	SI,[LastEntry]
		JNA	SHORT PutCircle_62
;
;  bertrage die Liste rckwrts nach rechts in das Video-Mem
;  Es ist 10 Uhr 30
;
PutCircle_70:	MOV	SI,[LastEntry]
		CMP	[FlagPixelPlus],True
		JNZ	SHORT PutCircle_72
		INC	SI
PutCircle_72:
		MOV	CL,[SI]			; CX := Lnge
		CMP	SI,OFFSET Liste
		JNZ	SHORT PutCircle_74
		DEC	CX
PutCircle_74:
		CALL	DrawRi
		SUB	DI,BX			; ES:DI-> vorige Scanline
		JNB	SHORT PutCircle_76
		CALL	DecRdWrBank
PutCircle_76:
		DEC	SI
		CMP	SI,OFFSET Liste
		JNB	SHORT PutCircle_72
PutCircle_80:
		MOV	SP,BP
		POP	BP
		RET	8		; Entferne 4 WORDs vom Stack
;
PutCircle	ENDP
;-------------------------------
;  Zeichnet eine Kreisscheibe ohne Verwendung von Winkelfunktionen.
;  Die Mitte der Kreisscheibe liegt auf einem Pixel. Deshalb hat belegt die
;  Kreisscheibe in X- und Y-Richtung 2*R +1 Pixel.
;  Das kleinste R betrgt 2.
;
;  Bercksichtigt XorMode.
;
;  Aufruf: PutDisk (XM, YM, R, Farbe:WORD)
;---------------
Xm		EQU	WORD PTR [BP+12]
Ym		EQU	WORD PTR [BP+10]
R		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
LastEntry	EQU	WORD PTR [BP-2]
FlagPixelPlus	EQU	BYTE PTR [BP-4]
;
;  Lokale CALLs: GetListe, DrawRi
;...............
PutDisk 	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,4		; 2 lokale Word Var
;
;  Erzeuge eine Liste mit den Lngenzunahmen der Horizontalen.
;  Die Routine kommt mit NOCY zurck, wenn zustzliche Horizontalen um
;  10:30 und 7:30 notwendig sind.
;
		MOV	AX,[R]		; AX:= R
		CALL	GetListe	; Erzeuge Liste
		MOV	[LastEntry],DI	; -> letzter Eintrag in die Liste
		MOV	AL,True 	; Bereite True vor
		JNC	SHORT PutDisk_1 ; Bei NOCY bleibt True
		MOV	AL,False	; Bereite False vor
PutDisk_1:
		MOV	[FlagPixelPlus],AL	; Setze vorbereiteten Wert
;
;  Berechne die Adresse des 1. Byte (ber dem Nordpol) im Video-Mem
;  DXDI = BpSl * (Ym - R - 1) + Xm
;
		MOVZX	EAX,[BytesPerScanline]	; EAX = BpSl

		SUB	EDX,EDX
		MOV	DX,[Ym] 	; EDX:= Ym
		SUB	DX,[R]		; EDX:= Ym - R
		DEC	DX		; EDX:= Ym - R - 1
		MUL	EDX		; EDXEAX := BpSl * (Ym - R - 1)
;
		MOVZX	EBX,[Xm]	; EBX := Xm
		ADD	EAX,EBX		; EDXEAX := BpSl * (Ym - R - 1) + X
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10		; [Byte]
		DIV	EBX		; EDX := Offset EAX := Segm
		MOV	DI,DX		; DI := Offset
		MOV	DX,AX		; DX := Segm
;
		MOV	ES,[WinASegment]
;
		SetBanks		; Setze beide Banks:= DX

		MOV	AL,[Farbe]
		MOV	AH,AL		; AH:AL := Farbe:Farbe
;
;  Verwendung der Register:
;  AH:AL := Farbe:Farbe fr DrawRi
;     BX := ganze Lnge der zuvor gezeichneten Sehne
;     CX := Lnge fr den Aufruf von DrawRi
;  ES:DI -> Pixel rechts neben der zuvor gezeichneten Sehne
;
;  bertrage die Liste vorwrts in das Video-Mem. Zeichne horizontale Sehnen.
;  Die halbe Lngenzunahme (Delta_L/2) von Sehne zu Sehne steht in der Liste.
;  Die Lnge der ersten Sehne betrgt nicht 2 * Delta_L, sondern 2 * Delta_L -1.
;  Deshalb beginnt der Loop mit einer vorigen Lnge von -1.
;
		MOV	SI,OFFSET Liste
		MOV	BX,-1		; Vorige Lnge = -1
		MOV	CH,0		; Hibyte der Lnge
PutDisk_4:
		MOV	CL,[SI]		; Hole Delta_L/2
		MOV	DX,[BytesPerScanLine]
		SUB	DX,BX		; Bpl - vorige Lnge
		SUB	DX,CX		; Bpl - vorige Lnge - Delta_L/2
		ADD	DI,DX		; DI-> nchste Scanline
		JNC	SHORT PutDisk_8
		CALL	IncRdWrBank
PutDisk_8:
		ADD	CX,CX		; CX = Delta_L
		ADD	CX,BX		; CX = Delta_L + alte Lnge
		MOV	BX,CX		; BX = alte lnge fr nchste Runde

		CALL	DrawRi		; Zeichne Horizontale

		INC	SI		; SI-> nchster Eintrag in Liste
		CMP	SI,[LastEntry]	; SI-> hinter letzten Eintrag
		JNA	SHORT PutDisk_4 ;  Nein, loop
;
;  bertrage die Liste rckwrts in das Video-Mem
;  Die Eintrge der Liste gelten jetzt als Hhen von Rechtecken
;  EING:    BX:= Lnge der zuletzt gezeichneten Sehne
;	 ES:DI-> rechts hinter das letzte Pixel
;
PutDisk_10:	MOV	SI,[LastEntry]		; SI-> letzter Eintrag
		CMP	[FlagPixelPlus],True	; Zustzliche Horizontale ?
		JNZ	SHORT PutDisk_12	;  Nein, skip
		INC	SI			; Ja, hinter letzten Eintrag
PutDisk_12:
		ADD	BX,2			; Jedes Rechteck 2 Pixel breiter
		ADD	DI,1			; ES:DI-> ein Pixel nach rechts
		JNC	SHORT PutDisk_14	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_14:
		MOV	CL,[SI]			; Lobyte der Hhe
PutDisk_16:
		MOV	DX,[BytesPerScanLine]
		SUB	DX,BX			; Bpl - Lnge
		ADD	DI,DX			; ES:DI-> nchste Scanline
		JNC	SHORT PutDisk_18	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_18:
		PUSH	CX			; Rette Loopcount fr Hhe
		MOV	CX,BX			; Lnge
		CALL	DrawRi
		POP	CX

		DEC	CX			; Loop mit Hhe
		JNZ	SHORT PutDisk_16
		DEC	SI			; SI-> voriger Eintrag
		CMP	SI,OFFSET Liste 	; SI vor Listenanfang ?
		JNB	SHORT PutDisk_12	;   Nein, loop
;
;  bertrage die Liste vorwrts in das Video-Mem
;  Die Eintrge der Liste gelten wieder als Hhen von Rechtecken
;  EING:    BX:= Lnge der zuletzt gezeichneten Sehne
;	 ES:DI-> rechts hinter das letzte Pixel
;
PutDisk_20:	MOV	SI,OFFSET Liste 	; SI-> Liste
PutDisk_22:
		MOV	CL,[SI] 		; Lobyte der Hhe
		CMP	SI,OFFSET Liste 	; 1. Eintrag der Liste ?
		JNZ	SHORT PutDisk_24	;  Nein, skip
		DEC	CX			; Ja, DEC Hhe
PutDisk_24:
		MOV	DX,[BytesPerScanLine]
		SUB	DX,BX
		ADD	DI,DX			; ES:DI-> nchste Scanline
		JNC	SHORT PutDisk_26	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_26:
		PUSH	CX			; Rette Loopcount fr Hhe
		MOV	CX,BX			; CX:= Lnge
		CALL	DrawRi			; Zeichne Horizontale
		POP	CX			; Restore Loopcount fr Hhe

		DEC	CX			; Loop mit Hhe
		JNZ	SHORT PutDisk_24

		INC	SI			; SI-> nchster Eintrag
		CMP	SI,[LastEntry]		; Letzter Eintrag berschritten ?
		JA	SHORT PutDisk_30	; Ja, fertig

		SUB	BX,2			; Lnge -2
		SUB	DI,1			; ES:DI-> ein Pixel nach links
		JNB	SHORT PutDisk_22	; Achte auf Bankswitch
		CALL	DecRdWrBank
		JMP	SHORT PutDisk_22
;...............
;  bertrage die Liste rckwrts in das Video-Mem
;  Zeichne horizontale Sehnen.
;  Die halbe Lngenabnahme (Delta_L/2) von Sehne zu Sehne steht in der Liste.
;  EING:    BX:= Lnge der zuletzt gezeichneten Sehne
;	 ES:DI-> rechts hinter das letzte Pixel
;
PutDisk_30:	MOV	CL,1			; Beginne mit Delta_L/2 := 1
		MOV	SI,[LastEntry]		; SI-> letzter Eintrag
		CMP	[FlagPixelPlus],True	; Zustzliche Horizontale ?
		JNZ	SHORT PutDisk_32	;  Nein, skip
		INC	SI			; Ja, SI-> hinter letzten Eintrag
PutDisk_32:
		MOV	DX,[BytesPerScanLine]
		SUB	DX,BX
		ADD	DX,CX
		ADD	DI,DX	; DI := DI + (Bpl - alte Lnge + Delta_L/2)
		JNC	SHORT PutDisk_38	; Achte auf Bankswitch
		CALL	IncRdWrBank
PutDisk_38:
		ADD	CX,CX			; CX:= Delta_L
		SUB	BX,CX			; BX:= alte Lnge - Delta_L
		MOV	CX,BX			; CX:= alte Lnge - Delta_L

		CALL	DrawRi			; Zeichne Horizontale

		MOV	CL,[SI] 		; CX:= Delta_L/2

		DEC	SI			; SI-> voriger Eintrag
		CMP	SI,OFFSET Liste 	; SI-> vor Listenanfang ?
		JNB	SHORT PutDisk_32	;  Nein, loop
PutDisk_40:
		MOV	SP,BP
		POP	BP
		RET	8			; Skip 4 WORD-Variable
PutDisk 	ENDP
;-------------------------------
;  Fllt ein Sprite mit Farbe.
;  Bercksichtigt XorMode.
;
;  Aufruf: FillSprite (X,Y,Breite,Hoehe,Farbe:WORD);
;---------------
X		EQU	WORD PTR [BP+14]
Y		EQU	WORD PTR [BP+12]
Breite		EQU	WORD PTR [BP+10]
Hoehe		EQU	WORD PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;---------------
FillSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		; Setze beide Windows := DX
;
		MOV	SI,[BytesPerScanline]
		SUB	SI,[Breite]	; SI = Scanlineoffset
;
		MOV	AL,[Farbe]
		MOV	AH,AL		; AH := AL := Farbe

		MOV	BX,[Breite]	; BX := Breite
		CLD
FillSprite_2:
		MOV	CX,BX		; CX = Pixel in X-Richtung
		CALL	DrawRi

		ADD	DI,SI		; ES:DI-> nchste Scanline
		JC	SHORT FillSprite_3
FillSprite_4:
		DEC	[Hoehe]		; Loop mit Hoehe
		JNZ	SHORT FillSprite_2
FillSprite_0:
		POP	BP
		RET	10		; Entferne 5 WORDs vom Stack
;................
FillSprite_3:	CALL	IncRdWrBank
		JMP	SHORT FillSprite_4
;...............
FillSprite	ENDP
;-------------------------------
;  Zoomt ein Rechteck auf doppelte Kantenlnge.
;  Die bertragung findet vom Save zum VGA-RAM statt.
;  Aufruf: ZoomSprite (X,Y,Breite,Hoehe:WORD; SaveAddr:POINTER);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Breite		EQU	WORD PTR [BP+12]
Hoehe		EQU	WORD PTR [BP+10]
SaveAddr	EQU	DWORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
LineCount	EQU	WORD PTR [BP-4]
LineOffset	EQU	WORD PTR [BP-6]
;---------------
ZoomSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; 3 lokale Word-Variable
		MOV	[DSSave],DS
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		MOV	BL,0		; Window A
		CALL	[WinFuncPtr]
;
;  Initialisiere die lokalen Variablen
;
		MOV	AX,[Hoehe]
		SHR	AX,1
		MOV	[LineCount],AX	; LineCount := Hoehe /2

		MOV	AX,[BytesPerScanline]
		SUB	AX,[Breite]
		MOV	[LineOffset],AX ; LineOffset := BpSl - Breite
;
;  Berechne den Offset fr das erste Byte aus dem Save
;  = Breite * LineCount/2 + Breite/4
;
		MOV	AX,[LineCount]
		SHR	AX,1		; AX := LineCount /2
		MOV	BX,[Breite]	; BX := Breite
		MUL	BX		; DXAX := Breite * LineCount/2
		SHR	BX,2		; Breite/4
		ADD	AX,BX
		LDS	SI,[SaveAddr]	; DS:SI-> Save
		ADD	SI,AX		; DS:SI-> 1.Byte

		MOV	BX,[Breite]	; Breite
ZoomSprite_2:
		MOV	DX,2		; Anzahl Durchlufe/Zeile
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
ZoomSprite_4:	ADD	DI,BX		; + Breite
		JC	SHORT ZoomSprite_10
		SUB	DI,BX
;
;  Zoom eine Zeile zum Video-Mem
;
		PUSH	SI		; Rette SI-> Zeilenanfang
		MOV	CX,[Breite]	; Anzahl Pixel/Zeile
		SHR	CX,1
		ALIGN	4
ZoomSprite_6:
		LODSB			; Hole vom Save
		MOV	AH,AL		; 2 Pixel nebeneinander
		STOSW			; Bringe zum Video-Mem
		DEC	CX
		JNZ	SHORT ZoomSprite_6
;
		POP	SI		; Restore SI-> Zeilenanfang
		ADD	DI,[LineOffset]
		JC	SHORT ZoomSprite_7
ZoomSprite_8:
		DEC	DX		; Loop mit Anzahl Durchlufe/Zeile
		JNZ	SHORT ZoomSprite_4
		ADD	SI,BX
		DEC	[LineCount]	; Loop mit Anzahl Scanlines
		JNZ	SHORT ZoomSprite_2
;
;  Rume den Stack auf
;
		MOV	DS,[DSSave]
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 4 WORDs und 1 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  DI hat die Anzahl Byte in der nchsten Bank
;
ZoomSprite_10:	PUSH	SI	; Rette SI-> Zeilenanfang
		PUSH	DI	; Rette DI = Anzahl Byte in der neuen Bank
		MOV	CX,BX	; CX := Breite
		SUB	CX,DI	; CX = Anzahl Byte in alter Bank
		SUB	DI,BX	; DI-> alte Bank
;
;  bertrage den 1. Teil der Zeile in die alte Bank.
;  CX hat die Anzahl Byte, die da noch reinpassen.
;  Jedes Byte, das wir vom Save holen, bringen wir 2X zum Video-Mem.
;  Der Bankwechsel kann uns zwischen den beiden Writes erwischen.
;
ZoomSprite_12:	LODSB			; Hole vom Save
		STOSB			; Bringe 1. mal zum Video-Mem
		DEC	CX		; Dec Bytezahl
		JZ  SHORT ZoomSprite_13	; Alte Bank voll ?
		STOSB			; Bringe 2. mal zum Video-Mem
		DEC	CX		; Dec Bytezahl
		JNZ SHORT ZoomSprite_12	; Alte Bank noch nicht voll ?
;
;  Incrementiere Write-Bank
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
;
;  bertrage den 2. Teil der Zeile in die neue Bank
;
		POP	CX	       ; CX = Anzahl Byte in der neuen Bank
ZoomSprite_14:			       ; Ab hier mu (CX mod 2) = 0 sein
		SHR	CX,1
		JZ  SHORT ZoomSprite_18; Skip, wenn CX = 0
ZoomSprite_16:
		LODSB		       ; Hole vom Save
		MOV	AH,AL	       ; 2 Pixel nebeneinander
		STOSW		       ; Bringe zum Video-Mem
		DEC	CX	       ; Dec Anzahl zu holende Byte
		JNZ  SHORT ZoomSprite_16
ZoomSprite_18:
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	DI,[LineOffset]
		POP	SI		; Restore SI-> Zeilenanfang
		JMP	SHORT ZoomSprite_8
;...............
;  Inkrementiere Write-Bank
;  und bringe das einzelne Byte in die neue Bank.
;
ZoomSprite_13:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
;
		POP	CX	; CX = Anzahl Byte in der neuen Bank
		STOSB		; Bringe das Byte in die neue Bank
		DEC	CX	; Ein Byte ist schon fertig
		JMP	SHORT ZoomSprite_14
;...............
ZoomSprite_7:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
		JMP	SHORT ZoomSprite_8
ZoomSprite	ENDP
;-------------------------------
;  bertrgt ein Sprite vom Video-Mem in das DOS-Mem
;
;  Aufruf: GetSprite (X,Y,Breite,Hoehe:WORD; SaveAddr:POINTER);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Breite		EQU	WORD PTR [BP+12]
Hoehe		EQU	WORD PTR [BP+10]
SaveAddr	EQU	DWORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
;---------------
GetSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,2		; 1 lokales Word
		MOV	[DSSave],DS
;
;  Berechne die Adresse der oberen linken Ecke
;  DXSI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
		MOV	SI,DI
;
;  Suche nach einem lesbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,1		; Bit#0 = Lesbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
;
;  Berechne den Abstand zwischen dem Ende der einen und dem Anfang der
;  nchsten Scanline
;
		MOV	AX,[BytesPerScanline]
		MOV	BX,[Breite]		; BX := Breite
		SUB	AX,BX			; AX := BpSl -Breite
;
		CLD				; String aufwrts

		MOV	DS,[WinASegment]	; DS:SI-> Video-Mem
		LES	DI,[SaveAddr]		; ES:DI-> Save

		ALIGN	4
GetSprite_2:
;  bertrage eine Zeile vom Video-Mem zum DOS-Mem
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		ADD	SI,BX
		JC	SHORT GetSprite_3
		SUB	SI,BX
;
;  Wir mssen nicht mit Bankswitch rechnen
;  Unterscheide zwischen gerader und ungerader Startadresse im Video-Mem
;
		TEST	SI,1
		JZ	SHORT GetSprite_4
;
;  Wir haben eine ungerade Startadresse im Video-Mem
;  bertrage erst ein Byte, dann wordweise und bei geraden Bytecount
;  noch ein Byte.
;
		MOV	CX,BX		; CX:= Bytecount
		MOVSB			; Erst ein Byte..
		DEC	CX		; DEC Bytecount
		SHR	CX,1		; CX:= Wordcount
		REP	MOVSW		; ...dann wordweise..
		RCL	CX,1		; ..und dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
		JMP	SHORT GetSprite_44
;...............
;  Wir haben eine gerade Startadresse im Video-Mem
;
GetSprite_4:	MOV	CX,BX		; CX:= Bytecount
		SHR	CX,1		; CX:= Wordcount
		REP	MOVSW		; Erst wordweise
		RCL	CX,1		; Dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
;
;  Berechne die ADR der nchsten Zeile und achte auf Bankswitch
;
GetSprite_44:	ADD	SI,AX		; SI-> nchste Zeile
		JC	SHORT GetSprite_5
GetSprite_6:
		DEC	[Hoehe]		; LOOP mit Zeilenzahl
		JNZ	SHORT GetSprite_2
;
;  Rume den Stack auf
;
GetSprite_0:	MOV	DS,[DSSave]
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 4 WORDs und 1 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  SI hat die Anzahl Byte in der nchsten Bank
;
GetSprite_3:	MOV	DX,SI		; DX = Anzahl Byte in neuer Bank
		SUB	SI,BX		; SI-> alte Bank
		MOV	CX,BX		; CX := Breite
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
		REP	MOVSB		; 1. Teil der Zeile...
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank	; ... Bankswitch...
		POP	DS

		MOV	CX,DX		; Bytezahl fr 2. Teil
		REP	MOVSB		; 2. Teil der Zeile
;
;  Berechne Startadr der nchsten Zeile
;
		ADD	SI,AX
		DEC	[Hoehe] 	; Dec Zeilenzahl
		JNZ	SHORT GetSprite_2
		JMP	SHORT GetSprite_0
;...............
GetSprite_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank
		POP	DS
		JMP	SHORT GetSprite_6
GetSprite	ENDP
;-------------------------------
;  bertrgt ein Sprite vom DOS-Mem zum Video-Mem
;
;  Aufruf: PutSprite (X,Y,Breite,Hoehe:WORD; SaveAddr:POINTER);
;---------------
X		EQU	WORD PTR [BP+16]
Y		EQU	WORD PTR [BP+14]
Breite		EQU	WORD PTR [BP+12]
Hoehe		EQU	WORD PTR [BP+10]
SaveAddr	EQU	DWORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
;---------------
PutSprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,2		; 1 lokales Word
		MOV	[DSSave],DS
;
;  Berechne die Adresse der oberen linken Ecke
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
;  Setze das Window := DX
;
		MOV	BH,0			; Window setzen
		MOV	BL,0			; Window A

		CALL	[WinFuncPtr]
;
;  Berechne die Scanlinedifferenz AX := BytePerLine - Breite
;
		MOV	AX,[BytesPerScanline]
		MOV	BX,[Breite]		; BX := Breite
		SUB	AX,BX			; AX := BpSl -Breite

		LDS	SI,[SaveAddr]		; DS:SI-> Save

		CLD				; String aufwrts
		ALIGN	4
PutSprite_2:
;
;  bertrage eine Zeile vom DOS-Mem zum Video-Mem
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		ADD	DI,BX
		JC	SHORT PutSprite_3
		SUB	DI,BX
;
;  Wir mssen nicht mit Bankswitch rechnen
;  Unterscheide zwischen gerader und ungerader Startadresse im Video-Mem
;
		TEST	DI,1
		JZ	SHORT PutSprite_4
;
;  Wir haben eine ungerade Startadresse im Video-Mem
;  bertrage erst ein einzelnes Byte, dann Words und bei gerader Bytezahl
;  noch ein Byte
;
		MOV	CX,BX		; CX:= Bytecount
		MOVSB			; bertrage ein Byte
		DEC	CX		; DEC Bytecount
		SHR	CX,1		; CX = Wordcount
		REP	MOVSW		; Erst wordweise..
		RCL	CX,1		; ..dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
		JMP	SHORT PutSprite_44
;...............
;  Wir haben eine gerade Startadresse im Video-Mem
;  bertrage Words und bei ungerader Bytezahl dann noch ein Byte
;
PutSprite_4:	MOV	CX,BX		; CX = BytesPerPixel*Breite (Byte)
		SHR	CX,1		; CX = Wordcount
		REP	MOVSW		; Erst wordweise
		RCL	CX,1		; Dann vielleicht..
		REP	MOVSB		; ..noch ein Byte
;
;  Berechne die ADR der nchsten Zeile und achte auf Bankswitch
;
PutSprite_44:	ADD	DI,AX			; DI-> nchste Zeile
		JC	SHORT PutSprite_5	; Achte auf Bankswitch
PutSprite_6:
		DEC	[Hoehe] 		; LOOP mit Zeilenzahl
		JNZ	SHORT PutSprite_2
;
;  Rume den Stack auf
;
PutSprite_0:	MOV	DS,[DSSave]
		MOV	SP,BP
		POP	BP
		RET	12		; Entferne 4 WORDs und 1 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  DI hat die Anzahl Byte in der nchsten Bank
;
PutSprite_3:	MOV	DX,DI		; DX = Anzahl Byte in neuer Bank
		SUB	DI,BX		; DI-> alte Bank
		MOV	CX,BX		; CX := Breite
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
		REP	MOVSB		; bertrage 1.Teil der Zeile
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank	; Nchste Bank
		POP	DS
;
		MOV	CX,DX
		REP	MOVSB		; bertrage 2.Teil der Zeile
;
;  Berechne Startadr der nchsten Zeile
;
		ADD	DI,AX
		DEC	[Hoehe]		;  Loop mit Zeilenzahl
		JNZ	SHORT PutSprite_2
		JMP	SHORT PutSprite_0
;...............
PutSprite_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
		JMP	SHORT PutSprite_6
PutSprite	ENDP
;-------------------------------
;  bertrgt ein Sprite vom Video-Mem in einen File.
;  Die bertragung findet zunchst vom Video-Mem zeilenweise in einen Buffer
;  statt. Bufferlage und Gre ist von TP aus whlbar und beeinflut die
;  Laufzeit der PROC (mehr Buffer = schneller). DOS schreibt dann vom Buffer
;  zum File.
;
;  Der File enthlt keinen Header und keine Palette (wie ein .BMP-File).
;
;  Aufruf: Sprite2File (X,Y,Breite,Hoehe:WORD;
;			    VAR Pathname:STRING; VAR ErrCode:WORD);
;			       BufferPtr:POINTER; BufferSize:WORD);
;---------------
X		EQU	WORD PTR [BP+26]
Y		EQU	WORD PTR [BP+24]
Breite		EQU	WORD PTR [BP+22]
Hoehe		EQU	WORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
;-------------------------------
Sprite2File	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,8		; 4 lokale Word-Variable
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	[DSSave],DS
;
;  LineDiff:= BytesPerScanLine-Breite
;
		MOV	AX,[BytesPerScanLine]
		SUB	AX,[Breite]
		MOV	[LineDiff],AX
;
		MOV	[BufferInhalt],0
;...............................
;  Kreiere einen File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	CX,0			; Fileattribute: Normal
		MOV	AH,3CH			; Function: Create Handle
		INT	21H			; DOS-Aufruf
		JC	Sprite2File_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXSI = (Y * BytesPerScanLine) + X	ES:= [WinASegment]
;...............................
		MOV	DS,[DSSave]
		GetScreenAddr
		MOV	SI,DI
;
		SetBanks		; Setze das Window := DX
;...............................
;  Setze Zeiger	DS:SI-> Video-Mem und ES:DI-> Buffer
;...............................
		MOV	DS,[WinASegment]; DS:SI-> Video-Mem
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
Sprite2File_2:
;...............................
;  bertrage eine Zeile des Sprite vom Video-Mem zum Buffer
;...............................
;  Wenn BufferInhalt + Breite <= BufferSize
;   dann pat die folgende Zeile noch in den Buffer
;
		MOV	AX,[BufferInhalt]
		ADD	AX,[Breite]
		CMP	AX,[BufferSize]
		JNA	SHORT Sprite2File_4
;
;  Die Zeile pat nicht mehr in den Buffer
;  Schreibe den BufferInhalt zum File
;
		PUSH	DS			; Rette DS-> Video-Mem
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to write
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		POP	DS			; Restore DS-> Video-Mem
		JC	SHORT Sprite2File_0	; DOS-Aufruf fehlgeschlagen ?
;
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
		MOV	AX,[Breite]	; Bereite BufferInhalt := Breite vor
Sprite2File_4:
		MOV	[BufferInhalt],AX
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		MOV	CX,[Breite]
		ADD	SI,CX
		JC	SHORT Sprite2File_3
		SUB	SI,CX
;
;  bertrage eine Zeile vom Video-Mem zum Buffer
;  Jetzt ist: DS:SI-> Video-Mem
;	      ES:DI-> Buffer
;		 CX = Breite
;
		CLD				; String aufwrts
		REP	MOVSB
;...............................
;  Bestimme die Adr der nchsten Zeile des Sprite im Video-Mem
;...............................
		ADD	SI,[LineDiff]
		JC	SHORT Sprite2File_5
Sprite2File_6:
;...............................
;  LOOP mit Hoehe
;...............................
		DEC	[Hoehe]
		JNZ	SHORT Sprite2File_2
;...............................
;  Schreibe den restlichen BufferInhalt zum File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer

		MOV	CX,[BufferInhalt]
		JCXZ	Sprite2File_8		; BufferInhalt = 0 ?
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2File_0	;  fehlgeschlagen ?
Sprite2File_8:
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
		MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2File_0	;  fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
Sprite2File_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr] ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
; Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]	;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	22		; Entferne 5 WORDs und 3 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  Jetzt ist: SI = Anzahl Byte in der nchsten Bank
;	      CX = Breite
;
Sprite2File_3:	MOV	DX,SI		; DX = Anzahl Byte in neuer Bank
		SUB	SI,CX		; SI-> alte Bank
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
		REP	MOVSB		; 1. Teil der Zeile...
;
;  Inkrementiere Read-Bank
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank	; ... Bankswitch...
		POP	DS
;
		MOV	CX,DX		; Bytezahl fr 2. Teil
		REP	MOVSB		; 2. Teil der Zeile
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	SI,[LineDiff]
		JMP	SHORT Sprite2File_6
;...............
Sprite2File_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank
		POP	DS
		JMP	SHORT Sprite2File_6
;...............
Sprite2File	ENDP
;-------------------------------
;  bertrgt ein Sprite vom Video-Mem in einen .BMP-File.
;  Die bertragung findet zunchst vom Video-Mem zeilenweise in einen Buffer
;  statt. Bufferlage und Gre ist von TP aus whlbar und beeinflut die
;  Laufzeit der PROC (mehr Buffer = schneller). DOS schreibt dann vom Buffer
;  zum File.
;
;  Der File enthlt einen .BMP-Header und die Palette.
;
;  Aufruf: Sprite2Bmp (X,Y,Breite,Hoehe:WORD;
;			   VAR Pathname:STRING; VAR ErrCode:WORD);
;			      BufferPtr:POINTER; BufferSize:WORD);
;---------------
X		EQU	WORD PTR [BP+26]
Y		EQU	WORD PTR [BP+24]
Breite		EQU	WORD PTR [BP+22]
Hoehe		EQU	WORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
FileBreite	EQU	WORD PTR [BP-10]
Rest		EQU	WORD PTR [BP-12]
;-------------------------------
Sprite2Bmp	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,12		; 6 lokale Word-Variable
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	[DSSave],DS
;
;  LineDiff:= BytesPerScanLine+Breite
;
		MOV	AX,[BytesPerScanLine]
		ADD	AX,[Breite]
		MOV	[LineDiff],AX
;
;  Wenn Breite mod 4 <> 0, dann FileBreite := (Breite mod 4) + 4
;  Sonst FileBreite := Breite
;
		MOV	AX,[Breite]
		TEST	AL,3
		JZ	SHORT Sprite2BMP_1
		AND	AX,NOT 3
		ADD	AX,4
Sprite2BMP_1:
		MOV	[FileBreite],AX
;
;  Rest:= FileBreite-Breite
;
		SUB	AX,[Breite]
		MOV	[Rest],AX
;
;  Bufferinhalt := 0
;
		MOV	[BufferInhalt],0
;...............................
;  Kreiere einen File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	CX,0			; Fileattribute: Normal
		MOV	AH,3CH			; Function: Create Handle
		INT	21H			; DOS-Aufruf
		JC	Sprite2File_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Bilde im Buffer BufferPtr den Header des .BMP-Files
;...............................
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
		SUB	EAX,EAX
		MOV	CX,36H/4
		REP	STOSD

		LDS	DI,[BufferPtr]	; DS:DI-> Buffer
		MOV	AL,'B'
		MOV	AH,'M'
		MOV	[DI],AX		; #0	Kennung 'BM'
;
		MOV	AX,[Breite]
		MOV	[DI+12H],AX	; #12	Breite
		MOV	AX,[Hoehe]
		MOV	[DI+16H],AX	; #16	Hhe

		MUL	[FileBreite]	; DXAX = FileBreite * Hoehe
		ADD	AX,436H
		ADC	DX,0		; DXAX = Filelnge
;
		MOV	[DI+2],AX
		MOV	[DI+4],DX	; #2   Filelnge
;
		MOV	AX,436H
		MOV	[DI+0AH],AX	; #A	Offset Datenbereich

		MOV	AX,28H
		MOV	[DI+0EH],AX	; #E	Lnge Info Header
;
		MOV	AX,1
		MOV	[DI+1AH],AX	; #1A	Farbebenen
;
		MOV	AX,8
		MOV	[DI+1CH],AX	; #1C	Bit/Pel
;
;  Schreibe den Header in den .BMP-File
;
		MOV	DX,DI		; DS:DX-> Buffer
		MOV	CX,36H		; Bytes to write
		MOV	BX,[FileHandle]	; BX = HANDLE
		MOV	AH,40H		; Function: Write Handle
		INT	21H		; DOS-Aufruf
		JC	Sprite2BMP_0	;  fehlgeschlagen ?
;
;  bertrage den DAC in die .BMP-Palette
;
		CALL	ColReg2BmpBuf
;
;  Schreibe die .BMP Palette in den File
;
		MOV	DX,DI		; DS:DX-> Buffer
		MOV	CX,400H 	; Bytes to write
		MOV	BX,[FileHandle]
		MOV	AH,40H		; Function: Write Handle
		INT	21H		; DOS-Aufruf
		JC	Sprite2BMP_0	;  fehlgeschlagen ?
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXSI = ((Y+Hoehe-1) * BytesPerScanLine) + X
;  GetScreenAddr ist ungeeignet, weil wir die untere linke Ecke brauchen
;...............................
		MOV	DS,[DSSave]

		MOVZX	EAX,[BytesPerScanline]
		MOVZX	EDX,[Y]		; EDX = Y
		ADD	DX,[Hoehe]	; EDX = Y+Hoehe
		DEC	DX		; EDX = Y+Hoehe-1
		MUL	EDX	; EDXEAX := BytesPerScanLine * (Y+Hoehe-1)
;
		MOVZX	EBX,[X]			; EBX := X
		ADD	EAX,EBX
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10			; [Byte]
		DIV	EBX			; EDX := Offset   EAX := Segm
		MOV	SI,DX			; SI := Offset
		MOV	DX,AX			; DX := Segm
;
		SetBanks		; Setze das Window := DX
;...............................
;  Setze Zeiger	DS:SI-> Video-Mem und ES:DI-> Buffer
;...............................
		MOV	DS,[WinASegment]; DS:SI-> Video-Mem
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
Sprite2Bmp_2:
;...............................
;  bertrage eine Zeile des Sprite vom Video-Mem zum Buffer
;...............................
;  Wenn BufferInhalt + FileBreite <= BufferSize
;   dann pat die folgende Zeile noch in den Buffer
;
		MOV	AX,[BufferInhalt]
		ADD	AX,[FileBreite]
		CMP	AX,[BufferSize]
		JNA	SHORT Sprite2Bmp_4
;
;  Die Zeile pat nicht mehr in den Buffer
;  Schreibe den BufferInhalt zum File
;
		PUSH	DS			; Rette DS-> Video-Mem
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to write
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		POP	DS			; Restore DS-> Video-Mem
		JC	SHORT Sprite2Bmp_0	; DOS-Aufruf fehlgeschlagen ?
;
		LES	DI,[BufferPtr]	; ES:DI-> Buffer
		MOV	AX,[FileBreite]	; Bereite BufferInhalt := FileBreite vor
Sprite2Bmp_4:
		MOV	[BufferInhalt],AX
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		MOV	CX,[Breite]
		ADD	SI,CX
		JC	SHORT Sprite2Bmp_3
		SUB	SI,CX
;
;  bertrage eine Zeile vom Video-Mem zum Buffer
;  Jetzt ist: DS:SI-> Video-Mem
;	      ES:DI-> Buffer
;		 CX = Breite
;
		CLD				; String aufwrts
		REP	MOVSB

		MOV	AL,0			; Flle den Rest mit 0
		MOV	CX,[Rest]
		REP	STOSB
;...............................
;  Bestimme die Adr der nchsten Zeile des Sprite im Video-Mem
;...............................
		SUB	SI,[LineDiff]
		JB	SHORT Sprite2Bmp_5
Sprite2Bmp_6:
;...............................
;  LOOP mit Hoehe
;...............................
		DEC	[Hoehe]
		JNZ	SHORT Sprite2Bmp_2
;...............................
;  Schreibe den restlichen BufferInhalt zum File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer

		MOV	CX,[BufferInhalt]
		JCXZ	Sprite2Bmp_8		; BufferInhalt = 0 ?
		MOV     BX,[FileHandle]
		MOV     AH,40H                  ; Function: Write Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2Bmp_0	;  fehlgeschlagen ?
Sprite2Bmp_8:
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
Sprite2BMP_7:	MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Sprite2Bmp_0	;  fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
Sprite2Bmp_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr] ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]	;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	22		; Entferne 5 WORDs und 3 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  Jetzt ist: SI = Anzahl Byte in der nchsten Bank
;	      CX = Breite
;
Sprite2Bmp_3:	MOV	DX,SI		; DX = Anzahl Byte in neuer Bank
		SUB	SI,CX		; SI-> alte Bank
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
		REP	MOVSB		; 1. Teil der Zeile...
;
;  Inkrementiere Read-Bank
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncRdBank	; ... Bankswitch...
		POP	DS
;
		MOV	CX,DX		; Bytezahl fr 2. Teil
		REP	MOVSB		; 2. Teil der Zeile

		MOV	AL,0		; Flle den Rest mit 0
		MOV	CX,[Rest]
		REP	STOSB
;
;  Berechne Startadr der vorigen Zeile
;  Sie liegt in der vorangegangenen Bank
;
		SUB	SI,[LineDiff]
Sprite2Bmp_5:
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	DecRdBank	; ... Bankswitch...
		POP	DS

		JMP	SHORT Sprite2Bmp_6
;...............
Sprite2Bmp	ENDP
;--------------------------------
;  Liest vom DAC die Color Register in einen Speicherbereich DS:DI
;
;  EING: DS:DI-> Buffer der Color Register (1024 Byte)
;
ColReg2BmpBuf	PROC
		PUSHA

		PUSH	ES
		PUSH	DS
		POP	ES

		MOV	DX,DI		; ES:DX-> Table
		SUB	BX,BX		; Starting Index
		MOV	CX,256		; Number of Regs to read
		MOV	AX,1017H	; Read Block of Color Reg
		INT	10H		; Video Int
		POP	ES
;
		MOV	SI,DI
		ADD	SI,300H
		ADD	DI,400H
		MOV	CX,100H
		MOV	BH,0
ColReg2BmpBuf_2:
		SUB	SI,3
		SUB	DI,4

		MOV	AL,[SI]
		SHL	AL,2
		MOV	AH,[SI+1]
		SHL	AH,2
		MOV	BL,[SI+2]
		SHL	BL,2

		MOV	[DI],BL
		MOV	[DI+1],AH
		MOV	[DI+2],AL
		MOV	[DI+3],BH	; Dummy-Byte fr .BMP-Pal

		LOOP	ColReg2BmpBuf_2
;
		POPA
		RET
ColReg2BmpBuf	ENDP
;-------------------------------
;  Liest von einem File in ein Sprite.
;  DOS liest das Sprite in Stcken vom File in einen Buffer. Bufferlage und
;  Gre ist von TP aus whlbar und beeinflut die Laufzeit der PROC (mehr
;  Buffer = schneller). Der Buffer enthlt eine Anzahl vollstndiger Zeilen
;  des Sprite. Anschlieend findet die bertragung aus dem Buffer zum
;  Video-Mem statt.
;
;  Der File enthlt keinen Header und keine Palette (wie ein .BMP-File).
;
;  Aufruf: File2Sprite (X,Y,Breite,Hoehe:WORD;
;			    VAR Pathname:STRING; VAR ErrCode:WORD);
;			       BufferPtr:POINTER; BufferSize:WORD);
;---------------
;  Stackaufbau:
X		EQU	WORD PTR [BP+26]
Y		EQU	WORD PTR [BP+24]
Breite		EQU	WORD PTR [BP+22]
Hoehe		EQU	WORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
LinesPerBuffer	EQU	WORD PTR [BP-10]
LineCount	EQU	WORD PTR [BP-12]
;-----------------------
File2Sprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,12		; 6 lokale Word-Variable
;...............................
;  Init die lokalen Variablen
;...............................
		MOV	[DSSave],DS
;
;  LineDiff:= BytesPerScanLine-Breite;
;
		MOV	AX,[BytesPerScanLine]
		SUB	AX,[Breite]
		MOV	[LineDiff],AX
;
;  LinesPerBuffer := LineCount := BufferSize / Breite
;
		MOV	AX,[BufferSize]
		SUB	DX,DX
		DIV	[Breite]
		MOV	[LinesPerBuffer],AX
		MOV	[LineCount],AX
;
;  BufferInhalt := LinesPerBuffer * Breite (AX hat LinePerBuffer)
;
		MUL	[Breite]
		MOV	[BufferInhalt],AX
;...............................
;  ffne den File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	AL,2			; Fileattr = Normal
		MOV     AH,3DH                  ; Function: Open Handle
		INT	21H			; DOS-Aufruf
		JC	File2Sprite_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;...............................
		MOV	DS,[DSSave]
		GetScreenAddr
;
		SetBanks		; Setze beide Windows:= DX
;...............................
;  Lies einen Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT File2Sprite_0	; fehlgeschlagen ?
;
;  Setze ES := [WinASegment]
;
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;...............................
;  bertrage eine Zeile vom Buffer zum Video-Mem
;...............................
File2Sprite_2:
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		MOV	CX,[Breite]
		ADD	DI,CX
		JC	SHORT File2Sprite_3
		SUB	DI,CX
;
;  Das Zeilenende liegt noch in der momentanen Bank
;  bertrage eine Zeile vom Buffer zum Video-Mem
;  Jetzt ist: DS:SI-> Buffer
;	      ES:DI-> Video-Mem
;		 CX = Breite
;
		CLD				; String aufwrts
		REP	MOVSB
;
;  Bestimme die ADR der nchsten Zeile im Video-Mem
;
		ADD	DI,[LineDiff]
		JC	SHORT File2Sprite_5
File2Sprite_6:
;
;  Sieh nach, ob die nchste Zeile noch im Buffer enthalten ist
;
		DEC	[LineCount]
		JNZ	SHORT  File2Sprite_8
;...............................
;  Die nchste Zeile ist nicht mehr im Buffer enthalten
;  Lies einen weiteren Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT File2Sprite_0	; fehlgeschlagen ?
;
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;
		MOV	AX,[LinesPerBuffer]
		MOV	[LineCount],AX		; LineCount := LinesPerBuffer
;...............................
;  LOOP mit Hoehe
;...............................
File2Sprite_8:	DEC	[Hoehe]
		JNZ	SHORT File2Sprite_2
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
		MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT File2Sprite_0	; fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
File2Sprite_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr]        ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]		;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	22		; Entferne 5 WORDs und 3 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  Jetzt ist: DI = Anzahl Byte in der nchsten Bank
;	      CX = Breite
;
File2Sprite_3:	MOV	DX,DI		; DX = Anzahl Byte in neuer Bank
		SUB	DI,CX		; DI-> alte Bank
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
;  bertrage den 1. Teil der Zeile
;
		CLD
		REP	MOVSB
;
;  Inkrementiere Write-Bank
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
;
;  bertrage den 2. Teil der Zeile
;
		MOV	CX,DX
		REP	MOVSB
;
;  Berechne Startadr der nchsten Zeile (Nicht schon wieder Bankswitch)
;
		ADD	DI,[LineDiff]
		JMP	SHORT File2Sprite_6
;...............
File2Sprite_5:	PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
		JMP	SHORT File2Sprite_6
;...............
File2Sprite	ENDP
;-------------------------------
;  Liest von einem .BMP-File in ein Sprite.
;  DOS liest das Sprite in Stcken vom File in einen Buffer. Bufferlage und
;  Gre ist von TP aus whlbar und beeinflut die Laufzeit der PROC (mehr
;  Buffer = schneller). Der Buffer enthlt eine Anzahl vollstndiger Zeilen
;  des Sprite. Anschlieend findet die bertragung aus dem Buffer zum
;  Video-Mem statt.
;
;  Der File enthlt einen .BMP-Header und die Palette.
;
;  Aufruf: Bmp2Sprite (X,Y:WORD; VAR Breite,Hoehe:WORD;
;			   VAR Pathname:STRING; VAR ErrCode:WORD);
;			      BufferPtr:POINTER; BufferSize:WORD);
;---------------
;  Stackaufbau:
X		EQU	WORD PTR [BP+30]
Y		EQU	WORD PTR [BP+28]
BreitePtr	EQU	DWORD PTR [BP+24]
HoehePtr	EQU	DWORD PTR [BP+20]
PathNamePtr	EQU	DWORD PTR [BP+16]
ErrCodePtr	EQU	DWORD PTR [BP+12]
BufferPtr	EQU	DWORD PTR [BP+8]
BufferSize	EQU	WORD PTR [BP+6]
;
;  Lokale Variable auf dem Stack:
;
DSSave		EQU	WORD PTR [BP-2]
FileHandle	EQU	WORD PTR [BP-4]
LineDiff	EQU	WORD PTR [BP-6]
BufferInhalt	EQU	WORD PTR [BP-8]
LinesPerBuffer	EQU	WORD PTR [BP-10]
LineCount	EQU	WORD PTR [BP-12]
FileBreite	EQU	WORD PTR [BP-14]
LokaleHoehe	EQU	WORD PTR [BP-16]
SpriteBreite	EQU	WORD PTR [BP-18]
Rest		EQU	WORD PTR [BP-20]
;-----------------------
Bmp2Sprite	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,20		; 10 lokale Word-Variable

		MOV	[DSSave],DS
;...............................
;  ffne den File und erzeuge einen [FileHandle]
;...............................
		LDS	DX,[PathNamePtr]	; DS:DX -> Pathname
		INC	DX			; Skip TP-Stringlnge
		MOV	AL,2			; Fileattr = Normal
		MOV     AH,3DH                  ; Function: Open Handle
		INT	21H			; DOS-Aufruf
		JC	Bmp2Sprite_0		;  fehlgeschlagen ?
		MOV     [FileHandle],AX
;...............................
;  Lies den Header des .BMP-File
;  Er enthlt u.a. Breite und Hhe des Sprite
;...............................
		LDS	DX,[BufferPtr]	; DS:DX-> Buffer
		MOV	CX,36H		; Bytes to read
		MOV	BX,[FileHandle]
		MOV	AH,3FH		; Function: Read Handle
		INT	21H
		JC	Bmp2Sprite_0
;...............................
;  bertrage die Breite und Hhe des Sprite in die lokalen Variablen
;  und in die TP-Variablen, damit auch TP die Breite und Hoehe kennt.
;...............................
		LDS	SI,[BufferPtr]	; DS:SI-> Header im Buffer
		LES	DI,[BreitePtr]	; ES:DI-> TP-Variable Breite
		MOV	AX,[SI+12H]	; Hole Breite aus dem Header
		MOV	ES:[DI],AX	; Lege in der TP-Variablen ab
		MOV	[SpriteBreite],AX
;
;  Die im File tatschlich verwendete Breite entspricht nur dann
;  der SpriteBreite, wenn SpriteBreite mod 4 = 0 ist. Sonst wird die FileBreite
;  auf den nchsthheren Wert fr mod 4 = 0 aufgerundet.
;
		TEST	AL,03
		JZ	SHORT Bmp2Sprite_1
		AND	AL,NOT 03
		ADD	AX,0004
Bmp2Sprite_1:
		MOV	[FileBreite],AX ; im File verwendete Breite
;
;  Rest:= FileBreite - SpriteBreite	; AX hat noch FileBreite
;
		SUB	AX,[SpriteBreite]
		MOV	[Rest],AX
;
;  bertrage die Hoehe in die lokale Variable, wo sie whrend der
;  Hauptschleife dekrementiert wird.
;
		LES	DI,[HoehePtr]	; ES:DI-> TP-Variable Hoehe
		MOV	AX,[SI+16H]	; Hole Hoehe aus dem Header
		MOV	ES:[DI],AX	; Lege in der TP-Variablen ab
		MOV	[LokaleHoehe],AX
;...............................
;  Lies die .BMP Palette in den Buffer
;...............................
		LDS	DX,[BufferPtr]	; DS:DX-> Buffer
		MOV	CX,400H 	; Bytes to read
		MOV	BX,[FileHandle]
		MOV	AH,3FH		; Function: Read Handle
		INT	21H
		JC	Bmp2Sprite_0
;...............................
;  bertrage die .BMP Color Register aus dem Buffer in den DAC
;...............................
		MOV	DI,DX
		CALL	BmpBuf2ColReg
;...............................
;  Init die lokalen Variablen
;...............................
;
;  LineDiff:= BytesPerScanLine+SpriteBreite;
;
		MOV	DS,[DSSave]
		MOV	AX,[BytesPerScanLine]
		ADD	AX,[SpriteBreite]
		MOV	[LineDiff],AX
;
;  LinesPerBuffer := LineCount := BufferSize / FileBreite
;
		MOV	AX,[BufferSize]
		SUB	DX,DX
		DIV	[FileBreite]
		MOV	[LinesPerBuffer],AX
		MOV	[LineCount],AX
;
;  BufferInhalt := LinesPerBuffer * FileBreite (AX hat LinesPerBuffer)
;
		MUL	[FileBreite]
		MOV	[BufferInhalt],AX
;...............................
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = ((Y+Hoehe-1) * BytesPerScanLine) + X	ES:= [WinASegment]
;  GetScreenAddr ist ungeeignet, weil wir die untere linke Ecke brauchen
;...............................

		MOVZX	EAX,[BytesPerScanline]
		MOVZX	EDX,[Y]		; EDX = Y
		ADD	DX,[LokaleHoehe]; EDX = Y+Hoehe
		DEC	DX		; EDX = Y+Hoehe-1
		MUL	EDX	; EDXEAX := BytesPerScanLine * (Y+Hoehe-1)
;
		MOVZX	EBX,[X]			; EBX := X
		ADD	EAX,EBX
;
		MOVZX	EBX,[WinGranularity]	; [kByte]
		SHL	EBX,10			; [Byte]
		DIV	EBX			; EDX := Offset   EAX := Segm
		MOV	DI,DX			; DI := Offset
		MOV	DX,AX			; DX := Segm
;
		SetBanks		; Setze das Window := DX
;...............................
;  Lies einen Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Bmp2Sprite_0	; fehlgeschlagen ?
;
;  Setze ES := [WinASegment]
;
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;...............................
;  bertrage eine Zeile vom Buffer zum Video-Mem
;...............................
Bmp2Sprite_2:
;
;  Sieh nach, ob das Zeilenende in die nchste Bank ragt
;
		MOV	CX,[SpriteBreite]
		ADD	DI,CX
		JC	SHORT Bmp2Sprite_3
		SUB	DI,CX
;
;  Das Zeilenende liegt noch in der momentanen Bank
;  bertrage eine Zeile vom Buffer zum Video-Mem
;  Jetzt ist: DS:SI-> Buffer
;	      ES:DI-> Video-Mem
;		 CX = SpriteBreite
;
		CLD				; String aufwrts
		REP	MOVSB
		ADD	SI,[Rest]
;
;  Bestimme die ADR der vorigen Zeile im Video-Mem
;
		SUB	DI,[LineDiff]
		JC	SHORT Bmp2Sprite_5
Bmp2Sprite_6:
;
;  Sieh nach, ob die nchste Zeile noch im Buffer enthalten ist
;
		DEC	[LineCount]
		JNZ	SHORT  Bmp2Sprite_8
;...............................
;  Die nchste Zeile ist nicht mehr im Buffer enthalten
;  Lies einen weiteren Buffer vom File
;...............................
		LDS	DX,[BufferPtr]		; DS:DX-> Buffer
		MOV	CX,[BufferInhalt]	; Bytes to read
		MOV     BX,[FileHandle]
		MOV     AH,3FH                  ; Function: Read Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Bmp2Sprite_0	; fehlgeschlagen ?
;
		LDS	SI,[BufferPtr]		; DS:SI-> Buffer
;
		MOV	AX,[LinesPerBuffer]
		MOV	[LineCount],AX		; LineCount := LinesPerBuffer
;...............................
;  LOOP mit LokaleHoehe
;...............................
Bmp2Sprite_8:	DEC	[LokaleHoehe]
		JNZ	SHORT Bmp2Sprite_2
;...............................
;  Schliee den File wieder und bereite ErrCode:= 0 vor
;...............................
		MOV	BX,[FileHandle] 	; BX = HANDLE
		MOV	AH,3EH			; Function: Close Handle
		INT	21H			; DOS-Aufruf
		JC	SHORT Bmp2Sprite_0	; fehlgeschlagen ?
;
		SUB	AX,AX			; ErrCode:=0
Bmp2Sprite_0:
;...............................
;  Lege den ErrCode ab (AX ist 0, wenn kein Error oder hat den DOS-ErrCode)
;...............................
		LDS	DI,[ErrCodePtr]        ; DS:DI-> ErrCode
		MOV	[DI],AX
;...............................
;  Rume den Stack auf und ret zu TP
;...............................
		MOV	DS,[DSSave]		;  Restore DS
		MOV	SP,BP
		POP	BP
		RET	26		; Entferne 3 WORDs und 5 POINTER
;................
;  Whrend einer Zeile ist Bankswitch notwendig
;  Jetzt ist: DI = Anzahl Byte in der nchsten Bank
;	      CX = SpriteBreite
;
Bmp2Sprite_3:	MOV	DX,DI		; DX = Anzahl Byte in neuer Bank
		SUB	DI,CX		; DI-> alte Bank
		SUB	CX,DX		; CX := Breite - Byte in neuer Bank
;
;  bertrage den 1. Teil der Zeile
;
		CLD
		REP	MOVSB
;
;  Inkrementiere Write-Bank
;
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	IncWrBank
		POP	DS
;
;  bertrage den 2. Teil der Zeile
;
		MOV	CX,DX
		REP	MOVSB
		ADD	SI,[Rest]
;
;  Berechne Startadr der darberliegenden Zeile.
;  Sie liegt in der vorangegangenen Write-Bank.
;
		SUB	DI,[LineDiff]
Bmp2Sprite_5:
		PUSH	DS
		MOV	DS,[DSSave]
		CALL	DecWrBank
		POP	DS
		JMP	SHORT Bmp2Sprite_6
;...............
Bmp2Sprite	ENDP
;--------------------------------
;  Schreibt die .BMP Color Register von einem Speicherbereich DS:DI in den DAC
;
;  EING: DS:DI-> .BMP Color Register (1024 Byte)
;
BmpBuf2ColReg	PROC
		PUSHA
;
		MOV	SI,DI
		MOV	DX,DI
		MOV	CX,256
BmpBuf2ColReg_2:
		MOV	AL,[SI]
		SHR	AL,2
		MOV	AH,[SI+1]
		SHR	AH,2
		MOV	BL,[SI+2]
		SHR	BL,2

		MOV	[DI],BL
		MOV	[DI+1],AH
		MOV	[DI+2],AL

		ADD	SI,4
		ADD	DI,3

		LOOP	BmpBuf2ColReg_2

		PUSH	ES
		PUSH	DS
		POP	ES		; ES:DX-> Table

		MOV	BX,0		; Starting Index
		MOV	CX,256		; Number of Regs to set
		MOV	AX,1012H	; Set Block of Color Reg
		INT	10H		; Video Int
		POP	ES
;
		POPA
		RET
BmpBuf2ColReg	ENDP
;-------------------------------
;  bertrgt ein ASCII-Zeichen in einer 16 x 8 Punkte Matrix auf den Video-Mem.
;  Dabei wird die obere linke Ecke als Bezugspunkt fr die geforderten X,Y-
;  Koordinaten genommen.
;
;  Aufruf: PutChar (X,Y:WORD; Char, CharSize, Farbe:BYTE);
;---------------
X		EQU	WORD PTR [BP+14]
Y		EQU	WORD PTR [BP+12]
Char		EQU	BYTE PTR [BP+10]
CharSize	EQU	BYTE PTR [BP+8]
Farbe		EQU	BYTE PTR [BP+6]
;---------------
PutChar		PROC	FAR
		PUSH	BP
		MOV	BP,SP
;
;  Berechne den Offset des Zeichens im CharSet
;
		MOV	AL,[Char]
		MOV	CX,16		   ; Jeder Eintrag hat 16 Bytes
		MUL	CL		   ; AX = 16 * CHAR #n
		PUSH	AX		   ; TOS = Offset
;
;  Berechne die Adresse des 1. Byte im Video-Mem
;  DXDI = (Y * BytesPerScanLine) + X ;		ES:= [WinASegment]
;
		GetScreenAddr
;
		SetBanks		   ; Setze beide Windows := DX
;
;  Init die Reg fr die bertragung vom  CharSet
;
		MOV	BX,[BytesPerScanline]	; BX = BpSl
		SUB	BX,8		   ; BX = Byte/Line -8
		MOV	DH,[XorMode]	   ; DH = Art der Verknpfung
;
		MOV	SI,OFFSET CharSet  ; FS:SI-> CharSet im CS
		POP	AX		   ; Restore Offset
		ADD	SI,AX		   ; DS:SI-> CharSet im CS CHAR #n
;
		MOV	CX,16		   ; Zeichenhhe
		MOV	DL,[Farbe]
		CLD
;  Jetzt ist:
;  CS:SI-> Zeichen im CharSet
;  ES:DI-> Video-Mem
;  SS:BP-> Variable auf dem Stack
;  BX = Byte/Line -8
;  CX = LineCount = 16
;  DL = Farbe
;  DH = XorMode
;
		CMP	DH,CH		   ; CASE OF XorMode
		JNZ	PutChaX
;
;  Wir haben MovMode. Verzweige je nach Zeichengre
;
		CMP	[CharSize],1	   ;  CASE OF CharSize
		JZ	PutChar_10
		CMP	[CharSize],2
		JZ	PutChar_20
;...............
;  CharSize = 0	( Einfache Breite, einfache Hhe)
;
PutChar_00:	MOV	AL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	AH,80H		   ; Testmaske
PutChar_02:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_04   ;	Nein, skip
		MOV	ES:[DI],DL	   ; Setze Pixel := Farbe
PutChar_04:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChar_05   ; Achte auf Bankswitch
PutChar_06:
		SHR	AH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChar_02   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des Video-Mem
		JC	SHORT PutChar_07   ; Achte auf Bankswitch
PutChar_08:
		DEC	CX		   ; LineCount
		JNZ	SHORT PutChar_00   ; Loop mit Zeilen/Char
PutChar_0:
		POP	BP
		RET	10		   ; Entferne 5 WORDs vom Stack
;---------------
PutChar_05:	CALL	IncWrBank
		JMP	SHORT PutChar_06
;---------------
PutChar_07:	CALL	IncWrBank
		JMP	SHORT PutChar_08
;------------------------------------------
;  CharSize = 1	 (Einfache Breite und doppelte Hhe)
;
PutChar_10:	MOV	AL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	DH,2		   ; Zeilen/Byte
PutChar_11:
		MOV	AH,80H		   ; Testmaske
PutChar_12:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_14   ;	Nein, skip
		MOV	ES:[DI],DL	   ; Setze Pixel := Farbe
PutChar_14:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChar_15   ; Achte auf Bankswitch
PutChar_16:
		SHR	AH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChar_12   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des Video-Mem
		JC	SHORT PutChar_17   ; Achte auf Bankswitch
PutChar_18:
		DEC	DH		   ; Loop mit Zeilen/Byte
		JNZ	SHORT PutChar_11

		DEC	CX		   ; LineCount
		JNZ	SHORT PutChar_10   ; Loop mit Zeilen/Char
		JMP	SHORT PutChar_0
;---------------
PutChar_15:	CALL	IncWrBank
		JMP	SHORT PutChar_16
;---------------
PutChar_17:	CALL	IncWrBank
		JMP	SHORT PutChar_18
;---------------
;  CharSize = 2	(Doppelte Breite und doppelte Hhe)
;
PutChar_20:
		SUB	BX,8		   ; BX = BytePerLine -16
PutChar_202:
		MOV	AL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	DH,2		   ; Zeilen/Byte
PutChar_21:
		MOV	AH,80H		   ; Testmaske
PutChar_22:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_24   ;	Nein, skip
		MOV	ES:[DI],DL	   ; Setze Pixel := Farbe
PutChar_24:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChar_25   ; Achte auf Bankswitch
PutChar_26:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChar_28   ;	Nein, skip
		MOV	ES:[DI],DL	   ; Setze Pixel := Farbe
PutChar_28:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChar_29   ; Achte auf Bankswitch
PutChar_30:
		SHR	AH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChar_22   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des Video-Mem
		JC	SHORT PutChar_31   ; Achte auf Bankswitch
PutChar_32:
		DEC	DH		   ; Loop mit Zeilen/Byte
		JNZ	PutChar_21

		DEC	CX		   ; LineCount
		JNZ	SHORT PutChar_202  ; Loop mit Zeilen/Char
		JMP	PutChar_0
;..............
PutChar_25:	CALL	IncWrBank
		JMP	SHORT PutChar_26
;..............
PutChar_29:	CALL	IncWrBank
		JMP	SHORT PutChar_30
;..............
PutChar_31:	CALL	IncWrBank
		JMP	SHORT PutChar_32
;---------------
;  Wir haben XorMode. Verzweige je nach Zeichengre
;
PutChaX:	CMP	[CharSize],1	   ;  CASE OF CharSize
		JZ	PutChaX_10
		CMP	[CharSize],2
		JZ	PutChaX_20
;...............
;  CharSize = 0	( Einfache Breite, einfache Hhe)
;
PutChaX_00:	MOV	AL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	AH,80H		   ; Testmaske
PutChaX_02:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChaX_04   ;	Nein, skip
		XOR	ES:[DI],DL	   ; Xor Pixel mit Farbe
PutChaX_04:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChaX_05   ; Achte auf Bankswitch
PutChaX_06:
		SHR	AH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChaX_02   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des Video-Mem
		JC	SHORT PutChaX_07   ; Bankswitch
PutChaX_08:
		DEC	CX		   ; LineCount
		JNZ	SHORT PutChaX_00   ; Loop mit Zeilen/Char
		JMP	PutChar_0
;---------------
PutChaX_05:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_06
;---------------
PutChaX_07:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_08
;-------------------------------
;  CharSize = 1	 (Einfache Breite und doppelte Hhe)
;
PutChaX_10:
		MOV	AL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	DH,2		   ; Zeilen/Byte
PutChaX_11:
		MOV	AH,80H		   ; Testmaske
PutChaX_12:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChaX_14   ;	Nein, skip
		XOR	ES:[DI],DL	   ; Xor Pixel mit Farbe
PutChaX_14:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChaX_15   ; Achte auf Bankswitch
PutChaX_16:
		SHR	AH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChaX_12   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des Video-Mem
		JC	SHORT PutChaX_17   ; Achte auf Bankswitch
PutChaX_18:
		DEC	DH		   ; Loop mit Zeilen/Byte
		JNZ	PutChaX_11

		DEC	CX		   ; LineCount
		JNZ	SHORT PutChaX_10   ; Loop mit Zeilen/Char
		JMP	PutChar_0
;---------------
PutChaX_15:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_16
;---------------
PutChaX_17:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_18
;---------------
;  CharSize = 2	(Doppelte Breite und doppelte Hhe)
;
PutChaX_20:
		SUB	BX,8		   ; BX = BytePerLine -16
PutChaX_202:
		MOV	AL,CS:[SI]	   ; Hole vom CharSet
		INC	SI
		MOV	DH,2		   ; Zeilen/Byte
PutChaX_21:
		MOV	AH,80H		   ; Testmaske
PutChaX_22:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChaX_24   ;	Nein, skip
		XOR	ES:[DI],DL	   ; Xor Pixel mit Farbe
PutChaX_24:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChaX_25   ; Achte auf Bankswitch
PutChaX_26:
		TEST	AL,AH		   ; Bit gesetzt ?
		JZ	SHORT PutChaX_28   ;	Nein, skip
		XOR	ES:[DI],DL	   ; Xor Pixel mit Farbe
PutChaX_28:
		INC	DI		   ; Ein Pixel nach rechts
		JZ	SHORT PutChaX_29   ; Achte auf Bankswitch
PutChaX_30:
		SHR	AH,1		   ; Testmaske -> ein Pixel nach rechts
		JNZ	SHORT PutChaX_22   ; Testmaske ausgelaufen ?

		ADD	DI,BX		   ; DI-> nchste Zeile des Video-Mem
		JC	SHORT PutChaX_31   ; Achte auf Bankswitch
PutChaX_32:
		DEC	DH		   ; Loop mit Zeilen/Byte
		JNZ	PutChaX_21

		DEC	CX		   ; LineCount
		JNZ	SHORT PutChaX_202  ; Loop mit Zeilen/Char
		JMP	PutChar_0
;..............
PutChaX_25:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_26
;..............
PutChaX_29:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_30
;..............
PutChaX_31:	CALL	IncRdWrBank
		JMP	SHORT PutChaX_32
;...............
PutChar		ENDP
;-------------------------------
;  Lscht den sichtbaren Bildschirmbereich (Fllt ihn mit schwarz)
;
;  Aufruf: ClearScreen
;---------------
ClearScreen	PROC	FAR
;
;  Berechne die Anzahl Bnke, die gelscht werden mssen
;
		MOVZX	EAX,[XResolution]
		MOVZX	EDX,[YResolution]
		MUL	EDX
		MOVZX	EBX,[WinSize]		; in kByte
		SHL	EBX,10			; in Byte
		DIV	EBX
		INC	AX
		MOV	SI,AX			; Anzahl Bnke
		MOV	DX,0			; Start-Window
		SUB	DI,DI			; Startadr
		MOV	ES,[WinASegment]
		CLD
ClearScreen_2:
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		MOV	BL,0		; Window A

		PUSH	DX
		CALL	[WinFuncPtr]
		POP	DX
;
		SUB	EAX,EAX		; Fillwert = 0
		MOV	CX,4000H

		REP	STOSD		; CX mal von EAX nach ES:[DI]

		ADD	DX,[WinSizePerGranu]
		DEC	SI
		JNZ	SHORT ClearScreen_2

                RET
ClearScreen	ENDP
;-------------------------------
;  Lscht das ganze Video-Mem (Fllt es mit schwarz)
;
ClearVGAMem	PROC	FAR
;
		MOV	SI,[TotalMemory]	; Anzahl Bnke
		MOV	DX,0			; Start-Window
		SUB	DI,DI			; Startadr
		MOV	ES,[WinASegment]	; ES:DI-> Video-Mem
		CLD				; String aufwrts
ClearVGAMem_2:
;
;  Setze das Window := DX und lsche es
;
		MOV	BH,0			; Window setzen
		MOV	BL,0			; Window A

		PUSH	DX
		CALL	[WinFuncPtr]
		POP	DX
;
		SUB	EAX,EAX			; Fillwert = 0
		MOV	CX,4000H
		REP	STOSD			; CX mal von EAX nach ES:[DI]
		ADD	DX,[WinSizePerGranu]
		DEC	SI			; Loop mit Anzahl Bnke
		JNZ	SHORT ClearVGAMem_2

		RET
ClearVGAMem	ENDP
;-------------------------------
;  Blendet die Bankgrenzen in der Farbe Rot ein
;
;  Aufruf: ShowBanks
;---------------
ShowBanks	PROC	FAR
;
		MOV	SI,[TotalMemory]	; Anzahl Bnke
		SUB	DX,DX			; Beginne mit Bank #0
		MOV	ES,[WinASegment]	; ES-> Video-Mem
		CLD				; String aufwrts
ShowBanks_2:
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		MOV	BL,0		; Window A

		PUSH	DX
		CALL	[WinFuncPtr]
		POP	DX
;
;  Flle eine Zeile
;
		MOV	CX,[BytesPerScanLine]; Zeilenlnge
		SUB	DI,DI			; ES:DI-> Video-Mem
		MOV	AL,12			; hellrot
		REP	STOSB			; Flle eine Zeile
;
		ADD	DX,[WinSizePerGranu]

		DEC	SI
		JNZ	SHORT ShowBanks_2	; Loop mit Anzahl Bnke

		RET
ShowBanks	ENDP
;-------------------------------
;======================================================================
;  Prozeduren, die innerhalb der UNIT mit NEAR CALL aufgerufen werden.
;=======================================================================
;  DrawRi, DrawLe, DrawUp, DrawDo,
;  GetListe
;  IncWrBank, DecWrBank, IncRdBank, DecRdBank, IncRdWrBank, DecRdWrBank
;-------------------------------
;  Zeichnet eine Grade nach rechts beginnend bei ES:DI
;  Bercksichtigt XORMode
;
;  EING: ES:DI-> Erstes Pixel
;	    CX = Lnge	(>=1)
;	    AX = Farbe:Farbe
;  AUSG:    DI = DI+CX	(Hinter das letzte Pixel. Evtl in der nchsten Bank)
;	    CX = 0
;---------------
DrawRi		PROC
;
;  Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	DrawRiX
;
;  Wir haben MOVE_Mode
;  Sieh nach, ob Bankberschreitung auftreten knnte
;
		CLD
		ADD	DI,CX
		JB	SHORT DrawRi_50
		SUB	DI,CX
;
;  Wir mssen nicht mit Bankberschreitung rechnen.
;  Sie nach, ob die Startadresse ungerade ist.
;
		TEST	DI,1
		JZ	SHORT DrawRi_100
;
;  Die Startadresse ist ungerade
;  Sieh nach, ob die Bytezahl gerade ist
;
		TEST	CL,1
		JZ	SHORT DrawRi_30
;
;  Startadresse und Bytezahl sind ungerade
;  bertrage erst ein Byte und dann wordweise
;
DrawRi_40:	STOSB			; Bringe erst ein Byte zum Video-Mem
					; Jetzt ist die Startadresse gerade
		SHR	CX,1
		JZ	SHORT DrawRi_44
DrawRi_42:
		REP	STOSW		; Bringe wordweise zum Video-Mem
DrawRi_44:
		RET
;...............
;  Die Startadresse ist ungerade und die Bytezahl gerade
;  bertrage zuerst und zuletzt ein Byte
;
DrawRi_30:	SHR	CX,1
		STOSB			; Bringe erst ein Byte zum Video-Mem
					; Jetzt ist die Startadresse gerade
		DEC	CX
		JZ	SHORT DrawRi_34
DrawRi_32:
		REP	STOSW		; Bringe wordweise zum Video-Mem
DrawRi_34:
		STOSB			; Bringe noch ein Byte zum Video-Mem

		RET
;...............
;  Die Startadresse ist ungerade
;  Sieh nach, ob die Bytezahl gerade ist
;
DrawRi_100:	TEST	CL,1
		JZ	SHORT DrawRi_10
;
;  Startadresse ist gerade und die Bytezahl ist ungerade
;  bertrage erst wordweise un dann noch ein Byte
;
DrawRi_20:	SHR	CX,1
		JZ	SHORT DrawRi_24
DrawRi_22:
		REP	STOSW		; Bringe wordweise zum Video-Mem
DrawRi_24:
		STOSB			; Bringe noch ein Byte zum Video-Mem
		RET
;...............
;  Startadresse und Bytezahl sind gerade
;  bertrage wordweise
;
DrawRi_10:
		SHR	CX,1
DrawRi_12:
		REP	STOSW		; Bringe zum Video-Mem
		RET
;...............
;  Wir mssen mit Bankberschreitung rechnen. Arbeite Byteweise
;
DrawRi_50:	SUB	DI,CX
DrawRi_52:
		MOV	ES:[DI],AL	; Bringe zum Video-Mem
		INC	DI
		JZ	SHORT DrawRi_53
DrawRi_54:
		DEC	CX
		JNZ	SHORT DrawRi_52
		RET
;...............
DrawRi_53:	CALL	IncWrBank
		JMP	SHORT DrawRi_54
;...............
;  Wir haben XORMode
;  Sieh nach, ob Bankberschreitung auftreten knnte
;
DrawRiX:	ADD	DI,CX
		JB	SHORT DrawRiX_50
		SUB	DI,CX
;
;  Wir mssen nicht mit Bankberschreitung rechnen.
;  Sie nach, ob die Startadresse ungerade ist.
;
		TEST	DI,1
		JZ	SHORT DrawRiX_100
;
;  Die Startadresse ist ungerade
;  Sieh nach, ob die Bytezahl gerade ist
;
		TEST	CL,1
		JZ	SHORT DrawRiX_30
;
;  Startadresse und Bytezahl sind ungerade
;  bertrage erst ein Byte und dann wordweise
;
DrawRiX_40:	XOR	ES:[DI],AL	; Bringe erst ein Byte zum Video-Mem
		INC	DI		; Jetzt ist die Startadresse gerade
		SHR	CX,1
		JZ	SHORT DrawRiX_44 ; Hatten wir nur ein Byte ?
DrawRiX_42:
		XOR	ES:[DI],AX	; Bringe wordweise zum Video-Mem
		ADD	DI,2
		DEC	CX
		JNZ	SHORT DrawRiX_42
DrawRiX_44:
		RET
;...............
;  Die Startadresse ist ungerade und die Bytezahl gerade
;  bertrage zuerst und zuletzt ein Byte
;
DrawRiX_30:	SHR	CX,1
		XOR	ES:[DI],AL	; Bringe erst ein Byte zum Video-Mem
		INC	DI		; Jetzt ist die Startadresse gerade
		DEC	CX
		JZ	SHORT DrawRiX_34
DrawRiX_32:
		XOR	ES:[DI],AX	; Bringe wordweise zum Video-Mem
		ADD	DI,2
		DEC	CX
		JNZ	SHORT DrawRiX_32
DrawRiX_34:
		XOR	ES:[DI],AL	; Bringe noch ein Byte zum Video-Mem
		INC	DI

		RET
;...............
;  Die Startadresse ist ungerade
;  Sieh nach, ob die Bytezahl gerade ist
;
DrawRiX_100:	TEST	CL,1
		JZ	SHORT DrawRiX_10
;
;  Startadresse ist gerade und die Bytezahl ist ungerade
;  bertrage erst wordweise und dann noch ein Byte
;
DrawRiX_20:
		SHR	CX,1
		JZ	SHORT DrawRiX_24
DrawRiX_22:
		XOR	ES:[DI],AX	; Bringe wordweise zum Video-Mem
		ADD	DI,2
		DEC	CX
		JNZ	SHORT DrawRiX_22
DrawRiX_24:
		XOR	ES:[DI],AL	; Bringe noch ein Byte zum Video-Mem
		INC	DI
		RET
;...............
;  Startadresse und Bytezahl sind gerade
;  bertrage wordweise
;
DrawRiX_10:
		SHR	CX,1
DrawRiX_12:
		XOR	ES:[DI],AX	; Bringe zum Video-Mem
		ADD	DI,2
		DEC	CX
		JNZ	SHORT DrawRiX_12
		RET
;...............
;  Wir mssen mit Bankberschreitung rechnen. Arbeite Byteweise
;
DrawRiX_50:
		SUB	DI,CX
DrawRiX_52:
		XOR	ES:[DI],AL	; Bringe zum Video-Mem
		INC	DI
		JZ	SHORT DrawRiX_53
DrawRiX_54:
		DEC	CX
		JNZ	SHORT DrawRiX_52
		RET
;...............
DrawRiX_53:	CALL	IncRdWrBank
		JMP	SHORT DrawRiX_54
DrawRi		ENDP
;-------------------------------
;  Zeichnet eine Grade nach links beginnend bei ES:DI
;  Bercksichtigt XORMode
;  EING: ES:DI-> erstes Pixel
;	    CX = Lnge	(>=1)
;	    AL = Farbe
;  AUSG:    DI = DI-CX	(vor das letzte Pixel. Evtl in der vorigen Bank)
;	    CX = 0
;	    DX = 1
;
DrawLe		PROC
		MOV	DX,1
;
;  Sieh nach, ob wir XORMode haben
;
		CMP	[XORMode],True
		JZ	SHORT DrawLeX
;
;  Wir haben MOVE_Mode
;
DrawLe_2:	MOV	ES:[DI],AL
		SUB	DI,DX
		JB	SHORT DrawLe_3
DrawLe_4:
		DEC	CX
		JNZ	SHORT DrawLe_2
		RET
;...............
DrawLe_3:	CALL	DecWrBank
		JMP	SHORT DrawLe_4
;---------------
;  Wir haben XORMode
;
DrawLeX:	XOR	ES:[DI],AL
		SUB	DI,DX
		JB	SHORT DrawLeX_3
DrawLeX_4:
		DEC	CX
		JNZ	SHORT DrawLeX
		RET
;...............
DrawLeX_3:	CALL	DecRdWrBank
		JMP	SHORT DrawLeX_4
;...............
DrawLe		ENDP
;-------------------------------
;  Zeichnet eine Gerade aufwrts beginnend bei ES:DI
;  Reagiert auf XORMode
;
;  EING: ES:DI-> Erstes Pixel
;	    AL = Farbe
;	    BX = BytesPerScanLine
;	    CX = Lnge (>< 0)
;  AUSG: ES:DI-> ber das letzte Pixel. Bank entsprechend.
;	    CX = 0
;---------------
DrawUp		PROC
		CMP	[XORMode],True
		JZ	SHORT DrawUpX

DrawUp_2:	MOV	ES:[DI],AL
		SUB	DI,BX
		JB	SHORT DrawUp_3
DrawUp_4:
		DEC	CX
		JNZ	SHORT DrawUp_2
		RET
;...............
DrawUp_3:	CALL	DecWrBank
		JMP	SHORT DrawUp_4
;---------------
DrawUpX:	XOR	ES:[DI],AL
		SUB	DI,BX
		JB	SHORT DrawUpX_3
DrawUpX_4:
		DEC	CX
		JNZ	SHORT DrawUpX
		RET
;...............
DrawUpX_3:	CALL	DecRdWrBank
		JMP	SHORT DrawUpX_4
;...............
DrawUp		ENDP
;-------------------------------
;  Zeichnet eine Gerade abwrts beginnend bei ES:DI
;  Reagiert auf XORMode
;
;  EING: ES:DI-> erstes Pixel
;	    AL = Farbe
;	    BX = BytesPerScanLine
;	    CX = Lnge (>< 0)
;
;  AUSG: ES:DI-> unter das letzte Pixel. Bank entsprechend.
;	    CX = 0
;
DrawDo		PROC
		CMP	[XORMode],True
		JZ	SHORT DrawDoX

DrawDo_2:	MOV	ES:[DI],AL
		ADD	DI,BX
		JC	SHORT DrawDo_3
DrawDo_4:
		DEC	CX
		JNZ	SHORT DrawDo_2
		RET
;...............
DrawDo_3:	CALL	IncWrBank
		JMP	SHORT DrawDo_4
;---------------
DrawDoX:	XOR	ES:[DI],AL
		ADD	DI,BX
		JC	SHORT DrawDoX_3
DrawDoX_4:
		DEC	CX
		JNZ	SHORT DrawDoX
		RET
;...............
DrawDoX_3:	CALL	IncRdWrBank
		JMP	SHORT DrawDoX_4
;...............
DrawDo		ENDP
;-------------------------------
		DB	"Jrgen Petsch fr c't 2.97"					 ;
;-------------------------------
;  Legt eine Liste mit den Lngen der Kreisstcke an
;  EING:    AX = R
;  AUSG: DS:DI-> OFFSET LastEntry
;	  NOCY = zustzliches Pixel notwendig
;...............
PX		EQU	WORD PTR [BP-2]
PY		EQU	WORD PTR [BP-4]
A		EQU	WORD PTR [BP-6]
;...............
GetListe	PROC
		PUSH	BP
		MOV	BP,SP
		SUB	SP,6		; 3 lokale WORD-Variable

		MOV	[Px],0		; PX = 0
		MOV	[A],AX		; A = R
		MOV	[Py],AX 	; Py = R

		MOV	DI,OFFSET Liste
		MOV	AX,DS
		MOV	ES,AX		; ES := DS
		SUB	EAX,EAX
		MOV	CX,128
		CLD
		REP	STOSD

		MOV	DI,OFFSET Liste
		MOV	BH,0		; Summe aller Lngen
		MOV	BL,0		; Lngencounter
GetListe_2:
		CMP	[A],0		; A < 0 ?
		JNS	SHORT GetListe_4; Nein, skip

		DEC	[Py]		; PY = PY - 1
		MOV	[DI],BL 	; Lege Lnge ab
		ADD	BH,BL		; Summe aller Lngen
		INC	DI		; DI-> nchster Eintrag
		MOV	BL,0		; Init Lnge:= 0

		MOV	AX,[Py]
		ADD	AX,AX
		ADD	[A],AX		; A = A + PY + PY
GetListe_4:
		DEC	[A]		; A = A - PX - PX - 1
		MOV	AX,[Px]
		ADD	AX,AX
		SUB	[A],AX
		INC	[Px]		; PX = PX +1
		INC	BL		; Inc Lnge

		MOV	AX,[Py]
		CMP	AX,[Px]		; PY < PX ?
		JNB	SHORT GetListe_2; Nein, loop

		MOV	BL,1		; Lnge:= 1
		MOV	[DI],BL 	; Eintrag mit Lnge:= 1

		CMP	BH,AL		; Summe aller Lngen < PY ?
		JB	SHORT GetListe_6; Ja, zustzlicher Eintrag
		DEC	DI		; kein zustzlicher Eintrag
GetListe_6:
		CMP	BH,AL		; Summe aller Lngen = PY ?
		CLC			; Ja, zustzliches Pixel
		JZ	SHORT GetListe_0
		STC			; Kein zustzliches Pixel
GetListe_0:
		MOV	SP,BP
		POP	BP
		RET
GetListe	ENDP
;-------------------------------
IncWrBank	PROC
		PUSHA
;
;  Suche nach einem schreibbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,2		; Bit#0 = schreibbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		ADD	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
		POPA
		RET
IncWrBank	ENDP
;-------------------------------
DecWrBank	PROC
		PUSHA
;
;  Suche nach einem schreibbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,2		; Bit#0 = schreibbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		SUB	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
		POPA
		RET
DecWrBank	ENDP
;-------------------------------
IncRdBank	PROC
		PUSHA
;
;  Suche nach einem lesbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,1		; Bit#0 = Lesbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		ADD	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]

		POPA
		RET
IncRdBank	ENDP
;-------------------------------
DecRdBank	PROC
		PUSHA
;
;  Suche nach einem lesbaren Window
;
		MOV	BL,[WinBAttributes]
		SHR	BL,1		; Bit#0 = Lesbar-Bit
		AND	BL,1		; wenn 1, dann WinB, sonst WinA
;
;  Lies die Position des Windows
;
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		SUB	DX,[WinSizePerGranu]
;
;  Setze das Window := DX
;
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]

		POPA
		RET
DecRdBank	ENDP
;-------------------------------
IncRdWrBank	PROC
		PUSHA
;
;  Lies die Position des WindowA
;
		MOV	BL,0		; WindowA
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		ADD	DX,[WinSizePerGranu]
;
;  Setze das WindowA := DX
;
		PUSH	DX
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
		POP	DX
;
;  Setze das WindowB := DX
;
		MOV	BL,1
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]

		POPA
		RET
IncRdWrBank	ENDP
;-------------------------------
DecRdWrBank	PROC
		PUSHA
;
;  Lies die Position des WindowA
;
		MOV	BL,0
		MOV	BH,1		; Window lesen
		CALL	[WinFuncPtr]
;
		SUB	DX,[WinSizePerGranu]
;
;  Setze das WindowA := DX
;
		PUSH	DX
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]
		POP	DX
;
;  Setze das WindowB := DX
;
		MOV	BL,1
		MOV	BH,0		; Window setzen
		CALL	[WinFuncPtr]

		POPA
		RET
DecRdWrBank	ENDP
;-------------------------------
;===============================
;  Zeichensatz 8*16
;===============================
CharSet LABEL Near
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,7EH,81H,0A5H,81H,81H,0BDH	   ; 
DB 99H,81H,81H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,7EH,0FFH,0DBH,0FFH,0FFH,0C3H	   ; 
DB 0E7H,0FFH,0FFH,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,6CH,0FEH,0FEH,0FEH	   ; 
DB 0FEH,7CH,38H,10H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,10H,38H,7CH,0FEH	   ; 
DB 7CH,38H,10H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,18H,3CH,3CH,0E7H,0E7H	   ; 
DB 0E7H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,18H,3CH,7EH,0FFH,0FFH	   ; 
DB 7EH,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,18H,3CH	   ; 
DB 3CH,18H,00H,00H,00H,00H,00H,00H	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0E7H,0C3H ; 
DB 0C3H,0E7H,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 00H,00H,00H,00H,00H,3CH,66H,42H	   ;
DB 42H,66H,3CH,00H,00H,00H,00H,00H	   ;
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0C3H,99H,0BDH  ;
DB 0BDH,99H,0C3H,0FFH,0FFH,0FFH,0FFH,0FFH  ;
DB 00H,00H,1EH,0EH,1AH,32H,78H,0CCH	   ; 
DB 0CCH,0CCH,0CCH,78H,00H,00H,00H,00H	   ; 
DB 00H,00H,3CH,66H,66H,66H,66H,3CH	   ; 
DB 18H,7EH,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,3FH,33H,3FH,30H,30H,30H	   ; 

DB 30H,70H,0F0H,0E0H,00H,00H,00H,00H	   ; 

DB 00H,00H,7FH,63H,7FH,63H,63H,63H	   ; 
DB 63H,67H,0E7H,0E6H,0C0H,00H,00H,00H	   ; 
DB 00H,00H,00H,18H,18H,0DBH,3CH,0E7H	   ; 
DB 3CH,0DBH,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,80H,0C0H,0E0H,0F0H,0F8H,0FEH,0F8H   ; 
DB 0F0H,0E0H,0C0H,80H,00H,00H,00H,00H	   ; 
DB 00H,02H,06H,0EH,1EH,3EH,0FEH,3EH	   ; 
DB 1EH,0EH,06H,02H,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,3CH,7EH,18H,18H,18H	   ; 
DB 7EH,3CH,18H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,66H,66H,66H,66H,66H,66H	   ; 
DB 66H,00H,66H,66H,00H,00H,00H,00H	   ; 
DB 00H,00H,7FH,0DBH,0DBH,0DBH,7BH,1BH	   ; 
DB 1BH,1BH,1BH,1BH,00H,00H,00H,00H	   ; 
DB 00H,7CH,0C6H,60H,38H,6CH,0C6H,0C6H	   ; 
DB 6CH,38H,0CH,0C6H,7CH,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 0FEH,0FEH,0FEH,0FEH,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,3CH,7EH,18H,18H,18H	   ; 
DB 7EH,3CH,18H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,3CH,7EH,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,7EH,3CH,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,18H,0CH,0FEH	   ; 
DB 0CH,18H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,30H,60H,0FEH	   ; 
DB 60H,30H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,0C0H,0C0H	   ; 
DB 0C0H,0FEH,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,28H,6CH,0FEH	   ; 
DB 6CH,28H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,10H,38H,38H,7CH	   ; 
DB 7CH,0FEH,0FEH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,0FEH,0FEH,7CH,7CH	   ; 
DB 38H,38H,10H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ;
DB 00H,00H,18H,3CH,3CH,3CH,18H,18H	   ; !
DB 18H,00H,18H,18H,00H,00H,00H,00H	   ; !
DB 00H,66H,66H,66H,24H,00H,00H,00H	   ; "
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; "
DB 00H,00H,00H,6CH,6CH,0FEH,6CH,6CH	   ; #
DB 6CH,0FEH,6CH,6CH,00H,00H,00H,00H	   ; #
DB 18H,18H,7CH,0C6H,0C2H,0C0H,7CH,06H	   ; $
DB 06H,86H,0C6H,7CH,18H,18H,00H,00H	   ; $
DB 00H,00H,00H,00H,0C2H,0C6H,0CH,18H	   ; %
DB 30H,60H,0C6H,86H,00H,00H,00H,00H	   ; %
DB 00H,00H,38H,6CH,6CH,38H,76H,0DCH	   ; &
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; &
DB 00H,30H,30H,30H,60H,00H,00H,00H	   ; '
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; '
DB 00H,00H,0CH,18H,30H,30H,30H,30H	   ; (
DB 30H,30H,18H,0CH,00H,00H,00H,00H	   ; (
DB 00H,00H,30H,18H,0CH,0CH,0CH,0CH	   ; )
DB 0CH,0CH,18H,30H,00H,00H,00H,00H	   ; )
DB 00H,00H,00H,00H,00H,66H,3CH,0FFH	   ; *
DB 3CH,66H,00H,00H,00H,00H,00H,00H	   ; *
DB 00H,00H,00H,00H,00H,18H,18H,7EH	   ; +
DB 18H,18H,00H,00H,00H,00H,00H,00H	   ; +
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; ,
DB 00H,18H,18H,18H,30H,00H,00H,00H	   ; ,
DB 00H,00H,00H,00H,00H,00H,00H,7EH	   ; -
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; -
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; .
DB 00H,00H,18H,18H,00H,00H,00H,00H	   ; .
DB 00H,00H,00H,00H,02H,06H,0CH,18H	   ; /
DB 30H,60H,0C0H,80H,00H,00H,00H,00H	   ; /
DB 00H,00H,38H,6CH,0C6H,0C6H,0D6H,0D6H	   ; 0
DB 0C6H,0C6H,6CH,38H,00H,00H,00H,00H	   ; 0
DB 00H,00H,18H,38H,78H,18H,18H,18H	   ; 1
DB 18H,18H,18H,7EH,00H,00H,00H,00H	   ; 1
DB 00H,00H,7CH,0C6H,06H,0CH,18H,30H	   ; 2
DB 60H,0C0H,0C6H,0FEH,00H,00H,00H,00H	   ; 2
DB 00H,00H,7CH,0C6H,06H,06H,3CH,06H	   ; 3
DB 06H,06H,0C6H,7CH,00H,00H,00H,00H	   ; 3
DB 00H,00H,0CH,1CH,3CH,6CH,0CCH,0FEH	   ; 4
DB 0CH,0CH,0CH,1EH,00H,00H,00H,00H	   ; 4
DB 00H,00H,0FEH,0C0H,0C0H,0C0H,0FCH,06H	   ; 5
DB 06H,06H,0C6H,7CH,00H,00H,00H,00H	   ; 5
DB 00H,00H,38H,60H,0C0H,0C0H,0FCH,0C6H	   ; 6
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 6
DB 00H,00H,0FEH,0C6H,06H,06H,0CH,18H	   ; 7
DB 30H,30H,30H,30H,00H,00H,00H,00H	   ; 7
DB 00H,00H,7CH,0C6H,0C6H,0C6H,7CH,0C6H	   ; 8
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 8
DB 00H,00H,7CH,0C6H,0C6H,0C6H,7EH,06H	   ; 9
DB 06H,06H,0CH,78H,00H,00H,00H,00H	   ; 9
DB 00H,00H,00H,00H,18H,18H,00H,00H	   ; :
DB 00H,18H,18H,00H,00H,00H,00H,00H	   ; :
DB 00H,00H,00H,00H,18H,18H,00H,00H	   ; ;
DB 00H,18H,18H,30H,00H,00H,00H,00H	   ; ;
DB 00H,00H,00H,06H,0CH,18H,30H,60H	   ; <
DB 30H,18H,0CH,06H,00H,00H,00H,00H	   ; <
DB 00H,00H,00H,00H,00H,7EH,00H,00H	   ; =
DB 7EH,00H,00H,00H,00H,00H,00H,00H	   ; =
DB 00H,00H,00H,60H,30H,18H,0CH,06H	   ; >
DB 0CH,18H,30H,60H,00H,00H,00H,00H	   ; >
DB 00H,00H,7CH,0C6H,0C6H,0CH,18H,18H	   ; ?
DB 18H,00H,18H,18H,00H,00H,00H,00H	   ; ?
DB 00H,00H,7CH,0C6H,0C6H,0C6H,0DEH,0DEH	   ; @
DB 0DEH,0DCH,0C0H,7CH,00H,00H,00H,00H	   ; @
DB 00H,00H,10H,38H,6CH,0C6H,0C6H,0FEH	   ; A
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; A
DB 00H,00H,0FCH,66H,66H,66H,7CH,66H	   ; B
DB 66H,66H,66H,0FCH,00H,00H,00H,00H	   ; B
DB 00H,00H,3CH,66H,0C2H,0C0H,0C0H,0C0H	   ; C
DB 0C0H,0C2H,66H,3CH,00H,00H,00H,00H	   ; C
DB 00H,00H,0F8H,6CH,66H,66H,66H,66H	   ; D
DB 66H,66H,6CH,0F8H,00H,00H,00H,00H	   ; D
DB 00H,00H,0FEH,66H,62H,68H,78H,68H	   ; E
DB 60H,62H,66H,0FEH,00H,00H,00H,00H	   ; E
DB 00H,00H,0FEH,66H,62H,68H,78H,68H	   ; F
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; F
DB 00H,00H,3CH,66H,0C2H,0C0H,0C0H,0DEH	   ; G
DB 0C6H,0C6H,66H,3AH,00H,00H,00H,00H	   ; G
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0FEH,0C6H   ; H
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; H
DB 00H,00H,7EH,18H,18H,18H,18H,18H	   ; I
DB 18H,18H,18H,7EH,00H,00H,00H,00H	   ; I
DB 00H,00H,1EH,0CH,0CH,0CH,0CH,0CH	   ; J
DB 0CCH,0CCH,0CCH,78H,00H,00H,00H,00H	   ; J
DB 00H,00H,0E6H,66H,66H,6CH,78H,78H	   ; K
DB 6CH,66H,66H,0E6H,00H,00H,00H,00H	   ; K
DB 00H,00H,0F0H,60H,60H,60H,60H,60H	   ; L
DB 60H,62H,66H,0FEH,00H,00H,00H,00H	   ; L
DB 00H,00H,0C6H,0EEH,0FEH,0FEH,0D6H,0C6H   ; M
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; M
DB 00H,00H,0C6H,0E6H,0F6H,0FEH,0DEH,0CEH   ; N
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; N
DB 00H,00H,7CH,0C6H,0C6H,0C6H,0C6H,0C6H	   ; O
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; O
DB 00H,00H,0FCH,66H,66H,66H,7CH,60H	   ; P
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; P
DB 00H,00H,7CH,0C6H,0C6H,0C6H,0C6H,0C6H	   ; Q
DB 0C6H,0D6H,0DEH,7CH,0CH,0EH,00H,00H	   ; Q
DB 00H,00H,0FCH,66H,66H,66H,7CH,6CH	   ; R
DB 66H,66H,66H,0E6H,00H,00H,00H,00H	   ; R
DB 00H,00H,7CH,0C6H,0C6H,60H,38H,0CH	   ; S
DB 06H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; S
DB 00H,00H,7EH,7EH,5AH,18H,18H,18H	   ; T
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; T
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0C6H,0C6H   ; U
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; U
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0C6H,0C6H   ; V
DB 0C6H,06CH,38H,10H,00H,00H,00H,00H	   ; V
DB 00H,00H,0C6H,0C6H,0C6H,0C6H,0D6H,0D6H   ; W
DB 0D6H,0FEH,0EEH,6CH,00H,00H,00H,00H	   ; W
DB 00H,00H,0C6H,0C6H,6CH,7CH,38H,38H	   ; X
DB 7CH,6CH,0C6H,0C6H,00H,00H,00H,00H	   ; X
DB 00H,00H,66H,66H,66H,66H,3CH,18H	   ; Y
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; Y
DB 00H,00H,0FEH,0C6H,86H,0CH,18H,30H	   ; Z
DB 60H,0C2H,0C6H,0FEH,00H,00H,00H,00H	   ; Z
DB 00H,00H,3CH,30H,30H,30H,30H,30H	   ; [
DB 30H,30H,30H,3CH,00H,00H,00H,00H	   ; [
DB 00H,00H,00H,80H,0C0H,0E0H,70H,38H	   ; \
DB 1CH,0EH,06H,02H,00H,00H,00H,00H	   ; \
DB 00H,00H,3CH,0CH,0CH,0CH,0CH,0CH	   ; ]
DB 0CH,0CH,0CH,3CH,00H,00H,00H,00H	   ; ]
DB 10H,38H,6CH,0C6H,00H,00H,00H,00H	   ; ^
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; ^
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; _
DB 00H,00H,00H,00H,00H,0FFH,00H,00H	   ; _
DB 30H,30H,18H,00H,00H,00H,00H,00H	   ; `
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; `
DB 00H,00H,00H,00H,00H,78H,0CH,7CH	   ; a
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; a
DB 00H,00H,0E0H,60H,60H,78H,6CH,66H	   ; b
DB 66H,66H,66H,7CH,00H,00H,00H,00H	   ; b
DB 00H,00H,00H,00H,00H,7CH,0C6H,0C0H	   ; c
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; c
DB 00H,00H,1CH,0CH,0CH,3CH,6CH,0CCH	   ; d
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; d
DB 00H,00H,00H,00H,00H,7CH,0C6H,0FEH	   ; e
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; e
DB 00H,00H,38H,6CH,64H,60H,0F0H,60H	   ; f
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; f
DB 00H,00H,00H,00H,00H,76H,0CCH,0CCH	   ; g
DB 0CCH,0CCH,0CCH,7CH,0CH,0CCH,78H,00H	   ; g
DB 00H,00H,0E0H,60H,60H,6CH,76H,66H	   ; h
DB 66H,66H,66H,0E6H,00H,00H,00H,00H	   ; h
DB 00H,00H,18H,18H,00H,38H,18H,18H	   ; i
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; i
DB 00H,00H,06H,06H,00H,0EH,06H,06H	   ; j
DB 06H,06H,06H,06H,66H,66H,3CH,00H	   ; j
DB 00H,00H,0E0H,60H,60H,66H,6CH,78H	   ; k
DB 78H,6CH,66H,0E6H,00H,00H,00H,00H	   ; k
DB 00H,00H,60H,60H,60H,60H,60H,60H	   ; l
DB 60H,64H,7CH,38H,00H,00H,00H,00H	   ; l
DB 00H,00H,00H,00H,00H,0ECH,0FEH,0D6H	   ; m
DB 0D6H,0D6H,0D6H,0C6H,00H,00H,00H,00H	   ; m
DB 00H,00H,00H,00H,00H,0DCH,66H,66H	   ; n
DB 66H,66H,66H,66H,00H,00H,00H,00H	   ; n
DB 00H,00H,00H,00H,00H,7CH,0C6H,0C6H	   ; o
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; o
DB 00H,00H,00H,00H,00H,0DCH,66H,66H	   ; p
DB 66H,66H,66H,7CH,60H,60H,0F0H,00H	   ; p
DB 00H,00H,00H,00H,00H,76H,0CCH,0CCH	   ; q
DB 0CCH,0CCH,0CCH,7CH,0CH,0CH,1EH,00H	   ; q
DB 00H,00H,00H,00H,00H,0DCH,76H,66H	   ; r
DB 60H,60H,60H,0F0H,00H,00H,00H,00H	   ; r
DB 00H,00H,00H,00H,00H,7CH,0C6H,60H	   ; s
DB 38H,0CH,0C6H,7CH,00H,00H,00H,00H	   ; s
DB 00H,00H,10H,30H,30H,0FCH,30H,30H	   ; t
DB 30H,30H,36H,1CH,00H,00H,00H,00H	   ; t
DB 00H,00H,00H,00H,00H,0CCH,0CCH,0CCH	   ; u
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; u
DB 00H,00H,00H,00H,00H,66H,66H,66H	   ; v
DB 66H,66H,3CH,18H,00H,00H,00H,00H	   ; v
DB 00H,00H,00H,00H,00H,0C6H,0C6H,0D6H	   ; w
DB 0D6H,0D6H,0FEH,6CH,00H,00H,00H,00H	   ; w
DB 00H,00H,00H,00H,00H,0C6H,6CH,38H	   ; x
DB 38H,38H,6CH,0C6H,00H,00H,00H,00H	   ; x
DB 00H,00H,00H,00H,00H,0C6H,0C6H,0C6H	   ; y
DB 0C6H,0C6H,0C6H,7EH,06H,0CH,0F8H,00H	   ; y
DB 00H,00H,00H,00H,00H,0FEH,0CCH,18H	   ; z
DB 30H,60H,0C6H,0FEH,00H,00H,00H,00H	   ; z
DB 00H,00H,0EH,18H,18H,18H,70H,18H	   ; {
DB 18H,18H,18H,0EH,00H,00H,00H,00H	   ; {
DB 00H,00H,18H,18H,18H,18H,00H,18H	   ; |
DB 18H,18H,18H,18H,00H,00H,00H,00H	   ; |
DB 00H,00H,70H,18H,18H,18H,0EH,18H	   ; }
DB 18H,18H,18H,70H,00H,00H,00H,00H	   ; }
DB 00H,00H,76H,0DCH,00H,00H,00H,00H	   ; ~
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; ~
DB 00H,00H,00H,00H,10H,38H,6CH,0C6H	   ; 
DB 0C6H,0C6H,0FEH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,3CH,66H,0C2H,0C0H,0C0H,0C0H	   ; 
DB 0C2H,66H,3CH,0CH,06H,7CH,00H,00H	   ; 
DB 00H,00H,0CCH,00H,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,0CH,18H,30H,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,10H,38H,6CH,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,0CCH,00H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,38H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,3CH,66H,60H,60H	   ; 
DB 66H,3CH,0CH,06H,3CH,00H,00H,00H	   ; 
DB 00H,10H,38H,6CH,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,0C6H,00H,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,7CH,0C6H,0FEH	   ; 
DB 0C0H,0C0H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,66H,00H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,18H,3CH,66H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,0C6H,00H,10H,38H,6CH,0C6H,0C6H	   ; 
DB 0FEH,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 38H,6CH,38H,00H,38H,6CH,0C6H,0C6H	   ; 
DB 0FEH,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 18H,30H,60H,00H,0FEH,66H,60H,7CH	   ; 
DB 60H,60H,66H,0FEH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,6CH,0FEH,0B2H,32H	   ; 
DB 7EH,0D8H,0D8H,6EH,00H,00H,00H,00H	   ; 
DB 00H,00H,3EH,6CH,0CCH,0CCH,0FEH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,0CEH,00H,00H,00H,00H	   ; 
DB 00H,10H,38H,6CH,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,0C6H,00H,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,30H,78H,0CCH,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,60H,30H,18H,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,0C6H,00H,00H,0C6H,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7EH,06H,0CH,78H,00H	   ; 
DB 00H,0C6H,00H,7CH,0C6H,0C6H,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,0C6H,00H,0C6H,0C6H,0C6H,0C6H,0C6H   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,18H,18H,3CH,66H,60H,60H,60H	   ; 
DB 66H,3CH,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,64H,60H,0F0H,60H,60H	   ; 
DB 60H,60H,0E6H,0FCH,00H,00H,00H,00H	   ; 
DB 00H,00H,66H,66H,3CH,18H,7EH,18H	   ; 
DB 7EH,18H,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,0F8H,0CCH,0CCH,0F8H,0C4H,0CCH,0DEH  ; 
DB 0CCH,0CCH,0CCH,0C6H,00H,00H,00H,00H	   ; 
DB 00H,0EH,1BH,18H,18H,18H,7EH,18H	   ; 
DB 18H,18H,18H,18H,0D8H,70H,00H,00H	   ; 
DB 00H,18H,30H,60H,00H,78H,0CH,7CH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,0CH,18H,30H,00H,38H,18H,18H	   ; 
DB 18H,18H,18H,3CH,00H,00H,00H,00H	   ; 
DB 00H,18H,30H,60H,00H,7CH,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,18H,30H,60H,00H,0CCH,0CCH,0CCH	   ; 
DB 0CCH,0CCH,0CCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,76H,0DCH,00H,0DCH,66H,66H	   ; 
DB 66H,66H,66H,66H,00H,00H,00H,00H	   ; 
DB 76H,0DCH,00H,0C6H,0E6H,0F6H,0FEH,0DEH   ; 
DB 0CEH,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 00H,3CH,6CH,6CH,3EH,00H,7EH,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,6CH,38H,00H,7CH,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,30H,30H,00H,30H,30H,60H	   ; 
DB 0C0H,0C6H,0C6H,7CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,0FEH,0C0H	   ; 
DB 0C0H,0C0H,0C0H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,0FEH,06H	   ; 
DB 06H,06H,06H,00H,00H,00H,00H,00H	   ; 
DB 00H,0C0H,0C0H,0C2H,0C6H,0CCH,18H,30H	   ; 
DB 60H,0DCH,86H,0CH,18H,3EH,00H,00H	   ; 
DB 00H,0C0H,0C0H,0C2H,0C6H,0CCH,18H,30H	   ; 
DB 66H,0CEH,9EH,3EH,06H,06H,00H,00H	   ; 
DB 00H,00H,18H,18H,00H,18H,18H,18H	   ; 
DB 3CH,3CH,3CH,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,36H,6CH,0D8H	   ; 
DB 6CH,36H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,0D8H,6CH,36H	   ; 
DB 6CH,0D8H,00H,00H,00H,00H,00H,00H	   ; 
DB 11H,44H,11H,44H,11H,44H,11H,44H	   ; 
DB 11H,44H,11H,44H,11H,44H,11H,44H	   ; 
DB 55H,0AAH,55H,0AAH,55H,0AAH,55H,0AAH	   ; 
DB 55H,0AAH,55H,0AAH,55H,0AAH,55H,0AAH	   ; 
DB 0DDH,77H,0DDH,77H,0DDH,77H,0DDH,77H	   ; 
DB 0DDH,77H,0DDH,77H,0DDH,77H,0DDH,77H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,0F8H,18H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0F6H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FEH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,0F8H,18H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 36H,36H,36H,36H,36H,0F6H,06H,0F6H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,0FEH,06H,0F6H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,0F6H,06H,0FEH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0FEH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,0F8H,18H,0F8H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0F8H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,1FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,1FH,18H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,37H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,37H,30H,3FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,3FH,30H,37H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,0F7H,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,0FFH,00H,0F7H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,37H,30H,37H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 00H,00H,00H,00H,00H,0FFH,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 36H,36H,36H,36H,36H,0F7H,00H,0F7H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 18H,18H,18H,18H,18H,0FFH,00H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0FFH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,0FFH,00H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,3FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,18H,18H,18H,18H,1FH,18H,1FH	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,1FH,18H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,3FH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,0FFH	   ; 
DB 36H,36H,36H,36H,36H,36H,36H,36H	   ; 
DB 18H,18H,18H,18H,18H,0FFH,18H,0FFH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,0F8H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,1FH	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 00H,00H,00H,00H,00H,00H,00H,0FFH	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH ; 
DB 0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H ; 
DB 0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H,0F0H ; 
DB 0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH	   ; 
DB 0FH,0FH,0FH,0FH,0FH,0FH,0FH,0FH	   ; 
DB 0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,00H  ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,76H,0DCH,0D8H	   ; 
DB 0D8H,0D8H,0DCH,76H,00H,00H,00H,00H	   ; 
DB 00H,00H,78H,0CCH,0CCH,0CCH,0D8H,0CCH	   ; 
DB 0C6H,0C6H,0C6H,0CCH,00H,00H,00H,00H	   ; 
DB 00H,00H,0FEH,0C6H,0C6H,0C0H,0C0H,0C0H   ; 
DB 0C0H,0C0H,0C0H,0C0H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,0FEH,6CH,6CH,6CH	   ; 
DB 6CH,6CH,6CH,6CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,0FEH,0C6H,60H,30H,18H	   ; 
DB 30H,60H,0C6H,0FEH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,7EH,0D8H,0D8H	   ; 
DB 0D8H,0D8H,0D8H,70H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,66H,66H,66H,66H	   ; 
DB 66H,7CH,60H,60H,0C0H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,76H,0DCH,18H,18H	   ; 
DB 18H,18H,18H,18H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,7EH,18H,3CH,66H,66H	   ; 
DB 66H,3CH,18H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,38H,6CH,0C6H,0C6H,0FEH	   ; 
DB 0C6H,0C6H,6CH,38H,00H,00H,00H,00H	   ; 
DB 00H,00H,38H,6CH,0C6H,0C6H,0C6H,6CH	   ; 
DB 6CH,6CH,6CH,0EEH,00H,00H,00H,00H	   ; 
DB 00H,00H,1EH,30H,18H,0CH,3EH,66H	   ; 
DB 66H,66H,66H,3CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,7EH,0DBH,0DBH	   ; 
DB 0DBH,7EH,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,03H,06H,7EH,0DBH,0DBH	   ; 
DB 0F3H,7EH,60H,0C0H,00H,00H,00H,00H	   ; 
DB 00H,00H,1CH,30H,60H,60H,7CH,60H	   ; 
DB 60H,60H,30H,1CH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,7CH,0C6H,0C6H,0C6H,0C6H	   ; 
DB 0C6H,0C6H,0C6H,0C6H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,0FEH,00H,00H,0FEH	   ; 
DB 00H,00H,0FEH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,18H,18H,7EH,18H	   ; 
DB 18H,00H,00H,0FFH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,30H,18H,0CH,06H,0CH	   ; 
DB 18H,30H,00H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,0CH,18H,30H,60H,30H	   ; 
DB 18H,0CH,00H,7EH,00H,00H,00H,00H	   ; 
DB 00H,00H,0EH,1BH,1BH,1BH,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 18H,18H,18H,18H,18H,18H,18H,18H	   ; 
DB 0D8H,0D8H,0D8H,70H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,18H,18H,00H,7EH	   ; 
DB 00H,18H,18H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,76H,0DCH,00H	   ; 
DB 76H,0DCH,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,38H,6CH,6CH,38H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,18H	   ; 
DB 18H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 18H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,0FH,0CH,0CH,0CH,0CH,0CH,0ECH	   ; 
DB 6CH,6CH,3CH,1CH,00H,00H,00H,00H	   ; 
DB 00H,0D8H,6CH,6CH,6CH,6CH,6CH,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,70H,0D8H,30H,60H,0C8H,0F8H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,7CH,7CH,7CH,7CH	   ; 
DB 7CH,7CH,7CH,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
DB 00H,00H,00H,00H,00H,00H,00H,00H	   ; 
;-------------------------------
CODE		ENDS
		END
