                TITLE  VESA24m.ASM
                .386
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  Grafik-Routinen fr Truecolor-Modi des VESA-Standards ;
;  Aufrufbar von Turbo Pascal    J.Petsch fr c't  2.97  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DATA            SEGMENT PARA PUBLIC 'DATA' USE16
;-------------------------------
VESAInfoBlock   LABEL   NEAR
;                                     Offs
VESASignature   DD      0           ; 00H
VESAVersion     DW      0           ; 04H
OEMStringPtr    DD      0           ; 06H
Capabilities    DD      0           ; 0AH
VideoModePtr    DD      0           ; 0EH
TotalMemory     DW      0           ; 12H
                DB      242 DUP (0)
;-------------------------------
ModeInfoBlock   LABEL   NEAR
;                                     Offs
ModeAttributes      DW      0       ; 00H
WinAAttributes      DB      0       ; 02H
WinBAttributes      DB      0       ; 03H
WinGranularity      DW      0       ; 04H  (kByte)
WinSize             DW      0       ; 06H  (kByte)
WinASegment         DW      0       ; 08H
WinBSegment         DW      0       ; 0AH
WinFuncPtr          DD      0       ; 0CH  (Pointer)
BytesPerScanLine    DW      0       ; 10H
XResolution         DW      0       ; 12H
YResolution         DW      0       ; 14H
XCharSize           DB      0       ; 16H
YCharSize           DB      0       ; 17H
NumberOfPlanes      DB      0       ; 18H
BitsPerPixel        DB      0       ; 19H
NumberOfBanks       DB      0       ; 1AH
MemoryModel         DB      0       ; 1BH
BankSize            DB      0       ; 1CH
NumberOfImagePages  DB      0       ; 1DH
Reserved            DB      0       ; 1EH
RedMaskSize         DB      0       ; 1FH
RedFieldPosition    DB      0       ; 20H
GreenMaskSize       DB      0       ; 21H
GreenFieldPosition  DB      0       ; 22H
BlueMaskSize        DB      0       ; 23H
BlueFieldPosition   DB      0       ; 24H
                    DB      0DBH DUP (0)
;----------------
WinSizePerGranu     DW      0   ; WinSize DIV WinGranularity
BytesPerPixel       DW      0   ; BitsPerPixel DIV 8
;-------------------------------
DATA            ENDS
;-------------------------------
CODE            SEGMENT PARA PUBLIC USE16
                ASSUME  CS:CODE, DS:DATA
;-------------------------------
PUBLIC  VESAAvail   ; FUNCTION kehrt mit True zurck und fllt
                    ;  VESAInfoBlock, wenn VESA-BIOS vorhanden
PUBLIC  GetVESAInfo ; Liefert Teile des VESAInfoBlockes an TP
PUBLIC  SetVESAMode ; Schaltet einen Truecolor-VESA-Modus ein
PUBLIC  SetAlfaMode ; Schaltet den VGA-Adapter auf 80*25 BW
PUBLIC  FillSprite  ; Fllt ein Sprite mit Farbe
;===============================
;  MACROs
;===============================
;  Berechnet die Adresse des 1. Byte im Video-Mem
;  ES:DXDI = (Y * BytesPerScanLine) + (X * BytesPerPixel)
GetScreenAddr  MACRO
               MOVZX  EAX,[BytesPerScanline]
               MOVZX  EDX,[Y]    ; EDX:= Y
               MUL    EDX        ; EDXEAX:= Y*BytesPerScanLine
               MOVZX  EDX,[X]    ; EDX:= X
               MOVZX  EBX,[BytesPerPixel]
               IMUL   EBX,EDX    ; EBX:= X * BytesPerPixel
               ADD    EAX,EBX
               MOVZX  EBX,[WinGranularity] ; [kByte]
               SHL    EBX,10               ; [Byte]
               DIV    EBX        ; EDX:= Offset   EAX:= Segm
               MOV    DI,DX                ; DI:= Offset
               MOV    DX,AX                ; DX:= Segm
               MOV    ES,[WinASegment]     ; ES:DI-> Video-Mem
               ENDM
;------------------------------
;  Stellt im EAX die 3 Farbkomponenten zusammen
;  EING: Rot, Gruen, Blau auf dem Stack
;        [Red/Green/BlueFieldPosition]
;  AUSG: EAX
GetColor       MACRO
               SUB    EBX,EBX    ; EBX:= 0
               MOV    BL,[Rot]   ; Hole Rot
               MOV    CL,[RedFieldPosition]
               SHL    EBX,CL     ; Bringe in RedFieldPos..
               MOV    EAX,EBX    ; ..und ins EAX

               SUB    EBX,EBX    ; EBX:= 0
               MOV    BL,[Gruen] ; Hole Gruen
               MOV    CL,[GreenFieldPosition]
               SHL    EBX,CL     ; Bringe in GreenFieldPos..
               OR     EAX,EBX    ; ..und ins EAX

               SUB    EBX,EBX    ; EBX:= 0
               MOV    BL,[Blau]  ; Hole Blau
               MOV    CL,[BlueFieldPosition]
               SHL    EBX,CL     ; Bringe in BlueFieldPos..
               OR     EAX,EBX    ; ..und ins EAX
               ENDM
;------------------------------
;  Setzt beide Banks:= DX
SetBanks       MACRO
               PUSH   DX
               SUB    BX,BX   ; BH:=0 Set Bank, BL:=0 Bank A
               CALL   [WinFuncPtr]
               POP    DX
               MOV    BL,1    ; Bank B
               CALL   [WinFuncPtr]
               ENDM
;==================================================
;  Von TP aus aufrufbare FUNCTIONs und PROCEDUREs
;==================================================
;  Versucht den VESAInfoBlock zu laden.
;  Aufruf: VESAAvail:BOOLEAN;
;--------------
VESAAvail      PROC   FAR
               MOV    DI,OFFSET VESAInfoBlock
               MOV    AX,4F00h       ; Return Super VGA Info
               INT    10h            ; Video Interrupt
               CMP    AX,004Fh       ; VESA BIOS vorhanden ?
               MOV    AX,0FFFFH      ;  Bereite True vor
               JZ     VESAAvail_0    ;  Ja, True bleibt
               NOT    AX             ; Nein, Ret mit False
VESAAvail_0:   RET
VESAAvail      ENDP
;-------------------------------
;  Liefert Teile des VESAInfoBlock an TP
;  Aufruf: GetVESAInfo (TpOEMString:STRING;
;                       VAR MemSize, Version:WORD);
TpOEMString    EQU    DWORD PTR [BP+14]   ; TP-Variable
MemSizePtr     EQU    DWORD PTR [BP+10]
VESAVersionPtr EQU    DWORD PTR [BP+6]
;...............
GetVESAInfo    PROC   FAR
               PUSH   BP
               MOV    BP,SP            ; Adressiere den Stack
;  Hole Version und wandle Nibbles B:A nach Dezimal
               MOV    AX,[VESAVersion] ; AX:= X:C:B:A
               MOV    BL,AL            ; BL:= B:A
               SHR    BL,4             ; BL:= B
               MOV    BH,0             ; BX:= B
               IMUL   BX,6             ; BX:= 6*B
               SUB    AL,BL            ; AL:= B:A - 6*B
               LES    DI,[VESAVersionPtr]; ES:DI-> TP-Variable
               MOV    ES:[DI],AX       ; Lege Version ab
;  Hole TotalMemory und lege in der TP-Variablen ab
               MOV    AX,[TotalMemory] ; Blcke a' 64k
               IMUL   AX,64            ; Wandle in kByte
               LDS    DI,[MemSizePtr]  ; DS:DI-> TP-Variable
               MOV    [DI],AX          ; Lege MemSize ab
;  bertrage den OEMString in die TP-Variable
               LES    DI,[TpOEMString] ; ES:DI-> TP-Variable
               INC    DI               ; Skip TP-Stringlnge
               LDS    SI,[OEMStringPtr]; DS:SI-> OEMString
               MOV    CL,0             ; Init Stringlnge:= 0
GetVESAInfo_2: LODSB                   ; Hole vom OEMString...
               CMP    AL,0             ; Schluzeichen ?
               JZ     GetVESAInfo_4    ;  Ja, fertig
               STOSB                   ; bringe zum TPOEMString
               INC    CL               ; Stringlnge +1
               JMP    GetVESAInfo_2    ; REPEAT UNTIL Zeichen=0
;---------------
GetVESAInfo_4: LDS    DI,[TPOEMString] ; DS:DI-> TP-Variable
               MOV    [DI],CL          ; Lege Stringlnge ab
               MOV    SP,BP
               POP    BP
               RET    12               ; Entferne 3 POINTER
GetVESAInfo    ENDP
;-------------------------------
;  Schaltet einen bestimmten Truecolor-VESA-Modus ein.
;  Aufruf: SetVESAMode (Xsoll,Ysoll:WORD; VAR VESAErr:WORD);
;  VesaErr
;  0 = kein Fehler
;  1 = Modus wird nicht vom VESA-BIOS untersttzt
;  2 = ModeInfoBlock konnte nicht gefllt werden
;  3 = Einschalten des Modus fehlgeschlagen
;---------------
Xsoll          EQU    WORD PTR [BP+12] ; TP-Variable
Ysoll          EQU    WORD PTR [BP+10]
VESAErrPtr     EQU    DWORD PTR [BP+6]
ListenSegm     EQU    WORD PTR [BP-2]  ; Lokale Variable
ListenOffs     EQU    WORD PTR [BP-4]
Modus          EQU    WORD PTR [BP-6]
;---------------
SetVESAMode    PROC   FAR
               PUSH   BP
               MOV    BP,SP           ; Adressiere den Stack
               SUB    SP,6            ; 3 lokale WORDs
;  VideoModePtr enthlt einen Pointer auf eine mit FFFFH
;  abgeschlossene Liste der untersttzten Modi.
               LES    SI,DWORD PTR [VideoModePtr]; ES:SI->Liste
               MOV    [ListenOffs],SI
               MOV    [ListenSegm],ES
;  Hole den nchsten Modus aus der Liste
SetVESAMode_2: MOV    ES,[ListenSegm]
               MOV    SI,[ListenOffs]
               ADD    [ListenOffs],2  ; -> nchster Eintrag
               MOV    CX,ES:[SI]      ; CX:= Modus aus Liste
               MOV    [Modus],CX      ; Modus fr spter
               MOV    DX,1            ; Bereite VESAErr:= 1 vor
               CMP    CX,0FFFFH       ; Letzter Eintrag?
               JZ     SetVESAMode_0   ; Ja, ret mit VESAErr
;  Flle fr CX:=Modus den ModeInfoBlock
               MOV    AX,DS
               MOV    ES,AX           ; ES:DI-> ModeInfoBlock
               MOV    DI,OFFSET ModeInfoBlock
               MOV    AX,4F01H        ; Ret Super VGA Mode Info
               INT    10H             ; Video Interrupt
               MOV    DX,2            ; Bereite VESAErr:= 2 vor
               CMP    AX,004Fh        ; erfolgreich ?
               JNZ    SetVESAMode_0   ;  Nein, Ret mit VESAErr
;  Wenn ModeInfoBlock.XResolution <> Xsoll, dann weitersuchen
               MOV    AX,[Xsoll]
               CMP    AX,[XResolution]
               JNZ    SetVESAMode_2
;  Wenn ModeInfoBlock.YResolution <> Ysoll, dann weitersuchen
               MOV    AX,[Ysoll]
               CMP    AX,[YResolution]
               JNZ    SetVESAMode_2
;  Wenn ModeInfoBlock.BitsPerPixel <> 24/32, dann weitersuchen
               CMP    [BitsPerPixel],24 ; BitsPerPixel=24 ?
               JZ     SetVESAMode_4     ;  Ja, Modus gefunden
               CMP    [BitsPerPixel],32 ; BitsPerPixel=32 ?
               JNZ    SetVESAMode_2     ;  Nein, weitersuchen
;  Jetzt wissen wir, da Modus zu Xsoll, Ysoll
;  mit 24 oder 32 Bit/Pixel gehrt. Schalte den Modus ein.
SetVESAMode_4: MOV    BX,[Modus]        ; BX := Modus
               MOV    AX,4F02H      ; Set Super VGA Video Mode
               INT    10H           ; Video Interrupt
               MOV    DX,3          ; Bereite VESAErr = 3 vor
               CMP    AX,004Fh      ; erfolgreich ?
               JNZ    SetVESAMode_0 ;  Nein, Ret mit VESAErr
;  Berechne WinSizePerGranu:= WinSize DIV WinGranularity
               MOV    AX,[WinSize]
               CWD                      ; DXAX:= WinSize
               DIV    [WinGranularity]
               MOV    [WinSizePerGranu],AX
;  Berechne BytesPerPixel:= BitsPerPixel DIV 8
               MOV    AL,[BitsPerPixel]
               SHR    AL,3
               MOV    AH,0
               MOV    [BytesPerPixel],AX
;  Bereite Ablage des VESAErr:= 0 vor
               SUB    DX,DX
SetVESAMode_0: LES    DI,[VESAErrPtr] ; ES:DI-> VESAErr
               MOV    ES:[DI],DX      ; Vorbereiteter VESAErr
               MOV    SP,BP
               POP    BP
               RET    8       ; Entferne 2 WORDs und 1 POINTER
SetVESAMode    ENDP
;-------------------------------
;  Schaltet den VGA-Adapter auf 80 x 25 BW Alphanumeric Mode
;  Aufruf: SetAlfaMode;
;---------------
SetAlfaMode    PROC   FAR
               MOV    AX,0003  ; AH=0 (Set Mode); AL:=Mode 3
               INT    10H      ; Video Interrupt
               RET
SetAlfaMode    ENDP
;-------------------------------
;  Fllt ein Sprite mit Farbe.
;  Aufruf: FillSprite (X,Y,Breite,Hoehe,Blau,Gruen,Rot:WORD);
;---------------
X              EQU    WORD PTR [BP+18]  ; TP-Variable
Y              EQU    WORD PTR [BP+16]
Breite         EQU    WORD PTR [BP+14]
Hoehe          EQU    WORD PTR [BP+12]
Blau           EQU    BYTE PTR [BP+10]
Gruen          EQU    BYTE PTR [BP+8]
Rot            EQU    BYTE PTR [BP+6]
;---------------
FillSprite     PROC   FAR
               PUSH   BP
               MOV    BP,SP            ; Adressiere den Stack
               CMP    [Breite],0       ; Breite = 0 ?
               JZ     FillSprite_0     ;  Ja, fertig
               CMP    [Hoehe],0        ; Hoehe = 0 ?
               JZ     FillSprite_0     ;  Ja, fertig
               GetScreenAddr           ; DXDI-> Video-Mem
               SetBanks                ; Setze beide Banks:= DX
               MOV    DX,[Breite]
               IMUL   DX,[BytesPerPixel] ; DX:= Breite in Byte
               MOV    SI,[BytesPerScanline]
               SUB    SI,DX              ; SI:= Scanlineoffset
               GetColor                  ; EAX := Farbkomp.
FillSprite_2:  MOV    CX,[Breite]
               CALL   DrawRi             ; Eine Horizontale
               ADD    DI,SI      ; ES:DI-> nchste Scanline
               JNC    SHORT FillSprite_4 ; Achte auf Bankswitch
               CALL   IncWrBank
FillSprite_4:  DEC    [Hoehe]            ; Loop mit Hoehe
               JNZ    SHORT FillSprite_2
FillSprite_0:  POP    BP
               RET    14         ; Entferne 7 WORDs vom Stack
FillSprite     ENDP
;-------------------------------
;  Zeichnet eine Gerade nach rechts beginnend bei ES:DI
;  EING: ES:DI-> Start
;           CX = Lnge, Anzahl Pixel (>=1) a' 3 oder 4 Byte
;          EAX = Farbkomponenten
;  AUSG: ES:DI = hinter das letzte Pixel
;           CX = 0
;...............
DrawRi         PROC
               CLD                     ; String aufwrts
;  Unterscheide zwischen 3 und 4 BytesPerPixel
               CMP    [BytesPerPixel],3
               JZ     SHORT DrawRi_3
;  Wir haben 4 BytesPerPixel
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
               SHL    CX,2            ; CX:= Anzahl Byte
               ADD    DI,CX           ; Bankberschreitung?
               JC     SHORT DrawRi_20 ;  Ja, Sonderfall
;  Wir haben 4 BytesPerPixel und keine Bankberschreitung.
DrawRi_10:     SUB     DI,CX      ; DI-> zurck in alte Bank
               SHR     CX,2       ; CX:= Anzahl Pixel
               REP     STOSD      ; CX mal EAX nach ES:[DI]
DrawRi_0:      RET
;...............
;  Wir haben 4 BytesPerPixel mit Bankberschreitung.
;  DI = Anzahl Byte in der nchsten Bank.  CX = Lnge in Byte
DrawRi_20:     MOV    DX,DI       ; DX:= Byte in neuer Bank
               SHR    DX,2        ; DX:= Pixel in neuer Bank
               SUB    DI,CX       ; ES:DI-> alte Bank
               SHR    CX,2        ; CX:= Lnge in Pixel
               SUB    CX,DX       ; CX:= Lnge-Pixel neue Bank
               REP    STOSD       ; Flle den 1. Teil der Zeile
               CALL   IncWrBank   ; Schalte um auf nchste Bank
               MOV    CX,DX       ; CX:= Pixel in neuer Bank
               REP    STOSD       ; Flle den 2. Teil der Zeile
               JMP    SHORT DrawRi_0  ; Fertig
;...............
;  Wir haben 3 BytesPerPixel.
DrawRi_3:      SHLD   EBX,EAX,16  ; Farbkomp.BL=C AH=B AL=A
;  Sieh nach, ob wir mit Bankberschreitung rechnen mssen.
               MOV    DX,CX           ; DX:= Anzahl Pixel
               IMUL   DX,3            ; DX:= Anzahl Byte
               ADD    DI,DX           ; Bankberschreitung ?
               JC     SHORT DrawRi_60 ;  Ja, Sonderfall
;  Wir haben 3 BytesPerPixel und keine Bankberschreitung.
               SUB    DI,DX           ; DI-> zurck alte Bank
DrawRi_52:     STOSW                  ; Komp. B:A zum Video-Mem
               MOV    ES:[DI],BL      ; Komp. C zum Video-Mem
               INC    DI
               LOOP   DrawRi_52       ; Loop mit Anzahl Pixel
               JMP    SHORT DrawRi_0  ; Fertig
;...............
;  Wir haben 3 BytesPerPixel und Bankberschreitung.
DrawRi_60:     SUB    DI,DX           ; DI-> zurck alte Bank
DrawRi_62:     MOV    ES:[DI],AL      ; Komp. A zum Video-Mem
               INC    DI              ; INC ES:DI-> Video-Mem
               JNZ    SHORT DrawRi_64 ; Achte auf Bankswitch
               CALL   IncWrBank
DrawRi_64:     MOV    ES:[DI],AH      ; Komp. B zum Video-Mem
               INC    DI              ; INC ES:DI-> Video-Mem
               JNZ    SHORT DrawRi_66 ; Achte auf Bankswitch
               CALL   IncWrBank
DrawRi_66:     MOV    ES:[DI],BL      ; Komp. C zum Video-Mem
               INC    DI              ; INC ES:DI-> Video-Mem
               JNZ    SHORT DrawRi_68 ; Achte auf Bankswitch
               CALL   IncWrBank
DrawRi_68:     LOOP   DrawRi_62       ; Loop mit Anzahl Pixel
               JMP    SHORT DrawRi_0  ; Fertig
DrawRi         ENDP
;-------------------------------
IncWrBank      PROC
               PUSHA
;  Suche nach einer beschreibbaren Bank
               MOV    BL,[WinBAttributes]
               SHR    BL,2    ; Bit#0 = schreibbar-Bit
               AND    BL,1    ; wenn 1, dann WinB, sonst WinA
;  Lies die Position der Bank
               MOV    BH,1    ; Window lesen
               CALL   [WinFuncPtr]
               ADD    DX,[WinSizePerGranu]
;  Setze die Bank := DX
               MOV    BH,0    ; Window setzen
               CALL   [WinFuncPtr]
               POPA
               RET
IncWrBank      ENDP
;-------------------------------
CODE           ENDS
               END
