unit topicsru;
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, FileCtrl;
{$IFDEF WIN32}
{$H-}
type PString = ^String;
{$ENDIF}

type
  TFindIDForm = class(TForm)
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    KWFList: TListBox;
    mFound: TMemo;
    cStop1stFound: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  protected
    function ScanKWF(FName,SrcItem: String): Boolean;
  public
    { Public declarations }
  end;

var
  FindIDForm: TFindIDForm;

implementation

{$R *.DFM}

procedure TFindIDForm.FormCreate(Sender: TObject);
begin
  DirectoryListBox1Change(Self);  { fllt KWFList }
  KeyPreview := True;
  mFound.Clear; mFound.Lines.Add('< bis dato nichts gefunden >');
  cStop1stFound.Caption := 'Nur 1. Fundstelle';
end;

procedure TFindIDForm.DirectoryListBox1Change(Sender: TObject);
var S: TSearchRec; x: Integer;
begin
  KWFList.Clear;
  x := FindFirst(DirectoryListBox1.Directory+'\*.KWF',$3F,S);
  while x = 0 do
  begin
    KWFList.Items.Add(S.Name);
    x := FindNext(S);
  end;
  Edit1.Enabled := KWFList.Items.Count > 0;
end;

procedure TFindIDForm.FormKeyPress(Sender: TObject; var Key: Char);
var x: Integer; FoundTopicID: Boolean;
begin
  if (Key = #13) and (ActiveControl = Edit1) then
  begin
    Key := #0; { sonst gibt's einen MessageBeep }
    FoundTopicID := False; mFound.Clear;
    for x := 0 to KWFList.Items.Count-1 do
    begin
      KWFList.ItemIndex := x;
      if ScanKWF(DirectoryListBox1.Directory+'\'
        +KWFList.Items[x],AnsiUppercase(Edit1.Text)) then
      begin
        FoundTopicID := True;
        if cStop1stFound.Checked then Break;
      end;
    end;
    if not FoundTopicID then
    begin
      KWFList.ItemIndex := -1;
      mFound.Lines.Add('<nichts gefunden>');
    end;
  end;
end;

{ Dateistruktur von KFWs:

Key(K)<0> Titel($) Topic(#)
Key(B)<1> Titel($) Topic(#)

Alle drei Elemente sind Pascal-Strings,
die B-Keys stellen optionale Zustze dar
und werden hier bei der Suche bergangen
Wenn eine Hilfeseite mehrere Keywords (K und/oder B) hat,
werden Titel und Topic# einfach entsprechend oft wiederholt.
Daten sind in Blocks  8 KByte, Block-Ende ist bei Bedarf
mit 0 aufgefllt.
}

function TFindIDForm.ScanKWF(FName,SrcItem: String): Boolean;
const BLOCKSIZE = 8192;
Label Done;
var FStream: TFileStream; Buf: PChar;
    TitleList: TStringList;
    UpTitle: String; ByteP: PByte;
    TitleP, TopicP: PString;
begin
  Result := False;
  FStream := TFileStream.Create(FName,fmOpenRead);
  FName := ExtractFileName(FName);
  FName := Copy(FName,1,Length(FName)-4);
  GetMem(Buf,BLOCKSIZE+2);
  Buf[BLOCKSIZE] := #0; Buf[BLOCKSIZE+1] := #0;
  TitleList := TStringList.Create; TitleList.Sorted := True;
  while FStream.Position < FStream.Size do
  begin
    FStream.Read(Buf^,BLOCKSIZE); ByteP := Pointer(Buf);
    repeat
      { Suche nach dem Endmarker eines K-Keywords }
      while ByteP^ <> 0 do Inc(ByteP);
      Inc(ByteP); TitleP := Pointer(ByteP);
      { Fllbytes (oder die beiden zu Fu eingesetzten
        Endmarker) am Ende des 8K-Blocks erreicht? }
      { Mit Length(TitleP)^ hat Delphi32 auch bei $H- Probleme }
      if TitleP^[0] = #0 then Break;
      UpTitle := AnsiUpperCase(TitleP^);
      if Pos(SrcItem,UpTitle) <> 0 then
      begin  { gefunden. Hatten wir den Titel schon? }
        if TitleList.IndexOf(UpTitle) = -1 then
        begin
          TitleList.Add(UpTitle);
          TopicP := TitleP;
          Inc(PChar(TopicP),Length(TopicP^)+1);
          mFound.Lines.Add(TitleP^+' '+TopicP^+'@'+FName);
          Result := True;
          if cStop1stFound.Checked then goto Done;
        end;
      end;
    until False;
  end;
Done:
  FreeMem(Buf,BLOCKSIZE+2); TitleList.Destroy; FStream.Destroy;
end;

end.
