unit Sawu; { 15-NOV-96 as (Arne Schpers) }

{ Das Gegenteil zu einem schnellen Timer.
  Compilierbar mit Delphi16 und Delphi32; die Form ist
  vollkommen leer und hat Standard-Eigenschaften.
  Bentigte Dateien: SAW1.WAV und SAW2.WAV im selben
  Verzeichnis wie SAW.EXE.
  Start ohne Kommmandozeilen-Parameter: Verzgerung um 5 Minuten;
  Start mit SAW 123: Verzgerung um 123 Minuten
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls, MPlayer, mmSystem;

type
  TProgState = (psStart,psSleep, psShave, psWorkDone, psDone);
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    MinuteDownCount: LongInt;
    Timer1: TTimer;
    ProgState: TProgState;
  end;

const
   PolyPoints = 8;  { Gesamtzahl der Ecken }
var
  Form1: TForm1;
  PPoints: Array[0..PolyPoints] of TPoint;
  MediaPlayer: TMediaPlayer;
  BlackPen: TPen;
  ScreenDC: HDC; OldPen: HPen;
  TotalPoints, PointCount, TimeOffset: LongInt;

implementation

{$R *.DFM}

procedure GetScreenDC;
begin
  if ScreenDC = 0 then
  begin
    ScreenDC := GetDC(0);
    OldPen := SelectObject(ScreenDC,BlackPen.Handle);
    SelectObject(ScreenDC,GetStockObject(BLACK_BRUSH));
  end;
end;

procedure ReleaseScreenDC;
begin
  if ScreenDC <> 0 then
  begin
    SelectObject(ScreenDC,OldPen);
    ReleaseDC(0,ScreenDC);
    ScreenDC := 0;
  end;
end;

procedure ScreenMoveTo(Pt: TPoint);
begin
{$IFDEF WIN32}
  MoveToEx(ScreenDC,Pt.X,Pt.Y,nil);
{$ELSE}
  MoveTo(ScreenDC,Pt.X,Pt.Y);
{$ENDIF}
end;
procedure LineDDaProc(x,y: Integer; lpData: Pointer); export;
{$IFDEF WIN32} stdcall; {$ENDIF}
var TargetTimePos: LongInt; LastPoint: TPoint;
begin
  if lpData = nil then Inc(TotalPoints)
   else
   begin
     LastPoint := Point(x+Random(3)-1,y+Random(3)-1);
     LineTo(ScreenDC,LastPoint.X,LastPoint.Y);
     SetPixel(ScreenDC,x+Random(12)-6,y-Random(12)+6,0);
     SetPixel(ScreenDC,x+Random(12)-6,y-Random(12)+6,0);
     if PointCount = 0 then TimeOffset := MediaPlayer.Position;
     Inc(PointCount);

     TargetTimePos := ((MediaPlayer.Length-TimeOffset-1800)*PointCount)
        div TotalPoints+TimeOffset;
     if (MediaPlayer.Position < TargetTimePos) then
     begin
       ReleaseScreenDC;
       while MediaPlayer.Position < TargetTimePos do
         Application.ProcessMessages;
       GetScreenDC;
       ScreenMoveTo(LastPoint);
     end;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var x, R, ScreenW2, ScreenH2: Integer;
begin
  MinuteDownCount := 5;
  if ParamCount = 1 then
  try
    MinuteDownCount := StrToInt(ParamStr(1));
  except
  end;
  SetBounds(-200,-200,100,100);  { weg vom Bildschirm }
  MediaPlayer := TMediaPlayer.Create(Self);
  with MediaPlayer do
  begin
    Visible := False; Parent := Self;
  end;
  Timer1 := TTimer.Create(Self);
  with Timer1 do
  begin
    Interval := 1;
    OnTimer := Timer1Timer; Enabled := True;
  end;
  ProgState := psStart;
  R := Screen.Width div 6;
  ScreenW2 := Screen.Width div 2 - R div 2;
  ScreenH2 := Screen.Height div 2 - R div 2;
  Randomize;
  for x := 0 to 7 do
    PPoints[x] := Point(Random(R),Random(R));

  Inc(PPoints[1].x,ScreenW2);
  PPoints[2].x := Screen.Width - Random(R);
  PPoints[3].x := Screen.Width - Random(R);
  Inc(PPoints[3].y, ScreenH2);
  PPoints[4].x := Screen.Width - Random(R);
  PPoints[4].y := Screen.Height - Random(R);

  Inc(PPoints[5].x,ScreenW2);
  PPoints[5].y := Screen.Height - Random(R);
  PPoints[6].y := Screen.Height - Random(R);
  Inc(PPoints[7].y,ScreenH2);
  PPoints[8] := PPoints[0];

  BlackPen := TPen.Create;
  with BlackPen do
  begin
    Color := clBlack; Style := psSolid; Width := 3;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ReleaseScreenDC;
  BlackPen.Free;
end;

var MemStream: TMemoryStream;

procedure TForm1.Timer1Timer(Sender: TObject);
var x: Integer; FStream: TFileStream;
type PData = {$IFDEF WIN32} LongInt; {$ELSE} Pointer; {$ENDIF}
begin
  case ProgState of
    psStart:
      begin
        Visible := False;
        { Raus aus ALT+TAB, Taskbar von Win95 und ALT+F4 }
        ShowWindow(Application.Handle,SW_HIDE);
        if MinuteDownCount <> 0 then Timer1.Interval := 60000;
      end;
    psSleep:
      begin
        Dec(MinuteDownCount);
        if MinuteDownCount > 0 then Exit;
        with MediaPlayer do
        begin
          FileName := ExtractFilePath(ParamStr(0))+'saw1.wav';
          Wait := False; Open; Play;
       end;
       Timer1.Interval := 9600;
      end;
    psShave:
      begin
        Timer1.Enabled := False;
        GetScreenDC;
        { Pixel durchzhlen }
        ScreenMoveTo(PPoints[0]);
        for x := 0 to PolyPoints-1 do
          LineDDA(PPoints[x].x,PPoints[x].y,PPoints[x+1].x,
            PPoints[x+1].y, @LineDDAProc,PData(0));
        { Pixel zeichnen + Delay }
        ScreenMoveTo(PPoints[0]);
        for x := 0 to PolyPoints-1 do
        begin
         LineDDA(PPoints[x].x,PPoints[x].y,PPoints[x+1].x,
           PPoints[x+1].y, @LineDDAProc,PData(Self));
        end;
        ReleaseScreenDC;
        Timer1.Interval := 3000; Timer1.Enabled := True;
      end;
    psWorkDone:
      begin
        MediaPlayer.Close;
        FStream := TFileStream.Create
           (ExtractFilePath(ParamStr(0))+'saw2.wav',fmOpenRead);
        MemStream := TMemoryStream.Create;
        MemStream.CopyFrom(FStream,FStream.Size);
        FStream.Destroy;
        sndPlaySound(MemStream.Memory,SND_MEMORY or SND_ASYNC);
        GetScreenDC;
        WinProcs.Polygon(ScreenDC,PPoints,PolyPoints);
        ReleaseScreenDC;
      end;
    psDone:
      begin
        MemStream.Free;
        Close;
      end;
  end;  { case }
  Inc(ProgState);
end;

end.
