unit FTimer;  { 03-OKT-96 as (Arne Schpers) }
{ Timer mit echter Auflsung von 1 msec (Win 3.x, 95, NT 4.0)
  Grenzen:
  1. Von diesen Timern ausgelste Ereignisse werden sequentiell
     in die Ereignis-Warteschlange eingereiht, d.h. nicht
     automatisch beim Anstehen anderer Ereignisse nach
     "hinten" verschoben.
  2. Unter Windows NT 4.0 sind die erreichbaren Wiederholraten
     ein Witz. Luft mmSystem dort in Ring 0 und produziert
     pro Rckruf zwei Ring-Umschaltungen?
}
{$C FIXED PERMANENT}    { <- Rckruf whrend Interrupts! }
interface
uses Classes, Messages, WinTypes, WinProcs, Forms, MMSystem;

type
  TFastTimer = class(TComponent)
  private
    FTimerID: Word;  { Timer-Handle von timeSetEvent }
    FWindowHandle: HWnd;  { Hilfsfenster fr verzgertes WM_TIMER }
    FEnabled: Boolean;
    FInterval: Word;
    FOnTimer: TNotifyEvent;
    FPendingEvents: Word;  { Botschaften in der Warteschlange }
  protected
    procedure SetEnabled(Value: Boolean);
    procedure SetInterval(Value: Word);
    procedure SetOnTimer(Value: TNotifyEvent);
    procedure UpdateTimer;  { Bei Vernderungen und bei Destroy }
    procedure WndProc(var Msg: TMessage);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Enabled: Boolean read FEnabled write SetEnabled;
    property Interval: Word read FInterval write SetInterval;
    property OnTimer: TNotifyEvent read FOnTimer write SetOnTimer;
    property PendingEvents: Word read FPendingEvents;
  end;

procedure Register;

implementation
uses SysUtils;
{ Botschaft von der Rckruffunktion an das Hilfsfenster }
var FastTimerMsg: Word;

{ Gemeinsam von allen FastTimern genutzte Rckruffunktion.
  dwUser steht fr das jeweilige TFastTimer-Objekt. FOnTimer
  darf hier *nicht* direkt ausgefhrt werden (Kontext ist
  irgendwo mittendrin in MMSystem). Maximal 6 Timer-Ereignisse
  lassen sich in der Warteschlange aufstapeln }
procedure TimerProc(wTimerID,msg: Word;
                             dwUser,dw1,dw2: LongInt); export;
{ Delphi 2.0 erwartet die Parameter sonst in den Registern(!) }
{$IFDEF WIN32} stdcall; {$ENDIF}
begin
{ Bei Delphi 1.x stimmt wg. "Smart Callbacks" das DSeg nicht }
{$IFNDEF WIN32} asm mov ax,SEG @Data; mov ds,ax; end; {$ENDIF}
  with TFastTimer(dwUser) do
    if PendingEvents < 5 then
    begin
      PostMessage(FWindowHandle,FastTimerMsg,0,0);
      Inc(FPendingEvents);
    end;
end;

{ Hier landen die "geposteten" FastTimerMsg-Botschaften dann
  im Kontext des Programms }
procedure TFastTimer.WndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = FastTimerMsg then
    try
      if Enabled then
      begin
        FEnabled := False; Dec(FPendingEvents);
        if Assigned(FOnTimer) then FOnTimer(Self);
      end;
    except
      FEnabled := False;
      Application.HandleException(Self);
    end
     else Result := DefWindowProc(FWindowHandle,
                                          Msg, wParam, lParam);
end;

constructor TFastTimer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);  { 1:1 wie in TTimer.Create }
  FWindowHandle := AllocateHWnd(WndProc);
  FEnabled := True; FInterval := 1000;
end;

destructor TFastTimer.Destroy;
begin
  Enabled := False;          { dito }
  DeallocateHWnd(FWindowHandle);
  inherited Destroy;
end;

{ XRef: Jede Vernderung von Enabled, Interval und FOnTimer }
procedure TFastTimer.UpdateTimer;
var MaxInt: Integer;
begin
  { Maximale Ungenauigkeit: 55 mSec (wie TTimer) }
  MaxInt := Interval; if MaxInt > 55 then MaxInt := 55;
  if Enabled and Assigned(FOnTimer) and (Interval <> 0)
    and not (csLoading in ComponentState) then
  begin
{$IFDEF WIN32}             { Rckrufzeit, Auflsung }
    FTimerID := timeSetEvent(Interval, MaxInt,
        TFNTimeCallBack(TimerProc), LongInt(Self),TIME_ONESHOT);
    if FTimerID = 0    { Rckrufzeit, max. mgliche Auflsung }
     then FTimerID := timeSetEvent(Interval, 0,
        TFNTimeCallBack(TimerProc), LongInt(Self),TIME_ONESHOT);
{$ELSE}
    FTimerID := timeSetEvent(Interval, MaxInt,
        TimerProc, LongInt(Self),TIME_ONESHOT);
    if FTimerID = 0    { Rckrufzeit, max. mgliche Auflsung }
     then FTimerID := timeSetEvent(Interval, 0,
        TimerProc, LongInt(Self),TIME_ONESHOT);
{$ENDIF}
  end;
end;

procedure TFastTimer.SetEnabled(Value: Boolean);
begin
  if Value <> FEnabled then
  begin
    FEnabled := Value; UpdateTimer;
  end;
end;

procedure TFastTimer.SetInterval(Value: Word);
begin
  if Value <> FInterval then
  begin
    FInterval := Value; UpdateTimer;
  end;
end;

procedure TFastTimer.SetOnTimer(Value: TNotifyEvent);
begin
  FOnTimer := Value; UpdateTimer;
end;

procedure Register;
begin
  RegisterComponents('Delphi Corner',[TFastTimer]);
end;

initialization
  FastTimerMsg := RegisterWindowMessage('TFastTimer');
end.
