PROGRAM Kofferpacken;

CONST  MaxAnz = 1000;

TYPE
  Loesung = RECORD
    x: ARRAY[1..MaxAnz] of Byte;
    Gewinn: LongInt;
    Gewicht: LongInt;
  END;

VAR
  wahl: Byte;
  TL: ARRAY[1..MaxAnz] of LongInt; {Tabuliste}
  TD: LongInt; {Tabudauer}
  StartLoes, BestLoes, AktLoes: Loesung;
  It, MaxIt, BestIt, MaxGewicht: LongInt;
  n: Word; {Anzahl der Gegenstaende}
  p, w: ARRAY[0..MaxAnz] of LongInt; {Gewinne, Gewichte}

(* Generieren von Probleminstanzen *)
PROCEDURE Generiere;
VAR i: Word;
BEGIN
  WRITE('Anzahl der Gegenstaende: '); READLN(n);
  MaxGewicht:=200;
  FOR i:=1 TO n DO
  BEGIN
    p[i]:=RANDOM(100)+1;  w[i]:=RANDOM(100)+1;
    WRITELN('Gegenstand ',i,' mit Gewinn ',p[i],
            ' und Gewicht ',w[i]);
  END;
END;

(* Einlesen einer Probleminstanz aus einer Datei *)
PROCEDURE LiesVonDatei;
VAR i: Word;
    namstr: String[80];
    dat: Text;
BEGIN
  WRITE('Eingabedatei: '); READLN(namstr);
  ASSIGN(dat,namstr);
  RESET(dat);
  READLN(dat,n); READLN(dat,MaxGewicht);
  FOR i:=1 TO n DO
    READLN(dat,p[i],w[i]);
  CLOSE(dat);
END;

(* Anzeigen der aktuellen Loesung *)
PROCEDURE ZeigeLoesung(Loes:Loesung);
VAR i: Word;
BEGIN
  WITH Loes DO
  BEGIN
    WRITE('Gewinn = ',Gewinn,'  Gewicht = ',Gewicht);
    WRITE('  Inhalt = {');
    FOR i:=1 TO n DO
      IF x[i]=1 THEN WRITE(' ',i);
    WRITELN(' }');
  END;
END;

(* Ermitteln der Anfangsloesung *)
PROCEDURE AnfangsLoesung;
VAR voll:      Boolean;
    max:       LongInt;
    besti, i:  Word;
BEGIN
  WRITELN('Ermittlung der Anfangsloesung:');
  WITH StartLoes DO
  BEGIN
    Gewinn:=0; Gewicht:=0;
    FOR i:=1 TO n DO x[i]:=0;
    REPEAT
      max:=0; besti:=0;
      (* Gewinnbringendster noch passender Gegenstand *)
      FOR i:=1 TO n DO
      IF (x[i] = 0) AND (Gewicht+w[i] <= MaxGewicht)
         AND (max < p[i]) THEN
      BEGIN
        max:=p[i];
        besti:=i;
      END;
      (* Einpacken, falls solcher Gegenstand vorhanden *)
      IF besti > 0 THEN
      BEGIN
        x[besti]:=1;
        Gewinn:=Gewinn+max;
        Gewicht:=Gewicht+w[besti];
        WRITELN('Einpacken von ',besti);
      END;
    UNTIL besti=0;
  END;
  BestLoes:=StartLoes;
END;

(* Tabu Search mit fester Tabudauer TD *)
PROCEDURE TabuSearch;
VAR i, besti: Word;
    max, min: LongInt;
BEGIN
  WRITELN('Anwendung von Tabu Search:');
  (* Initialisierungen *)

  FOR i:=1 TO n DO TL[i]:=-TD;
  AktLoes:=BestLoes;
  It:=1;
  BestIt:=0;
  WITH AktLoes DO
  BEGIN
    REPEAT
      WRITELN('Iteration ',It,': ');
      WRITE('Tabuliste: < ');
      FOR i:=1 TO n DO
        IF It-TL[i] <= TD THEN WRITE(i,' ');
      WRITE(']  ');
      max:=0; besti:=0;
      (* Waehle gewinnbringendsten passenden Gegenstand, der
         nicht tabu ist oder zu neuer bester Loesung fuehrt *)
      FOR i:=1 TO n DO
        IF (x[i]=0) AND (Gewicht+w[i]<=MaxGewicht) AND
           ((max<p[i]) OR ((max=p[i]) AND (w[i]<w[besti])))
           AND ((It-TL[i]>TD) OR
                (Gewinn+p[i]>BestLoes.Gewinn)) THEN
        BEGIN
          max:=p[i];
          besti:=i;
        END;
      (* Einpacken, falls solcher Gegenstand vorhanden *)
      IF besti > 0 THEN
      BEGIN
        x[besti]:=1;
        Gewinn:=Gewinn+max;
        Gewicht:=Gewicht+w[besti];
        TL[besti]:=It;               {Tabu setzen}
        WRITELN(' -> Einpacken von Gegenstand ',besti);
      END
      (* Falls nicht: Waehle zu entfernenden Gegenstand *)
      ELSE
      BEGIN
        min:=MaxLongInt;
        FOR i:=1 TO n DO
        IF (x[i] = 1) AND
           ((min>p[i]) OR ((min=p[i]) AND (w[i]>w[besti])))
           AND (It-TL[i]>TD) THEN
        BEGIN
          min:=p[i];
          besti:=i;
        END;
        (* Auspacken, falls solcher Gegenstand vorhanden *)
        IF besti > 0 THEN
        BEGIN
          x[besti]:=0;
          Gewinn:=Gewinn-min;
          Gewicht:=Gewicht-w[besti];
          TL[besti]:=It;               {Tabu setzen}
          WRITELN(' -> Auspacken von Gegenstand ',besti);
        END
        (* Keine Aktion, alle Zuege tabu *)
        ELSE
          WRITELN('Alle moeglichen Zuege sind tabu!');
      END;
      ZeigeLoesung(AktLoes);

      (* Speichern der aktuellen Loesung bei Verbesserung *)
      IF Gewinn > BestLoes.Gewinn THEN
      BEGIN
        BestLoes:=AktLoes;
        BestIt:=It;
        WRITE('Neue beste Loesung mit Gewinn ');
        WRITELN(Gewinn,' in Iteration ',It);
      End;
      READLN;
      (* Erhoehen des Iterationszaehlers *)
      INC(It);
    UNTIL It>MaxIt; {Abbruchkriterium}
  END;
END;

(* Hauptprogramm *)
BEGIN
  WRITELN('Einfaches Tabu Search fuer Schmugglerproblem');
  WRITELN;
  WRITELN('(1) Einlesen von Datei');
  WRITELN('(2) Generieren eines zufaelligen Problems');
  WRITELN;
  REPEAT
    WRITE('Bitte waehlen Sie: ');
    READLN(wahl);
  UNTIL wahl in [1,2];
  IF wahl = 1 THEN
    LiesVonDatei
  ELSE
    Generiere;

  WRITE('Tabudauer: '); READLN(TD);
  WRITE('Maximale Iterationsanzahl: '); READLN(MaxIt);
  AnfangsLoesung;
  ZeigeLoesung(StartLoes);
  TabuSearch;
  WRITELN;
  WRITELN('Anfangsloesung:');
  ZeigeLoesung(StartLoes);
  WRITELN('Beste Loesung gefunden in Iteration ',
          BestIt,':');
  ZeigeLoesung(BestLoes);
END.
