###################################################################################
#
# gentel.pl		Juergen Fey                                   V 0.1  9.8.96
#
# Generiert die HTML-Seiten fuer ein Online-Telefonbuch aus einer ASCII-Datei,
# die vorher aus einer Datenbankabfrage generiert wurde.
#
###################################################################################

$program = "gentel.pl V .01";		# Programmname und Version fuer HTML-Ausgabe

$input  = $ARGV[0];			# ASCII-Telefondatei
$output = $ARGV[1];			# Name der HTML-Seite

$pagecnt = 0;				# Seitenzaehler

open (INPUT, "<$input")   || die ("Kann Telefon-ASCII-Datei nicht zum Lesen oeffnen\n");
open (NAME , ">$output")  || die ("Kann HTML-Seite $output nicht erzeugen\n");

&Print_Header ($output);     
close (NAME);
open  (NAME , ">>$output") || die ("Kann HTML-Seite $output nicht erzeugen\n");

while ($line = <INPUT>)			# zeilenweise einlesen
 {
   if ($pagecnt > 0)			# erste Zeile ignorieren, da dort DB-Info
     {
       $line =~ s/\"//g;			# Anfuehrungszeichen ausfiltern
       $line = &asciitohtml ($line);
       
       @datensatz = split (/\|/, $line); # Die Felder in @datensatz aufspalten
       
# Datenfelder in einzelne Variablen ueberfuehren
       $TelefonID 	= @datensatz[0];
       $TelefonName 	= @datensatz[1];
       $Vorname 	= @datensatz[2];
       $Kuerzel 	= @datensatz[3];
       $LocationTelefon	= @datensatz[4];
       $ZentraleTelefon = @datensatz[5];
       $ZentraleFax	= @datensatz[6];
       $NameTelefon 	= @datensatz[7];
       $NameFax 	= @datensatz[8];
       $NameEmail 	= @datensatz[9];
       $LocationID 	= @datensatz[10];
       $Name_Kurz 	= @datensatz[11];
       $LocationName 	= @datensatz[12];
       $Strasse 	= @datensatz[13];
       $PLZ 		= @datensatz[14];
       $Ort 		= @datensatz[15];
       $Zimmer 		= @datensatz[16];
       $AbteilungID 	= @datensatz[17];
       $AbteilungName 	= @datensatz[18];
       $Kurz 		= @datensatz[19];    

       print NAME ("<TR>\n");
       print NAME ("<TD ALIGN=LEFT  BGCOLOR=#ffff80>$Vorname $TelefonName</TD>\n");
       print NAME ("<TD ALIGN=LEFT  BGCOLOR=#ffff80>$LocationTelefon$NameTelefon</TD>\n");
       print NAME ("<TD ALIGN=RIGHT BGCOLOR=#ffff80>$NameFax</TD>\n");
       print NAME ("<TD ALIGN=LEFT  BGCOLOR=#ffff80><A HREF=\"mailto:$NameEmail\">$NameEmail</A></TD>\n");
       print NAME ("</TR>\n");
 
       print ("."); 
     }
   $pagecnt++;
  }   

&Print_Footer ($output);
close (NAME);



###################################################################################
sub Print_Header
{
   local ($name) = @_;
#   open (NAME, ">$name");
    
   print NAME ("<HTML>\n");
   print NAME ("<HEAD>\n");
  
   print NAME ("<!-- c't Telefonbuch-Beispiel. Erstellt durch $program-->\n");
   print NAME ("<BASEFONT SIZE = 3>\n");
   print NAME ("</HEAD>\n");
   print NAME ("<BODY BGCOLOR=#FFFFFF LINK=#FF0000 VLINK=#008000>\n");
   
   print NAME ("<TABLE BORDER=0 COLS=\"4\" WIDTH=\"90%\">\n");
   print NAME ("<COL WIDTH=\".25\">\n");
   print NAME ("<COL WIDTH=\".25\">\n");
   print NAME ("<COL WIDTH=\".10\">\n");
   print NAME ("<COL WIDTH=\".25\">\n");
   print NAME ("<TR>\n");
   print NAME ("<TH BGCOLOR=#E8E8E8 WIDTH=\"25%\" ALIGN=LEFT>Name</TH>\n");
   print NAME ("<TH BGCOLOR=#E8E8E8 WIDTH=\"25%\" ALIGN=LEFT>Telefon</TH>\n");  
   print NAME ("<TH BGCOLOR=#E8E8E8 WIDTH=\"10%\" ALIGN=LEFT>Fax</TH>\n");  
   print NAME ("<TH BGCOLOR=#E8E8E8 WIDTH=\"25%\" ALIGN=LEFT>Email</TH>\n");
   print NAME ("</TR>\n");
 
#   close (NAME);
}   
    
sub Print_Footer
{
  local ($name) = @_;
#  open (NAME, ">$name");

  print NAME ("</TABLE>\n");
  
  print NAME ("<P>");
  print NAME ("<BR>\n");
  print NAME ("<FONT SIZE=-2>\n");	
#   print NAME ("<P>\n");
  print NAME ("<CENTER>Copyright &copy; 1996 Verlag Heinz Heise</CENTER>\n");
  print NAME ("<CENTER>Alle Rechte vorbehalten. All Rights Reserved</CENTER>\n");
  ($sec, $min, $hour, $tag, $monat, $jahr, @rest) = localtime (time);
  $monat++;
  print NAME ("<CENTER><EM>last modified: $tag.$monat.$jahr</EM> by <A HREF=\"mailto:jf@heise.de\"><em>Webmaster</em></A></CENTER>\n");
  print NAME ("</FONT>\n");	
  print NAME ("</BODY>\n");
  print NAME ("</HTML>\n");  
#  close (NAME);
}
 
 
#################################################################################
#
# asciitohtml					    	     (c) J. Fey   21.3.96
#
# Filtert die Sonderzeichen in einem ein als Parameter uebergebenen Wortes
# in die HTML-Tags
#
################################################################################## 
sub asciitohtml
{
  local ($wort) = @_;
  
  $wort =~ s/&+/&amp;/g;		# &-Zeichen
  $wort =~ s/+/&auml;/g;		# Umlaute
  $wort =~ s/+/&ouml;/g;
  $wort =~ s/+/&uuml;/g;
  $wort =~ s/+/&Auml;/g;
  $wort =~ s/+/&Ouml;/g;
  $wort =~ s/+/&Uuml;/g;
  $wort =~ s/+/&szlig;/g;		# scharfes s
             
  $wort =~ s/+/&Agrave;/g;		# franz.
  $wort =~ s/+/&Aacute;/g;
  $wort =~ s/+/&Acirc;/g;
  $wort =~ s/+/&Egrave;/g;
  $wort =~ s/+/&Eacute;/g;
  $wort =~ s/+/&Ecirc;/g;
  $wort =~ s/+/&Igrave;/g;
  $wort =~ s/+/&Iacute;/g;
  $wort =~ s/+/&Icirc;/g;
  $wort =~ s/+/&Ograve;/g;
  $wort =~ s/+/&Oacute;/g;
  $wort =~ s/+/&Ocirc;/g;
  $wort =~ s/+/&Ugrave;/g;
  $wort =~ s/+/&Uacute;/g;
  $wort =~ s/+/&Ucirc;/g;
             
  $wort =~ s/+/&agrave;/g;		# franz.
  $wort =~ s/+/&aacute;/g;
  $wort =~ s/+/&acirc;/g;
  $wort =~ s/+/&egrave;/g;
  $wort =~ s/+/&eacute;/g;
  $wort =~ s/+/&ecirc;/g;
  $wort =~ s/+/&igrave;/g;
  $wort =~ s/+/&iacute;/g;
  $wort =~ s/+/&icirc;/g;
  $wort =~ s/+/&ograve;/g;
  $wort =~ s/+/&oacute;/g;
  $wort =~ s/+/&ocirc;/g;
  $wort =~ s/+/&ugrave;/g;
  $wort =~ s/+/&uacute;/g;
  $wort =~ s/+/&ucirc;/g;
  
  return $wort;
}

