// Message filter for Delphi for OS/2
// (c) 1996 Matthias Withopf

#define INCL_DOS
#include <os2.h>
#include <dir.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <alloc.h>
#include <io.h>
#include <dos.h>
#include "filter.h"

unsigned int BufSize,CurBufLen;
char        *InBuffer,*OutBuffer,*CurInPtr,*CurOutPtr,*LinePtr;
char         Line[256];

char NextChar(void)
{
  if (CurInPtr < InBuffer + CurBufLen) return *CurInPtr++;
  CurInPtr = InBuffer;
  if ((!DosRead(HF_STDIN,(PVOID)InBuffer,BufSize,(PULONG)&CurBufLen)) && CurBufLen)
    return NextChar();
  return 0;
}

void flushOut(unsigned Size)
{
	unsigned int bytes;
  if (Size)
    {
      CurOutPtr = OutBuffer;
      DosWrite(HF_STDOUT,(PVOID)OutBuffer,Size,(PULONG)&bytes);
    }
}

void Put(char *S,int Len)
{
  for (int i = 0; i < Len; i++)
    {
      *CurOutPtr++ = S[i];
      if (CurOutPtr >= OutBuffer + BufSize)
        flushOut(BufSize);
    }
}

void ProcessLine(char *Line)
{
  static BOOL PutFileName = TRUE;
  static BOOL IsFirstLine = TRUE;
  int    CurLineNum = 1;

	if (!Line[0]) return;
  char *p = Line;
  if (IsFirstLine)
    {
      IsFirstLine = FALSE;
      goto L;
    }
  if (PutFileName)
    {
      char  FileName[256];
      char *p = FileName,*p1 = Line;
      while (*p1 && (*p1 != '('))
        *p++ = *p1++;
      *p = '\0';
      PutFileName = FALSE;
      int Type = MsgNewFile;
      Put((char *)&Type,1);
    	Put(FileName,strlen(FileName) + 1);
    }
  while (*p && (*p != '(')) ++p;
  ++p;
  CurLineNum = atoi(p);
  while (*p && (*p != ')')) ++p;
  ++p;
  while (*p == ' ') ++p;
L:
  if (*p)
    {
      int Type = MsgNewLine;
      Put((char *)&Type,1);
      int i = CurLineNum;
      Put((char *)&i,2);
      i = 1;
      Put((char *)&i,2);
      Put(p,strlen(p) + 1);
    }
}

int main(void)
{
	setmode(1,O_BINARY);
	BufSize = 64000U;
	if (!(InBuffer = (char *)malloc(BufSize))) exit(EXIT_PROCESS);
	CurInPtr = InBuffer;
	BufSize = BufSize / 2;
	OutBuffer = InBuffer + BufSize;
	CurOutPtr = OutBuffer;
	LinePtr = Line;
	CurBufLen = 0;
	Put(PipeId,PipeIdLen);
	char c;
	while ((c = NextChar()) != 0)
	  {
		  if ((c == 13) || (c == 10))
    		{
		    	*LinePtr = 0;
    			ProcessLine(Line);
		    	LinePtr = Line;
    		}
	  	else if (LinePtr - Line < 132)
    		{
		    	*LinePtr = c;
    			LinePtr++;
    		}
   	}
	*LinePtr = 0;
	ProcessLine(Line);
	char EndMark = MsgEoFile;
	Put(&EndMark,1);
	flushOut((unsigned)(CurOutPtr - OutBuffer));
	return  0;
}
