;************************************************************************
;RJ_ISR.ASM
;Host-Interrupt-Routinen
;fr "Klangwerkstatt", angepat von C. Meyer 7/96
;
;The ISRs which follow require that r6 has been established as
;a pointer to a stack which grows towards increasing addresses.
;
;************************************************************************


;------------------------------------------------------------------------
;Host-Commands
;Reglerwerte vom Rechner setzen:
;------------------------------------------------------------------------

		org p:
HLevel	move	n6,x:LEVEL_IDX ;Level-Index zurcksetzen
		rti

HRegler	move	r0,x:(r6)+		;auf den Stack
		move	#SLIDER,r0		;Adresse des 1. Speichers
		do	#16,HRegLoop		;16 Regler
		jclr	#0,x:HSR,*		;warten, bis HTDE gesetzt wird
		movep	x:HRX,x:(r0)+	;Wert in Speicher
HRegLoop
		bset	#SLIDER_NEW,x:FLAGS	;Flag setzen
		move	x:-(r6),r0
		rti


;------------------------------------------------------------------------
;SSI Receive ISR
;ADDA-Wandler abfragen (Network-Mode)
;benutzt r6 als Stack-Pointer (mu initialisiert sein!)
;------------------------------------------------------------------------

ssi_rx_isr
		move	r0,x:(r6)+      ;beutzte Register retten
		move	x1,x:(r6)+
		move	x:FRAME_PTR,r0
		movep	x:SSIDR,x1		;SSI-Daten vom AD-Wandler nach x1
		jset 	#3,x:SSISR,Frame1	;jmp -> 1. Frame erkannt
		jmp 	(r0)			;Springe zum aktuellen Frame
Frame2	move	#Frame3,r0
		movep	n6,x:SSIDR		;Bit 17+18 DA = 0  (n6=Dauer-0)
		jmp		<AddaEnd
Frame3	move	x1,x:IN_TEMP_R
		move	#Frame4,r0
		movep	x:OUT_TEMP_R,x:SSIDR	;rechten Wert ausgeben
		jmp		<AddaEnd
Frame4	movep	n6,x:SSIDR		;Bit 17+18 DA = 0
		jmp		<AddaEnd
Frame1	move	x1,x:InValL		;Linker Wert fr Berechnung
		move	#Frame2,r0		;nchster Frame
		movep	x:OutValL,x:SSIDR	;Wert von linker Berechnung ausgeben
		move	x:IN_TEMP_R,x1	;Eingangswert Adda-Rechts
		move	x1,x:InValR		;als Eingangswert fr Berechnung
		move	x:OutValR,x1	;Ausgangswert der Berechnung rechts
		move	x1,x:OUT_TEMP_R	;als Ausgangswert fr Adda-Rechts
		bset	#SAMPLE_OK,x:FLAGS
AddaEnd	move	r0,x:FRAME_PTR
		move	x:-(r6),x1
		move	x:-(r6),r0      ;restore r0
ssi_tx_isr
		rti
