;*************************************************************************
;
;Framework fr Motorola EVM56K
;mit CS4215
;
;Registerbelegung:
;r6			= Variablen-Stack (*ISR.ASM)
;
;*************************************************************************


;ab hier mglichst nichts mehr ndern
;Variablen-Platz zuteilen.
;Im Zweifel LST-File konsultieren, um berschneidungen zu vermeiden!

;Bereich $10-$13 und $20-$25 ist bei EVM der TX/RX_BUFFer

SLIDER	equ 	$00     ;Parametersatz, belegt wie ROMEO-Regler
LEVEL0	equ		$10		;4 Worte fr TX/RX_BUFFer reserviert
LEVEL	equ		$14     ;(ROMEO-I/O-Pegel) hier bis $1F frei verfgbar
ISRV0	equ		$20     ;6 Worte fr ISR-Variablen reserviert
VARS	equ		$26     ;"schnelle" (<$3F) Laufzeit-Variablen
STACK   equ		$60     ;Variablen-Stack, u.a. fr ISR, wchst nach oben

START   EQU     $40     ;Reset-Vektor
BOOT	EQU		$26		;Boot-Programm belegt Host-Vektoren (nicht benutzt)

;Steht im 128er Boot-EPROM (Base $8000) wg. Adrespiegelung auch an $C000
		org     p:$0
	IF EPROM
		jmp		BOOT
	ELSE
		jmp     START
	ENDIF

;Interrupt-Vektoren
		org     p:$000c
		jsr     ssi_rx_isr      ;SSI receive data
		jsr     ssi_rx_isr      ;SSI receive data with exception
		jsr     ssi_tx_isr      ;SSI transmit data
		jsr     ssi_tx_isr      ;SSI transmit with exception

;------------------------------------------------------------------------

;Booten aus EPROM. Evt. ntig, weil Boot-Loader im 56K
;nur 512 Worte ldt. Die werden gerade abgearbeitet,
;drfen deshalb nicht berschrieben werden
;Adressen und Lngen nderbar. Konvertierung mit SREC -B nicht vergessen!

	IF EPROM
		opt	now	;wg. berschriebenen Host-Interrupt-Bereich
DSPDest	equ		START	          	;Programmbeginn im P:RAM
ROMBase	equ		$8000				;EPROM-Anfang im EVM56K-Adressraum
ROMLng	equ		$2000-DSPDest*3		;8 KBytes ROM = 2,6 KBytes DSP-Prog.
ROMBoot	equ		$C000				;Boot-Startadresse des 56K
ROMAdr	equ		ROMBoot+DSPDest*3	;*3 wg. 3 Bytes/Wort im EPROM

		org p:BOOT
EPROMBoot
		ori 	#3,mr           ;mask interrupts
		movep   #$00F0,x:BCR    ;15 waits for EPROM
		move	#DSPDest,r0
		move	#(ROMAdr),r1
		move	#ROMLng,x0
		do		x0,BootLp1
		do		#3,BootLp2
		movem	p:(r1)+,a2
		rep	#8
		asr a
BootLp2	movem	a1,p:(r0)+
BootLp1
		jmp		START
		opt	w
	ENDIF

;------------------------------------------------------------------------

;Initialisierung laut Motorola
		org     p:START
Reset
		movep   #$261009,x:PLL  ;40 MHz einstellen
		ori 	#3,mr           ;mask interrupts
		movec   #0,sp           ;clear hardware STACK pointer
		move    #0,omr          ;operating mode 0
		move    #STACK,r6		;initialise stack pointer
		move    #-1,m6          ;linear addressing
		movep   #0000,x:BCR     ;no Waitstates after bootstrap

;Codec- und SSI-Initialisierung
		include 'evm_init.asm'
;Steuerworte fr Crystal-Codec 4215 aufsetzen, werden bei jedem
;Sample neu bertragen und knnen zwischendurch gendert werden:
TONE_OUTPUT     EQU     HEADPHONE_EN+LINEOUT_EN+(0*LEFT_ATTN)+(0*RIGHT_ATTN)
TONE_INPUT      EQU     MIC_IN_SELECT+(15*MONITOR_ATTN)
		move    #TONE_OUTPUT,y0 ;set up control words
		move    y0,x:TX_BUFF_BASE+2
		move    #TONE_INPUT,y0
		move    y0,x:TX_BUFF_BASE+3

;User-Initialisierung zuletzt:
		jsr		user_init

;*************************************************************************
;Hauptschleife
;*************************************************************************

loop_1
	IF DEBUG
			move	(r7)+		;Restzyklen fr Debug
	ENDIF
		jset    #2,x:SSISR,loop_1    	;wait for frame sync to pass
loop_2
	IF DEBUG
			move	(r7)+		;Restzyklen fr Debug
	ENDIF
		jclr    #2,x:SSISR,loop_2  		;wait for frame sync
		jsr     process_stereo
	IF DEBUG
		move	r7,n7           ;Restzyklen knnen in n7 berwacht werden
		move	n6,r7			;Restzyklen auf 0
	ENDIF
		jmp     loop_1

;Interrupt-Service-Routinen einbinden
		include 'evm_isr.asm'
