// Datei CTApplet.java
import java.awt.*;      //#include Abstract Window Tooolkit
import java.applet.*;   //#include Applet-Klassen
public class CTApplet extends Applet {
    // Das Bild
    Image ctBild;
    // Breite, Hhe des GIF-Bildes
    int width, height;
    // Musik, die beim Klicken auf das Bild
    // abgespielt wird.
    AudioClip ctSound;
    // init()-Methode wird bei Start des Applets
    // aufgerufen
    public void init() {
       // Start des Ladens des Bildes ber
       // das HTTP-Protokoll. Ein eigener Thread
       // ldt das Bild im Hintergrund. Es wird
       // umgehend mit der Ausfhrung des Programms
       // fortgefahren.
       // Als Referenz wird der URL des Applets
       // genommen und relativ dazu die Bilddatei
       // angesprochen. 
       ctBild = getImage(getCodeBase(),
               "images/ct.gif");
       // Analog wird im Hintergrund eine Audiodatei
       // geladen
       ctSound = getAudioClip(getCodeBase(),
               "audio/ct.au");
       // Ist der vom Browser zur Verfgung gestellte
       // Rahmen gro genug ?
       if (size().width < 400 || size().height <150) {
             // ggf. wird das Applet-
             //rechteck nachjustiert
             resize(400,150);
       }
    }
    // Solange das Bild nicht komplett ist wird
    // durch das Nachfragen nach den Dimensionen des
    // Bildes wiederholt die update()-Methode getriggert.
    public void paint(Graphics g) {   
       width = ctBild.getWidth(this); 
       height = ctBild.getHeight(this);
       // Solange das Bild noch nicht komplett geladen
       // ist, wird als Breite und Hhe des Bildes
       // -1 zurckgeliefert 
       if (width > 0) {
           g.clearRect(10,10,width,height);
           g.drawRect(10,10,width,height);
       }
       // drawImage(Image,x,y,breite,hhe,observer)
       g.drawImage(ctBild,10,10,width,height,this);                 
   }
    // update wird mehrfach aufgerufen, whrend das Bild
    // geladen wird
    public void update (Graphics g) {  
         width = ctBild.getWidth(this);
         if (width > 0) 
              System.out.println("Bild ist komplett!");
         paint(g);
    }
}
