#define STRICT         // Striktere Typprfungen einschalten
#include <windows.h>   // Windows.h einlesen
#include <stdio.h>     // wegen sprintf

#include "winedit.h"   // Fr Prototypen und globale Variablen

// Implementiert die Thread-Funktion
DWORD WINAPI AutoSaveThread(LPVOID lpv)
{
  DWORD dwDelay=((DWORD)lpv)*1000; // Sekunden mal 1000 Millisekunden
  DWORD dwAutoSaveCount=0;
  // Bis der Thread angehalten oder das Programm beendet wird...
  while (TRUE) {
    // Mach doch erst mal Pause
    Sleep(dwDelay);
    if (*szPathname!=0) { // Haben wir einen gltigen Dateinamen?
      // Ja, dann speichere!
      if (RTEdit_SaveFile()==FALSE) { // Problem?
        CHAR szBuffer[300];
        sprintf(szBuffer,"Beim automatischen Sichern der Datei \"%s\" "
          "trat ein Fehler auf!",szPathname);
        MessageBox(NULL,szBuffer,szWndTitle,
          MB_ICONEXCLAMATION|MB_TASKMODAL|MB_OK);
      }
      else dwAutoSaveCount++; // Mitzhlen!
    }
    else { // Kein Dateiname, kein Autosave!
      MessageBox(hwndMain,"Die AutoSave-Funktion arbeitet nur, wenn "
        "das Dokument benannt worden ist!",szWndTitle,
        MB_ICONEXCLAMATION|MB_TASKMODAL|MB_OK);
    }
  }
  return dwAutoSaveCount; // Wird allerdings nirgendwo erfragt
}

// Erzeugt den zweiten Thread
VOID CreateAutoSaveThread(DWORD dwAutoSaveDelay)
{
  DWORD dwThreadId;
  hThreadAutoSave=CreateThread(NULL,0, // keine Security, Standard-Stack
    AutoSaveThread, // Adresse der Thread-Funktion
    (LPVOID)dwAutoSaveDelay, // Thread-Parameter: AutoSave-Delay in Sek.
    0, // keine Erzeugungsoptionen -> Thread luft sofort los
    &dwThreadId); // fr die Thread-Id
}
