#define STRICT         // Striktere Typprfungen einschalten
#include <windows.h>   // Windows.h einlesen
#include <richedit.h>  // Alle RichEdit-Details finden sich in richedit.h
#include <windowsx.h>  // Windowsx.h fr die Message Cracker
#include <stdio.h>     // wegen sprintf

#include "winedit.h"   // Resource-IDs

//Achtung neu!
// Entfernen des folgenden Kommentars fhrt zur Compilation mit einem
// Mutex statt einer Critical Section!
// #define USE_A_MUTEX
//Ende neu

// Diese Konstanten zur Suche in RichEdit-Controls werden in der Win32-
// Dokumentation zwar beschrieben, aber in keinem der mit VC++ 4
// gelieferten Header-Files definiert. Selbst ist der Mann!
#define FT_WHOLEWORD 2
#define FT_MATCHCASE 4

CHAR szClassName[]="RTEdit";  // Fensterklasse fr das Haupt-Window
CHAR szWndTitle[]="WinEdit";  // Titel des Hauptfensters
CHAR szFilename[MAX_PATH]="Dokument"; // Default-Dateiname zur Anzeige
CHAR szPathname[MAX_PATH]=""; // tatschlicher Dateiname inklusive Pfad
CHAR szSearch[100]="";        // enthlt den aktuellen Suchstring
UINT uFormat=SF_RTF;          // Textformat in der Richedit-Control
// Textstring im Rich Text Format fr die Initialisierung der
// RichEdit-Control via Clipboard
CHAR szRTFText[]="{\\rtf1\\ansi\\deff0\\deftab720{\\fonttbl{\\f0\\fnil "
  "MS Sans Serif;}{\\f1\\fnil\\fcharset2 Symbol;}{\\f2\\fswiss\\fprq2 "
  "System;}{\\f3\\fnil Times New Roman;}}"
  "{\\colortbl\\red0\\green0\\blue0;}"
  "\\deflang1033\\pard\\plain\\f3\\fs30 Hallo, dies ist ein Testtext!"
  "\\par"
  "\\par \\plain\\f3\\fs30\\b Diese Zeile ist FETT..."
  "\\par"
  "\\par \\plain\\f3\\fs30\\i ... diese ist KURSIV ..."
  "\\par"
  "\\par \\plain\\f3\\fs30\\ul und die ist UNTERSTRICHEN, oder?"
  "\\par"
  "\\par \\plain\\f3\\fs50 Und die \\plain\\f3\\fs50\\b "
  "letzte\\plain\\f3\\fs50  ist \\plain\\f3\\fs50\\i "
  "etwas\\plain\\f3\\fs50  \\plain\\f3\\fs50\\ul gr\\'f6\\'dfer!"
  "\\par \\plain\\f3\\fs50}";
HINSTANCE hInst;  // fr die Instanz-Handle
HWND hwndMain;    // fr das Toplevel-Window
HWND hwndRTEdit;  // fr die RichEdit-Window-Handle
WNDPROC wpRichEdit;    // Originaladresse der RichEdit-Window-Prozedur
HWND hwndSearchDialog; // fr die Suchen-Dialogbox
HFONT hFont;      // fr den verwendeten Font
BOOL fWord=FALSE; // Suche findet nur ganzes Wort
BOOL fCase=TRUE;  // Suche bercksichtigt Gro-/Kleinschreibung
//Achtung neu!
#ifdef USE_A_MUTEX
  HANDLE hmutexAutoSave; // Handle fr den Mutex
#else
  CRITICAL_SECTION csAutoSave; // Datenstruktur fr eine kritische Sektion
#endif
HANDLE hThreadAutoSave;  // Handle fr den zweiten, den AutoSave-Thread
//Ende neu

// Sucht nach dem nchsten Vorkommen des Strings in szSearch in der
// RichEdit-Control
VOID RTEdit_SearchNext(VOID);
VOID RTEdit_SearchNext(VOID)
{
  FINDTEXTEX fte;
  LONG lPos;
  WPARAM wP;
  if (szSearch[0]==0) { // szSearch mu initialisiert werden
    // Dafr wird der Such-Dialog aktiviert
    PostMessage(hwndMain,WM_COMMAND,ID_BEARBEITEN_SUCHEN,0);
    return;
  }
  // Aktuelle Cursor-Position im Text holen
  SendMessage(hwndRTEdit,EM_EXGETSEL,0,(LPARAM)&fte.chrg);
  // und fte-Struktur initialisieren
  fte.chrg.cpMin=fte.chrg.cpMax;
  fte.chrg.cpMax=-1;
  fte.lpstrText=szSearch;
  wP=fWord?FT_WHOLEWORD:0;  // Ganzes Wort?
  wP|=fCase?FT_MATCHCASE:0; // Gro-/Kleinschreibung?
  // Und suchen lassen!
  lPos=SendMessage(hwndRTEdit,EM_FINDTEXTEX,wP,(LPARAM)&fte);
  if (lPos==-1) { // Nichts gefunden...
    CHAR szNotFound[300];
    sprintf(szNotFound,"Ende der Datei erreicht, der Suchtext \"%s\" "
      "wurde nicht mehr gefunden!",fte.lpstrText);
    MessageBox(hwndSearchDialog,szNotFound,szWndTitle,
      MB_ICONEXCLAMATION|MB_TASKMODAL|MB_OK);
  }
  else { // Gefundenen Text markieren lassen
    SendMessage(hwndRTEdit,EM_EXSETSEL,0,(LPARAM)&fte.chrgText);
  }
}

// DialogBox-Callback-Prozedur fr den modalen WINEDIT_INFODLG-Dialog
BOOL CALLBACK InfoDlgProc(HWND hwnd,UINT msg,UINT wP,LONG lP);
BOOL CALLBACK InfoDlgProc(HWND hwnd,UINT msg,UINT wP,LONG lP)
{
  switch (msg) {
    case WM_INITDIALOG:
      return TRUE;           // Windows setzt den Focus
    case WM_COMMAND:         // OK- oder Close-Button gedrckt
      switch (LOWORD(wP)) {
        case IDOK:           // OK
        case IDCANCEL:       // Close
          EndDialog(hwnd,0); // Dialog beenden
          return TRUE;
      }
  }
  return FALSE; // Andere Messages werden nicht behandelt
}

// Callback-Prozedur fr den nicht-modalen WINEDIT_SEARCH-Dialog
BOOL CALLBACK SearchDlgProc(HWND hwnd,UINT msg,UINT wP,LONG lP);
BOOL CALLBACK SearchDlgProc(HWND hwnd,UINT msg,UINT wP,LONG lP)
{
  switch (msg) {
    case WM_INITDIALOG:
      SendMessage(hwndRTEdit,EM_HIDESELECTION,FALSE,TRUE);
      SendDlgItemMessage(hwnd,ID_FIND_GANZESWORT,BM_SETCHECK,fWord,0);
      SendDlgItemMessage(hwnd,ID_FIND_GROSSKLEIN,BM_SETCHECK,fCase,0);
      EnableWindow(GetDlgItem(hwnd,IDOK),FALSE);
      return TRUE;  // Windows setzt den Focus
    // "Nchsten finden"- oder "Suche beenden"-Button gedrckt
    case WM_COMMAND:
      switch (LOWORD(wP)) {
        case IDOK:  // Nchsten finden
          SendDlgItemMessage(hwnd,ID_FIND_EDIT,WM_GETTEXT,
            sizeof(szSearch),(LPARAM)szSearch);
          // oder: GetDlgItemText(hwnd,ID_FIND_EDIT,WM_GETTEXT,
          //         sizeof(szSearch),(LPARAM)szSearch);
          fWord=SendDlgItemMessage(hwnd,ID_FIND_GANZESWORT,
            BM_GETCHECK,0,0);
          fCase=SendDlgItemMessage(hwnd,ID_FIND_GROSSKLEIN,
            BM_GETCHECK,0,0);
          RTEdit_SearchNext();
          break;
        case IDCANCEL:  // Suche beenden
          fWord=SendDlgItemMessage(hwnd,ID_FIND_GANZESWORT,
            BM_GETCHECK,0,0);
          fCase=SendDlgItemMessage(hwnd,ID_FIND_GROSSKLEIN,
            BM_GETCHECK,0,0);
          SendMessage(hwndRTEdit,EM_HIDESELECTION,TRUE,TRUE);
          DestroyWindow(hwnd); // Dialog beenden
          hwndSearchDialog=NULL;
          return TRUE;
        case ID_FIND_EDIT:
          if (HIWORD(wP)==EN_CHANGE) {
            BOOL fHasText=SendDlgItemMessage(hwnd,ID_FIND_EDIT,
              WM_GETTEXTLENGTH,0,0)!=0;
            EnableWindow(GetDlgItem(hwnd,IDOK),fHasText);
          }
      }
  }
  return FALSE; // Andere Messages werden nicht behandelt
}

// Aktualisiert die Titelbar des Hauptwindows mit Applikationsname
// und Dateiname des aktiven Dokumentes
VOID UpdateWndTitle(VOID);
VOID UpdateWndTitle(VOID)
{
  CHAR szTitle[300];
  sprintf(szTitle,"%s - %s",szFilename,szWndTitle);
  SendMessage(hwndMain,WM_SETTEXT,0,(WPARAM)szTitle);
}

// Callback zum Einlesen von RichEdit-Dateien
DWORD CALLBACK RTEdit_StreamIn(DWORD dwCookie,LPBYTE pbBuff,LONG cb,
  LONG *pcb);
DWORD CALLBACK RTEdit_StreamIn(DWORD dwCookie,LPBYTE pbBuff,LONG cb,
  LONG *pcb)
{
  DWORD dw;
  if (ReadFile((HANDLE)dwCookie,pbBuff,cb,&dw,NULL)) {
    *pcb=(LONG)dw;
    return 0; // Mehr!
  }
  return 1; // Fertig!
}

// Callback zum Speichern von RichEdit-Dateien
DWORD CALLBACK RTEdit_StreamOut(DWORD dwCookie,LPBYTE pbBuff,LONG cb,
  LONG *pcb);
DWORD CALLBACK RTEdit_StreamOut(DWORD dwCookie,LPBYTE pbBuff,LONG cb,
  LONG *pcb)
{
  DWORD dw;
  if (WriteFile((HANDLE)dwCookie,pbBuff,cb,&dw,NULL)) {
    *pcb=(LONG)dw;
    return 0; // OK!
  }
  return 1; // Fehler!
}

// Formatiert den markierten Text in der RichEdit-Control (wenn keine
// Markierung existiert, werden die Default-Attribute modifiziert)
VOID RTEdit_FormatText(int id);
VOID RTEdit_FormatText(int id)
{
  CHARFORMAT cf;
  cf.cbSize=sizeof(cf);
  // Aktuelle Formateinstellungen lesen
  SendMessage(hwndRTEdit,EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
  // ... und entsprechend anpassen
  switch (id) {
    case ID_FORMAT_FETT:
      cf.dwMask=CFM_BOLD;
      cf.dwEffects^=CFE_BOLD;
      break;
    case ID_FORMAT_KURSIV:
      cf.dwMask=CFM_ITALIC;
      cf.dwEffects^=CFE_ITALIC;
      break;
    case ID_FORMAT_UNTERSTRICHEN:
      cf.dwMask=CFM_UNDERLINE;
      cf.dwEffects^=CFE_UNDERLINE;
      break;
    case ID_FORMAT_GROESSER:
      cf.dwMask=CFM_SIZE;
      cf.yHeight+=20; // Die RichEdit-Fontgre wird in Twips
                      // (1/1440 inch) gemessen
      break;
    case ID_FORMAT_KLEINER:
      cf.dwMask=CFM_SIZE;
      cf.yHeight-=20;
      break;
  }
  // Alles wieder zurck zur Control
  SendMessage(hwndRTEdit,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
}

// Zeigt das Kontextmenu fr die RichEdit-Control. Die resultierenden
// WM_COMMAND-Nachrichten werden an hwndParent gesandt.
VOID ShowContextMenu(HWND hwndParent);
VOID ShowContextMenu(HWND hwndParent)
{
  POINT pt;
  HMENU hMenu=CreatePopupMenu(); // Dynamisches Menu erzeugen
  BOOL f=SendMessage(hwndRTEdit,EM_CANPASTE,0,0); // Paste mglich?
  // Ist Text in der Control markiert?
  LRESULT l=SendMessage(hwndRTEdit,EM_SELECTIONTYPE,0,0);
  // Menu-Eintrge hinzufgen
  if (l!=SEL_EMPTY) {
    AppendMenu(hMenu,MF_STRING,ID_BEARBEITEN_AUSSCHNEIDEN,"Ausschneiden");
    AppendMenu(hMenu,MF_STRING,ID_BEARBEITEN_KOPIEREN,"Kopieren");
  }
  if (f) AppendMenu(hMenu,MF_STRING,ID_BEARBEITEN_EINFUEGEN,"Einfgen");
  AppendMenu(hMenu,MF_STRING,ID_BEARBEITEN_LOESCHEN,"Lschen");
  // Separator hinzufgen
  AppendMenu(hMenu,MF_SEPARATOR,0,NULL);
  AppendMenu(hMenu,MF_STRING,ID_BEARBEITEN_ALLESAUSWAEHLEN,
    "Alles auswhlen");
  GetCursorPos(&pt); // Aktuelle Mausposition holen
  // ... und Menu dort anzeigen und bearbeiten lassen
  TrackPopupMenu(hMenu,TPM_CENTERALIGN|TPM_RIGHTBUTTON,pt.x,pt.y,0,
    hwndParent,NULL);
  DestroyMenu(hMenu); // Menu freigeben
}

// Window-Prozedur zum Subclassing des RichEdit-Fensters
LRESULT CALLBACK RTEdit_SubclassWndProc(HWND hwnd,UINT msg,WPARAM wP,
                                        LPARAM lP);
LRESULT CALLBACK RTEdit_SubclassWndProc(HWND hwnd,UINT msg,WPARAM wP,
                                        LPARAM lP)
{
  static BOOL fCaptured=FALSE;
  static int w,h;
  switch (msg) {
    case WM_LBUTTONDOWN:
      if (GetKeyState(VK_SHIFT)&0x80000000) { // Shift gedrckt
        RECT rc;
        GetWindowRect(hwndMain,&rc);
        w=rc.right-rc.left;
        h=rc.bottom-rc.top;
        SetCursorPos(rc.left,rc.top);
        SetCapture(hwnd);
        SetCursor(LoadCursor(NULL,IDC_ARROW));
        fCaptured=TRUE;
        return 0;
      }
      break;
    case WM_LBUTTONUP:
      if (fCaptured) {
        ReleaseCapture();
        fCaptured=FALSE;
        return 0;
      }
      break;
    case WM_MOUSEMOVE:
      if (fCaptured) {
        POINT pt;
        GetCursorPos(&pt);
        MoveWindow(hwndMain,pt.x,pt.y,w,h,TRUE);
        return 0;
      }
      break;
    case WM_RBUTTONDOWN:
      ShowContextMenu(hwndMain); // Kontextmenu anzeigen
      break;
  }
  return wpRichEdit(hwnd,msg,wP,lP); // alte Funktion aufrufen
}

// WM_CREATE-Handler, erzeugt die RichEdit-Control sowie den Font, mit
// dem die Control arbeiten soll. Dann wird der Anfangstext von szRTFText
// via Speicher-Handle und Clipboard in die Control kopiert.
BOOL RTEdit_OnCreate(HWND hwnd,LPCREATESTRUCT lpCreateStruct);
BOOL RTEdit_OnCreate(HWND hwnd,LPCREATESTRUCT lpCreateStruct)
{
  // Child-Fenster der RichEdit-Klasse erzeugen
  hwndRTEdit=CreateWindow("RichEdit",  // Klassenname "RichEdit"
    "",  // Hier kein Window-Text, wird spter gesetzt
    WS_CHILD|WS_VISIBLE|WS_BORDER|WS_VSCROLL| // Window-Stilbits
    // sowie weitere RichEdit-spezifische Optionen
    ES_LEFT|        // Text linksbndig
    ES_MULTILINE|   // mehrzeilig
    ES_AUTOVSCROLL, // mit vertikaler Scrollbar, falls erforderlich
    0,0,            // x,y-Position im Haupt-Window
    10,10,          // Breite und Hhe (in Pixel), wird spter korrigiert
    hwnd,           // Parent-Fenster ist das Haupt-Window
    (HMENU)ID_RICHEDIT, // Child-Id
    hInst,          // Instanz-Handle
    NULL);          // keine zustzlichen benutzerdefinierten Daten
  if (hwndRTEdit) { // Window da ?
    UINT cfRTF;
    HGLOBAL hgRTF;
    LPVOID lpRTF;
    wpRichEdit=(WNDPROC)GetWindowLong(hwndRTEdit,GWL_WNDPROC);
    SetWindowLong(hwndRTEdit,GWL_WNDPROC,(LONG)RTEdit_SubclassWndProc);
    // Font aus der Times-Roman-Familie erzeugen
    hFont=CreateFont(0,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,
      ANSI_CHARSET,0,0,0,VARIABLE_PITCH|FF_ROMAN,NULL);
    // ... und an die RichEdit-Control senden
    SendMessage(hwndRTEdit,WM_SETFONT,(WPARAM)hFont,FALSE);
    // Clipboard mit dem Anfangstext initialisieren
    // Zuerst Text in die Speicher-Handle hg kopieren
    hgRTF=GlobalAlloc(GHND,sizeof(szRTFText));
    lpRTF=GlobalLock(hgRTF);
    strcpy(lpRTF,szRTFText);
    GlobalUnlock(hgRTF);
     // Dann das RTF-Format registrieren und Handle im Clipboard ablegen
    cfRTF=RegisterClipboardFormat(CF_RTF);
    OpenClipboard(hwnd); // Clipboard ffnen...
    EmptyClipboard();    // ... leeren...
    hFont=SetClipboardData(cfRTF,hgRTF); // ... und Handle kopieren
    CloseClipboard(); // Clipboard schlieen
    // RichEdit anweisen, den RTF-Text vom Clipboard zu lesen
    // (mglich wre natrlich auch der Aufruf der Funktion
    // RTEdit_OnCommand(), die weiter unten definiert wird)
    SendMessage(hwndRTEdit,WM_PASTE,0,0);
    // Clipboard-Inhalt wieder lschen
    OpenClipboard(hwnd);
    EmptyClipboard();
    CloseClipboard();
//Achtung neu!
#ifdef USE_A_MUTEX
    // Unbenannten Mutex fr die AutoSave-Funktion erzeugen
    hmutexAutoSave=CreateMutex(NULL,FALSE,NULL);
#else
    // Critical Section fr die AutoSave-Funktion initialisieren
    InitializeCriticalSection(&csAutoSave);
#endif
    // Zweiten Thread fr die AutoSave-Funktion erzeugen
    CreateAutoSaveThread(AUTOSAVE_DELAY);
//Ende neu
  }
  return hwndRTEdit!=NULL; // !=0 heit Erfolg
}

// Behandelt die WM_SIZE-Nachrichten fr das Haupt-Window und pat die
// Gre des RichEdit-Child-Windows an die des Toplevel-Windows an
VOID RTEdit_OnSize(HWND hwnd,UINT state,int cx,int cy);
VOID RTEdit_OnSize(HWND hwnd,UINT state,int cx,int cy)
{
  MoveWindow(hwndRTEdit,0,0,cx,cy,TRUE);
}

// Behandelt die WM_SETFOCUS-Messages und gibt den Eingabe-Fokus gleich
// weiter an die RichEdit-Control
VOID RTEdit_OnSetFocus(HWND hwnd,HWND hwndOldFocus);
VOID RTEdit_OnSetFocus(HWND hwnd,HWND hwndOldFocus)
{
  SetFocus(hwndRTEdit);
}

// Erzeugt MessageBox, die erfragt, ob nderungen gespeichert werden
INT RTEdit_CheckSave(VOID);
INT RTEdit_CheckSave(VOID)
{
  CHAR szAsk[300];
  sprintf(szAsk,"nderungen an %s speichern?",szFilename);
  return MessageBox(hwndMain,szAsk,szWndTitle,
    MB_ICONEXCLAMATION|MB_YESNOCANCEL);
}

// ffnet einen Common Dialog zur Eingabe eines Dateinamens
BOOL RTEdit_QueryFilename(LPSTR lpszFilename,BOOL fSave);
BOOL RTEdit_QueryFilename(LPSTR lpszFilename,BOOL fSave)
{
  OPENFILENAME ofn;
  CHAR szName[MAX_PATH];
  BOOL fValid;
  strcpy(szName,lpszFilename);
  ofn.lStructSize=sizeof(ofn);
  ofn.hwndOwner=hwndMain;
  ofn.hInstance=NULL;
  ofn.lpstrFilter="RichText-Dateien (*.rtf)\0*.RTF\0"
    "Text-Dateien (*.txt)\0*.TXT\0\0";
  ofn.lpstrCustomFilter=NULL;
  ofn.nMaxCustFilter=0;
  ofn.nFilterIndex=1;
  ofn.lpstrFile=szName;
  ofn.nMaxFile=sizeof(szName);
  ofn.lpstrFileTitle=NULL;
  ofn.nMaxFileTitle=0;
  ofn.lpstrInitialDir=NULL;
  ofn.Flags=OFN_HIDEREADONLY|OFN_PATHMUSTEXIST;
  ofn.nFileOffset=0;
  ofn.nFileExtension=0;
  ofn.lpstrDefExt="rtf";
  ofn.lCustData=0L;
  ofn.lpfnHook=0L;
  ofn.lpTemplateName=(LPSTR)NULL;
//Achtung neu!
  SuspendThread(hThreadAutoSave); // AutoSave-Thread anhalten
//Ende neu
  if (fSave) {
    ofn.lpstrTitle="WinEdit - Speichern";
    ofn.Flags|=OFN_OVERWRITEPROMPT;
    fValid=GetSaveFileName(&ofn);
  }
  else {
    ofn.lpstrTitle="WinEdit - ffnen";
    ofn.Flags|=OFN_FILEMUSTEXIST;
    fValid=GetOpenFileName (&ofn);
  }
//Achtung neu!
  ResumeThread(hThreadAutoSave); // AutoSave-Thread reaktivieren
//Ende neu
  if (fValid) {
    uFormat=ofn.nFilterIndex==1?SF_RTF:SF_TEXT;
    if ((ofn.nFileExtension!=0)&&(szName[ofn.nFileExtension-1]!='.'))
      strcat(szName,ofn.nFilterIndex==1?".rtf":".txt");
    strcpy(szPathname,szName);
    strcpy(szFilename,&szName[ofn.nFileOffset]);
    UpdateWndTitle();
  }
  return fValid;
}

// Erzeugt ein neues, leeres Dokument oder ffnet ein bestehendes
VOID RTEdit_NewOrOpenFile(BOOL fNew);
VOID RTEdit_NewOrOpenFile(BOOL fNew)
{
  if (SendMessage(hwndRTEdit,EM_GETMODIFY,0,0)) { // Inhalt gendert?
    switch (RTEdit_CheckSave()) { // Speichern oder nicht?
      case IDYES:    // Ja
        RTEdit_SaveFile();
        break;
      case IDNO:     // Nein
        break;
      case IDCANCEL: // Abgebrochen
        return;
    }
  }
  if (fNew) { // Datei/Neu
    SendMessage(hwndRTEdit,WM_SETTEXT,0,(LPARAM)""); // Text lschen
    SendMessage(hwndRTEdit,EM_SETMODIFY,FALSE,0); // Modify-Flag lschen
    strcpy(szPathname,"");
    strcpy(szFilename,"Dokument");
    UpdateWndTitle();
  }
  else { // Datei/ffnen
    CHAR szName[MAX_PATH]="";
    if (RTEdit_QueryFilename(szName,FALSE)) {
      HANDLE hFile;
#ifdef USE_A_MUTEX
      WaitForSingleObject(hmutexAutoSave,INFINITE);
#else
      EnterCriticalSection(&csAutoSave);
#endif
      hFile=CreateFile(szPathname,GENERIC_READ,0,NULL,
        OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,NULL);
      if (hFile!=INVALID_HANDLE_VALUE) {
        // EDITSTREAM-Struktur initialisieren
        EDITSTREAM es;
        es.dwCookie=(DWORD)hFile;       // File-Handle
        es.dwError=0;
        es.pfnCallback=RTEdit_StreamIn; // Adresse des Read-Callbacks
        // Einlesen der Datei via Callback
        if (SendMessage(hwndRTEdit,EM_STREAMIN,uFormat,(LPARAM)&es)==0) {
          CHAR sz[300];
          sprintf(sz,"Fehler beim Einlesen der Datei %s",szFilename);
          MessageBox(hwndMain,sz,szWndTitle,MB_ICONHAND|MB_OK);
          // Text in der Control komplett lschen
          SendMessage(hwndRTEdit,WM_SETTEXT,0,(LPARAM)"");
        }
        // Modify-Flag rcksetzen
        SendMessage(hwndRTEdit,EM_SETMODIFY,FALSE,0);
        CloseHandle(hFile);
      }
#ifdef USE_A_MUTEX
      ReleaseMutex(hmutexAutoSave);
#else
      LeaveCriticalSection(&csAutoSave);
#endif
    }
  }
}

// Datei speichern
BOOL RTEdit_SaveFile(VOID)
{
  HANDLE hFile;
  BOOL fSuccess=FALSE;
  if (*szPathname==0) {
    if (RTEdit_QueryFilename("Dokument",TRUE)==FALSE)
      return FALSE;
  }
#ifdef USE_A_MUTEX
  WaitForSingleObject(hmutexAutoSave,INFINITE);
#else
  EnterCriticalSection(&csAutoSave);
#endif
  hFile=CreateFile(szPathname,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,
    FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,NULL);
  if (hFile!=INVALID_HANDLE_VALUE) {
    // EDITSTREAM-Struktur initialisieren
    EDITSTREAM es;
    es.dwCookie=(DWORD)hFile;        // File-Handle
    es.dwError=0;                    // ???
    es.pfnCallback=RTEdit_StreamOut; // Adresse des Write-Callbacks
    // Schreiben der Datei via Callback
    if (SendMessage(hwndRTEdit,EM_STREAMOUT,uFormat,(LPARAM)&es)==0) {
      CHAR sz[300];
      sprintf(sz,"Fehler beim Speichern der Datei %s",szFilename);
      MessageBox(hwndMain,sz,szWndTitle,MB_ICONHAND|MB_OK);
    }
    // Modify-Flag rcksetzen
    SendMessage(hwndRTEdit,EM_SETMODIFY,FALSE,0);
    CloseHandle(hFile);
    fSuccess=TRUE;
  }
#ifdef USE_A_MUTEX
  ReleaseMutex(hmutexAutoSave);
#else
  LeaveCriticalSection(&csAutoSave);
#endif
  return fSuccess;
}

// In neuer Datei spaichern
VOID RTEdit_SaveFileAs(VOID);
VOID RTEdit_SaveFileAs(VOID)
{
  CHAR szSave[MAX_PATH];
  strcpy(szSave,szPathname);      // alten Namen sichern
  *szPathname=0;
  if (RTEdit_SaveFile()==FALSE) { // kein gltiger Name
    strcpy(szPathname,szSave);    // alten Namen wiederherstellen
    return;
  }
}

// Behandelt alle WM_COMMAND-Nachrichten, die von Menus oder via
// Accelerators erzeugt werden.
VOID RTEdit_OnCommand(HWND hwnd,int id,HWND hwndCtl,UINT codeNotify);
VOID RTEdit_OnCommand(HWND hwnd,int id,HWND hwndCtl,UINT codeNotify)
{
  switch (id) {
    case ID_DATEI_NEU:
      RTEdit_NewOrOpenFile(TRUE);
      break;
    case ID_DATEI_OEFFNEN:
      RTEdit_NewOrOpenFile(FALSE);
      break;
    case ID_DATEI_SPEICHERN:
      RTEdit_SaveFile();
      break;
    case ID_DATEI_SPEICHERNUNTER:
      RTEdit_SaveFileAs();
      break;
    case ID_DATEI_BEENDEN:
      // Fenster zerstren, alles weitere siehe bei WM_DESTROY
      DestroyWindow(hwnd);
      break;
    // Undo-Message an Control schicken
    case ID_BEARBEITEN_RUECKGAENGIG:
      SendMessage(hwndRTEdit,EM_UNDO,0,0);
      break;
    // Cut-Message
    case ID_BEARBEITEN_AUSSCHNEIDEN:
      SendMessage(hwndRTEdit,WM_CUT,0,0);
      break;
    // Copy-Message
    case ID_BEARBEITEN_KOPIEREN:
      SendMessage(hwndRTEdit,WM_COPY,0,0);
      break;
    // Paste-Message
    case ID_BEARBEITEN_EINFUEGEN:
      SendMessage(hwndRTEdit,WM_PASTE,0,0);
      break;
    // Clear-Message
    case ID_BEARBEITEN_LOESCHEN:
      SendMessage(hwndRTEdit,WM_CLEAR,0,0);
      break;
    // Markierung via EM_EXSETSEL setzen
    case ID_BEARBEITEN_ALLESAUSWAEHLEN: {
      CHARRANGE cr;
      cr.cpMin=0;  // 0, -1 bedeutet gesamten Text
      cr.cpMax=-1;
      SendMessage(hwndRTEdit,EM_EXSETSEL,0,(LPARAM)&cr);
      break;
      }
    case ID_BEARBEITEN_SUCHEN:
      if (hwndSearchDialog==NULL)
        hwndSearchDialog=CreateDialog(hInst,"WINEDIT_SEARCHDLG",hwndMain,
          SearchDlgProc);
      else
        SetActiveWindow(hwndSearchDialog);
      break;
    case ID_BEARBEITEN_WEITERSUCHEN:
      RTEdit_SearchNext();
      break;
    // Entsprechendes Format modifizieren
    case ID_FORMAT_FETT:
    case ID_FORMAT_KURSIV:
    case ID_FORMAT_UNTERSTRICHEN:
    case ID_FORMAT_GROESSER:
    case ID_FORMAT_KLEINER:
      RTEdit_FormatText(id);
      break;
    // WINEDIT_INFODLG als modale DialogBox anzeigen
    case ID_HILFE_INFO:
      DialogBox(hInst,     // Instanz-Handle
        "WINEDIT_INFODLG", // Name der Dialog-Ressource
        hwnd,              // Window-Handle des Parents
        InfoDlgProc);      // Dialog-Callback-Funktion
      break;
  }
}

// Behandelt WM_INITMENUPOPUP-Nachrichten und deaktiviert ggf. bestimmte
// Menueinstellungen im Bearbeiten-Menu, die zur Zeit nicht aktiviert
// werden knnen.
VOID RTEdit_OnInitMenuPopup(HWND hwnd,HMENU hMenu,UINT uItem,
  BOOL fSystemMenu);
VOID RTEdit_OnInitMenuPopup(HWND hwnd,HMENU hMenu,UINT uItem,
  BOOL fSystemMenu)
{
  if (uItem==1) { // 1 == Bearbeiten-Menu
    // Die notwendigen Informationen bei der RichEdit-Control erfragen
    BOOL f1=SendMessage(hwndRTEdit,EM_CANUNDO,0,0);  // Undo mglich?
    BOOL f2=SendMessage(hwndRTEdit,EM_CANPASTE,0,0); // Paste mglich?
    // Ist Text in der Control markiert?
    LRESULT l=SendMessage(hwndRTEdit,EM_SELECTIONTYPE,0,0);
    // Die betroffenen Menu-Eintrge entweder grau oder aktiv schalten
    EnableMenuItem(hMenu,ID_BEARBEITEN_RUECKGAENGIG,
      f1?MF_ENABLED:MF_GRAYED);
    EnableMenuItem(hMenu,ID_BEARBEITEN_AUSSCHNEIDEN,
      l!=SEL_EMPTY?MF_ENABLED:MF_GRAYED);
    EnableMenuItem(hMenu,ID_BEARBEITEN_KOPIEREN,
      l!=SEL_EMPTY?MF_ENABLED:MF_GRAYED);
    EnableMenuItem(hMenu,ID_BEARBEITEN_EINFUEGEN,
      f2?MF_ENABLED:MF_GRAYED);
  }
}

// Behandelt die WM_DESTROY-Nachricht: zerstrt den Font und legt eine
// WM_QUIT-Message in der Message-Queue ab
VOID RTEdit_OnDestroy(HWND hwnd);
VOID RTEdit_OnDestroy(HWND hwnd)
{
//Achtung neu!
  SuspendThread(hThreadAutoSave); // Thread anhalten
#ifdef USE_A_MUTEX
  // Mutex-Handle schlieen und Mutex damit freigeben
  CloseHandle(hmutexAutoSave);
#else
  // Critical Section lschen
  DeleteCriticalSection(&csAutoSave);
#endif
//Ende neu
  DeleteObject(hFont); // hFont freigeben
  PostQuitMessage(0);  // WM_QUIT in die Nachrichtenschlange legen
}

// Die Window-Prozedur fr die Applikation
LRESULT CALLBACK RTEdit_WndProc(HWND hwnd,UINT msg,WPARAM wP,LPARAM lP);
LRESULT CALLBACK RTEdit_WndProc(HWND hwnd,UINT msg,WPARAM wP,LPARAM lP)
{
  switch (msg) {
    // WM_CREATE erhlt ein Window direkt nach seiner Erzeugung, z.B. um
    // weitere Initialisierungen vorzunehmen.
    case WM_CREATE:
      return HANDLE_WM_CREATE(hwnd,wP,lP,RTEdit_OnCreate);
    // Bei jeder Vergrerung oder Verkleinerung
    case WM_SIZE:
      return HANDLE_WM_SIZE(hwnd,wP,lP,RTEdit_OnSize);
    // Wenn die Applikation den Fokus erhlt
    case WM_SETFOCUS:
      return HANDLE_WM_SETFOCUS(hwnd,wP,lP,RTEdit_OnSetFocus);
    // Signalisiert eine Menu- oder Acceleratorauswahl
    case WM_COMMAND:
      return HANDLE_WM_COMMAND(hwnd,wP,lP,RTEdit_OnCommand);
    // Ein Popup-Menu soll gleich dargestellt werden
    case WM_INITMENUPOPUP:
      return HANDLE_WM_INITMENUPOPUP(hwnd,wP,lP,RTEdit_OnInitMenuPopup);
    // Das Hauptfenster wird geschlossen, dabei wird automatisch auch das
    // RichEdit-Child-Window zerstrt.
    case WM_DESTROY:
      return HANDLE_WM_DESTROY(hwnd,wP,lP,RTEdit_OnDestroy);
  }
  // Alle anderen Nachrichten landen bei der Standard-Behandlung
  return DefWindowProc(hwnd,msg,wP,lP);
}

// Das Hauptprogramm
INT WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
  LPSTR lpCmdLine,INT nCmdShow)
{
  WNDCLASS wc;
  HACCEL hAccel;
  HINSTANCE hRichEditDLL;
  MSG msg;
  CHAR szTitle[300];
  hInst=hInstance; // Instance-Handle in globale Variable schreiben
  // RichEdit-DLL in der 32-Bit-Form laden
  hRichEditDLL=LoadLibrary("RICHED32.DLL");
  // Da RICHED32.DLL nicht auf allen 32-Bit-Systemen installiert sein
  // mu, wird das Resultat geprft
  if (hRichEditDLL==0) {
     // Nicht gefunden?
    MessageBox(NULL,"RICHED32.DLL leider, leider nicht gefunden, "
      "WinEdit wird daher beendet...",szWndTitle,MB_ICONHAND|MB_OK);
    return 0;
  }
  // Accelerator-Tabelle laden
  hAccel=LoadAccelerators(hInstance,"WINEDIT_ACCELERATORS");
  // WNDCLASS-Struktur fllen
  wc.style=CS_HREDRAW|CS_VREDRAW;   // Klassen-Optionen
  wc.lpfnWndProc=RTEdit_WndProc;    // Adresse der Window-Prozedur
  wc.cbClsExtra=0; wc.cbWndExtra=0; // ignorieren
  wc.hInstance=hInstance;           // Instanz-Handle, ignorieren
  wc.hIcon=LoadIcon(hInstance,IDI_APPLICATION); // Icon (Default)
  wc.hCursor=LoadCursor(NULL,IDC_ARROW);        // Cursor (Default)
  wc.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);    // Hintergrund (Default)
  wc.lpszMenuName="WINEDIT_HAUPTMENU";          // Name des Hauptmenus
  wc.lpszClassName=szClassName;     // Klassenname, siehe 1. Parameter
                                    // von CreateWindow()
  RegisterClass(&wc);               // Klasse bei Windows registrieren
  sprintf(szTitle,"%s - %s",szFilename,szWndTitle);
  hwndMain=CreateWindow(szClassName,     // Fenster der Klasse erzeugen
                    szTitle,     // Fenster-Titel (Window-Text)
                    WS_OVERLAPPEDWINDOW, // Fenstertyp, weitere Optionen
                    CW_USEDEFAULT,0,     // x,y-Position auf dem Schirm
                    480,320,     // Breite und Hhe (in Pixel)
                    NULL,        // Parent-Fenster (keines)
                    NULL,        // Menu-Handle (keine, siehe WNDCLASS)
                    hInstance,   // Instanz-Handle
                    NULL);       // Zustzliche Daten

  // Das Fenster wird unsichtbar erzeugt, daher sichtbar machen
  ShowWindow(hwndMain,nCmdShow); // nCmdShow: letzter WinMain()-Parameter
  // Eine Nachrichtenschleife wie aus dem Bilderbuch
  while (GetMessage(&msg,NULL,0,0)) {
    // Ggf. Dialog-Nachrichten bearbeiten
    if (hwndSearchDialog&&IsDialogMessage(hwndSearchDialog,&msg))
      continue;
    // Ggf. WM_KEYDOWN etc. in Accelerator bersetzen
    if (TranslateAccelerator(hwndMain,hAccel,&msg))
      continue;
    // Keine Dialog-Nachricht, kein Accelerator, daher mu die Message
    // bersetzt ...
    TranslateMessage(&msg);
    // und an den Adressaten weitergeleitet werden
    DispatchMessage(&msg);
  }

  // RICHED32.DLL freigeben
  FreeLibrary(hRichEditDLL);
  // Finito
  return 0;
}

