#!/bin/perl
# Programm: CT-ROBOT 

use Winsock;

# &connect_to_server(SD,$host,$port) ffnet eine TCP-Verbindung,
# Daten knnen mittels &get(SD) empfangen und mit &put(SD,$msg)
# gesendet werden.
sub connect_to_server {
  local(*SD, $host, $port) = @_;
  # Socket-Adresse aus Rechneradresse und Portnummer bestimmen
  my($server) = &get_socket_address($host,$port);
  return "Rechner $host unbekannt" if !defined $server;

  socket(SD, PF_INET, SOCK_STREAM, 0) # Socket erzeugen
    or return "Fehler in socket(2): $!";
  connect(SD, $server) # Verbindung zum Server knpfen
    or return "Fehler in connect(2): $!";

  # Ausgabepufferung fr SD-Deskriptor ausschalten
  my($old) = select(SD); $| = 1; select($old);  binmode(SD);
  $_buffer_ = ""; # Puffer fr &get() lschen
  return undef;
}

# &get_socket_address($host,$port) erzeugt eine Adresse fr
# den Systembefehl connect();
# Die Adressen werden automatisch gecached, um den Nameserver-
# Lookup zu reduzieren.
sub get_socket_address {
  my($host, $port) = @_;
  unless (exists $addr{$host,$port}) {
    my($addr) = (gethostbyname($host))[4];
    return undef if !defined $addr;
    $addr{$host,$port} = pack('S n a4 x8', AF_INET,$port,$addr);
  }
  return $addr{$host,$port};
}

# &get(SD) und &put(SD,$msg): Workaround fr Datenaustausch
# ber Sockets, da die Standard-Funktionen zum Zeilenweisen 
# Lesen bzw. Schreiben in Version 5 Build 91 von Perl fr 
# Windows NT nicht funktionieren
sub get {
  local(*SD) = @_;
  my($pos,$tmp);
  while (($pos = index($_buffer_,"\n")) < 0) {
    recv(SD,$tmp,2048,0);
    unless ($tmp eq '') {
      $_buffer_ .= $tmp;
    } else {
      # \n fehlt an Dateiende, deshalb von Hand anfgen
      return undef unless $_buffer_;
      $_buffer_ .= "\n";
    }
  }
  
  # Zeichen bis zum ersten new line lschen
  $tmp = substr($_buffer_,0,$pos+1);
  substr($_buffer_,0,$pos+1) = "";
  return $tmp;
}

sub put
{
  local(*SD,$msg) = @_;
  send(SD,$msg,0);
}

# &open_url(SD,@url) ffnet eine Verbindung zu einem HTTP-Server
# @url ist die URL-Spezifik. in der Form (Proto,Host,Part,Path),
# die von parse_url (siehe unten) zusammengestellt wird.
# Mit &get(SD) kann anschlieend der Seiteninhalt ausgelesen
# werden.
sub open_url {
  local(*FD, @url) = @_;
  my($protocol, $host, $port, $path) = @url;
  
  return "Protokoll `$protocol' wird nicht untersttzt"
    unless ($protocol =~ /^http$/i);

  # Verbindung zum HTTP-Server aufbauen
  $error = &connect_to_server(SD, $host, $port)
    and return $error;

  # Get-Request zum Server schicken
  put(SD,"GET $path HTTP/1.0\r\n");
  put(SD,"User-Agent: CT-ROBOT\r\n\r\n");

  # Server-Antwort lesen und auswerten
  if (get(SD) =~ /^HTTP\S+\s+(\d+)\s*(.*)/i) {
    my ($error_code, $error_text) = ($1, $2);
    # Im Fehlerfall (Code != 200) Meldung zurckgeben
    if ($error_code != 200) {
      return "$error_text (code = $error_code)";
    }
    # HTTP-Protokoll-Header berspringen
    while ($_ = get(SD)) {
      last if /^\r?$/;  # Leerzeile markiert Header-Ende
    }
  }
  return undef;
}

# &parse_url($url,@base) spaltet die URL-Spezifikation $url in
# die Felder (Protocol,Host,Port,Path) auf und gibt sie als
# Liste zurck.
# Mit @base kann optional eine Basisseite fr relative URLs
# definiert werden:
#  &parse_url("file", &parse_url("http://host/dir/index.html"))
#              -> ("http","host",80,"dir/file")
sub parse_url
{
  my($url, @base) = @_;
  my($protocol, $host, $port, $path);

  # Spezifikation in Komponenten auflsen
  if ($url =~
       m%(([^:]+):)?(//([^/:]+))?(:(\d+))?([^#]*)?(#.*)?$%) {
    ($protocol, $host, $port, $path) = ($2, $4, $6, $7);

    # Defaults aus @base holen
    $protocol = $base[0] if !defined($protocol);
    $host     = $base[1] if !defined($host);
    $port     = $base[2] if !defined($port);

    # Leeres Pfadfeld bedeutet "/" (= Server-Root)
    $path = "/" if !defined($path) or ($path eq '');
    # Bei relativen Pfaden Directory aus @base voranstellen
    if ($path =~ m%^[^/]%) {
      if ($base[3] =~ m%(.*)/[^/]*%) {
        $path = "$1/$path";
      }
    }
    $path =~ s%/[^/]*/?\.\.%%g; # "dir/.."-Felder strippen
    $path =~ s%//+\.?%/%g;      # Doppelte Pfadtrenner `/' entf.

    if ($protocol =~ /^http$/i) {
      # falls Port-Nummer nicht definiert, Port 80 verwenden
      $port = 80 unless defined $port;
    }
  }
  return ($protocol, $host, $port, $path);
}

# &process_url(@url) liest eine URL aus und kopiert sie in eine
# Ausgabedatei;  darberhinaus werden alle aus dieser Seite
# referenzierten URLs geladen, insofern sich diese auf dem
# gleichen Server wie die Basie-URL befinden
sub process_url {
  my(@url,@links) = @_;

  # Falls URL schon eingelesen wurde, ignorieren.
  # Dazu werden alle URLs, die gelesen werden, in dem assoz.
  # Array %processed_links mit dem Hash-Key $key eingetragen.
  my($key) = join("#",@url);    
  return 1 if exists $processed_links{$key};
  $processed_links{$key} = 1;

  # Verbindung zum HTTP-Server ffnen
  return "open_url(): $error"
    if $error = &open_url(IN, @url);

  print "Laden der URL `$url[0]://$url[1]$url[3]'\n";

  # Ausgabedatei mit Namen "Host/Pfad" ffnen
  return "open_output_file(): $error"
    if $error = &open_output_file(OUT, @url);

  %links = ();
  # Zeilenweise HTML-Seite auslesen und in Ausgabedatei kopieren
  while ($_ = get(<IN>)) {
    print OUT;

    # Querverweise aus HTML-Code extrahieren:
    # dazu zuerst Text vor und nach jedem HTML-Statement entf.
    # und Zeile in Einzelbefehle aufspalten
    s/^[^<]*<(.*)>[^>]*$/$1/;
    foreach (split(/>[^<]*</)) {

      # Statement mit HREF-Referenz scannen
      if (/^([a-z]*).*href\s*=\s*\"([^>\"]+)\"/i) {
        # Schlsselwort und URL extrahieren
        ($stmt = $1) =~ tr/[a-z]/[A-Z]/;
        @link = &parse_url($2,@url) or next;

        if ($stmt eq "BASE") { # Base-Statement;
          # ndert die Basisseite fr relative URLs
          @url = @link;
        }
        elsif ($stmt eq "A") { # Anchor-Statement;
          # enthlt Querverweis auf neue Seite
          $links{join("#",@link)} = 1; # URL zwischenspeichern
        }
      }
    }
  }

  # Rekursiv die Querverweise der aktuellen Seite bearbeiten
  unless ($flag) {
    $flag = 1;
    foreach $key (keys(%links)) {
      @link = split("#",$key);
      # Verweise auf andere Rechner ignorieren
      # ($link[1] und $url[1] sind die Rechnernamen)
      unless ($link[1] ne $url[1]) {
        &process_url(@link);
      }
    }
    $flag = 0;
  }
  return undef;
}

# &open_output_file(FD,@url): Filehandle FD fr Ausgabedatei
# der URL @url ffnen.
sub open_output_file {
  local(*FD, @url) = @_;
  # Host und Pfad-Felder zu Dateinamen verknpfen
  my($file) = $url[1] ."/".
        (($url[3] =~ m%/$%) ? "$url[3]index.html":$url[3]);
  $file =~ s%/+%\\%g; # `/' in `\' tranformieren
  my($directory,$filename) = ($file =~ m%^(.*)\\([^\\]+)%);

  # falls Directory nicht existiert, Dir-Struktur erzeugen
  if ($directory and not -d $directory) {
    my($path) = "";
    foreach $dir (split("\\\\",$directory)) {
      if (not -d ($path .= $dir)) {
        mkdir($path, 0777)
          or return "Fehler in mkdir(\"$path\"): $!";
      }
      $path .= "\\";
    }
  }
  open(FD, ">$file")
     or return "Datei kann nicht geffnet werden: $!";
  binmode(FD);
  return undef;
}

#
# Hauptprogramm
#
foreach $url (@ARGV) { # URLs aus Kommandozeile nacheinander lesen

  # URL-Spezifikation in Proto/Host/Port/Path-Feld aufspalten
  unless (@url = &parse_url($url)) {
    print "Fehlerhafte URL `$url' ignoriert.\n";
    next;
  }

  # Implementation des Robot-Ausschlu-Protokolls
  $ignore_url = $matching_agent = 0;
  # URL "/robots.txt" auf dem gleichen Server lesen
  @robot_url = (@url[0..2],"/robots.txt");
  unless ($error = &open_url(ROB, @robot_url)) {
    while ($_ = get(<ROB>)) {
      # Leerzeile markiert Ende eines Eintrags
      /^\r*$/ and do { $matching_agent = 0; next; };
      # Kommentare entfernen
      s/\s*#.*//;
      if (/^User-agent:\s*(.*)\r?/i) {
        # Falls User-Agent CT-ROBOT oder * (Wildcard) ist,
        # Disallow-Eintrag auswerten
        $matching_agent = 1
           if ($1 =~ /CT-ROBOT/i) or ($1 eq "*");
      }
      elsif ($matching_agent and /^Disallow:\s*(.*)\r?/i) {
        # URL ignorieren, falls Disallow-Feld definiert ist
        $ignore_url = 1 unless ($1 eq '');
      }
    }
  }
  if ($ignore_url) {
    print "Zugriff auf URL `$url' verweigert\n";
    next;
  }

  # URL einlesen und Querverweise auflsen
  if ($error = &process_url(@url)) {
    print "Fehler beim Lesen der URL `$url':\n$error\n";
  }
}


