/*****************************************************************************/
/* program: backp.c          * date: 29.10.94 * Autor: Hans Georg Frey       */
/*****************************************************************************/
/* Usage: Hauptprogramm zur Steuerung eines Backpropagation-Algorithmus.     */
/*        Es wird von hier aus lediglich in die jeweiligen Unterprogramme    */
/*        verzweigt. Dort befindet sich dann die "Intelligenz". Auf diese    */
/*        Weise sind die einzelnen Module relativ flexibel.                  */
/*                                                                           */
/****************** MODIFIED**************************************************/
/* date:*  By:   * what:                                             * Vers. */
/*****************************************************************************/
/*                                                                       1.0 */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>                             /** Veraltetes Listing: *     */
#include "backp.h"                             /******************************/
#include "display.h"
#include "system.h"
#include "transfer.h"
#include "train.h"
#include <stdlib.h>
#include <string.h>

int main(int argc, char argv [])       /* ACHTUNG mit 32 BIT-DOS  _cdecl nicht */
{                                      /* vergessen */
  int  ret_val;                        /* Speicher fuer Eingabetaste */
  int  i_Wahl;                         /* Eingabewahl */
  int  i;                              /* Zaehlervariable */
  char b_Beenden = FALSE;              /* Abbruch FLAG */
  char b_MusterGeladen = FALSE;        /* wurde eine Musterdatei geladen */
  int  ai_NetzSchichten[MAX_SCHICHTEN+1]; /* NeuronenAnzahl+1, 0 im letzten  */
                                       /* als Bedingung fuer Ende von Schleifen */
  NetzParameter sp_NetzParameter;      /* Alle Umgebungswerte zum Netz */
  Pattern* p_Pattern;                  /* aufnehmen der Muster */

#ifdef _OSK                            /* Es wird OS9 benutzt */
  DisplayInit();                       /* deshalb muss die termcap */
#endif                                 /* Initialisiert werden */

  for( i=0; i < MAX_SCHICHTEN + 1; i++ )    /* Anzahl der Neuronen in jeder */
    ai_NetzSchichten[i] = 0;           /* Schicht initialisieren */

  p_Pattern = NULL;                    /* Initialilisieren der Parameter */
  sp_NetzParameter.Lernrate             = LERNRATE;
  sp_NetzParameter.Momentum             = MOMENTUM;
  sp_NetzParameter.b_ZufallLernen       = FALSE;
  sp_NetzParameter.b_TrainiertesNetz    = FALSE;
  sp_NetzParameter.b_Protokoll          = FALSE;
  sp_NetzParameter.l_Perioden           = 0;
  sp_NetzParameter.i_PeriodenProAusgabe = 0;
  strcpy( sp_NetzParameter.c_MusterDatei, "\0" );
  strcpy( sp_NetzParameter.c_ProDatei, "\0" );
  sp_NetzParameter.ul_Seed              = (LONG )SEED;
  sp_NetzParameter.f_FlatSpot           = FLATSPOT;
  sp_NetzParameter.f_WeightDecay        = WEIGHTDECAY;

  do
  {                                    /* Was soll getan werden */
    i_Wahl = EingabeMaske( sp_NetzParameter, ai_NetzSchichten );
    switch( i_Wahl )
    {                                  /* (1) Netz konfigurieren */
      case '1' : bpgSpeicherFreigeben( &sp_NetzParameter );
                 sp_NetzParameter.l_Perioden = 0;
                 EingabeNetzKonf( ai_NetzSchichten, b_MusterGeladen
                                , &sp_NetzParameter );
                 break;                /* (2) Musterdaten laden */
      case '2' : if( b_MusterGeladen ) /* Dann kann der belegte Speicher */
                 {                     /* wieder freigegeben werden */
                   PatternLoeschen( p_Pattern );
                   if( sp_NetzParameter.b_TrainiertesNetz )
                   {
                     write_str( 10, 21, "Es liegt bereits ein trainiertes Netz vor." );
                     write_str( 10, 22, "Soll dieses Ueberschrieben werden?  (j/n)" );
                     do
                     {
                       n_gotoxy( 55, 21 );
                       ret_val = getchar();
                     }while( ret_val != 'j' && ret_val != 'n' );
                   }
                   if( ret_val == 'j' )
                   {
                     bpgSpeicherFreigeben( &sp_NetzParameter );
                   }
                   sp_NetzParameter.l_Perioden = 0;
                   sp_NetzParameter.i_PeriodenProAusgabe = 0;
                   b_MusterGeladen = FALSE; /* keine Muster mehr da deshalb!! */
                 }                     /* Musterdaten einlesen */
                 strcpy( sp_NetzParameter.c_MusterDatei, LEER_STRING );
                 p_Pattern = PatternLaden( ai_NetzSchichten
                                         , &sp_NetzParameter );
                 if( p_Pattern != NULL ) /* konnten die Daten gelesen werden */
                   b_MusterGeladen = TRUE;  /* Flag setzen */
                 break;
      case '3' :                       /* (3) Mit Datenstrom arbeiten */
													/* Auf dem PC wird nur Kommentar ausgegeben */
					  write_str( 10, 22, "Diese Funktion ist auf dem PC nicht verfuegbar" );
					  n_GetKey();
					  break;
      case '4' : if( b_MusterGeladen ) /* (4) Trainierte Daten laden */
                 {                     /* vorher alles alte loeschen */
                   PatternLoeschen( p_Pattern );
                   bpgSpeicherFreigeben( &sp_NetzParameter );
                 }
                 AllesZurueck( &sp_NetzParameter );
                 p_Pattern = GewichteLaden( &sp_NetzParameter, ai_NetzSchichten );
                 if( p_Pattern != NULL )
                   b_MusterGeladen = TRUE;
                 break;                /* (5) Trainierte Daten speichern */
      case '5' : if( sp_NetzParameter.b_TrainiertesNetz )
                 {
                   GewichteSpeichern( sp_NetzParameter, ai_NetzSchichten );
					  }
                 break;                /* (6) Parameter veraendern */
      case '6' : EingabeLernparameter( &sp_NetzParameter );
                 ProtokollAnlegen( &sp_NetzParameter, ai_NetzSchichten );
                 break;                /* (7) Netz trainieren */
      case '7' : if( ai_NetzSchichten[0] == 0 || ! b_MusterGeladen )
                 {                    /* gibt es etwas zum trainieren */
                   write_str( 10, 20, "Es liegt keine Netzstruktur vor oder es wurde noch keine Muster geladen" );
                   write_str( 37, 22, "Taste" );
                   n_GetKey();
                 }
                 else
                 {
                   ProtokollAnlegen( &sp_NetzParameter, ai_NetzSchichten );
						 bpgTrainieren( ai_NetzSchichten, p_Pattern, &sp_NetzParameter );
                 }
                 break;                /* (8) Netz testen */
      case '8' : if( ! b_MusterGeladen )/* Musterdaten muessen geladen sein */
                 {
                   write_str( 10, 22, "Es wurde noch kein Muster geladen" );
                   n_GetKey();
                 }
                 else if( !sp_NetzParameter.b_TrainiertesNetz )
                 {
                   write_str( 10, 23, "Es liegt kein trainiertes Netz vor" );
                   n_GetKey();
                 }
                 else
						 bpgTesten( ai_NetzSchichten, p_Pattern,
                              sp_NetzParameter, MUSTER );
                 break;                /* (9) Speicher freigeben */
      case '9' : bpgSpeicherFreigeben( &sp_NetzParameter );
                 ProtokollAnlegen( &sp_NetzParameter, ai_NetzSchichten );
                 sp_NetzParameter.l_Perioden = 0;
                 break;
      case '0' : b_Beenden = TRUE;     /* (10 ) Das Programm soll beendet werden */
                 ProtokollSchliessen();
                 break;
    }
  } while( ! b_Beenden );

  n_clrscr();                          /* Bildschirm aufraeumen */
  return( 0 );                         /* und tschuess */
}

/******************************************************************************/
void AllesZurueck( NetzParameter* sp_NetzParameter )
{                                      /* Die Netzparameter werden auf default */
                                       /* Werte gesetzt */
  sp_NetzParameter->Lernrate             = LERNRATE;
  sp_NetzParameter->Momentum             = MOMENTUM;
  sp_NetzParameter->b_ZufallLernen       = FALSE;
  sp_NetzParameter->b_Protokoll          = FALSE;
  sp_NetzParameter->b_TrainiertesNetz    = FALSE;
  sp_NetzParameter->l_Perioden           = 0;
  sp_NetzParameter->i_PeriodenProAusgabe = 0;
  sp_NetzParameter->ul_Seed              = SEED;
  sp_NetzParameter->f_FlatSpot           = FLATSPOT;
  sp_NetzParameter->f_WeightDecay        = WEIGHTDECAY;
}
