
//
// Projekt Raycast-Engine
// 1995 by Stefan Becker
//
// Player.c++
// Implementierung der Personen-Klasse
//

//
// Eigene Includes:
//

#include	"Globals.h"
#include	"Player.h"

//
// Externe Referenzen:
//

extern	WINKEL_TAB	x_winkel_tab,y_winkel_tab;	// Tabelle der Richtungsvektoren
												// (ntig fr Drehungen)
extern	MAZE		maze;						// Umgebung (ntig fr Kollisions-Check
												// mit einer Wand)

//
// Player-Kosntruktor:
//

Player::Player(void)
{
	init();		// Standard-Init-Routine
}

//
// Erweiterter Konstruktor:
//

Player::Player(int x, int y, int winkel)
{
	init();				// Standard-Init-Routine
	set(x,y,winkel);	// Diese Daten gleich bernehmen
}

//
// Destruktor:
//

Player::~Player(void)
{
	// Tut nichts.
}

//
// Methode zum Initialisieren des Spielers:
//

void Player::init(void)
{
	x = y = 150;				// Startposition bei (150,150)
	winkel = 0;					// Zu Beginn nach rechts sehen.
	rx = x_winkel_tab[winkel];	// Richtungsvektor nach rechts
	ry = y_winkel_tab[winkel];
}

//
// Methode zum Setzen der Position:
//

int Player::set(int nx, int ny, int nwinkel)
{
	int		raster_x,raster_y;

	// Pixel in Textur-Raster umrechnen:
	raster_x = nx / TEX_SIZE;
	raster_y = ny / TEX_SIZE;

	// Ist das legal?
	if((raster_x<0) || (raster_x>=MAZE_X) 	||	// X-Position legal?
	   (raster_y<0) || (raster_y>=MAZE_Y) 	||	// Y-Position legal?
	   (maze[raster_x][raster_y] != ' ')	||	// Ist da freie Flche oder eine Wand?
	   (winkel<0) || (winkel>=ANZ_WINKEL))		// Ist der Winkel korrekt?
		return false;	// Illegale Positionsangabe!

	// Position ist legal. bernehmen:
	x = nx;
	y = ny;
	winkel = nwinkel;

	// Setzen der Position war erfolgreich:
	return true;
}

//
// Methode zum Abfragen der Position
//

void Player::get(int *px, int *py, int *pwinkel)
{
	// Werte einfach auslesen:
	*px = x;
	*py = y;
	*pwinkel = winkel;	
}

//
// Methode zum Bewegen des Spielers:
//

int Player::move(char kommando)
{
	int	nx,ny,raster_x,raster_y;

	// Welches Kommando darf es denn sein?
	switch(kommando)
	{
		case	TURN_LEFT	:	// linksherum drehen:
								winkel += TURN_INC;			// So viele Winkel weiter
								if(winkel >= ANZ_WINKEL)	// Legaler Winkel?
									winkel -= ANZ_WINKEL;	// Nein: korrigieren
								rx = x_winkel_tab[winkel];	// Richtungsvektor anpassen
								ry = y_winkel_tab[winkel];
								break;
		case	TURN_RIGHT	:	// rechtsherum drehen:
								winkel -= TURN_INC;			// So viele Winkel weiter
								if(winkel < 0)				// Legaler Winkel?
									winkel += ANZ_WINKEL;	// Nein: korrigieren
								rx = x_winkel_tab[winkel];	// Richtungsvektor anpassen
								ry = y_winkel_tab[winkel];
								break;
		case	WALK_FORW	:	// vorwrts laufen: Neue Position nach einem "Schritt":
								nx = x + (int)(x_winkel_tab[winkel] * (float)WALK_INC);
								ny = y + (int)(y_winkel_tab[winkel] * (float)WALK_INC);

								// Ist das im Spielfeld?
								if((nx<0) || (nx>=MAZE_MAX_X) || (ny<0) || (ny>=MAZE_MAX_Y))
									return false;	// Nein: Da kann man nicht hin!

								// Ist im Spielfeld. Wo liegt das im Raster?
								raster_x = nx / TEX_SIZE;
								raster_y = ny / TEX_SIZE;

								// Ist da freies Feld?
								if(maze[raster_x][raster_y] != ' ')
									return false;	// Nein. Da kann man nicht hin!

								// Bewegung ist mglich. Neue Position bernehmen:
								x = nx;
								y = ny;								
								break;
		case	WALK_BACKW	:	// rckwrts laufen (daher "-" anstatt "+"):
								nx = x - (int)(x_winkel_tab[winkel] * (float)WALK_INC);
								ny = y - (int)(y_winkel_tab[winkel] * (float)WALK_INC);

								// Ist das im Spielfeld?
								if((nx<0) || (nx>=MAZE_MAX_X) || (ny<0) || (ny>=MAZE_MAX_Y))
									return false;	// Nein: Da kann man nicht hin!

								// Ist im Spielfeld. Wo liegt das im Raster?
								raster_x = nx / TEX_SIZE;
								raster_y = ny / TEX_SIZE;

								// Ist da freies Feld?
								if(maze[raster_x][raster_y] != ' ')
									return false;	// Nein. Da kann man nicht hin!

								// Bewegung ist mglich. Neue Position bernehmen:
								x = nx;
								y = ny;								
								break;
		default				:	// unbekanntes Kommando!
								return false;
	}

	// Kommando  wurde ausgefhrt!
	return true;
}

//
// Player.c++
//
