
//
// Bresenham.h
// Header fr Bresenham-Klasse
//

#include	"Globals.h"

//
// Bresenham-Subklasse fr 1. Oktanten des Kreises.
// Daraus wird spter der Bresenham-Algorithmus fr
// alle Oktanten abgeleitet.
//

class Oktal_Bresenham
{
private:			// Alle meine Daten sind sehr privat:
	int		x,y;								// aktuelle Position
	int		dx,dy;								// X/Y-Differenzen
	int		c1,c2;								// Error-Konstanten
	int		error;								// aktuelle Summe
	int		fertig;								// Haben wir den Endpunkt erreicht?
	
public:				// Alle meine Methoden sind ffentlich:
	Oktal_Bresenham(void);						// Standard-Konstruktor
   	Oktal_Bresenham(int x, int y);				// Konstruktor
	~Oktal_Bresenham(void);						// Destruktor

	virtual	void	init(void);					// Standard-Init-Routine
    virtual	void	set(int x, int y);			// Zielpunkt setzen
    virtual	int		next(int *x, int *y);		// nchsten Punkt berechnen
	virtual	void  	print(void);				// Status ausgeben (nicht implementiert)
};

//
// Klasse fr den Bresenham-Algorithmus.
// (Wird vom Oktal-Bresenham abgeleitet)
//

class Bresenham : public Oktal_Bresenham
{
private:	// Diese Variablen bestimmen die Ansteuerung des Oktal_Bresenham:
	int		swap_xy;							// Mssen x und y vertauscht werden?
	int		x_negieren;							// Mu x negiert werden?
	int		y_negieren;							// Mu y negiert werden?

public:	
	Bresenham();								// Konstruktor
	Bresenham(int x, int y);					// Konstruktor
	~Bresenham();								// Destruktor

	// Von Oktal_Bresenham vererbte Routinen:
	void	init(void);					// Standard-Init-Routine
	void	set(int x, int y);			// Zielpunkt setzen
	int		next(int *x, int *y);		// nchsten Punkt berechnen
	void  	print(void);				// Status ausgeben (nicht implememtiert)
};

//
// Bresenham.h
//
