
//
// Projekt Raycast-Engine
// 1995 by Stefan Becker
//
// Bresenham.c++
// Klasse fr Oktal_Bresenham-Algorithmus
//

#include	"Bresenham.h"	// Typdeklaration der Klassen

#include	<stdio.h>		// Der bliche I/O-Kram

//
// Standard-Init-Routine
//

void Oktal_Bresenham::init(void)
{
	x = y = dx = dy = error = c1 = c2 = fertig = 0;	// Alles Ausnullen
}

//
// Standard-Konstruktor
//

Oktal_Bresenham::Oktal_Bresenham(void)
{
	init();		// init-Routine aufrufen
}

//
// Ziel definieren:
//

void Oktal_Bresenham::set(int nx, int ny)
{
	// Legaler Aufruf?
	if((nx<0) || (ny<0) || (ny>nx))
		fatal_error("Falscher Aufruf von Oktal_Bresenham::set!");

	// Variablen rcksetzen
	Oktal_Bresenham::init();

	// Daten bernehmen:
	dx = nx;	dy = ny;

	// ErrorSumme und Konstanten noch richtig setzen:
	c1 = 2 * dy;
	error = c1 - dx;
	c2 = error - dx;	
}

//
// Konstruktor mit Zieldefinition
//

Oktal_Bresenham::Oktal_Bresenham(int nx, int ny)
{
	init();			// zuerst die Init-Routine aufrufen und
	set(nx,ny);		// dann ustzlich dx und dy setzen:
}

//
// Nchsten Bresenham-Punkt generieren:
//

int Oktal_Bresenham::next(int *nx, int *ny)
{
	// Sind wir schon fertig?
	if(fertig)
		return FALSE;	// Hier ist fr alle weiteren Aufrufe Ende!

	// Ab hier in jedem Fall die aktuelle Position liefern
	*nx = x;
	*ny = y;

	// Sind wir schon fertig?
	if(x >= dx)					// Sind wir am Endpunkt angelangt?
	{
		fertig = TRUE;			// Merken, da hier Ende ist.
		return TRUE;			// Aber dieser Punkt ist noch gltig!
	}

	// Wir sind immer noch nicht fertig. In X-Richtung aufwrts laufen:
	x++;						// Schritt nach rechts
	if(error < 0)				// Error ggf. erhhen
		error += c1;
	else
	{
		y++;					// Auch ein Schritt nach oben
		error += c2;			// Fehler vermerken.
	}

	return TRUE;	// Es geht danach noch weiter!
}

//
// Informationen ausgeben:
//

void Oktal_Bresenham::print(void)
{
	// Tut momentan nichts
}

//
// Destruktor
//

Oktal_Bresenham::~Oktal_Bresenham(void)
{
	// Macht nichts
}

// ----------------------------------------------------
// Nun die Methoden der abgeleiteten Bresenham-Klasse:
// ----------------------------------------------------

//
// Konstruktoren/Init-Routinen:
//

void Bresenham::init(void)
{
	// Alte Init-Routine aufrufen:
	Oktal_Bresenham::init();

	// Klassenvariablen ausnullen:
	swap_xy = x_negieren = y_negieren = 0;
}

Bresenham::Bresenham(void)
{
	init();							// neue Variablen setzen
}

Bresenham::Bresenham(int nx, int ny)
{
	init();							// neue Variablen setzen
	set(nx,ny);						// X/Y-Werte setzen
}

//
// Destruktor:
//

Bresenham::~Bresenham(void)
{
	// Tut nichts
}

//
// Werte setzen:
//

void Bresenham::set(int nx, int ny)
{
	int		h;

	// Erstmal ein Init:
	init();

	// Werte fr Oktanten passend flschen:

	// Mu x negiert werden?
	if(nx < 0)
	{
		// x negieren:
		x_negieren = TRUE;
		nx = -nx;
	}

	// Mu y negiert werden?
	if(ny < 0)
	{
		// y negieren:
		y_negieren = TRUE;
		ny = -ny;
	}

	// Mssen x und y vertauscht werden?
	if(ABS(nx) < ABS(ny))
	{
		// x und y vertauschen:
		swap_xy = TRUE;
		h = nx;
		nx = ny;
		ny = h;
	}

	// Die geflschten Werte an Oktal_Bresenham weiterreichen:
	Oktal_Bresenham::set(nx,ny);
}

//
// Nchsten Punkt holen:
//

int Bresenham::next(int *nx, int *ny)
{
	int		h,fertig;

	// Oktal_Bresenham aufrufen:
	fertig = Oktal_Bresenham::next(nx,ny);

	// x/y-Werte passend "zurckflschen":

	// Mssen x und y vertauscht werden?
	if(swap_xy)
	{
		// x und y vertauschen:
		h = *nx;
		*nx = *ny;
		*ny = h;
	}

	// Mu x negiert werden?
	if(x_negieren)
		*nx = -*nx;		// negieren

	// Mu y negiert werden?
	if(y_negieren)
		*ny = -*ny;		// negieren

	// Ergebnis des Oktal_Bresenham liefern:
	return fertig;
}

//
// Werte ausgeben:
//

void Bresenham::print(void)
{
	Oktal_Bresenham::print();		// Alte Methode aufrufen

	// Tut momentan nichts
}

//
// Bresenham.c++
//
