/* tonline.cmd: Internet-Zugang ber T-Online. */
/* Von Harald Bgeholz / c't                   */
parse arg interface

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs
                              /* geeignet anpassen: */
anschluss="xxxxxxxxxxxx"      /* Anschlukennung */
mitbenutzer="xxxx"            /* Mitbenutzernummer */
password="xxxxxxxx"           /* Kennwort */

cr="0d"x 
crlf="0d0a"x
escseq="[?25h"                /* Btx-Eingabeaufforderung */

call flush_receive            /* Puffer leeren */

call send "ATZ" || cr         /* Modem initialisieren */
call waitfor "OK", 5
if rc=1 then signal failure
call send "atdt0w051119304" || cr      /* whlen */
call waitfor "CONNECT"
call waitfor crlf
say "Connect erfolgreich."
call SysSleep 2               /* 2 Sekunden warten */
call send "."                 /* . senden */
call SysSleep 1               /* 1 Sekunde warten */
call send cr                  /* cr senden */
call waitfor escseq, 20
if rc=1 then signal failure
if pos("kennung:", waitfor_buffer) = 0 then signal failure
say "Anschlukennung"
call send anschluss           /* Anschlukennung senden */
call waitfor escseq, 10
if rc=1 then signal failure
if pos("Mitbenutzer", waitfor_buffer) = 0 then signal failure
say "Mitbenutzer senden..."
call send mitbenutzer         /* Mitbenutzer senden */
if length(mitbenutzer)<4 then call send cr
call waitfor escseq, 10
if rc=1 then signal failure
if pos("[21;21H", waitfor_buffer) = 0 then signal failure
say "Passwort senden..."
call send password            /* Password senden */
if length(password)<8 then call send cr
call waitfor escseq, 10
if rc=1 then signal failure
say "TD-Vorwarnung abschalten..."
call send "*53#" || cr
call waitfor escseq, 10
if rc=1 then signal failure
if pos("ausgeschaltet", waitfor_buffer) = 0 then signal failure
say "Gateway-Seite aufrufen..."
call send "*190144100#" || cr
call waitfor escseq, 10
if rc=1 then signal failure
if pos("ER-Verb", waitfor_buffer) = 0 then signal failure
say "Gebhrenbesttigung..."
call send "19"
call waitfor "STATUS OK", 10
if rc=1 then signal failure
call waitfor crlf
say "LIN..."
call send "LIN" || cr
do forever
  call waitfor crlf
  parse var waitfor_buffer a " " b "0d0a"x
  if a = "." || "0d0a"x then leave
  select
    when a = "YOURIP" then myip=b
    when a = "DESTIP" then destip=b
    when a = "NETMASK" then netmask=b
    otherwise /* sonstigen Kram ignorieren */
  end
end
say "2. Phase"
do forever
  call waitfor crlf
  parse var waitfor_buffer a " " b "0d0a"x
  if a = "." || "0d0a"x then leave
end
call send "OK" || cr

"ifconfig" interface myip destip "netmask" netmask
"route add default" destip "1"

say "SLIP-Verbindung aufgebaut."
exit 0

failure:
say "Mist! Schiefgegangen!"
exit 1


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC



/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

readpass:

  answer = ''
  do until key = cr
    key = slip_getch()
    if key \= cr then do
      answer = answer || key
    end
  end
  say ''
  return answer


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Eat anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
