/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     statbar.c                                                        *
*  Aufgabe:   Statusbar (_sehr_ einfach gehalten)                              *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "statbar.h"
#include "debug.h"

#define ID_TEXT  999

MRESULT EXPENTRY statusbarWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

/* Name     : registerStatusbar
** Task     : registieren des Statusbars (so noch nicht geschehen)
** Input    : HAB hab                   - handle anchor block
*/
void registerStatusbar(HAB hab)
  {
  static BOOL registered=FALSE;

  if (!registered)
      WinRegisterClass(hab, "ctStatusbar", statusbarWndProc, 0, 0);
  } /* registerStatusbar */


/* Name     : statusbarWndProc
** Task     : window procedure des status bars
** Input    : HWND hwnd                 - window handle
              ULONG msg                 - Message
              MPARAM mp1                - Parameter 1
              MPARAM mp2                - Paramater 2
** Output   : gem window procedure
*/
MRESULT EXPENTRY statusbarWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
   {
   HWND hwndText;
   switch(msg)
     {
     /* WM_CREATE wird geschickt, wenn das Fenster kreiiert wird */
     case WM_CREATE:
                /* Child soll ein static Textfenster sein */
                hwndText=WinCreateWindow(hwnd,
                             WC_STATIC,
                             "c't Editor",
                             SS_TEXT|WS_VISIBLE,
                             0,
                             0,
                             2000,
                             20,
                             hwnd,
                             HWND_TOP,
                             ID_TEXT,
                             0L,
                             NULL);
                 ensure(validwin(hwndText));
        break;

    /* WM_SIZE wird bei jeder Grenvernderung geschickt */
    case WM_SIZE:
         {
         /* Ermittle aktuelle Gre aus den Parametern */
         int cx=SHORT1FROMMP(mp2);
         int cy=SHORT2FROMMP(mp2);
         ensure(cx>=0 && cy>=0);

         hwndText=WinWindowFromID(hwnd, ID_TEXT);
         ensure(validwin(hwndText));
         WinSetWindowPos(hwndText,HWND_TOP,0,0,cx,cy, SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         } /* endswitch: msg */
       break;

    /* interne Message: Setzte neuen Fenstertext im Statusbereich */
    case SB_SETTEXT:
       hwndText=WinWindowFromID(hwnd, ID_TEXT);
       ensure(validwin(hwndText));
       ensure(validread(mp1));
       WinSetWindowText(hwndText, mp1);
       break;
    default:
       return(WinDefWindowProc(hwnd,msg,mp1,mp2));
     } /* statusbarWndProc */
   return FALSE;
   }
