#ifndef _SEMAPHORE_H_
#define _SEMAPHORE_H_

#include "debug.h"

class CritSection {
public:
  CritSection()  { DosEnterCritSec(); }
  ~CritSection() { DosExitCritSec(); }
};

class Mutex {
  HMTX sema4;
public:
  Mutex(int init=0, char *name=0) { DosCreateMutexSem((PSZ)name, &sema4, 0, init); }
  ~Mutex() { DosCloseMutexSem(sema4); }
  APIRET request(ULONG timeout=SEM_INDEFINITE_WAIT)
     {
     return DosRequestMutexSem(sema4, timeout); }
  APIRET release() { return DosReleaseMutexSem(sema4); }
};

class EventSem {
  HEV sema4;
public:
  EventSem(int init=1, char *name=0)
     { DosCreateEventSem((PSZ)name, &sema4, DC_SEM_SHARED, init); }
  ~EventSem() { DosCloseEventSem(sema4); }
  APIRET post() { return DosPostEventSem(sema4); }
  APIRET reset() { ULONG posted; return DosResetEventSem(sema4, &posted); }
  APIRET reset(ULONG& posted) { return DosResetEventSem(sema4, &posted); }
  ULONG  query() { ULONG posted; DosQueryEventSem(sema4, &posted);
                   return posted; }
  APIRET wait(ULONG timeout=SEM_INDEFINITE_WAIT)
                 { return DosWaitEventSem(sema4, timeout); }
};

#endif
