#include "common.h"
#include "menu.h"

void setConditionalMenu(HWND hwndFrame, ULONG id_submenu, ULONG id_default)
  {
  MENUITEM menuitem;
  HWND hwndMenu;
  ULONG style;

  hwndMenu=WinWindowFromID(hwndFrame, FID_MENU);
  WinSendMsg(hwndMenu, MM_QUERYITEM,
             MPFROM2SHORT(id_submenu, TRUE),
             MPFROMP(&menuitem));

  style=WinQueryWindowULong(menuitem.hwndSubMenu, QWL_STYLE);
  WinSetWindowULong(menuitem.hwndSubMenu,
                    QWL_STYLE, style|MS_CONDITIONALCASCADE);
  WinSendMsg(menuitem.hwndSubMenu, MM_SETDEFAULTITEMID, (MPARAM)id_default, 0);
  }

void setMenuAttrib(HWND hwndFrame, USHORT id, USHORT attrib, BOOL set)
  {
  HWND hwndMenu;
  hwndMenu=WinWindowFromID(hwndFrame, FID_MENU);
  WinSendMsg(hwndMenu, MM_SETITEMATTR,
                       MPFROM2SHORT(id, TRUE),
                       MPFROM2SHORT(attrib, set ? attrib : ~attrib));
  }

void setMenuChecked(HWND hwndFrame, USHORT id, BOOL set)
  {
  setMenuAttrib(hwndFrame,id, MIA_CHECKED, set);
  }
