#ifndef _ERRCODES_H_
#define _ERRCODES_H_

static char *pmerror(unsigned short rc)
  {
  switch(rc)
     {
     case 0x1001: return "PMERR_INVALID_HWND";
     case 0x1002: return "PMERR_INVALID_HMQ";
     case 0x1003: return "PMERR_PARAMETER_OUT_OF_RANGE";
     case 0x1004: return "PMERR_WINDOW_LOCK_UNDERFLOW";
     case 0x1005: return "PMERR_WINDOW_LOCK_OVERFLOW";
     case 0x1006: return "PMERR_BAD_WINDOW_LOCK_COUNT";
     case 0x1007: return "PMERR_WINDOW_NOT_LOCKED";
     case 0x1008: return "PMERR_INVALID_SELECTOR";
     case 0x1009: return "PMERR_CALL_FROM_WRONG_THREAD";
     case 0x100A: return "PMERR_RESOURCE_NOT_FOUND";
     case 0x100B: return "PMERR_INVALID_STRING_PARM";
     case 0x100C: return "PMERR_INVALID_HHEAP";
     case 0x100D: return "PMERR_INVALID_HEAP_POINTER";
     case 0x100E: return "PMERR_INVALID_HEAP_SIZE_PARM";
     case 0x100F: return "PMERR_INVALID_HEAP_SIZE";
     case 0x1010: return "PMERR_INVALID_HEAP_SIZE_WORD";
     case 0x1011: return "PMERR_HEAP_OUT_OF_MEMORY";
     case 0x1012: return "PMERR_HEAP_MAX_SIZE_REACHED";
     case 0x1013: return "PMERR_INVALID_HATOMTBL";
     case 0x1014: return "PMERR_INVALID_ATOM";
     case 0x1015: return "PMERR_INVALID_ATOM_NAME";
     case 0x1016: return "PMERR_INVALID_INTEGER_ATOM";
     case 0x1017: return "PMERR_ATOM_NAME_NOT_FOUND";
     case 0x1018: return "PMERR_QUEUE_TOO_LARGE";
     case 0x1019: return "PMERR_INVALID_FLAG";
     case 0x101A: return "PMERR_INVALID_HACCEL";
     case 0x101B: return "PMERR_INVALID_HPTR";
     case 0x101C: return "PMERR_INVALID_HENUM";
     case 0x101D: return "PMERR_INVALID_SRC_CODEPAGE";
     case 0x101E: return "PMERR_INVALID_DST_CODEPAGE";
     case 0x101f: return "PMERR_UNKNOWN_COMPONENT_ID";
     case 0x1020: return "PMERR_UNKNOWN_ERROR_CODE";
     case 0x1021: return "PMERR_SEVERITY_LEVELS";
     case 0x1034: return "PMERR_INVALID_RESOURCE_FORMAT";
     case 0x1036: return "PMERR_NO_MSG_QUEUE";
     case 0x1037: return "PMERR_WIN_DEBUGMSG";
     case 0x1038: return "PMERR_QUEUE_FULL";
     case 0x1039: return "PMERR_LIBRARY_LOAD_FAILED";
     case 0x103A: return "PMERR_PROCEDURE_LOAD_FAILED";
     case 0x103B: return "PMERR_LIBRARY_DELETE_FAILED";
     case 0x103C: return "PMERR_PROCEDURE_DELETE_FAILED";
     case 0x103D: return "PMERR_ARRAY_TOO_LARGE";
     case 0x103E: return "PMERR_ARRAY_TOO_SMALL";
     case 0x103F: return "PMERR_DATATYPE_ENTRY_BAD_INDEX";
     case 0x1040: return "PMERR_DATATYPE_ENTRY_CTL_BAD";
     case 0x1041: return "PMERR_DATATYPE_ENTRY_CTL_MISS";
     case 0x1042: return "PMERR_DATATYPE_ENTRY_INVALID";
     case 0x1043: return "PMERR_DATATYPE_ENTRY_NOT_NUM";
     case 0x1044: return "PMERR_DATATYPE_ENTRY_NOT_OFF";
     case 0x1045: return "PMERR_DATATYPE_INVALID";
     case 0x1046: return "PMERR_DATATYPE_NOT_UNIQUE";
     case 0x1047: return "PMERR_DATATYPE_TOO_LONG";
     case 0x1048: return "PMERR_DATATYPE_TOO_SMALL";
     case 0x1049: return "PMERR_DIRECTION_INVALID";
     case 0x104A: return "PMERR_INVALID_HAB";
     case 0x104D: return "PMERR_INVALID_HSTRUCT";
     case 0x104E: return "PMERR_LENGTH_TOO_SMALL";
     case 0x104F: return "PMERR_MSGID_TOO_SMALL";
     case 0x1050: return "PMERR_NO_HANDLE_ALLOC";
     case 0x1051: return "PMERR_NOT_IN_A_PM_SESSION";
     case 0x1052: return "PMERR_MSG_QUEUE_ALREADY_EXISTS";
     case 0x1055: return "PMERR_OLD_RESOURCE";
     case 0x1101: return "PMERR_INVALID_PIB";
     case 0x1102: return "PMERR_INSUFF_SPACE_TO_ADD";
     case 0x1103: return "PMERR_INVALID_GROUP_HANDLE";
     case 0x1104: return "PMERR_DUPLICATE_TITLE";
     case 0x1105: return "PMERR_INVALID_TITLE";
     case 0x1107: return "PMERR_HANDLE_NOT_IN_GROUP";
     case 0x1106: return "PMERR_INVALID_TARGET_HANDLE";
     case 0x1108: return "PMERR_INVALID_PATH_STATEMENT";
     case 0x1109: return "PMERR_NO_PROGRAM_FOUND";
     case 0x110A: return "PMERR_INVALID_BUFFER_SIZE";
     case 0x110B: return "PMERR_BUFFER_TOO_SMALL";
     case 0x110C: return "PMERR_PL_INITIALISATION_FAIL";
     case 0x110D: return "PMERR_CANT_DESTROY_SYS_GROUP";
     case 0x110E: return "PMERR_INVALID_TYPE_CHANGE";
     case 0x110F: return "PMERR_INVALID_PROGRAM_HANDLE";
     case 0x1110: return "PMERR_NOT_CURRENT_PL_VERSION";
     case 0x1111: return "PMERR_INVALID_CIRCULAR_REF";
     case 0x1112: return "PMERR_MEMORY_ALLOCATION_ERR";
     case 0x1113: return "PMERR_MEMORY_DEALLOCATION_ERR";
     case 0x1114: return "PMERR_TASK_HEADER_TOO_BIG";
     case 0x1115: return "PMERR_INVALID_INI_FILE_HANDLE";
     case 0x1116: return "PMERR_MEMORY_SHARE";
     case 0x1117: return "PMERR_OPEN_QUEUE";
     case 0x1118: return "PMERR_CREATE_QUEUE";
     case 0x1119: return "PMERR_WRITE_QUEUE";
     case 0x111A: return "PMERR_READ_QUEUE";
     case 0x111B: return "PMERR_CALL_NOT_EXECUTED";
     case 0x111C: return "PMERR_UNKNOWN_APIPKT";
     case 0x111D: return "PMERR_INITHREAD_EXISTS";
     case 0x111E: return "PMERR_CREATE_THREAD";
     case 0x111F: return "PMERR_NO_HK_PROFILE_INSTALLED";
     case 0x1120: return "PMERR_INVALID_DIRECTORY";
     case 0x1121: return "PMERR_WILDCARD_IN_FILENAME";
     case 0x1122: return "PMERR_FILENAME_BUFFER_FULL";
     case 0x1123: return "PMERR_FILENAME_TOO_LONG";
     case 0x1124: return "PMERR_INI_FILE_IS_SYS_OR_USER";
     case 0x1125: return "PMERR_BROADCAST_PLMSG";
     case 0x1126: return "PMERR_190_INIT_DONE";
     case 0x1127: return "PMERR_HMOD_FOR_PMSHAPI";
     case 0x1128: return "PMERR_SET_HK_PROFILE";
     case 0x1129: return "PMERR_API_NOT_ALLOWED";
     case 0x112A: return "PMERR_INI_STILL_OPEN";
     case 0x112B: return "PMERR_PROGDETAILS_NOT_IN_INI";
     case 0x112C: return "PMERR_PIBSTRUCT_NOT_IN_INI";
     case 0x112D: return "PMERR_INVALID_DISKPROGDETAILS";
     case 0x112E: return "PMERR_PROGDETAILS_READ_FAILURE";
     case 0x112F: return "PMERR_PROGDETAILS_WRITE_FAILURE";
     case 0x1130: return "PMERR_PROGDETAILS_QSIZE_FAILURE";
     case 0x1131: return "PMERR_INVALID_PROGDETAILS";
     case 0x1132: return "PMERR_SHEPROFILEHOOK_NOT_FOUND";
     case 0x1133: return "PMERR_190PLCONVERTED";
     case 0x1134: return "PMERR_FAILED_TO_CONVERT_INI_PL";
     case 0x1135: return "PMERR_PMSHAPI_NOT_INITIALISED";
     case 0x1136: return "PMERR_INVALID_SHELL_API_HOOK_ID";
     case 0x1200: return "PMERR_DOS_ERROR";
     case 0x1201: return "PMERR_NO_SPACE";
     case 0x1202: return "PMERR_INVALID_SWITCH_HANDLE";
     case 0x1203: return "PMERR_NO_HANDLE";
     case 0x1204: return "PMERR_INVALID_PROCESS_ID";
     case 0x1205: return "PMERR_NOT_SHELL";
     case 0x1206: return "PMERR_INVALID_WINDOW";
     case 0x1207: return "PMERR_INVALID_POST_MSG";
     case 0x1208: return "PMERR_INVALID_PARAMETERS";
     case 0x1209: return "PMERR_INVALID_PROGRAM_TYPE";
     case 0x120A: return "PMERR_NOT_EXTENDED_FOCUS";
     case 0x120B: return "PMERR_INVALID_SESSION_ID";
     case 0x120C: return "PMERR_SMG_INVALID_ICON_FILE";
     case 0x120D: return "PMERR_SMG_ICON_NOT_CREATED";
     case 0x120E: return "PMERR_SHL_DEBUG";
     case 0x1301: return "PMERR_OPENING_INI_FILE";
     case 0x1302: return "PMERR_INI_FILE_CORRUPT";
     case 0x1303: return "PMERR_INVALID_PARM";
     case 0x1304: return "PMERR_NOT_IN_IDX";
     case 0x1305: return "PMERR_NO_ENTRIES_IN_GROUP";
     case 0x1306: return "PMERR_INI_WRITE_FAIL";
     case 0x1307: return "PMERR_IDX_FULL";
     case 0x1308: return "PMERR_INI_PROTECTED";
     case 0x1309: return "PMERR_MEMORY_ALLOC";
     case 0x130A: return "PMERR_INI_INIT_ALREADY_DONE";
     case 0x130B: return "PMERR_INVALID_INTEGER";
     case 0x130C: return "PMERR_INVALID_ASCIIZ";
     case 0x130D: return "PMERR_CAN_NOT_CALL_SPOOLER";
     case 0x1401: return "PMERR_WARNING_WINDOW_NOT_KILLED";
     case 0x1402: return "PMERR_ERROR_INVALID_WINDOW";
     case 0x1403: return "PMERR_ALREADY_INITIALIZED";
     case 0x1405: return "PMERR_MSG_PROG_NO_MOU";
     case 0x1406: return "PMERR_MSG_PROG_NON_RECOV";
     case 0x1407: return "PMERR_WINCONV_INVALID_PATH";
     case 0x1408: return "PMERR_PI_NOT_INITIALISED";
     case 0x1409: return "PMERR_PL_NOT_INITIALISED";
     case 0x140A: return "PMERR_NO_TASK_MANAGER";
     case 0x140B: return "PMERR_SAVE_NOT_IN_PROGRESS";
     case 0x140C: return "PMERR_NO_STACK_SPACE";
     case 0x140d: return "PMERR_INVALID_COLR_FIELD";
     case 0x140e: return "PMERR_INVALID_COLR_VALUE";
     case 0x140f: return "PMERR_COLR_WRITE";
     case 0x1501: return "PMERR_TARGET_FILE_EXISTS";
     case 0x1502: return "PMERR_SOURCE_SAME_AS_TARGET";
     case 0x1503: return "PMERR_SOURCE_FILE_NOT_FOUND";
     case 0x1504: return "PMERR_INVALID_NEW_PATH";
     case 0x1505: return "PMERR_TARGET_FILE_NOT_FOUND";
     case 0x1506: return "PMERR_INVALID_DRIVE_NUMBER";
     case 0x1507: return "PMERR_NAME_TOO_LONG";
     case 0x1508: return "PMERR_NOT_ENOUGH_ROOM_ON_DISK";
     case 0x1509: return "PMERR_NOT_ENOUGH_MEM";
     case 0x150B: return "PMERR_LOG_DRV_DOES_NOT_EXIST";
     case 0x150C: return "PMERR_INVALID_DRIVE";
     case 0x150D: return "PMERR_ACCESS_DENIED";
     case 0x150E: return "PMERR_NO_FIRST_SLASH";
     case 0x150F: return "PMERR_READ_ONLY_FILE";
     case 0x151F: return "PMERR_GROUP_PROTECTED";
     case 0x152F: return "PMERR_INVALID_PROGRAM_CATEGORY";
     case 0x1530: return "PMERR_INVALID_APPL";
     case 0x1531: return "PMERR_CANNOT_START";
     case 0x1532: return "PMERR_STARTED_IN_BACKGROUND";
     case 0x1533: return "PMERR_INVALID_HAPP";
     case 0x1534: return "PMERR_CANNOT_STOP";
     case 0x1601: return "PMERR_INTERNAL_ERROR_1";
     case 0x1602: return "PMERR_INTERNAL_ERROR_2";
     case 0x1603: return "PMERR_INTERNAL_ERROR_3";
     case 0x1604: return "PMERR_INTERNAL_ERROR_4";
     case 0x1605: return "PMERR_INTERNAL_ERROR_5";
     case 0x1606: return "PMERR_INTERNAL_ERROR_6";
     case 0x1607: return "PMERR_INTERNAL_ERROR_7";
     case 0x1608: return "PMERR_INTERNAL_ERROR_8";
     case 0x1609: return "PMERR_INTERNAL_ERROR_9";
     case 0x160A: return "PMERR_INTERNAL_ERROR_10";
     case 0x160B: return "PMERR_INTERNAL_ERROR_11";
     case 0x160C: return "PMERR_INTERNAL_ERROR_12";
     case 0x160D: return "PMERR_INTERNAL_ERROR_13";
     case 0x160E: return "PMERR_INTERNAL_ERROR_14";
     case 0x160F: return "PMERR_INTERNAL_ERROR_15";
     case 0x1610: return "PMERR_INTERNAL_ERROR_16";
     case 0x1611: return "PMERR_INTERNAL_ERROR_17";
     case 0x1612: return "PMERR_INTERNAL_ERROR_18";
     case 0x1613: return "PMERR_INTERNAL_ERROR_19";
     case 0x1614: return "PMERR_INTERNAL_ERROR_20";
     case 0x1615: return "PMERR_INTERNAL_ERROR_21";
     case 0x1616: return "PMERR_INTERNAL_ERROR_22";
     case 0x1617: return "PMERR_INTERNAL_ERROR_23";
     case 0x1618: return "PMERR_INTERNAL_ERROR_24";
     case 0x1619: return "PMERR_INTERNAL_ERROR_25";
     case 0x161A: return "PMERR_INTERNAL_ERROR_26";
     case 0x161B: return "PMERR_INTERNAL_ERROR_27";
     case 0x161C: return "PMERR_INTERNAL_ERROR_28";
     case 0x161D: return "PMERR_INTERNAL_ERROR_29";
     case 0x1630: return "PMERR_INVALID_FREE_MESSAGE_ID";
     case 0x1641: return "PMERR_FUNCTION_NOT_SUPPORTED";
     case 0x1642: return "PMERR_INVALID_ARRAY_COUNT";
     case 0x1643: return "PMERR_INVALID_LENGTH";
     case 0x1644: return "PMERR_INVALID_BUNDLE_TYPE";
     case 0x1645: return "PMERR_INVALID_PARAMETER";
     case 0x1646: return "PMERR_INVALID_NUMBER_OF_PARMS";
     case 0x1647: return "PMERR_GREATER_THAN_64K";
     case 0x1648: return "PMERR_INVALID_PARAMETER_TYPE";
     case 0x1649: return "PMERR_NEGATIVE_STRCOND_DIM";
     case 0x164A: return "PMERR_INVALID_NUMBER_OF_TYPES";
     case 0x164B: return "PMERR_INCORRECT_HSTRUCT";
     case 0x164C: return "PMERR_INVALID_ARRAY_SIZE";
     case 0x164D: return "PMERR_INVALID_CONTROL_DATATYPE";
     case 0x164E: return "PMERR_INCOMPLETE_CONTROL_SEQU";
     case 0x164F: return "PMERR_INVALID_DATATYPE";
     case 0x1650: return "PMERR_INCORRECT_DATATYPE";
     case 0x1651: return "PMERR_NOT_SELF_DESCRIBING_DTYP";
     case 0x1652: return "PMERR_INVALID_CTRL_SEQ_INDEX";
     case 0x1653: return "PMERR_INVALID_TYPE_FOR_LENGTH";
     case 0x1654: return "PMERR_INVALID_TYPE_FOR_OFFSET";
     case 0x1655: return "PMERR_INVALID_TYPE_FOR_MPARAM";
     case 0x1656: return "PMERR_INVALID_MESSAGE_ID";
     case 0x1657: return "PMERR_C_LENGTH_TOO_SMALL";
     case 0x1658: return "PMERR_APPL_STRUCTURE_TOO_SMALL";
     case 0x1659: return "PMERR_INVALID_ERRORINFO_HANDLE";
     case 0x165A: return "PMERR_INVALID_CHARACTER_INDEX";
     case 0x0000: return "PMERR_OK";
     case 0x2001: return "PMERR_ALREADY_IN_AREA";
     case 0x2002: return "PMERR_ALREADY_IN_ELEMENT";
     case 0x2003: return "PMERR_ALREADY_IN_PATH";
     case 0x2004: return "PMERR_ALREADY_IN_SEG";
     case 0x2005: return "PMERR_AREA_INCOMPLETE";
     case 0x2006: return "PMERR_BASE_ERROR";
     case 0x2007: return "PMERR_BITBLT_LENGTH_EXCEEDED";
     case 0x2008: return "PMERR_BITMAP_IN_USE";
     case 0x2009: return "PMERR_BITMAP_IS_SELECTED";
     case 0x200A: return "PMERR_BITMAP_NOT_FOUND";
     case 0x200B: return "PMERR_BITMAP_NOT_SELECTED";
     case 0x200C: return "PMERR_BOUNDS_OVERFLOW";
     case 0x200D: return "PMERR_CALLED_SEG_IS_CHAINED";
     case 0x200E: return "PMERR_CALLED_SEG_IS_CURRENT";
     case 0x200F: return "PMERR_CALLED_SEG_NOT_FOUND";
     case 0x2010: return "PMERR_CANNOT_DELETE_ALL_DATA";
     case 0x2011: return "PMERR_CANNOT_REPLACE_ELEMENT_0";
     case 0x2012: return "PMERR_COL_TABLE_NOT_REALIZABLE";
     case 0x2013: return "PMERR_COL_TABLE_NOT_REALIZED";
     case 0x2014: return "PMERR_COORDINATE_OVERFLOW";
     case 0x2015: return "PMERR_CORR_FORMAT_MISMATCH";
     case 0x2016: return "PMERR_DATA_TOO_LONG";
     case 0x2017: return "PMERR_DC_IS_ASSOCIATED";
     case 0x2018: return "PMERR_DESC_STRING_TRUNCATED";
     case 0x2019: return "PMERR_DEVICE_DRIVER_ERROR_1";
     case 0x201A: return "PMERR_DEVICE_DRIVER_ERROR_2";
     case 0x201B: return "PMERR_DEVICE_DRIVER_ERROR_3";
     case 0x201C: return "PMERR_DEVICE_DRIVER_ERROR_4";
     case 0x201D: return "PMERR_DEVICE_DRIVER_ERROR_5";
     case 0x201E: return "PMERR_DEVICE_DRIVER_ERROR_6";
     case 0x201F: return "PMERR_DEVICE_DRIVER_ERROR_7";
     case 0x2020: return "PMERR_DEVICE_DRIVER_ERROR_8";
     case 0x2021: return "PMERR_DEVICE_DRIVER_ERROR_9";
     case 0x2022: return "PMERR_DEVICE_DRIVER_ERROR_10";
     case 0x2023: return "PMERR_DEV_FUNC_NOT_INSTALLED";
     case 0x2024: return "PMERR_DOSOPEN_FAILURE";
     case 0x2025: return "PMERR_DOSREAD_FAILURE";
     case 0x2026: return "PMERR_DRIVER_NOT_FOUND";
     case 0x2027: return "PMERR_DUP_SEG";
     case 0x2028: return "PMERR_DYNAMIC_SEG_SEQ_ERROR";
     case 0x2029: return "PMERR_DYNAMIC_SEG_ZERO_INV";
     case 0x202A: return "PMERR_ELEMENT_INCOMPLETE";
     case 0x202B: return "PMERR_ESC_CODE_NOT_SUPPORTED";
     case 0x202C: return "PMERR_EXCEEDS_MAX_SEG_LENGTH";
     case 0x202D: return "PMERR_FONT_AND_MODE_MISMATCH";
     case 0x202E: return "PMERR_FONT_FILE_NOT_LOADED";
     case 0x202F: return "PMERR_FONT_NOT_LOADED";
     case 0x2030: return "PMERR_FONT_TOO_BIG";
     case 0x2031: return "PMERR_HARDWARE_INIT_FAILURE";
     case 0x2032: return "PMERR_HBITMAP_BUSY";
     case 0x2033: return "PMERR_HDC_BUSY";
     case 0x2034: return "PMERR_HRGN_BUSY";
     case 0x2035: return "PMERR_HUGE_FONTS_NOT_SUPPORTED";
     case 0x2036: return "PMERR_ID_HAS_NO_BITMAP";
     case 0x2037: return "PMERR_IMAGE_INCOMPLETE";
     case 0x2038: return "PMERR_INCOMPAT_COLOR_FORMAT";
     case 0x2039: return "PMERR_INCOMPAT_COLOR_OPTIONS";
     case 0x203A: return "PMERR_INCOMPATIBLE_BITMAP";
     case 0x203B: return "PMERR_INCOMPATIBLE_METAFILE";
     case 0x203C: return "PMERR_INCORRECT_DC_TYPE";
     case 0x203D: return "PMERR_INSUFFICIENT_DISK_SPACE";
     case 0x203E: return "PMERR_INSUFFICIENT_MEMORY";
     case 0x203F: return "PMERR_INV_ANGLE_PARM";
     case 0x2040: return "PMERR_INV_ARC_CONTROL";
     case 0x2041: return "PMERR_INV_AREA_CONTROL";
     case 0x2042: return "PMERR_INV_ARC_POINTS";
     case 0x2043: return "PMERR_INV_ATTR_MODE";
     case 0x2044: return "PMERR_INV_BACKGROUND_COL_ATTR";
     case 0x2045: return "PMERR_INV_BACKGROUND_MIX_ATTR";
     case 0x2046: return "PMERR_INV_BITBLT_MIX";
     case 0x2047: return "PMERR_INV_BITBLT_STYLE";
     case 0x2048: return "PMERR_INV_BITMAP_DIMENSION";
     case 0x2049: return "PMERR_INV_BOX_CONTROL";
     case 0x204A: return "PMERR_INV_BOX_ROUNDING_PARM";
     case 0x204B: return "PMERR_INV_CHAR_ANGLE_ATTR";
     case 0x204C: return "PMERR_INV_CHAR_DIRECTION_ATTR";
     case 0x204D: return "PMERR_INV_CHAR_MODE_ATTR";
     case 0x204E: return "PMERR_INV_CHAR_POS_OPTIONS";
     case 0x204F: return "PMERR_INV_CHAR_SET_ATTR";
     case 0x2050: return "PMERR_INV_CHAR_SHEAR_ATTR";
     case 0x2051: return "PMERR_INV_CLIP_PATH_OPTIONS";
     case 0x2052: return "PMERR_INV_CODEPAGE";
     case 0x2053: return "PMERR_INV_COLOR_ATTR";
     case 0x2054: return "PMERR_INV_COLOR_DATA";
     case 0x2055: return "PMERR_INV_COLOR_FORMAT";
     case 0x2056: return "PMERR_INV_COLOR_INDEX";
     case 0x2057: return "PMERR_INV_COLOR_OPTIONS";
     case 0x2058: return "PMERR_INV_COLOR_START_INDEX";
     case 0x2059: return "PMERR_INV_COORD_OFFSET";
     case 0x205A: return "PMERR_INV_COORD_SPACE";
     case 0x205B: return "PMERR_INV_COORDINATE";
     case 0x205C: return "PMERR_INV_CORRELATE_DEPTH";
     case 0x205D: return "PMERR_INV_CORRELATE_TYPE";
     case 0x205E: return "PMERR_INV_CURSOR_BITMAP";
     case 0x205F: return "PMERR_INV_DC_DATA";
     case 0x2060: return "PMERR_INV_DC_TYPE";
     case 0x2061: return "PMERR_INV_DEVICE_NAME";
     case 0x2062: return "PMERR_INV_DEV_MODES_OPTIONS";
     case 0x2063: return "PMERR_INV_DRAW_CONTROL";
     case 0x2064: return "PMERR_INV_DRAW_VALUE";
     case 0x2065: return "PMERR_INV_DRAWING_MODE";
     case 0x2066: return "PMERR_INV_DRIVER_DATA";
     case 0x2067: return "PMERR_INV_DRIVER_NAME";
     case 0x2068: return "PMERR_INV_DRAW_BORDER_OPTION";
     case 0x2069: return "PMERR_INV_EDIT_MODE";
     case 0x206A: return "PMERR_INV_ELEMENT_OFFSET";
     case 0x206B: return "PMERR_INV_ELEMENT_POINTER";
     case 0x206C: return "PMERR_INV_END_PATH_OPTIONS";
     case 0x206D: return "PMERR_INV_ESC_CODE";
     case 0x206E: return "PMERR_INV_ESCAPE_DATA";
     case 0x206F: return "PMERR_INV_EXTENDED_LCID";
     case 0x2070: return "PMERR_INV_FILL_PATH_OPTIONS";
     case 0x2071: return "PMERR_INV_FIRST_CHAR";
     case 0x2072: return "PMERR_INV_FONT_ATTRS";
     case 0x2073: return "PMERR_INV_FONT_FILE_DATA";
     case 0x2074: return "PMERR_INV_FOR_THIS_DC_TYPE";
     case 0x2075: return "PMERR_INV_FORMAT_CONTROL";
     case 0x2076: return "PMERR_INV_FORMS_CODE";
     case 0x2077: return "PMERR_INV_FONTDEF";
     case 0x2078: return "PMERR_INV_GEOM_LINE_WIDTH_ATTR";
     case 0x2079: return "PMERR_INV_GETDATA_CONTROL";
     case 0x207A: return "PMERR_INV_GRAPHICS_FIELD";
     case 0x207B: return "PMERR_INV_HBITMAP";
     case 0x207C: return "PMERR_INV_HDC";
     case 0x207D: return "PMERR_INV_HJOURNAL";
     case 0x207E: return "PMERR_INV_HMF";
     case 0x207F: return "PMERR_INV_HPS";
     case 0x2080: return "PMERR_INV_HRGN";
     case 0x2081: return "PMERR_INV_ID";
     case 0x2082: return "PMERR_INV_IMAGE_DATA_LENGTH";
     case 0x2083: return "PMERR_INV_IMAGE_DIMENSION";
     case 0x2084: return "PMERR_INV_IMAGE_FORMAT";
     case 0x2085: return "PMERR_INV_IN_AREA";
     case 0x2086: return "PMERR_INV_IN_CALLED_SEG";
     case 0x2087: return "PMERR_INV_IN_CURRENT_EDIT_MODE";
     case 0x2088: return "PMERR_INV_IN_DRAW_MODE";
     case 0x2089: return "PMERR_INV_IN_ELEMENT";
     case 0x208A: return "PMERR_INV_IN_IMAGE";
     case 0x208B: return "PMERR_INV_IN_PATH";
     case 0x208C: return "PMERR_INV_IN_RETAIN_MODE";
     case 0x208D: return "PMERR_INV_IN_SEG";
     case 0x208E: return "PMERR_INV_IN_VECTOR_SYMBOL";
     case 0x208F: return "PMERR_INV_INFO_TABLE";
     case 0x2090: return "PMERR_INV_JOURNAL_OPTION";
     case 0x2091: return "PMERR_INV_KERNING_FLAGS";
     case 0x2092: return "PMERR_INV_LENGTH_OR_COUNT";
     case 0x2093: return "PMERR_INV_LINE_END_ATTR";
     case 0x2094: return "PMERR_INV_LINE_JOIN_ATTR";
     case 0x2095: return "PMERR_INV_LINE_TYPE_ATTR";
     case 0x2096: return "PMERR_INV_LINE_WIDTH_ATTR";
     case 0x2097: return "PMERR_INV_LOGICAL_ADDRESS";
     case 0x2098: return "PMERR_INV_MARKER_BOX_ATTR";
     case 0x2099: return "PMERR_INV_MARKER_SET_ATTR";
     case 0x209A: return "PMERR_INV_MARKER_SYMBOL_ATTR";
     case 0x209B: return "PMERR_INV_MATRIX_ELEMENT";
     case 0x209C: return "PMERR_INV_MAX_HITS";
     case 0x209D: return "PMERR_INV_METAFILE";
     case 0x209E: return "PMERR_INV_METAFILE_LENGTH";
     case 0x209F: return "PMERR_INV_METAFILE_OFFSET";
     case 0x20A0: return "PMERR_INV_MICROPS_DRAW_CONTROL";
     case 0x20A1: return "PMERR_INV_MICROPS_FUNCTION";
     case 0x20A2: return "PMERR_INV_MICROPS_ORDER";
     case 0x20A3: return "PMERR_INV_MIX_ATTR";
     case 0x20A4: return "PMERR_INV_MODE_FOR_OPEN_DYN";
     case 0x20A5: return "PMERR_INV_MODE_FOR_REOPEN_SEG";
     case 0x20A6: return "PMERR_INV_MODIFY_PATH_MODE";
     case 0x20A7: return "PMERR_INV_MULTIPLIER";
     case 0x20A8: return "PMERR_INV_NESTED_FIGURES";
     case 0x20A9: return "PMERR_INV_OR_INCOMPAT_OPTIONS";
     case 0x20AA: return "PMERR_INV_ORDER_LENGTH";
     case 0x20AB: return "PMERR_INV_ORDERING_PARM";
     case 0x20AC: return "PMERR_INV_OUTSIDE_DRAW_MODE";
     case 0x20AD: return "PMERR_INV_PAGE_VIEWPORT";
     case 0x20AE: return "PMERR_INV_PATH_ID";
     case 0x20AF: return "PMERR_INV_PATH_MODE";
     case 0x20B0: return "PMERR_INV_PATTERN_ATTR";
     case 0x20B1: return "PMERR_INV_PATTERN_REF_PT_ATTR";
     case 0x20B2: return "PMERR_INV_PATTERN_SET_ATTR";
     case 0x20B3: return "PMERR_INV_PATTERN_SET_FONT";
     case 0x20B4: return "PMERR_INV_PICK_APERTURE_OPTION";
     case 0x20B5: return "PMERR_INV_PICK_APERTURE_POSN";
     case 0x20B6: return "PMERR_INV_PICK_APERTURE_SIZE";
     case 0x20B7: return "PMERR_INV_PICK_NUMBER";
     case 0x20B8: return "PMERR_INV_PLAY_METAFILE_OPTION";
     case 0x20B9: return "PMERR_INV_PRIMITIVE_TYPE";
     case 0x20BA: return "PMERR_INV_PS_SIZE";
     case 0x20BB: return "PMERR_INV_PUTDATA_FORMAT";
     case 0x20BC: return "PMERR_INV_QUERY_ELEMENT_NO";
     case 0x20BD: return "PMERR_INV_RECT";
     case 0x20BE: return "PMERR_INV_REGION_CONTROL";
     case 0x20BF: return "PMERR_INV_REGION_MIX_MODE";
     case 0x20C0: return "PMERR_INV_REPLACE_MODE_FUNC";
     case 0x20C1: return "PMERR_INV_RESERVED_FIELD";
     case 0x20C2: return "PMERR_INV_RESET_OPTIONS";
     case 0x20C3: return "PMERR_INV_RGBCOLOR";
     case 0x20C4: return "PMERR_INV_SCAN_START";
     case 0x20C5: return "PMERR_INV_SEG_ATTR";
     case 0x20C6: return "PMERR_INV_SEG_ATTR_VALUE";
     case 0x20C7: return "PMERR_INV_SEG_CH_LENGTH";
     case 0x20C8: return "PMERR_INV_SEG_NAME";
     case 0x20C9: return "PMERR_INV_SEG_OFFSET";
     case 0x20CA: return "PMERR_INV_SETID";
     case 0x20CB: return "PMERR_INV_SETID_TYPE";
     case 0x20CC: return "PMERR_INV_SET_VIEWPORT_OPTION";
     case 0x20CD: return "PMERR_INV_SHARPNESS_PARM";
     case 0x20CE: return "PMERR_INV_SOURCE_OFFSET";
     case 0x20CF: return "PMERR_INV_STOP_DRAW_VALUE";
     case 0x20D0: return "PMERR_INV_TRANSFORM_TYPE";
     case 0x20D1: return "PMERR_INV_USAGE_PARM";
     case 0x20D2: return "PMERR_INV_VIEWING_LIMITS";
     case 0x20D3: return "PMERR_JFILE_BUSY";
     case 0x20D4: return "PMERR_JNL_FUNC_DATA_TOO_LONG";
     case 0x20D5: return "PMERR_KERNING_NOT_SUPPORTED";
     case 0x20D6: return "PMERR_LABEL_NOT_FOUND";
     case 0x20D7: return "PMERR_MATRIX_OVERFLOW";
     case 0x20D8: return "PMERR_METAFILE_INTERNAL_ERROR";
     case 0x20D9: return "PMERR_METAFILE_IN_USE";
     case 0x20DA: return "PMERR_METAFILE_LIMIT_EXCEEDED";
     case 0x20DB: return "PMERR_NAME_STACK_FULL";
     case 0x20DC: return "PMERR_NOT_CREATED_BY_DEVOPENDC";
     case 0x20DD: return "PMERR_NOT_IN_AREA";
     case 0x20DE: return "PMERR_NOT_IN_DRAW_MODE";
     case 0x20DF: return "PMERR_NOT_IN_ELEMENT";
     case 0x20E0: return "PMERR_NOT_IN_IMAGE";
     case 0x20E1: return "PMERR_NOT_IN_PATH";
     case 0x20E2: return "PMERR_NOT_IN_RETAIN_MODE";
     case 0x20E3: return "PMERR_NOT_IN_SEG";
     case 0x20E4: return "PMERR_NO_BITMAP_SELECTED";
     case 0x20E5: return "PMERR_NO_CURRENT_ELEMENT";
     case 0x20E6: return "PMERR_NO_CURRENT_SEG";
     case 0x20E7: return "PMERR_NO_METAFILE_RECORD_HANDLE";
     case 0x20E8: return "PMERR_ORDER_TOO_BIG";
     case 0x20E9: return "PMERR_OTHER_SET_ID_REFS";
     case 0x20EA: return "PMERR_OVERRAN_SEG";
     case 0x20EB: return "PMERR_OWN_SET_ID_REFS";
     case 0x20EC: return "PMERR_PATH_INCOMPLETE";
     case 0x20ED: return "PMERR_PATH_LIMIT_EXCEEDED";
     case 0x20EE: return "PMERR_PATH_UNKNOWN";
     case 0x20EF: return "PMERR_PEL_IS_CLIPPED";
     case 0x20F0: return "PMERR_PEL_NOT_AVAILABLE";
     case 0x20F1: return "PMERR_PRIMITIVE_STACK_EMPTY";
     case 0x20F2: return "PMERR_PROLOG_ERROR";
     case 0x20F3: return "PMERR_PROLOG_SEG_ATTR_NOT_SET";
     case 0x20F4: return "PMERR_PS_BUSY";
     case 0x20F5: return "PMERR_PS_IS_ASSOCIATED";
     case 0x20F6: return "PMERR_RAM_JNL_FILE_TOO_SMALL";
     case 0x20F7: return "PMERR_REALIZE_NOT_SUPPORTED";
     case 0x20F8: return "PMERR_REGION_IS_CLIP_REGION";
     case 0x20F9: return "PMERR_RESOURCE_DEPLETION";
     case 0x20FA: return "PMERR_SEG_AND_REFSEG_ARE_SAME";
     case 0x20FB: return "PMERR_SEG_CALL_RECURSIVE";
     case 0x20FC: return "PMERR_SEG_CALL_STACK_EMPTY";
     case 0x20FD: return "PMERR_SEG_CALL_STACK_FULL";
     case 0x20FE: return "PMERR_SEG_IS_CURRENT";
     case 0x20FF: return "PMERR_SEG_NOT_CHAINED";
     case 0x2100: return "PMERR_SEG_NOT_FOUND";
     case 0x2101: return "PMERR_SEG_STORE_LIMIT_EXCEEDED";
     case 0x2102: return "PMERR_SETID_IN_USE";
     case 0x2103: return "PMERR_SETID_NOT_FOUND";
     case 0x2104: return "PMERR_STARTDOC_NOT_ISSUED";
     case 0x2105: return "PMERR_STOP_DRAW_OCCURRED";
     case 0x2106: return "PMERR_TOO_MANY_METAFILES_IN_USE";
     case 0x2107: return "PMERR_TRUNCATED_ORDER";
     case 0x2108: return "PMERR_UNCHAINED_SEG_ZERO_INV";
     case 0x2109: return "PMERR_UNSUPPORTED_ATTR";
     case 0x210A: return "PMERR_UNSUPPORTED_ATTR_VALUE";
     case 0x210B: return "PMERR_ENDDOC_NOT_ISSUED";
     case 0x210C: return "PMERR_PS_NOT_ASSOCIATED";
     case 0x210D: return "PMERR_INV_FLOOD_FILL_OPTIONS";
     case 0x210E: return "PMERR_INV_FACENAME";
     case 0x210F: return "PMERR_PALETTE_SELECTED";
     case 0x2110: return "PMERR_NO_PALETTE_SELECTED";
     case 0x2111: return "PMERR_INV_HPAL";
     case 0x2112: return "PMERR_PALETTE_BUSY";
     case 0x2113: return "PMERR_START_POINT_CLIPPED";
     case 0x2114: return "PMERR_NO_FILL";
     case 0x2115: return "PMERR_INV_FACENAMEDESC";
     case 0x2116: return "PMERR_INV_BITMAP_DATA";
     case 0x2117: return "PMERR_INV_CHAR_ALIGN_ATTR";
     case 0x2118: return "PMERR_INV_HFONT";
     case 0x2119: return "PMERR_HFONT_IS_SELECTED";
     case 0x2120: return "PMERR_DRVR_NOT_SUPPORTED";
     case 0x4001: return "PMERR_SPL_DRIVER_ERROR";
     case 0x4002: return "PMERR_SPL_DEVICE_ERROR";
     case 0x4003: return "PMERR_SPL_DEVICE_NOT_INSTALLED";
     case 0x4004: return "PMERR_SPL_QUEUE_ERROR";
     case 0x4005: return "PMERR_SPL_INV_HSPL";
     case 0x4006: return "PMERR_SPL_NO_DISK_SPACE";
     case 0x4007: return "PMERR_SPL_NO_MEMORY";
     case 0x4008: return "PMERR_SPL_PRINT_ABORT";
     case 0x4009: return "PMERR_SPL_SPOOLER_NOT_INSTALLED";
     case 0x400A: return "PMERR_SPL_INV_FORMS_CODE";
     case 0x400B: return "PMERR_SPL_INV_PRIORITY";
     case 0x400C: return "PMERR_SPL_NO_FREE_JOB_ID";
     case 0x400D: return "PMERR_SPL_NO_DATA";
     case 0x400E: return "PMERR_SPL_INV_TOKEN";
     case 0x400F: return "PMERR_SPL_INV_DATATYPE";
     case 0x4010: return "PMERR_SPL_PROCESSOR_ERROR";
     case 0x4011: return "PMERR_SPL_INV_JOB_ID";
     case 0x4012: return "PMERR_SPL_JOB_NOT_PRINTING";
     case 0x4013: return "PMERR_SPL_JOB_PRINTING";
     case 0x4014: return "PMERR_SPL_QUEUE_ALREADY_EXISTS";
     case 0x4015: return "PMERR_SPL_INV_QUEUE_NAME";
     case 0x4016: return "PMERR_SPL_QUEUE_NOT_EMPTY";
     case 0x4017: return "PMERR_SPL_DEVICE_ALREADY_EXISTS";
     case 0x4018: return "PMERR_SPL_DEVICE_LIMIT_REACHED";
     case 0x4019: return "PMERR_SPL_STATUS_STRING_TRUNC";
     case 0x401A: return "PMERR_SPL_INV_LENGTH_OR_COUNT";
     case 0x401B: return "PMERR_SPL_FILE_NOT_FOUND";
     case 0x401C: return "PMERR_SPL_CANNOT_OPEN_FILE";
     case 0x401D: return "PMERR_SPL_DRIVER_NOT_INSTALLED";
     case 0x401E: return "PMERR_SPL_INV_PROCESSOR_DATTYPE";
     case 0x401F: return "PMERR_SPL_INV_DRIVER_DATATYPE";
     case 0x4020: return "PMERR_SPL_PROCESSOR_NOT_INST";
     case 0x4021: return "PMERR_SPL_NO_SUCH_LOG_ADDRESS";
     case 0x4022: return "PMERR_SPL_PRINTER_NOT_FOUND";
     case 0x4023: return "PMERR_SPL_DD_NOT_FOUND";
     case 0x4024: return "PMERR_SPL_QUEUE_NOT_FOUND";
     case 0x4025: return "PMERR_SPL_MANY_QUEUES_ASSOC";
     case 0x4026: return "PMERR_SPL_NO_QUEUES_ASSOCIATED";
     case 0x4027: return "PMERR_SPL_INI_FILE_ERROR";
     case 0x4028: return "PMERR_SPL_NO_DEFAULT_QUEUE";
     case 0x4029: return "PMERR_SPL_NO_CURRENT_FORMS_CODE";
     case 0x402A: return "PMERR_SPL_NOT_AUTHORISED";
     case 0x402B: return "PMERR_SPL_TEMP_NETWORK_ERROR";
     case 0x402C: return "PMERR_SPL_HARD_NETWORK_ERROR";
     case 0x402D: return "PMERR_DEL_NOT_ALLOWED";
     case 0x402E: return "PMERR_CANNOT_DEL_QP_REF";
     case 0x402F: return "PMERR_CANNOT_DEL_QNAME_REF";
     case 0x4030: return "PMERR_CANNOT_DEL_PRINTER_DD_REF";
     case 0x4031: return "PMERR_CANNOT_DEL_PRN_NAME_REF";
     case 0x4032: return "PMERR_CANNOT_DEL_PRN_ADDR_REF";
     case 0x4033: return "PMERR_SPOOLER_QP_NOT_DEFINED";
     case 0x4034: return "PMERR_PRN_NAME_NOT_DEFINED";
     case 0x4035: return "PMERR_PRN_ADDR_NOT_DEFINED";
     case 0x4036: return "PMERR_PRINTER_DD_NOT_DEFINED";
     case 0x4037: return "PMERR_PRINTER_QUEUE_NOT_DEFINED";
     case 0x4038: return "PMERR_PRN_ADDR_IN_USE";
     case 0x4039: return "PMERR_SPL_TOO_MANY_OPEN_FILES";
     case 0x403A: return "PMERR_SPL_CP_NOT_REQD";
     case 0x4040: return "PMERR_UNABLE_TO_CLOSE_DEVICE";
     case 4001: return "PMERR_SPL_ERROR_1";
     case 4002: return "PMERR_SPL_ERROR_2";
     case 4003: return "PMERR_SPL_ERROR_3";
     case 4004: return "PMERR_SPL_ERROR_4";
     case 4005: return "PMERR_SPL_ERROR_5";
     case 4006: return "PMERR_SPL_ERROR_6";
     case 4007: return "PMERR_SPL_ERROR_7";
     case 4008: return "PMERR_SPL_ERROR_8";
     case 4009: return "PMERR_SPL_ERROR_9";
     case 4010: return "PMERR_SPL_ERROR_10";
     case 4011: return "PMERR_SPL_ERROR_11";
     case 4012: return "PMERR_SPL_ERROR_12";
     case 4013: return "PMERR_SPL_ERROR_13";
     case 4014: return "PMERR_SPL_ERROR_14";
     case 4015: return "PMERR_SPL_ERROR_15";
     case 4016: return "PMERR_SPL_ERROR_16";
     case 4017: return "PMERR_SPL_ERROR_17";
     case 4018: return "PMERR_SPL_ERROR_18";
     case 4019: return "PMERR_SPL_ERROR_19";
     case 4020: return "PMERR_SPL_ERROR_20";
     case 4021: return "PMERR_SPL_ERROR_21";
     case 4022: return "PMERR_SPL_ERROR_22";
     case 4023: return "PMERR_SPL_ERROR_23";
     case 4024: return "PMERR_SPL_ERROR_24";
     case 4025: return "PMERR_SPL_ERROR_25";
     case 4026: return "PMERR_SPL_ERROR_26";
     case 4027: return "PMERR_SPL_ERROR_27";
     case 4028: return "PMERR_SPL_ERROR_28";
     case 4029: return "PMERR_SPL_ERROR_29";
     case 4030: return "PMERR_SPL_ERROR_30";
     case 4031: return "PMERR_SPL_ERROR_31";
     case 4032: return "PMERR_SPL_ERROR_32";
     case 4033: return "PMERR_SPL_ERROR_33";
     case 4034: return "PMERR_SPL_ERROR_34";
     case 4035: return "PMERR_SPL_ERROR_35";
     case 4036: return "PMERR_SPL_ERROR_36";
     case 4037: return "PMERR_SPL_ERROR_37";
     case 4038: return "PMERR_SPL_ERROR_38";
     case 4039: return "PMERR_SPL_ERROR_39";
     case 4040: return "PMERR_SPL_ERROR_40";
     case 4041: return "PMERR_SPLMSGBOX_INFO_CAPTION";
     case 4042: return "PMERR_SPLMSGBOX_WARNING_CAPTION";
     case 4043: return "PMERR_SPLMSGBOX_ERROR_CAPTION";
     case 4044: return "PMERR_SPLMSGBOX_SEVERE_CAPTION";
     case 4045: return "PMERR_SPLMSGBOX_JOB_DETAILS";
     case 4046: return "PMERR_SPLMSGBOX_ERROR_ACTION";
     case 4047: return "PMERR_SPLMSGBOX_SEVERE_ACTION";
     case 4048: return "PMERR_SPLMSGBOX_BIT_0_TEXT";
     case 4049: return "PMERR_SPLMSGBOX_BIT_1_TEXT";
     case 4050: return "PMERR_SPLMSGBOX_BIT_2_TEXT";
     case 4051: return "PMERR_SPLMSGBOX_BIT_3_TEXT";
     case 4052: return "PMERR_SPLMSGBOX_BIT_4_TEXT";
     case 4053: return "PMERR_SPLMSGBOX_BIT_5_TEXT";
     case 4054: return "PMERR_SPLMSGBOX_BIT_15_TEXT";
     case 4055: return "PMERR_SPL_NOPATHBUFFER";
     case 4093: return "PMERR_SPL_ALREADY_INITIALISED";
     case 4095: return "PMERR_SPL_ERROR";
     case 0x5001: return "PMERR_INV_TYPE";
     case 0x5002: return "PMERR_INV_CONV";
     case 0x5003: return "PMERR_INV_SEGLEN";
     case 0x5004: return "PMERR_DUP_SEGNAME";
     case 0x5005: return "PMERR_INV_XFORM";
     case 0x5006: return "PMERR_INV_VIEWLIM";
     case 0x5007: return "PMERR_INV_3DCOORD";
     case 0x5008: return "PMERR_SMB_OVFLOW";
     case 0x5009: return "PMERR_SEG_OVFLOW";
     case 0x5010: return "PMERR_PIC_DUP_FILENAME";
     default: return "unknown error";
     }
  }

static char *pmsev(USHORT rc)
  {
  switch(rc)
     {
     case SEVERITY_NOERROR:       return "no error (?)";
     case SEVERITY_WARNING:       return "warning";
     case SEVERITY_ERROR:         return "error";
     case SEVERITY_UNRECOVERABLE: return "unrecoverable";
     default:                     return "unknown";
     }
  }

static char *queryClass(ULONG cl)
  {
  switch (cl)
    {
    case ERRCLASS_OUTRES:       return "Out of resources";
    case ERRCLASS_TEMPSIT:      return "Temporary situation";
    case ERRCLASS_AUTH:         return "Authorization failure";
    case ERRCLASS_INTRN:        return "Internal error";
    case ERRCLASS_HRDFAIL:      return "Device hardware failure";
    case ERRCLASS_SYSFAIL:      return "System failure";
    case ERRCLASS_APPERR:       return "Probably application error";
    case ERRCLASS_NOTFND:       return "Item not located";
    case ERRCLASS_BADFMT:       return "Bad format for function or data";
    case ERRCLASS_LOCKED:       return "Resource or data locked";
    case ERRCLASS_MEDIA:        return "Incorrect media, CRC error";
    case ERRCLASS_ALREADY:      return "Action already taken or done; or resource exists";
    case ERRCLASS_UNK:          return "Unclassified";
    case ERRCLASS_CANT:         return "Cannot perform requested action";
    case ERRCLASS_TIME:         return "Timeout";
    default:                    return "Unknown error code";
    }
  }

static char *queryAction(ULONG action)
  {
  switch(action)
    {
    case ERRACT_RETRY:          return "Retry immediately";
    case ERRACT_DLYRET:         return "Delay and retry";
    case ERRACT_USER:           return "Bad user input - retry";
    case ERRACT_ABORT:          return "Terminate in an orderly manner";
    case ERRACT_PANIC:          return "Terminate immediately";
    case ERRACT_IGNORE:         return "Ignore error";
    case ERRACT_INTRET:         return "Retry after user intervention";
    default:                    return "Unknown error code";
    }
  }

char *doserror(unsigned long rc)
  {
  switch(rc)
     {
     case 1: return "ERROR_INVALID_FUNCTION";
     case 2: return "ERROR_FILE_NOT_FOUND";
     case 3: return "ERROR_PATH_NOT_FOUND";
     case 4: return "ERROR_TOO_MANY_OPEN_FILES";
     case 5: return "ERROR_ACCESS_DENIED";
     case 6: return "ERROR_INVALID_HANDLE";
     case 7: return "ERROR_ARENA_TRASHED";
     case 8: return "ERROR_NOT_ENOUGH_MEMORY";
     case 9: return "ERROR_INVALID_BLOCK";
     case 10: return "ERROR_BAD_ENVIRONMENT";
     case 11: return "ERROR_BAD_FORMAT";
     case 12: return "ERROR_INVALID_ACCESS";
     case 13: return "ERROR_INVALID_DATA";
     case 15: return "ERROR_INVALID_DRIVE";
     case 16: return "ERROR_CURRENT_DIRECTORY";
     case 17: return "ERROR_NOT_SAME_DEVICE";
     case 18: return "ERROR_NO_MORE_FILES";
     case 19: return "ERROR_WRITE_PROTECT";
     case 20: return "ERROR_BAD_UNIT";
     case 21: return "ERROR_NOT_READY";
     case 22: return "ERROR_BAD_COMMAND";
     case 23: return "ERROR_CRC";
     case 24: return "ERROR_BAD_LENGTH";
     case 25: return "ERROR_SEEK";
     case 26: return "ERROR_NOT_DOS_DISK";
     case 27: return "ERROR_SECTOR_NOT_FOUND";
     case 28: return "ERROR_OUT_OF_PAPER";
     case 29: return "ERROR_WRITE_FAULT";
     case 30: return "ERROR_READ_FAULT";
     case 31: return "ERROR_GEN_FAILURE";
     case 32: return "ERROR_SHARING_VIOLATION";
     case 33: return "ERROR_LOCK_VIOLATION";
     case 34: return "ERROR_WRONG_DISK";
     case 35: return "ERROR_FCB_UNAVAILABLE";
     case 36: return "ERROR_SHARING_BUFFER_EXCEEDED";
     case 37: return "ERROR_CODE_PAGE_MISMATCHED";
     case 38: return "ERROR_HANDLE_EOF";
     case 39: return "ERROR_HANDLE_DISK_FULL";
     case 50: return "ERROR_NOT_SUPPORTED";
     case 51: return "ERROR_REM_NOT_LIST";
     case 52: return "ERROR_DUP_NAME";
     case 53: return "ERROR_BAD_NETPATH";
     case 54: return "ERROR_NETWORK_BUSY";
     case 55: return "ERROR_DEV_NOT_EXIST";
     case 56: return "ERROR_TOO_MANY_CMDS";
     case 57: return "ERROR_ADAP_HDW_ERR";
     case 58: return "ERROR_BAD_NET_RESP";
     case 59: return "ERROR_UNEXP_NET_ERR";
     case 60: return "ERROR_BAD_REM_ADAP";
     case 61: return "ERROR_PRINTQ_FULL";
     case 62: return "ERROR_NO_SPOOL_SPACE";
     case 63: return "ERROR_PRINT_CANCELLED";
     case 64: return "ERROR_NETNAME_DELETED";
     case 65: return "ERROR_NETWORK_ACCESS_DENIED";
     case 66: return "ERROR_BAD_DEV_TYPE";
     case 67: return "ERROR_BAD_NET_NAME";
     case 68: return "ERROR_TOO_MANY_NAMES";
     case 69: return "ERROR_TOO_MANY_SESS";
     case 70: return "ERROR_SHARING_PAUSED";
     case 71: return "ERROR_REQ_NOT_ACCEP";
     case 72: return "ERROR_REDIR_PAUSED";
     case 73: return "ERROR_SBCS_ATT_WRITE_PROT";
     case 74: return "ERROR_SBCS_GENERAL_FAILURE";
     case 75: return "ERROR_XGA_OUT_MEMORY";
     case 80: return "ERROR_FILE_EXISTS";
     case 81: return "ERROR_DUP_FCB";
     case 82: return "ERROR_CANNOT_MAKE";
     case 83: return "ERROR_FAIL_I24";
     case 84: return "ERROR_OUT_OF_STRUCTURES";
     case 85: return "ERROR_ALREADY_ASSIGNED";
     case 86: return "ERROR_INVALID_PASSWORD";
     case 87: return "ERROR_INVALID_PARAMETER";
     case 88: return "ERROR_NET_WRITE_FAULT";
     case 89: return "ERROR_NO_PROC_SLOTS";
     case 90: return "ERROR_NOT_FROZEN";
     case 93: return "ERROR_NO_ITEMS";
     case 95: return "ERROR_INTERRUPT";
     case 99: return "ERROR_DEVICE_IN_USE";
     case 100: return "ERROR_TOO_MANY_SEMAPHORES";
     case 101: return "ERROR_EXCL_SEM_ALREADY_OWNED";
     case 102: return "ERROR_SEM_IS_SET";
     case 103: return "ERROR_TOO_MANY_SEM_REQUESTS";
     case 104: return "ERROR_INVALID_AT_INTERRUPT_TIME";
     case 105: return "ERROR_SEM_OWNER_DIED";
     case 106: return "ERROR_SEM_USER_LIMIT";
     case 107: return "ERROR_DISK_CHANGE";
     case 108: return "ERROR_DRIVE_LOCKED";
     case 109: return "ERROR_BROKEN_PIPE";
     case 110: return "ERROR_OPEN_FAILED";
     case 111: return "ERROR_BUFFER_OVERFLOW";
     case 112: return "ERROR_DISK_FULL";
     case 113: return "ERROR_NO_MORE_SEARCH_HANDLES";
     case 114: return "ERROR_INVALID_TARGET_HANDLE";
     case 115: return "ERROR_PROTECTION_VIOLATION";
     case 116: return "ERROR_VIOKBD_REQUEST";
     case 117: return "ERROR_INVALID_CATEGORY";
     case 118: return "ERROR_INVALID_VERIFY_SWITCH";
     case 119: return "ERROR_BAD_DRIVER_LEVEL";
     case 120: return "ERROR_CALL_NOT_IMPLEMENTED";
     case 121: return "ERROR_SEM_TIMEOUT";
     case 122: return "ERROR_INSUFFICIENT_BUFFER";
     case 123: return "ERROR_INVALID_NAME";
     case 124: return "ERROR_INVALID_LEVEL";
     case 125: return "ERROR_NO_VOLUME_LABEL";
     case 126: return "ERROR_MOD_NOT_FOUND";
     case 127: return "ERROR_PROC_NOT_FOUND";
     case 128: return "ERROR_WAIT_NO_CHILDREN";
     case 129: return "ERROR_CHILD_NOT_COMPLETE";
     case 130: return "ERROR_DIRECT_ACCESS_HANDLE";
     case 131: return "ERROR_NEGATIVE_SEEK";
     case 132: return "ERROR_SEEK_ON_DEVICE";
     case 133: return "ERROR_IS_JOIN_TARGET";
     case 134: return "ERROR_IS_JOINED";
     case 135: return "ERROR_IS_SUBSTED";
     case 136: return "ERROR_NOT_JOINED";
     case 137: return "ERROR_NOT_SUBSTED";
     case 138: return "ERROR_JOIN_TO_JOIN";
     case 139: return "ERROR_SUBST_TO_SUBST";
     case 140: return "ERROR_JOIN_TO_SUBST";
     case 141: return "ERROR_SUBST_TO_JOIN";
     case 142: return "ERROR_BUSY_DRIVE";
     case 143: return "ERROR_SAME_DRIVE";
     case 144: return "ERROR_DIR_NOT_ROOT";
     case 145: return "ERROR_DIR_NOT_EMPTY";
     case 146: return "ERROR_IS_SUBST_PATH";
     case 147: return "ERROR_IS_JOIN_PATH";
     case 148: return "ERROR_PATH_BUSY";
     case 149: return "ERROR_IS_SUBST_TARGET";
     case 150: return "ERROR_SYSTEM_TRACE";
     case 151: return "ERROR_INVALID_EVENT_COUNT";
     case 152: return "ERROR_TOO_MANY_MUXWAITERS";
     case 153: return "ERROR_INVALID_LIST_FORMAT";
     case 154: return "ERROR_LABEL_TOO_LONG";
     case 155: return "ERROR_TOO_MANY_TCBS";
     case 156: return "ERROR_SIGNAL_REFUSED";
     case 157: return "ERROR_DISCARDED";
     case 158: return "ERROR_NOT_LOCKED";
     case 159: return "ERROR_BAD_THREADID_ADDR";
     case 160: return "ERROR_BAD_ARGUMENTS";
     case 161: return "ERROR_BAD_PATHNAME";
     case 162: return "ERROR_SIGNAL_PENDING";
     case 163: return "ERROR_UNCERTAIN_MEDIA";
     case 164: return "ERROR_MAX_THRDS_REACHED";
     case 165: return "ERROR_MONITORS_NOT_SUPPORTED";
     case 166: return "ERROR_UNC_DRIVER_NOT_INSTALLED";
     case 167: return "ERROR_LOCK_FAILED";
     case 168: return "ERROR_SWAPIO_FAILED";
     case 169: return "ERROR_SWAPIN_FAILED";
     case 170: return "ERROR_BUSY";
     case 173: return "ERROR_CANCEL_VIOLATION";
     case 174: return "ERROR_ATOMIC_LOCK_NOT_SUPPORTED";
     case 175: return "ERROR_READ_LOCKS_NOT_SUPPORTED";
     case 180: return "ERROR_INVALID_SEGMENT_NUMBER";
     case 181: return "ERROR_INVALID_CALLGATE";
     case 182: return "ERROR_INVALID_ORDINAL";
     case 183: return "ERROR_ALREADY_EXISTS";
     case 184: return "ERROR_NO_CHILD_PROCESS";
     case 185: return "ERROR_CHILD_ALIVE_NOWAIT";
     case 186: return "ERROR_INVALID_FLAG_NUMBER";
     case 187: return "ERROR_SEM_NOT_FOUND";
     case 188: return "ERROR_INVALID_STARTING_CODESEG";
     case 189: return "ERROR_INVALID_STACKSEG";
     case 190: return "ERROR_INVALID_MODULETYPE";
     case 191: return "ERROR_INVALID_EXE_SIGNATURE";
     case 192: return "ERROR_EXE_MARKED_INVALID";
     case 193: return "ERROR_BAD_EXE_FORMAT";
     case 194: return "ERROR_ITERATED_DATA_EXCEEDS_64k";
     case 195: return "ERROR_INVALID_MINALLOCSIZE";
     case 196: return "ERROR_DYNLINK_FROM_INVALID_RING";
     case 197: return "ERROR_IOPL_NOT_ENABLED";
     case 198: return "ERROR_INVALID_SEGDPL";
     case 199: return "ERROR_AUTODATASEG_EXCEEDS_64k";
     case 200: return "ERROR_RING2SEG_MUST_BE_MOVABLE";
     case 201: return "ERROR_RELOC_CHAIN_XEEDS_SEGLIM";
     case 202: return "ERROR_INFLOOP_IN_RELOC_CHAIN";
     case 203: return "ERROR_ENVVAR_NOT_FOUND";
     case 204: return "ERROR_NOT_CURRENT_CTRY";
     case 205: return "ERROR_NO_SIGNAL_SENT";
     case 206: return "ERROR_FILENAME_EXCED_RANGE";
     case 207: return "ERROR_RING2_STACK_IN_USE";
     case 208: return "ERROR_META_EXPANSION_TOO_LONG";
     case 209: return "ERROR_INVALID_SIGNAL_NUMBER";
     case 210: return "ERROR_THREAD_1_INACTIVE";
     case 211: return "ERROR_INFO_NOT_AVAIL";
     case 212: return "ERROR_LOCKED";
     case 213: return "ERROR_BAD_DYNALINK";
     case 214: return "ERROR_TOO_MANY_MODULES";
     case 215: return "ERROR_NESTING_NOT_ALLOWED";
     case 216: return "ERROR_CANNOT_SHRINK";
     case 217: return "ERROR_ZOMBIE_PROCESS";
     case 218: return "ERROR_STACK_IN_HIGH_MEMORY";
     case 219: return "ERROR_INVALID_EXITROUTINE_RING";
     case 220: return "ERROR_GETBUF_FAILED";
     case 221: return "ERROR_FLUSHBUF_FAILED";
     case 222: return "ERROR_TRANSFER_TOO_LONG";
     case 223: return "ERROR_FORCENOSWAP_FAILED";
     case 224: return "ERROR_SMG_NO_TARGET_WINDOW";
     case 228: return "ERROR_NO_CHILDREN";
     case 229: return "ERROR_INVALID_SCREEN_GROUP";
     case 230: return "ERROR_BAD_PIPE";
     case 231: return "ERROR_PIPE_BUSY";
     case 232: return "ERROR_NO_DATA";
     case 233: return "ERROR_PIPE_NOT_CONNECTED";
     case 234: return "ERROR_MORE_DATA";
     case 240: return "ERROR_VC_DISCONNECTED";
     case 250: return "ERROR_CIRCULARITY_REQUESTED";
     case 251: return "ERROR_DIRECTORY_IN_CDS";
     case 252: return "ERROR_INVALID_FSD_NAME";
     case 253: return "ERROR_INVALID_PATH";
     case 254: return "ERROR_INVALID_EA_NAME";
     case 255: return "ERROR_EA_LIST_INCONSISTENT";
     case 256: return "ERROR_EA_LIST_TOO_LONG";
     case 257: return "ERROR_NO_META_MATCH";
     case 258: return "ERROR_FINDNOTIFY_TIMEOUT";
     case 259: return "ERROR_NO_MORE_ITEMS";
     case 260: return "ERROR_SEARCH_STRUC_REUSED";
     case 261: return "ERROR_CHAR_NOT_FOUND";
     case 262: return "ERROR_TOO_MUCH_STACK";
     case 263: return "ERROR_INVALID_ATTR";
     case 264: return "ERROR_INVALID_STARTING_RING";
     case 265: return "ERROR_INVALID_DLL_INIT_RING";
     case 266: return "ERROR_CANNOT_COPY";
     case 267: return "ERROR_DIRECTORY";
     case 268: return "ERROR_OPLOCKED_FILE";
     case 269: return "ERROR_OPLOCK_THREAD_EXISTS";
     case 270: return "ERROR_VOLUME_CHANGED";
     case 271: return "ERROR_FINDNOTIFY_HANDLE_IN_USE";
     case 272: return "ERROR_FINDNOTIFY_HANDLE_CLOSED";
     case 273: return "ERROR_NOTIFY_OBJECT_REMOVED";
     case 274: return "ERROR_ALREADY_SHUTDOWN";
     case 275: return "ERROR_EAS_DIDNT_FIT";
     case 276: return "ERROR_EA_FILE_CORRUPT";
     case 277: return "ERROR_EA_TABLE_FULL";
     case 278: return "ERROR_INVALID_EA_HANDLE";
     case 279: return "ERROR_NO_CLUSTER";
     case 280: return "ERROR_CREATE_EA_FILE";
     case 281: return "ERROR_CANNOT_OPEN_EA_FILE";
     case 282: return "ERROR_EAS_NOT_SUPPORTED";
     case 283: return "ERROR_NEED_EAS_FOUND";
     case 284: return "ERROR_DUPLICATE_HANDLE";
     case 285: return "ERROR_DUPLICATE_NAME";
     case 286: return "ERROR_EMPTY_MUXWAIT";
     case 287: return "ERROR_MUTEX_OWNED";
     case 288: return "ERROR_NOT_OWNER";
     case 289: return "ERROR_PARAM_TOO_SMALL";
     case 290: return "ERROR_TOO_MANY_HANDLES";
     case 291: return "ERROR_TOO_MANY_OPENS";
     case 292: return "ERROR_WRONG_TYPE";
     case 293: return "ERROR_UNUSED_CODE";
     case 294: return "ERROR_THREAD_NOT_TERMINATED";
     case 295: return "ERROR_INIT_ROUTINE_FAILED";
     case 296: return "ERROR_MODULE_IN_USE";
     case 297: return "ERROR_NOT_ENOUGH_WATCHPOINTS";
     case 298: return "ERROR_TOO_MANY_POSTS";
     case 299: return "ERROR_ALREADY_POSTED";
     case 300: return "ERROR_ALREADY_RESET";
     case 301: return "ERROR_SEM_BUSY";
     case 0xFF00: return "ERROR_USER_DEFINED_BASE";
     case 303: return "ERROR_INVALID_PROCID";
     case 304: return "ERROR_INVALID_PDELTA";
     case 305: return "ERROR_NOT_DESCENDANT";
     case 306: return "ERROR_NOT_SESSION_MANAGER";
     case 307: return "ERROR_INVALID_PCLASS";
     case 308: return "ERROR_INVALID_SCOPE";
     case 309: return "ERROR_INVALID_THREADID";
     case 310: return "ERROR_DOSSUB_SHRINK";
     case 311: return "ERROR_DOSSUB_NOMEM";
     case 312: return "ERROR_DOSSUB_OVERLAP";
     case 313: return "ERROR_DOSSUB_BADSIZE";
     case 314: return "ERROR_DOSSUB_BADFLAG";
     case 315: return "ERROR_DOSSUB_BADSELECTOR";
     case 316: return "ERROR_MR_MSG_TOO_LONG";
     case 317: return "ERROR_MR_MID_NOT_FOUND";
     case 318: return "ERROR_MR_UN_ACC_MSGF";
     case 319: return "ERROR_MR_INV_MSGF_FORMAT";
     case 320: return "ERROR_MR_INV_IVCOUNT";
     case 321: return "ERROR_MR_UN_PERFORM";
     case 322: return "ERROR_TS_WAKEUP";
     case 323: return "ERROR_TS_SEMHANDLE";
     case 324: return "ERROR_TS_NOTIMER";
     case 326: return "ERROR_TS_HANDLE";
     case 327: return "ERROR_TS_DATETIME";
     case 328: return "ERROR_SYS_INTERNAL";
     case 329: return "ERROR_QUE_CURRENT_NAME";
     case 330: return "ERROR_QUE_PROC_NOT_OWNED";
     case 331: return "ERROR_QUE_PROC_OWNED";
     case 332: return "ERROR_QUE_DUPLICATE";
     case 333: return "ERROR_QUE_ELEMENT_NOT_EXIST";
     case 334: return "ERROR_QUE_NO_MEMORY";
     case 335: return "ERROR_QUE_INVALID_NAME";
     case 336: return "ERROR_QUE_INVALID_PRIORITY";
     case 337: return "ERROR_QUE_INVALID_HANDLE";
     case 338: return "ERROR_QUE_LINK_NOT_FOUND";
     case 339: return "ERROR_QUE_MEMORY_ERROR";
     case 340: return "ERROR_QUE_PREV_AT_END";
     case 341: return "ERROR_QUE_PROC_NO_ACCESS";
     case 342: return "ERROR_QUE_EMPTY";
     case 343: return "ERROR_QUE_NAME_NOT_EXIST";
     case 344: return "ERROR_QUE_NOT_INITIALIZED";
     case 345: return "ERROR_QUE_UNABLE_TO_ACCESS";
     case 346: return "ERROR_QUE_UNABLE_TO_ADD";
     case 347: return "ERROR_QUE_UNABLE_TO_INIT";
     case 349: return "ERROR_VIO_INVALID_MASK";
     case 350: return "ERROR_VIO_PTR";
     case 351: return "ERROR_VIO_APTR";
     case 352: return "ERROR_VIO_RPTR";
     case 353: return "ERROR_VIO_CPTR";
     case 354: return "ERROR_VIO_LPTR";
     case 355: return "ERROR_VIO_MODE";
     case 356: return "ERROR_VIO_WIDTH";
     case 357: return "ERROR_VIO_ATTR";
     case 358: return "ERROR_VIO_ROW";
     case 359: return "ERROR_VIO_COL";
     case 360: return "ERROR_VIO_TOPROW";
     case 361: return "ERROR_VIO_BOTROW";
     case 362: return "ERROR_VIO_RIGHTCOL";
     case 363: return "ERROR_VIO_LEFTCOL";
     case 364: return "ERROR_SCS_CALL";
     case 365: return "ERROR_SCS_VALUE";
     case 366: return "ERROR_VIO_WAIT_FLAG";
     case 367: return "ERROR_VIO_UNLOCK";
     case 368: return "ERROR_SGS_NOT_SESSION_MGR";
     case 369: return "ERROR_SMG_INVALID_SGID";
     case 370: return "ERROR_SMG_NOSG";
     case 371: return "ERROR_SMG_GRP_NOT_FOUND";
     case 372: return "ERROR_SMG_SET_TITLE";
     case 373: return "ERROR_KBD_PARAMETER";
     case 374: return "ERROR_KBD_NO_DEVICE";
     case 375: return "ERROR_KBD_INVALID_IOWAIT";
     case 376: return "ERROR_KBD_INVALID_LENGTH";
     case 377: return "ERROR_KBD_INVALID_ECHO_MASK";
     case 378: return "ERROR_KBD_INVALID_INPUT_MASK";
     case 379: return "ERROR_MON_INVALID_PARMS";
     case 380: return "ERROR_MON_INVALID_DEVNAME";
     case 381: return "ERROR_MON_INVALID_HANDLE";
     case 382: return "ERROR_MON_BUFFER_TOO_SMALL";
     case 383: return "ERROR_MON_BUFFER_EMPTY";
     case 384: return "ERROR_MON_DATA_TOO_LARGE";
     case 385: return "ERROR_MOUSE_NO_DEVICE";
     case 386: return "ERROR_MOUSE_INV_HANDLE";
     case 387: return "ERROR_MOUSE_INV_PARMS";
     case 388: return "ERROR_MOUSE_CANT_RESET";
     case 389: return "ERROR_MOUSE_DISPLAY_PARMS";
     case 390: return "ERROR_MOUSE_INV_MODULE";
     case 391: return "ERROR_MOUSE_INV_ENTRY_PT";
     case 392: return "ERROR_MOUSE_INV_MASK";
     case 395: return "ERROR_INVALID_FREQUENCY";
     case 396: return "ERROR_NLS_NO_COUNTRY_FILE";
     case 397: return "ERROR_NLS_OPEN_FAILED";
     case 398: return "ERROR_NLS_NO_CTRY_CODE";
     case 399: return "ERROR_NLS_TABLE_TRUNCATED";
     case 400: return "ERROR_NLS_BAD_TYPE";
     case 401: return "ERROR_NLS_TYPE_NOT_FOUND";
     case 402: return "ERROR_VIO_SMG_ONLY";
     case 403: return "ERROR_VIO_INVALID_ASCIIZ";
     case 404: return "ERROR_VIO_DEREGISTER";
     case 405: return "ERROR_VIO_NO_POPUP";
     case 406: return "ERROR_VIO_EXISTING_POPUP";
     case 407: return "ERROR_KBD_SMG_ONLY";
     case 408: return "ERROR_KBD_INVALID_ASCIIZ";
     case 409: return "ERROR_KBD_INVALID_MASK";
     case 410: return "ERROR_KBD_REGISTER";
     case 411: return "ERROR_KBD_DEREGISTER";
     case 412: return "ERROR_MOUSE_SMG_ONLY";
     case 413: return "ERROR_MOUSE_INVALID_ASCIIZ";
     case 414: return "ERROR_MOUSE_INVALID_MASK";
     case 415: return "ERROR_MOUSE_REGISTER";
     case 416: return "ERROR_MOUSE_DEREGISTER";
     case 417: return "ERROR_SMG_BAD_ACTION";
     case 418: return "ERROR_SMG_INVALID_CALL";
     case 419: return "ERROR_SCS_SG_NOTFOUND";
     case 420: return "ERROR_SCS_NOT_SHELL";
     case 421: return "ERROR_VIO_INVALID_PARMS";
     case 422: return "ERROR_VIO_FUNCTION_OWNED";
     case 423: return "ERROR_VIO_RETURN";
     case 424: return "ERROR_SCS_INVALID_FUNCTION";
     case 425: return "ERROR_SCS_NOT_SESSION_MGR";
     case 426: return "ERROR_VIO_REGISTER";
     case 427: return "ERROR_VIO_NO_MODE_THREAD";
     case 428: return "ERROR_VIO_NO_SAVE_RESTORE_THD";
     case 429: return "ERROR_VIO_IN_BG";
     case 430: return "ERROR_VIO_ILLEGAL_DURING_POPUP";
     case 431: return "ERROR_SMG_NOT_BASESHELL";
     case 432: return "ERROR_SMG_BAD_STATUSREQ";
     case 433: return "ERROR_QUE_INVALID_WAIT";
     case 434: return "ERROR_VIO_LOCK";
     case 435: return "ERROR_MOUSE_INVALID_IOWAIT";
     case 436: return "ERROR_VIO_INVALID_HANDLE";
     case 437: return "ERROR_VIO_ILLEGAL_DURING_LOCK";
     case 438: return "ERROR_VIO_INVALID_LENGTH";
     case 439: return "ERROR_KBD_INVALID_HANDLE";
     case 440: return "ERROR_KBD_NO_MORE_HANDLE";
     case 441: return "ERROR_KBD_CANNOT_CREATE_KCB";
     case 442: return "ERROR_KBD_CODEPAGE_LOAD_INCOMPL";
     case 443: return "ERROR_KBD_INVALID_CODEPAGE_ID";
     case 444: return "ERROR_KBD_NO_CODEPAGE_SUPPORT";
     case 445: return "ERROR_KBD_FOCUS_REQUIRED";
     case 446: return "ERROR_KBD_FOCUS_ALREADY_ACTIVE";
     case 447: return "ERROR_KBD_KEYBOARD_BUSY";
     case 448: return "ERROR_KBD_INVALID_CODEPAGE";
     case 449: return "ERROR_KBD_UNABLE_TO_FOCUS";
     case 450: return "ERROR_SMG_SESSION_NON_SELECT";
     case 451: return "ERROR_SMG_SESSION_NOT_FOREGRND";
     case 452: return "ERROR_SMG_SESSION_NOT_PARENT";
     case 453: return "ERROR_SMG_INVALID_START_MODE";
     case 454: return "ERROR_SMG_INVALID_RELATED_OPT";
     case 455: return "ERROR_SMG_INVALID_BOND_OPTION";
     case 456: return "ERROR_SMG_INVALID_SELECT_OPT";
     case 457: return "ERROR_SMG_START_IN_BACKGROUND";
     case 458: return "ERROR_SMG_INVALID_STOP_OPTION";
     case 459: return "ERROR_SMG_BAD_RESERVE";
     case 460: return "ERROR_SMG_PROCESS_NOT_PARENT";
     case 461: return "ERROR_SMG_INVALID_DATA_LENGTH";
     case 462: return "ERROR_SMG_NOT_BOUND";
     case 463: return "ERROR_SMG_RETRY_SUB_ALLOC";
     case 464: return "ERROR_KBD_DETACHED";
     case 465: return "ERROR_VIO_DETACHED";
     case 466: return "ERROR_MOU_DETACHED";
     case 467: return "ERROR_VIO_FONT";
     case 468: return "ERROR_VIO_USER_FONT";
     case 469: return "ERROR_VIO_BAD_CP";
     case 470: return "ERROR_VIO_NO_CP";
     case 471: return "ERROR_VIO_NA_CP";
     case 472: return "ERROR_INVALID_CODE_PAGE";
     case 473: return "ERROR_CPLIST_TOO_SMALL";
     case 474: return "ERROR_CP_NOT_MOVED";
     case 475: return "ERROR_MODE_SWITCH_INIT";
     case 476: return "ERROR_CODE_PAGE_NOT_FOUND";
     case 477: return "ERROR_UNEXPECTED_SLOT_RETURNED";
     case 478: return "ERROR_SMG_INVALID_TRACE_OPTION";
     case 479: return "ERROR_VIO_INTERNAL_RESOURCE";
     case 480: return "ERROR_VIO_SHELL_INIT";
     case 481: return "ERROR_SMG_NO_HARD_ERRORS";
     case 482: return "ERROR_CP_SWITCH_INCOMPLETE";
     case 483: return "ERROR_VIO_TRANSPARENT_POPUP";
     case 484: return "ERROR_CRITSEC_OVERFLOW";
     case 485: return "ERROR_CRITSEC_UNDERFLOW";
     case 486: return "ERROR_VIO_BAD_RESERVE";
     case 487: return "ERROR_INVALID_ADDRESS";
     case 488: return "ERROR_ZERO_SELECTORS_REQUESTED";
     case 489: return "ERROR_NOT_ENOUGH_SELECTORS_AVA";
     case 490: return "ERROR_INVALID_SELECTOR";
     case 491: return "ERROR_SMG_INVALID_PROGRAM_TYPE";
     case 492: return "ERROR_SMG_INVALID_PGM_CONTROL";
     case 493: return "ERROR_SMG_INVALID_INHERIT_OPT";
     case 494: return "ERROR_VIO_EXTENDED_SG";
     case 495: return "ERROR_VIO_NOT_PRES_MGR_SG";
     case 496: return "ERROR_VIO_SHIELD_OWNED";
     case 497: return "ERROR_VIO_NO_MORE_HANDLES";
     case 498: return "ERROR_VIO_SEE_ERROR_LOG";
     case 499: return "ERROR_VIO_ASSOCIATED_DC";
     case 500: return "ERROR_KBD_NO_CONSOLE";
     case 501: return "ERROR_MOUSE_NO_CONSOLE";
     case 502: return "ERROR_MOUSE_INVALID_HANDLE";
     case 503: return "ERROR_SMG_INVALID_DEBUG_PARMS";
     case 504: return "ERROR_KBD_EXTENDED_SG";
     case 505: return "ERROR_MOU_EXTENDED_SG";
     case 506: return "ERROR_SMG_INVALID_ICON_FILE";
     case 507: return "ERROR_TRC_PID_NON_EXISTENT";
     case 508: return "ERROR_TRC_COUNT_ACTIVE";
     case 509: return "ERROR_TRC_SUSPENDED_BY_COUNT";
     case 510: return "ERROR_TRC_COUNT_INACTIVE";
     case 511: return "ERROR_TRC_COUNT_REACHED";
     case 512: return "ERROR_NO_MC_TRACE";
     case 513: return "ERROR_MC_TRACE";
     case 514: return "ERROR_TRC_COUNT_ZERO";
     case 515: return "ERROR_SMG_TOO_MANY_DDS";
     case 516: return "ERROR_SMG_INVALID_NOTIFICATION";
     case 517: return "ERROR_LF_INVALID_FUNCTION";
     case 518: return "ERROR_LF_NOT_AVAIL";
     case 519: return "ERROR_LF_SUSPENDED";
     case 520: return "ERROR_LF_BUF_TOO_SMALL";
     case 521: return "ERROR_LF_BUFFER_CORRUPTED";
     case 522: return "ERROR_LF_INVALID_DAEMON";
     case 523: return "ERROR_LF_INVALID_TEMPL";
     case 524: return "ERROR_LF_GENERAL_FAILURE";
     case 525: return "ERROR_LF_INVALID_ID";
     case 526: return "ERROR_LF_INVALID_HANDLE";
     case 527: return "ERROR_LF_NO_ID_AVAIL";
     case 528: return "ERROR_LF_TEMPLATE_AREA_FULL";
     case 529: return "ERROR_LF_ID_IN_USE";
     case 530: return "ERROR_MOU_NOT_INITIALIZED";
     case 531: return "ERROR_MOUINITREAL_DONE";
     case 532: return "ERROR_DOSSUB_CORRUPTED";
     case 533: return "ERROR_MOUSE_CALLER_NOT_SUBSYS";
     case 534: return "ERROR_ARITHMETIC_OVERFLOW";
     case 535: return "ERROR_TMR_NO_DEVICE";
     case 536: return "ERROR_TMR_INVALID_TIME";
     case 537: return "ERROR_PVW_INVALID_ENTITY";
     case 538: return "ERROR_PVW_INVALID_ENTITY_TYPE";
     case 539: return "ERROR_PVW_INVALID_SPEC";
     case 540: return "ERROR_PVW_INVALID_RANGE_TYPE";
     case 541: return "ERROR_PVW_INVALID_COUNTER_BLK";
     case 542: return "ERROR_PVW_INVALID_TEXT_BLK";
     case 543: return "ERROR_PRF_NOT_INITIALIZED";
     case 544: return "ERROR_PRF_ALREADY_INITIALIZED";
     case 545: return "ERROR_PRF_NOT_STARTED";
     case 546: return "ERROR_PRF_ALREADY_STARTED";
     case 547: return "ERROR_PRF_TIMER_OUT_OF_RANGE";
     case 548: return "ERROR_PRF_TIMER_RESET";
     case 639: return "ERROR_VDD_LOCK_USEAGE_DENIED";
     case 640: return "ERROR_TIMEOUT";
     case 641: return "ERROR_VDM_DOWN";
     case 642: return "ERROR_VDM_LIMIT";
     case 643: return "ERROR_VDD_NOT_FOUND";
     case 644: return "ERROR_INVALID_CALLER";
     case 645: return "ERROR_PID_MISMATCH";
     case 646: return "ERROR_INVALID_VDD_HANDLE";
     case 647: return "ERROR_VLPT_NO_SPOOLER";
     case 648: return "ERROR_VCOM_DEVICE_BUSY";
     case 649: return "ERROR_VLPT_DEVICE_BUSY";
     case 650: return "ERROR_NESTING_TOO_DEEP";
     case 651: return "ERROR_VDD_MISSING";
     case 671: return "ERROR_BIDI_INVALID_LENGTH";
     case 672: return "ERROR_BIDI_INVALID_INCREMENT";
     case 673: return "ERROR_BIDI_INVALID_COMBINATION";
     case 674: return "ERROR_BIDI_INVALID_RESERVED";
     case 675: return "ERROR_BIDI_INVALID_EFFECT";
     case 676: return "ERROR_BIDI_INVALID_CSDREC";
     case 677: return "ERROR_BIDI_INVALID_CSDSTATE";
     case 678: return "ERROR_BIDI_INVALID_LEVEL";
     case 679: return "ERROR_BIDI_INVALID_TYPE_SUPPORT";
     case 680: return "ERROR_BIDI_INVALID_ORIENTATION";
     case 681: return "ERROR_BIDI_INVALID_NUM_SHAPE";
     case 682: return "ERROR_BIDI_INVALID_CSD";
     case 683: return "ERROR_BIDI_NO_SUPPORT";
     case 691: return "ERROR_IMP_INVALID_PARM";
     case 692: return "ERROR_IMP_INVALID_LENGTH";
     case 730: return "ERROR_MON_BAD_BUFFER";
     case 731: return "ERROR_MODULE_CORRUPTED";
     case 1477: return "ERROR_SM_OUTOF_SWAPFILE";
     case 2055: return "ERROR_LF_TIMEOUT";
     case 2057: return "ERROR_LF_SUSPEND_SUCCESS";
     case 2058: return "ERROR_LF_RESUME_SUCCESS";
     case 2059: return "ERROR_LF_REDIRECT_SUCCESS";
     case 2060: return "ERROR_LF_REDIRECT_FAILURE";
     case 32768: return "ERROR_SWAPPER_NOT_ACTIVE";
     case 32769: return "ERROR_INVALID_SWAPID";
     case 32770: return "ERROR_IOERR_SWAP_FILE";
     case 32771: return "ERROR_SWAP_TABLE_FULL";
     case 32772: return "ERROR_SWAP_FILE_FULL";
     case 32773: return "ERROR_CANT_INIT_SWAPPER";
     case 32774: return "ERROR_SWAPPER_ALREADY_INIT";
     case 32775: return "ERROR_PMM_INSUFFICIENT_MEMORY";
     case 32776: return "ERROR_PMM_INVALID_FLAGS";
     case 32777: return "ERROR_PMM_INVALID_ADDRESS";
     case 32778: return "ERROR_PMM_LOCK_FAILED";
     case 32779: return "ERROR_PMM_UNLOCK_FAILED";
     case 32780: return "ERROR_PMM_MOVE_INCOMPLETE";
     case 32781: return "ERROR_UCOM_DRIVE_RENAMED";
     case 32782: return "ERROR_UCOM_FILENAME_TRUNCATED";
     case 32783: return "ERROR_UCOM_BUFFER_LENGTH";
     case 32784: return "ERROR_MON_CHAIN_HANDLE";
     case 32785: return "ERROR_MON_NOT_REGISTERED";
     case 32786: return "ERROR_SMG_ALREADY_TOP";
     case 32787: return "ERROR_PMM_ARENA_MODIFIED";
     case 32788: return "ERROR_SMG_PRINTER_OPEN";
     case 32789: return "ERROR_PMM_SET_FLAGS_FAILED";
     case 32790: return "ERROR_INVALID_DOS_DD";
     case 32791: return "ERROR_BLOCKED";
     case 32792: return "ERROR_NOBLOCK";
     case 32793: return "ERROR_INSTANCE_SHARED";
     case 32794: return "ERROR_NO_OBJECT";
     case 32795: return "ERROR_PARTIAL_ATTACH";
     case 32796: return "ERROR_INCACHE";
     case 32797: return "ERROR_SWAP_IO_PROBLEMS";
     case 32798: return "ERROR_CROSSES_OBJECT_BOUNDARY";
     case 32799: return "ERROR_LONGLOCK";
     case 32800: return "ERROR_SHORTLOCK";
     case 32801: return "ERROR_UVIRTLOCK";
     case 32802: return "ERROR_ALIASLOCK";
     case 32803: return "ERROR_ALIAS";
     case 32804: return "ERROR_NO_MORE_HANDLES";
     case 32805: return "ERROR_SCAN_TERMINATED";
     case 32806: return "ERROR_TERMINATOR_NOT_FOUND";
     case 32807: return "ERROR_NOT_DIRECT_CHILD";
     case 32808: return "ERROR_DELAY_FREE";
     case 32809: return "ERROR_GUARDPAGE";
     case 32900: return "ERROR_SWAPERROR";
     case 32901: return "ERROR_LDRERROR";
     case 32902: return "ERROR_NOMEMORY";
     case 32903: return "ERROR_NOACCESS";
     case 32904: return "ERROR_NO_DLL_TERM";
     case 65026: return "ERROR_CPSIO_CODE_PAGE_INVALID";
     case 65027: return "ERROR_CPSIO_NO_SPOOLER";
     case 65028: return "ERROR_CPSIO_FONT_ID_INVALID";
     case 65033: return "ERROR_CPSIO_INTERNAL_ERROR";
     case 65034: return "ERROR_CPSIO_INVALID_PTR_NAME";
     case 65037: return "ERROR_CPSIO_NOT_ACTIVE";
     case 65039: return "ERROR_CPSIO_PID_FULL";
     case 65040: return "ERROR_CPSIO_PID_NOT_FOUND";
     case 65043: return "ERROR_CPSIO_READ_CTL_SEQ";
     case 65045: return "ERROR_CPSIO_READ_FNT_DEF";
     case 65047: return "ERROR_CPSIO_WRITE_ERROR";
     case 65048: return "ERROR_CPSIO_WRITE_FULL_ERROR";
     case 65049: return "ERROR_CPSIO_WRITE_HANDLE_BAD";
     case 65074: return "ERROR_CPSIO_SWIT_LOAD";
     case 65077: return "ERROR_CPSIO_INV_COMMAND";
     case 65078: return "ERROR_CPSIO_NO_FONT_SWIT";
     case 65079: return "ERROR_ENTRY_IS_CALLGATE";
     default: return "unknown error";
     }
  }

static int cmp(char *s, PSZ cs)
  {
  ULONG x=(ULONG)cs;

  return (*(ULONG *)s) == x;
  }

static char *queryClassname(char *classname)
  {
  if (cmp(classname, WC_FRAME))
     return "[Frame]";
  else if (cmp(classname, WC_COMBOBOX))
     return "[ComboBox]";
  else if (cmp(classname, WC_BUTTON))
     return "[Button]";
  else if (cmp(classname, WC_MENU))
     return "[Menu]";
  else if (cmp(classname, WC_STATIC))
     return "[Static]";
  else if (cmp(classname, WC_ENTRYFIELD))
     return "[Entryfield]";
  else if (cmp(classname, WC_LISTBOX))
     return "[Listbox]";
  else if (cmp(classname, WC_SCROLLBAR))
     return "[Scrollbar]";
  else if (cmp(classname, WC_TITLEBAR))
     return "[Titlebar]";
  else if (cmp(classname, WC_MLE))
     return "[Mle]";
  else if (cmp(classname, WC_SPINBUTTON))
     return "[SpinButton]";
  else if (cmp(classname, WC_CONTAINER))
     return "[Container]";
  else if (cmp(classname, WC_SLIDER))
     return "[Slider]";
  else if (cmp(classname, WC_VALUESET))
     return "[ValueSet]";
  else if (cmp(classname, WC_NOTEBOOK))
     return "[Notebook]";
  else if (cmp(classname, WC_CIRCULARSLIDER))
     return "[CircSlider]";
  else
     return classname;
  }

static char *querywmessage(unsigned msg)
  {
  switch(msg)
     {
     case 0x0000: return "WM_NULL";
     case 0x0001: return "WM_CREATE";
     case 0x0002: return "WM_DESTROY";
     case 0x0004: return "WM_ENABLE";
     case 0x0005: return "WM_SHOW";
     case 0x0006: return "WM_MOVE";
     case 0x0007: return "WM_SIZE";
     case 0x0008: return "WM_ADJUSTWINDOWPOS";
     case 0x0009: return "WM_CALCVALIDRECTS";
     case 0x000a: return "WM_SETWINDOWPARAMS";
     case 0x000b: return "WM_QUERYWINDOWPARAMS";
     case 0x000c: return "WM_HITTEST";
     case 0x000d: return "WM_ACTIVATE";
     case 0x000f: return "WM_SETFOCUS";
     case 0x0010: return "WM_SETSELECTION";
     case 0x0011: return "WM_PPAINT";
     case 0x0012: return "WM_PSETFOCUS";
     case 0x0013: return "WM_PSYSCOLORCHANGE";
     case 0x0014: return "WM_PSIZE";
     case 0x0015: return "WM_PACTIVATE";
     case 0x0016: return "WM_PCONTROL";
     case 0x0020: return "WM_COMMAND";
     case 0x0021: return "WM_SYSCOMMAND";
     case 0x0022: return "WM_HELP";
     case 0x0023: return "WM_PAINT";
     case 0x0024: return "WM_TIMER";
     case 0x0025: return "WM_SEM1";
     case 0x0026: return "WM_SEM2";
     case 0x0027: return "WM_SEM3";
     case 0x0028: return "WM_SEM4";
     case 0x0029: return "WM_CLOSE";
     case 0x002a: return "WM_QUIT";
     case 0x002b: return "WM_SYSCOLORCHANGE";
     case 0x002d: return "WM_SYSVALUECHANGED";
     case 0x002e: return "WM_APPTERMINATENOTIFY";
     case 0x002f: return "WM_PRESPARAMCHANGED";
     case 0x0030: return "WM_CONTROL";
     case 0x0031: return "WM_VSCROLL";
     case 0x0032: return "WM_HSCROLL";
     case 0x0033: return "WM_INITMENU";
     case 0x0034: return "WM_MENUSELECT";
     case 0x0035: return "WM_MENUEND";
     case 0x0036: return "WM_DRAWITEM";
     case 0x0037: return "WM_MEASUREITEM";
     case 0x0038: return "WM_CONTROLPOINTER";
     case 0x003a: return "WM_QUERYDLGCODE";
     case 0x003b: return "WM_INITDLG";
     case 0x003c: return "WM_SUBSTITUTESTRING";
     case 0x003d: return "WM_MATCHMNEMONIC";
     case 0x003e: return "WM_SAVEAPPLICATION";
     case 0x0F00: return "WM_HELPBASE";
     case 0x0FFF: return "WM_HELPTOP";
     case 0x1000: return "WM_USER";
     case 0x0079: return "WM_MOUSELAST / WM_BUTTONCLICKLAST / WM_BUTTON3DBLCLK";
     case 0x0070: return "WM_MOUSEMOVE";
     case 0x0071: return "WM_BUTTON1DOWN";
     case 0x0072: return "WM_BUTTON1UP";
     case 0x0073: return "WM_BUTTON1DBLCLK";
     case 0x0074: return "WM_BUTTON2DOWN";
     case 0x0075: return "WM_BUTTON2UP";
     case 0x0076: return "WM_BUTTON2DBLCLK";
     case 0x0077: return "WM_BUTTON3DOWN";
     case 0x0078: return "WM_BUTTON3UP";
     case 0x007D: return "WM_MOUSEMAP";
     case 0x0410: return "WM_EXTMOUSEFIRST / WM_CHORD";
     case 0x0411: return "WM_BUTTON1MOTIONSTART";
     case 0x0412: return "WM_BUTTON1MOTIONEND";
     case 0x0413: return "WM_BUTTON1CLICK";
     case 0x0414: return "WM_BUTTON2MOTIONSTART";
     case 0x0415: return "WM_BUTTON2MOTIONEND";
     case 0x0416: return "WM_BUTTON2CLICK";
     case 0x0417: return "WM_BUTTON3MOTIONSTART";
     case 0x0418: return "WM_BUTTON3MOTIONEND";
     case 0x0419: return "WM_BUTTON3CLICK";
     case 0x0428: return "WM_ENDSELECT / WM_MOUSETRANSLATELAST";
     case 0x0420: return "WM_BEGINDRAG";
     case 0x0421: return "WM_ENDDRAG";
     case 0x0422: return "WM_SINGLESELECT";
     case 0x0423: return "WM_OPEN";
     case 0x0424: return "WM_CONTEXTMENU";
     case 0x0425: return "WM_CONTEXTHELP";
     case 0x0426: return "WM_TEXTEDIT";
     case 0x0427: return "WM_BEGINSELECT";
     case 0x04C0: return "WM_PENFIRST";
     case 0x04FF: return "WM_PENLAST";
     case 0x0500: return "WM_MMPMFIRST";
     case 0x05FF: return "WM_MMPMLAST";
     case 0x007a: return "WM_CHAR";
     case 0x007b: return "WM_VIOCHAR";
     case 0x007c: return "WM_JOURNALNOTIFY";
     case 0x0040: return "WM_FLASHWINDOW";
     case 0x0041: return "WM_FORMATFRAME";
     case 0x0042: return "WM_UPDATEFRAME";
     case 0x0043: return "WM_FOCUSCHANGE";
     case 0x0044: return "WM_SETBORDERSIZE";
     case 0x0045: return "WM_TRACKFRAME";
     case 0x0046: return "WM_MINMAXFRAME";
     case 0x0047: return "WM_SETICON";
     case 0x0048: return "WM_QUERYICON";
     case 0x0049: return "WM_SETACCELTABLE";
     case 0x004a: return "WM_QUERYACCELTABLE";
     case 0x004b: return "WM_TRANSLATEACCEL";
     case 0x004c: return "WM_QUERYTRACKINFO";
     case 0x004d: return "WM_QUERYBORDERSIZE";
     case 0x004e: return "WM_NEXTMENU";
     case 0x004f: return "WM_ERASEBACKGROUND";
     case 0x0050: return "WM_QUERYFRAMEINFO";
     case 0x0051: return "WM_QUERYFOCUSCHAIN";
     case 0x0052: return "WM_OWNERPOSCHANGE";
     case 0x0053: return "WM_CALCFRAMERECT";
     case 0x0055: return "WM_WINDOWPOSCHANGED";
     case 0x0056: return "WM_ADJUSTFRAMEPOS";
     case 0x0059: return "WM_QUERYFRAMECTLCOUNT";
     case 0x005B: return "WM_QUERYHELPINFO";
     case 0x005C: return "WM_SETHELPINFO";
     case 0x005D: return "WM_ERROR";
     case 0x005E: return "WM_REALIZEPALETTE";
     case 0x0060: return "WM_RENDERFMT";
     case 0x0061: return "WM_RENDERALLFMTS";
     case 0x0062: return "WM_DESTROYCLIPBOARD";
     case 0x0063: return "WM_PAINTCLIPBOARD";
     case 0x0064: return "WM_SIZECLIPBOARD";
     case 0x0065: return "WM_HSCROLLCLIPBOARD";
     case 0x0066: return "WM_VSCROLLCLIPBOARD";
     case 0x0067: return "WM_DRAWCLIPBOARD";
     case 0x00A0: return "WM_DDE_FIRST / WM_DDE_INITIATE";
     case 0x00A1: return "WM_DDE_REQUEST";
     case 0x00A2: return "WM_DDE_ACK";
     case 0x00A3: return "WM_DDE_DATA";
     case 0x00A4: return "WM_DDE_ADVISE";
     case 0x00A5: return "WM_DDE_UNADVISE";
     case 0x00A6: return "WM_DDE_POKE";
     case 0x00A7: return "WM_DDE_EXECUTE";
     case 0x00A8: return "WM_DDE_TERMINATE";
     case 0x00A9: return "WM_DDE_INITIATEACK";
     case 0x00AF: return "WM_DDE_LAST";
     case 0x00b0: return "WM_QUERYCONVERTPOS / WM_DBCSFIRST";
     case 0x00cf: return "WM_DBCSLAST";
     default:     return "?";
     }
  }

#endif
