/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     default.cpp                                                      *
*  Aufgabe:   Standardaktionen bei Anwahl der vorgegebenen Menpunkte          *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include <stdio.h>
#include <ctype.h>
//#ifdef __WATCOMC__
 #include <io.h>
//#endif

#include "debug.h"
#include "edit.h"
#include "action.h"
#include "editor.h"
#include "menu.h"
#include "mle.h"
#include "ctedit.h"
#include "srchdlg.h"
#include "generic.h"

// Blocksize fr den EMX nicht grer 32K
#define BLOCKSIZE 32000

MRESULT EXPENTRY SearchDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern HMODULE module;

inline void MsgBox(char *headline, char *text)
  {
  ensure(validread(headline) && validread(text));
  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, (PSZ)text, (PSZ)headline, 0,
               MB_OK|MB_MOVEABLE);
  }

/* Name     : fileDlg
** Task     : File Dialog
** Input    : HWND hwnd                 - window handle des MLE
              char *name                - Dateiname
              int attr                  - FDS_OPEN_DIALOG,  FDS_SAVEAS_DIALOG
** Output   : BOOL                      - TRUE: ok FALSE: Abort
*/
BOOL fileDlg(HWND hwnd, char *name, int attr)
  {
  ensure(validwin(hwnd) && validptr(name) && validptr(name+CCHMAXPATH-1));

  FILEDLG fild;
  ensure(validptr(&fild));
  ULONG drive, dummy;
  char *def;
  static char  lastPath[CCHMAXPATH];
  static ULONG lastDrive;

  def="*.*";
  *name=0;
  memset((void *)&fild, 0, sizeof(FILEDLG));
  fild.cbSize=sizeof(FILEDLG);
  fild.fl=attr|FDS_CENTER|FDS_HELPBUTTON;

  if (lastPath[0]=='\0')
     {
     DosQueryCurrentDisk(&drive, &dummy);
     ULONG len=CCHMAXPATH;
     DosQueryCurrentDir(drive, fild.szFullFile+1, &len);
     fild.szFullFile[0]='\\';
     strcat(fild.szFullFile, "\\*.*");
     }
  else
     {
     drive=lastDrive;
     strcpy(fild.szFullFile, lastPath);
     }
  fild.pszIDrive=new char[4];
  strcpy(fild.pszIDrive, "C:");
  fild.pszIDrive[0]=(char)64+drive;
//fild.pszIDrive="c:\\";

  /* File Dialog box */
  WinFileDlg(HWND_DESKTOP, hwnd, &fild);
  delete fild.pszIDrive;

  if (fild.lReturn==DID_OK)
     {
     strcpy(name, fild.szFullFile);
     strcpy(lastPath, name+2);
     lastDrive=toupper(name[0]);
     lastDrive-=64;
     for (char *p=lastPath+strlen(lastPath);p>lastPath;--p)
        if (*p=='\\')
           { *(p+1)=0; break; }
     if (p>lastPath)
        strcat(lastPath, "*.*");
     else
        strcpy(lastPath, "\\*.*");

     return TRUE;
     } /* endif: fild.lReturn==DID_OK */
  return FALSE;
  } /* fileDlg */



/* Name     : fontDlg
** Task     : Font Dialog
** Input    : HWND hwnd                 - window handle des MLE
              FATTRS *fAttrs            - Schriftattribute (Ausgabe)
              BOOL monospaced           - TRUE: monospaced font
*/
BOOL fontDlg(HWND hwnd, FATTRS *fAttrs, BOOL monospaced)
  {
  ensure(validwin(hwnd) && validptr(fAttrs) && (monospaced==TRUE||monospaced==FALSE));
  FONTDLG fntd;

  HWND hwndFontDlg;
  CHAR szFamilyname[FACESIZE];

  memset(&fntd, 0, sizeof(FONTDLG));
  memcpy(&fntd.fAttrs, fAttrs, sizeof(FATTRS));

  fntd.cbSize=sizeof(FONTDLG);
  fntd.fl=FNTS_HELPBUTTON|FNTS_CENTER;
  fntd.fl|=monospaced ? FNTS_FIXEDWIDTHONLY :FNTS_PROPORTIONALONLY;
  fntd.clrFore=CLR_BLACK;
  fntd.clrBack=SYSCLR_WINDOW;
  fntd.fxPointSize=MAKEFIXED(8,0);
  fntd.hpsScreen=WinGetPS(hwnd);
  fntd.usWeight=5;
  fntd.usWidth=5;
  szFamilyname[0]=0;
  strcpy(szFamilyname, fAttrs->szFacename);
  fntd.pszFamilyname=szFamilyname;
  fntd.usFamilyBufLen=FACESIZE;
  fntd.pszTitle="Schriftart";
  fntd.pszPreview="c't - Beipieltext";

  hwndFontDlg=WinFontDlg(HWND_DESKTOP, hwnd, &fntd);

  WinReleasePS(fntd.hpsScreen);

  if ( hwndFontDlg && fntd.lReturn==DID_OK)
     {
     memcpy(fAttrs, &fntd.fAttrs, sizeof(FATTRS));
     return TRUE;
     } /* endif: hwndFontDlg && fntd.lReturn==DID_OK */
  return FALSE;
  } /* fontDlg */


/* Name     : loadMLE
** Task     : lade eine Datei in ein MLE
** Input    : HWND hwnd                 - window handle des MLE
              char *name                - Name der Datei
** Output   : TRUE: alles ok
** State    : under construction
*/
BOOL loadMLE(HWND hwnd, char *name)
  {
  ensure(validwin(hwnd) && validread(name));
  FILE *fp;
  char *buffer;
  ULONG offset=0, count;

  buffer=new char[BLOCKSIZE];
  ensure(buffer && validread(buffer));

  /* Datei ffnen */
  if (access(name, 0)==-1)
     {
     // Datei existiert nicht
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)"Datei existiert nicht.",
                    "Fehler beim ffnen",
                   0, MB_OK|MB_ICONEXCLAMATION);
     return TRUE;
     }
  if (access(name, 4)==-1)
     {
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)"Achtung, keine Leseberechtigung der Datei.",
                    "Fehler beim ffnen",
                   0, MB_OK|MB_ICONEXCLAMATION);
     return FALSE;
     }

  fp=fopen(name, "r");
  if (!fp)
     {
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)"Achtung, es trat ein Fehler beim ffnen der Datei auf.",
                    "Fehler beim ffnen",
                   0, MB_OK|MB_ICONEXCLAMATION);
     delete buffer;
     return FALSE;
     }

  memset(buffer, 0, BLOCKSIZE);

  /* Aktuellen Text im MLE lschen */
  WinSetWindowText(hwnd, "");

  /*
  ** Laden ins MLE
  */
  WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, buffer, (MPARAM)(BLOCKSIZE));

  count=(int)WinSendMsg(hwnd, MLM_QUERYTEXTLENGTH,0,(MPARAM)-1);
  WinSendMsg(hwnd, MLM_FORMAT, (MPARAM)MLFIE_NOTRANS, 0);
  WinSendMsg(hwnd, MLM_DELETE, 0, (MPARAM)count);

  WinSendMsg(hwnd, MLM_DISABLEREFRESH, 0, 0);
  while ( (count=fread(buffer, 1, BLOCKSIZE, fp)) != 0)
     {
     WinSendMsg(hwnd, MLM_IMPORT, (MPARAM)&offset, (MPARAM)count);
     } /* endwhile: (count=fread(buffer, 1, BLOCKSIZE, fp)) */
  if (ferror(fp))
     {
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)strerror(ferror(fp)),
                    "Fehler beim Lesen der Datei",
                   0, MB_OK|MB_ICONEXCLAMATION);
     WinSendMsg(hwnd, MLM_ENABLEREFRESH, 0, 0);
     WinPostMsg(hwnd, MLM_SETCHANGED, (MPARAM)TRUE, 0);
     fclose(fp);
     return FALSE;
     }

  WinSendMsg(hwnd, MLM_ENABLEREFRESH, 0, 0);
  fclose(fp);

  /* Ok, buffer wird nicht mehr gebraucht */
  delete buffer;

  /* Setze Text auf "nicht gendert" */
  WinPostMsg(hwnd, MLM_SETCHANGED, (MPARAM)FALSE, 0);

  /* ok */
  return TRUE;
  } /* loadMLE */



/* Name     : saveMLE
** Task     : speichere Inhalt des MLE mit Namen
** Input    : HWND hwnd                 - window handle des MLE
              char *name                - neuer Name
** Output   : TRUE: alles ok
*/
BOOL saveMLE(HWND hwnd, char *name)
  {
  ensure(validwin(hwnd) && validread(name));
  FILE *fp;
  char *buffer=new char[BLOCKSIZE];
  ensure(validptr(buffer));
  ULONG offset=0, count=-1, written;

  /* Lschen der Datei */
  remove(name);

  fp=fopen(name, "wb");
  if (!fp)
     {
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)"Achtung, die Datei konnte nicht geschrieben werden.",
                    "Fehler beim Schreiben",
                   0, MB_OK|MB_ICONEXCLAMATION);
     return FALSE;
     }

  memset(buffer, 0, BLOCKSIZE);
  WinSendMsg(hwnd, MLM_FORMAT, (MPARAM)MLFIE_CFTEXT, 0);

  WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, (MPARAM)buffer, (MPARAM)BLOCKSIZE);
  count=(int)WinSendMsg(hwnd, MLM_QUERYTEXTLENGTH,0, (MPARAM)-1);
  while ((written=(ULONG)WinSendMsg(hwnd, MLM_EXPORT, (MPARAM)&offset, (MPARAM)&count))!=0)
     fwrite(buffer, written, 1, fp);
  if (ferror(fp))
     {
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)strerror(ferror(fp)),
                    "Fehler beim Schreiben",
                   0, MB_OK|MB_ICONEXCLAMATION);
     fclose(fp);
     delete buffer;
     return FALSE;
     }
  fclose(fp);
  delete buffer;
  WinPostMsg(hwnd, MLM_SETCHANGED, (MPARAM)FALSE, 0);
  return TRUE;
  } /* saveMLE */



/* Name     : load
** Task     : Laden einer Datei in den Editor
** Input    : HWND hwnd                 - window handle des MLE
              char *name                -
** State    : under construction
*/
int load(HWND hwnd, char *name)
  {
  ensure(validwin(hwnd) && validread(name));
  if (fileDlg(hwnd, name, FDS_OPEN_DIALOG))
     {
     loadMLE(hwnd, name);
     /*
     if (!loadMLE(hwnd, name))
        MsgBox("Achtung", "Die Datei kann nicht geladen werden");
     else
     */
        return TRUE;
     } /* endif: fileDlg(hwnd, name, FDS_OPEN_DIALOG) */
  return FALSE;
  } /* load */

/* Name     : saveas
** Task     : Speichern einer Datei
** Input    : HWND hwnd                 - window handle des MLE
              char *name                - Name der Datei
*/
void saveas(HWND hwnd, char *name)
  {
  ensure(validwin(hwnd) && validptr(name));

  if (fileDlg(hwnd, name, FDS_SAVEAS_DIALOG|FDS_ENABLEFILELB))
     {
     FILE *fp=fopen(name, "r");
     if (fp)
        {
        fclose(fp);

        if (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
            (PSZ)"Achtung, die Datei existiert schon. Soll die "
                 "Datei berschrieben werden?", "Achtung",
                 0, MB_OKCANCEL) !=MBID_OK)
          {
           name[0]=0;
           return;
          }
        } /* endif: fp */
     if (!saveMLE(hwnd, name))
        name[0]=0;
     /*
     if (!saveMLE(hwnd, name))
        MsgBox("Fehler", "Die Datei kann nicht gespeichert werden");
     */
     } /* endif: fileDlg(hwnd, name, FDS_SAVEAS_DIALOG|FDS_ENABLEFILELB) */
  } /* saveas */



/* Name     : save
** Task     : Speichern des MLE
** Input    : HWND hwnd                 - window handle des MLE
              char *name                - Name der Datei
*/
void save(HWND hwnd, char *name)
  {
  if (!*name)
     saveas(hwnd, name);
  else
     saveMLE(hwnd, name);
  } /* save */


ActionBase *DefaultAction[] =
  {
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::discard),            "~Neu",            "Einen neuen Text bearbeiten",  ID_MENUITEM_NEW, 0, 0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::open),               "~ffnen",         "Eine neue Datei laden",        ID_MENUITEM_OPEN, 0, 0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::save),               "~Speichern",      "Die aktuelle Datei speichern", ID_MENUITEM_SAVE, 0, 0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::saveas),             "Speichern unter", "Die aktuelle Datei unter einem neuen Namen speichern", ID_MENUITEM_SAVEAS, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::quit),               "Beenden",         "Editor beenden", ID_MENUITEM_QUIT, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::print),              "Drucken",         "Datei drucken", ID_MENUITEM_PRINT, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::undo),               "~Widerrufen",     "Letzte nderung rckgngig machen", ID_MENUITEM_UNDO, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::cut),                "Ausschneiden",    "Markierten Text ausschneiden und ins Clipboard kopieren ", ID_MENUITEM_CUT, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::copy),               "Kopieren",        "Markierten Text ins Clipboard kopieren", ID_MENUITEM_COPY,0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::insert),             "Einfgen",        "Text aus dem Clipboard einfgen", ID_MENUITEM_INSERT, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::clear),              "Lschen",         "Markierten Text lschen", ID_MENUITEM_DELETE, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::markall),            "Alles markieren", "Den gesamten Text markieren", ID_MENUITEM_MARKALL, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::dlgSearch),          "Suchen",          "Einen String im Text suchen", ID_MENUITEM_SEARCH, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::monoFont),           "Schriftart(mono) setzen", "Zur monospaced Schriftart wechseln", ID_MENUITEM_FONTMSET, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::setMonoFont),        "Schriftart(mono) whlen", "Monospaced Schriftart auswhlen", ID_MENUITEM_FONTMCHANGE, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::propFont),           "Schriftart(prop) setzen", "Zur proportionalen Schriftart wechseln", ID_MENUITEM_FONTPSET, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::setPropFont),        "Schriftart(prop) whlen", "Proportionale Schriftart auswhlen", ID_MENUITEM_FONTPCHANGE, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::fontToggle),         "Schriftart wechseln", "Schriftart wechseln (monospaced <-> proportional)", ID_MENUITEM_FONTTOGGLE, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::colorPalette),       "Farbpalette",     "WPS Objekt \"Farbpalette\" ffnen", ID_MENUITEM_COLOR,0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::wordWrapOn),         "Umbruch (an)",    "Zeilenumbruch einschalten", ID_MENUITEM_WWON, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::wordWrapOff),        "Umbruch (aus)",   "Zeilenumbruch ausschalten", ID_MENUITEM_WWOFF, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::toolbarToggle),      "Toolbar (an)",    "Toolbar sichtbar/unsichtbar machen", ID_MENUITEM_TOOLBAR, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::autoIndentToggle),   "Autoindent",      "Automatisches Einrcken", ID_MENUITEM_INDENT, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::quickmarkToggle),    "Quick cut'n paste","Schnelles Markieren und Clipboard-Kopieren", ID_MENUITEM_QUICKMARK,0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::saveini),            "Einstellungen speichern", "Aktuelle Einstellungen speichern", ID_MENUITEM_OPTIONSAVE, 0,0),
  new ActionMember((Editor::ActionMemberFnPtr)(Editor::about),              "Produktinformation", "Produktinformation", ID_MENUITEM_HELPABOUT, 0,0),
  new Action(0,"","",0,0,0)
  };
/* Name     : initDefaultAction
** Task     : Standardaktionsliste aufbauen
** Input    : ActionList& list          - Liste
*/
void initDefaultAction(ActionList& list)
  {
  // list.clear();
  list.remove(USER_OFFSET_ID);

/*
  for (int i=0; DefaultAction[i].id; i++)
     list.append(&DefaultAction[i]);
*/
  } /* initDefaultAction */


#pragma pack(4)
typedef struct _ESEARCH
{
  USHORT cb;
  PCHAR  pchFind;
  PCHAR  pchReplace;
  SHORT  cchFind;
  SHORT  cchReplace;
  IPT    iptStart;
  IPT    iptStop;
  USHORT cchFound;
} MLE_ESEARCHDATA;
#pragma pack()

/* Name     : SearchDlgProc
** Task     : Dialog window procedure
** Input    : HWND hwnd                 - dialog handle
              ULONG msg                 - Message
              MPARAM mp1                - Parameter 1
              MPARAM mp2                - Parameter 2
*/
MRESULT EXPENTRY SearchDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  MLE_ESEARCHDATA mlesrch;
  HWND hwndEntry;
  char search[128];
  char replace[128];
  BOOL rc;
  BOOL changeAll, caseSensitive;
  ULONG style;
  HWND h;
  HWND hwndMle=0;

  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  if (edit)
     {
     ensure(validread(edit));
     hwndMle=edit->queryMle();
     }

  switch (msg)
     {
     case WM_INITDLG:
        WinSetFocus(WinWindowFromID(hwnd, IDS_SEARCH), TRUE);
        WinSetWindowPtr(hwnd, QWL_USER, (void *)mp2);
        break;
     case WM_COMMAND:
        switch(SHORT1FROMMP(mp1))
           {
           case IDS_CANCEL:
                 WinDismissDlg(hwnd, TRUE);
                 break;
           case IDS_SEARCH:
           case IDS_CHANGE:
              ensure(validptr(search));
              ensure(validptr(replace));
              ensure(validptr(&mlesrch));
              hwndEntry = WinWindowFromID(hwnd, IDS_FIND);
              ensure(validwin(hwndEntry));
              WinQueryWindowText(hwndEntry,
                                 sizeof(search),
                                 search);

              hwndEntry = WinWindowFromID(hwnd, IDS_REPLACE);
              ensure(validwin(hwndEntry));
              WinQueryWindowText(hwndEntry,
                                 sizeof(replace),
                                 replace);

              /* Fill the MLE_SEARCHDATA data structure                          */
              mlesrch.cb         = sizeof(MLE_ESEARCHDATA);  /* Structure size           */
              mlesrch.pchFind    = search;           /* Search string            */
              mlesrch.pchReplace = SHORT1FROMMP(mp1)==IDS_SEARCH ?
                                      0 : replace;
              mlesrch.cchFind    = strlen(search);
              mlesrch.cchReplace = strlen(replace);
              mlesrch.iptStart   = -1;
              mlesrch.iptStop    = -1;

              caseSensitive=
                  (BOOL)WinSendMsg(WinWindowFromID(hwnd, IDS_CASESENSITIVE),
                             BM_QUERYCHECK, 0,0);
              changeAll=
                  (BOOL)WinSendMsg(WinWindowFromID(hwnd, IDS_CHANGEALL),
                             BM_QUERYCHECK, 0,0);
              /* Start the search operation */
              style=MLFSEARCH_SELECTMATCH;
              if (changeAll && SHORT1FROMMP(mp1)==IDS_CHANGE)
                 style=MLFSEARCH_CHANGEALL;
              if (caseSensitive)
                 style|=MLFSEARCH_CASESENSITIVE;
              ensure(validwin(hwndMle));
              rc=(BOOL)WinSendMsg(hwndMle,
                         MLM_SEARCH,
                         (MPARAM)style,
                         (MPARAM)&mlesrch);
              if (SHORT1FROMMP(mp1)==IDS_CHANGE)
                 WinSendMsg(hwndMle, MLM_INSERT, (MPARAM)replace, 0);
              if (!rc)
                 WinDismissDlg(hwnd, TRUE);
              return FALSE;
              } /* endswitch: SHORT1FROMMP(mp1) */
        break;
     } /* endswitch: msg */
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
  }
