#include <somobj.hh>
#include "BEdit.hh"

class AppEditor;

#pragma SOMNoMangling(on)
class SOMEditor : public Editor
  {
#pragma SOMClassName(*, "SOMEditor")
#pragma SOMClassVersion(*,1,0)
#pragma SOMIDLPass(*,"Implementation-Begin", "dllname=\"editdll.dll\";")
    AppEditor *edit;
  public:
    SOMEditor();
    virtual ~SOMEditor();
// "interne" Informationen
    virtual HWND       queryFrame();
    virtual HWND       queryContextMenu();
    virtual HWND       queryToolbar();
    virtual HWND       queryMle();

// Datei (laden, speichern, exportieren, ...)
    virtual char      *queryName();
    virtual char      *setName(char *x);
    virtual void       load(char *s);
    virtual void       save(char *s=0);
    virtual BOOL       getText(char *buffer, int length, int pos=0);
    virtual BOOL       getTextLine(char *buffer, int length, int line);
    virtual void       loadini();
    virtual void       saveini();

// Editieren (cut, paste, ...)
    virtual void       add(char *text, BOOL changeCurPos=FALSE, int offset=-1);
    virtual void       addLine(char *text, BOOL changeCurPos, int offset=-1);
    virtual BOOL       isChanged();
    virtual void       clear();
    virtual void       clearAll();
    virtual void       copy();
    virtual void       cut();
    virtual void       paste();
    virtual void       insert(char *text);
    virtual void       discard();
    virtual void       undo();
    virtual void       markall();
    virtual void       disableUpdate();
    virtual void       enableUpdate();
    virtual void       setWordWrap(BOOL w=TRUE);
    virtual BOOL       queryWordWrap();
    virtual void       setReadOnly(BOOL set=TRUE);
    virtual BOOL       queryReadOnly();
    virtual void       setChangedFlag(BOOL c);
    virtual void       resetChangedFlag();
    virtual void       removeLine(int line);
    virtual int        queryNrOfLines();
    virtual void       setText(char *);
    virtual int        queryTextLength();

// Cursor
    virtual int        queryCurrentLine();
    virtual int        queryCurrentCol();
    virtual int        queryCurrentCurPos();

    virtual void       setCurrentLine(int line);
    virtual void       setCurrentCol(int col);
    virtual void       setCurrentCurPos(int pos);

// Features (Toolbar, ...)
    virtual void       setStatusText(char *s);
    virtual BOOL       queryIndent();
    virtual void       setIndent(BOOL b);
    virtual BOOL       queryQuickmark();
    virtual void       setQuickmark(BOOL b);
    virtual BOOL       queryHideToolbar();
    virtual void       hideToolbar(BOOL b);
#pragma SOMNoMangling(off)
    virtual ActionFnPtr addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual ActionFnPtr addMenuItem(ActionFnPtr p, int mainmenu, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual int        addContextMenu(ActionFnPtr p, int mainmenu, char *entry, char *description, int *ret_id=0);

    virtual ActionFnPtr addToolbarButton(ActionMemberFnPtr p, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual ActionFnPtr addMenuItem(ActionMemberFnPtr p, int mainmenu, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual int        addContextMenu(ActionMemberFnPtr p, int mainmenu, char *entry, char *description, int *ret_id=0);
#pragma SOMNoMangling(pop)

    virtual BOOL       doAction(int i);
    virtual BOOL       search(char *s, int offset=-1);

// Hilfsfunktionen
    virtual void       setConditionalMenu(int submenuid, int defaultid);
    virtual void       setMenuChecked(int id, BOOL set=TRUE);
// Farbe
    virtual void       setColor(int color);
    virtual unsigned   queryBkColor();
    virtual void       setBkColor(unsigned color=CLR_WHITE);
    virtual unsigned   queryFgColor();
    virtual void       setFgColor(unsigned color=CLR_BLACK);

// Font
    virtual void       setFonttype(BOOL b);
    virtual BOOL       queryFonttype();
    virtual FATTRS&    queryMonoFont();
    virtual FATTRS&    queryPropFont();
#pragma SOMNoMangling(off)
    virtual void       setFont(char *name=0, int size=0, int monospaced=-1);
    virtual void       setFont(FATTRS& f);
#pragma SOMNoMangling(pop)

// "interne" Funktionen, sollten vorsichtig benutzt werden
    virtual ActionBase *queryAction(unsigned id);
    virtual char      *queryHelptext(unsigned id);
    virtual void       setFrame(HWND h);
    virtual void       setToolbar(HWND h);
    virtual void       setStatusbar(HWND h);
    virtual void       setMle(HWND h);
    virtual void       setMaxLine(int i);
    virtual void       setCurLine(int i);
    virtual void       setCurColumn(int i);
    virtual void       setModified(int i);
    virtual void       updateStatusline(int force=FALSE);
    virtual void       cleanContextMenu();
    virtual void       setInitFile(char *s);
    virtual void       process(Editor *e);
    virtual void       threadEntry();

    virtual int        open();
    virtual int        saveas();
    virtual int        quit();
    virtual int        print();
    virtual int        dlgSearch();
    virtual int        monoFont();
    virtual int        setMonoFont();
    virtual int        propFont();
    virtual int        setPropFont();
    virtual int        fontToggle();
    virtual int        colorPalette();
    virtual int        wordWrapOn();
    virtual int        wordWrapOff();
    virtual int        toolbarToggle();
    virtual int        autoIndentToggle();
    virtual int        quickmarkToggle();
    virtual int        about();
    virtual void       ctInitEditorWindow();
    virtual void       ctDeInitEditorWindow();
    virtual void       ctNewName(char *name);
    virtual void       ctContextMenu(char *name, char *selection);
    virtual MRESULT    pmmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
/* SOMEditor */
#pragma SOMReleaseOrder( \
)
  };
