/* globale Variablen */
int cruise_active = 1;	/* zu Beginn: "cruise" */
int photo_active  = 0;
int ir_active     = 0;
int bump_active   = 0;
float cruise_t,photo_t,ir_t,bump_t;
float cruise_r,photo_r,ir_r,bump_r;


void wait(int milli_seconds)	/* Basis-Operation  */
{ long timer_a;	/* Warten ohne "busy wait" */
  timer_a = mseconds() + (long) milli_seconds;
  while( timer_a > mseconds() )
  { defer(); }	/* Freigabe des Prozessors */
}


void motor_control()	/* Konfliktauflsung, S-Knoten */
{ while (1) {
   printf("Suche Licht-");	/* Test-Ausgabe auf LCD */
   
   if (photo_active) {	/* Ziel erreicht: Prioritt 1 */
      printf("ZIEL\n");
      drive(photo_t,photo_r);	/* Fahrbefehl: Geschw.+Drehg. */
      tune();	/* Melodie spielen */
      while (1) {}	/* Programm-Stop mit busy wait */
     }
     else if (bump_active) {	/* Kollision: Prioritt 2 */
      printf("BMP \n");
      drive(bump_t,bump_r);
          }
     else if (ir_active) {	/* Infrarot: Prioritt 3 */
      printf("IR  \n");
      drive(ir_t,ir_r);
          }
     else if (cruise_active) {	/* Default: Prioritt 4 */
            printf("CRUI\n");
            drive(cruise_t,cruise_r);
          }
     else drive(0.0,0.0);	/* Stop, nichts aktiv */
   defer();	/* nchster Proze */
  }
}


int cruise()	/* Default-Aktivitt */
{ while(1) {	/* Endlosschleife */
    cruise_t =  30.0;	/* Geschwindigkeit setzen */
    cruise_r =   5.0;	/* Drehgesch.leichte Linkskurve*/
    cruise_active = 1;	/* immer aktiv */
    wait(1000);	/* 1 Sek. lang      */
  }
}


int photo()	/* Stop falls Licht */
{ int bright;
  while (1) {     	/* 0 (hell) .. */
    bright = 510 - (analog(1) + analog(0)); /* 255 (dunkel) */
    if (bright > 500) {	/* Schwellwert */
      photo_t = 0.0;	/* Anhalten */
      photo_r = 0.0;
      photo_active = 1;
    }
  }
  defer();
}


void bump()	/* Test auf Kollisionen */
{ int bstat;
  while (1) {	
    bstat = bumper();	/* Bumperstatus auslesen */
    if (bstat & 0b010)	/* linker Bumper aktiv */
     { bump_t = -30.0;	/* Zurckfahren */
       bump_r =   0.0;
       bump_active = 1;
       wait(700);	
       bump_t =   0.0;	/* nach rechts drehen */
       bump_r = -40.0;
       wait(500);
     }	
     else if (bstat & 0b001)	/* rechter Bumper aktiv */
      { bump_t = -30.0;	/* Zurckfahren */
        bump_r =   0.0;
        bump_active = 1;
        wait(700);	
        bump_t =   0.0;	/* nach links drehen */
        bump_r =  40.0;
        bump_active = 1;
        wait(500);
      }
     else if (bstat & 0b100)	/* hinterer Bumper */
      { bump_t =   0.0;	/* nach rechts drehen */
        bump_r = -40.0;
        bump_active = 1;
        wait(1000);
      }
    else bump_active = 0;
   defer();	/* nchsten Proze aktivieren */
 }
}


void ir()	/* Test Infrarot-Sensoren */
{ int val;
  while (1) {
    val = ir_detect();	/* Sensor auslesen */
    if ((val == 0b10) || (val == 0b11))	/* Infrarot links oder beide */
     { ir_t =  20.0;	/* Bogen nach rechts */
       ir_r = -20.0;
       ir_active = 1;
     }
     else if (val == 0b01)	/* Infrarot rechts aktiv */
      { ir_t =  20.0;	/* Bogen nach links */
        ir_r =  20.0;
        ir_active = 1;
      }
     else ir_active = 0;
    sleep(0.1);
    defer();
  }
}


void tune()	/* Ziel-Melodie */
{ tone( 698.5,0.2);	/* Frequenz und Tondauer */
  tone( 851.5,0.2);
  tone(1046.5,0.2);
  tone(1396.9,0.8);
 }



void main()	/* Hauptprogramm    */
{  sleep(1.0);	/* 1 Sec. warten    */
   start_process(motor_control());	/* Prozesse starten */
   start_process(cruise());
   start_process(photo());
   start_process(ir());
   start_process(bump());
}	/* Prozesse laufen parallel */


