#define STRICT               // Striktere Typprfungen einschalten
#define WIN32_LEAN_AND_MEAN  // Nur wichtige Headerfiles compilieren
#include <windows.h>
#include <stdio.h>

int main() {
  HMODULE hDLL;
  FARPROC lpfnMessageBox;

  printf("Demonstration: Runtime Dynamic Linking\n\n");

  printf("Lade DLL USER32.DLL...");
  hDLL=LoadLibrary("USER32.DLL"); // DLL laden
  if (hDLL==0) { // Fehler?
    printf(" miglckt!\n");
    return 0;
  }
  printf(" Module-Handle der DLL: 0x%x\n\n",hDLL);

  printf("Erfrage Adresse der MessageBox()-Funktion...");
  lpfnMessageBox=GetProcAddress(hDLL,"MessageBoxA"); // Adresse lesen
  // "MessageBoxA", weil die ANSI-Version der Funktion gebraucht wird
  // (siehe Kasten Unicode)
  
  if (lpfnMessageBox==NULL) { // Fehler?
    printf(" miglckt!\n");
    return 0;
  }
  printf(" Adresse der Funktion: 0x%x\n\n",lpfnMessageBox);

  printf("Rufe MessageBox() via lpfnMessageBox auf...");
  // MessageBox() aufrufen
  lpfnMessageBox(NULL,"Eine dynamische MessageBox!","MBOX.EXE",MB_OK);

  FreeLibrary(hDLL); // Bibliothek freigeben
  return 0;
}

