//#define UNICODE   // Unicode fr Win32-Headerfiles einschalten
//#define _UNICODE  // Die C-Header brauchen eine separate Einladung

#define STRICT               // Striktere Typprfungen einschalten
#define WIN32_LEAN_AND_MEAN  // Nur wichtige Headerfiles compilieren
#include <windows.h>
#include <stdio.h>
#include <tchar.h> // Unicode-Layer fr C-Runtime-Aufrufe

#define RED_ON_BLUE FOREGROUND_RED|BACKGROUND_BLUE
#define BLUE_ON_RED FOREGROUND_BLUE|BACKGROUND_RED

HANDLE hOut, hIn;
CONSOLE_SCREEN_BUFFER_INFO csbi;

// Fllt den kompletten Schirm mit einem Vordergrund/Hintergrundattribut
VOID FillScreenAttr(WORD wAttr);
VOID FillScreenAttr(WORD wAttr)
{
  DWORD dwWritten;
  COORD coPos;
  coPos.X=0; coPos.Y=0;  // Oben links
  FillConsoleOutputAttribute(hOut, // Console-Output-Handle
    wAttr, // Farbattribut
    (csbi.dwSize.X)*(csbi.dwSize.Y), // Anzahl zu fllender Zellen
    coPos, // Startposition
    &dwWritten); // Anzahl gefllter Zellen
}

// Fllt den kompletten Schirm mit einem Zeichen
VOID FillScreenChar(TCHAR ch);
VOID FillScreenChar(TCHAR ch)
{
  DWORD dwWritten;
  COORD coPos;
  coPos.X=0; coPos.Y=0;
  // Siehe FillConsoleOutputAttribute()
  FillConsoleOutputCharacter(hOut,ch, // ch ist auszugebendes Zeichen
    (csbi.dwSize.X)*(csbi.dwSize.Y),coPos,&dwWritten);
}

// Wartet auf ein Zeichen (Ctrl oder Shift bewirken nichts)
VOID kbhit1(VOID);
VOID kbhit1(VOID)
{
  TCHAR ch;
  DWORD dwRead;
  ReadConsole(hIn,&ch,1,&dwRead,NULL);
}

// Wartet auf eine beliebige gedrckte Taste (auch Ctrl et cetera)
VOID kbhit2(VOID);
VOID kbhit2(VOID)
{
  INPUT_RECORD ir;
  DWORD dwRead;
  do {
    ReadConsoleInput(hIn,&ir,1,&dwRead);
    if ((ir.EventType==KEY_EVENT) // Warten auf Tastatur-Event und...
       &&(ir.Event.KeyEvent.bKeyDown==TRUE)) // gedrckte Taste
       break;
  } while (TRUE);
}

int main() {
  COORD coPos;
  DWORD dwWritten,dwRead,i;
  TCHAR szHello[]=TEXT("Hello, World!");
  TCHAR szEmpty[]=TEXT("             ");
  WORD awAttr[80];
  SMALL_RECT srctSource;
  CHAR_INFO chi;
  INPUT_RECORD ir;
  CONSOLE_CURSOR_INFO cci;

  hOut=GetStdHandle(STD_OUTPUT_HANDLE); // Standard-Input- und
  hIn=GetStdHandle(STD_INPUT_HANDLE);   // Output-Handle lesen

  SetConsoleMode(hIn,ENABLE_MOUSE_INPUT|ENABLE_WINDOW_INPUT);
   // Mauseingabe und Window-Buffer-Events aktivieren
  GetConsoleScreenBufferInfo(hOut,&csbi); // Information ber die Console
  _tprintf(TEXT("Anzahl Spalten: %d  Anzahl Zeilen: %d\n"),
    csbi.dwSize.X,csbi.dwSize.Y);
  _tprintf(TEXT("Aktuelle Cursor-Position: %d,%d\n"),
    csbi.dwCursorPosition.X,csbi.dwCursorPosition.Y);
  kbhit1(); // beliebiges Zeichen lesen, Variante 1

  FillScreenAttr(RED_ON_BLUE);
  for (i=32;i<128;i++)
    FillScreenChar((TCHAR)i);
  coPos.X=0; coPos.Y=0;
  SetConsoleCursorPosition(hOut,coPos); // Cursor-Position setzen
  kbhit2(); // beliebiges Zeichen lesen, Variante 2

  FillScreenChar(TEXT(' ')); // Bildschirm lschen
  for (i=0;i<_tcslen(szHello);i++) // awAttr mit Attributen fllen
    awAttr[i]=BLUE_ON_RED;
  for (i=0;i<6;i++) {
    coPos.X=(short)i*2; coPos.Y=(short)i;
    // Ausreichend viele Zellen mit BLUE_ON_RED fllen
    WriteConsoleOutputAttribute(hOut, // Handle
      awAttr, // Array mit Farbattributen
      _tcslen(szHello), // Gre des Arrays == Lnge von szHello
      coPos, // Position
      &dwWritten); // Anzahl gescxhriebene Attribute
    // In die gleichen Zellen szHello ausgeben
    WriteConsoleOutputCharacter(hOut,szHello,_tcslen(szHello),
      coPos,&dwWritten);
  }
  #ifdef UNICODE
    chi.Char.UnicodeChar=L'#';
  #else
    chi.Char.AsciiChar='#';
  #endif
  chi.Attributes=RED_ON_BLUE;
  for (i=0;i<(DWORD)csbi.dwSize.Y-6;i++) {
    coPos.X=(short)i+1; coPos.Y=(short)i+1;
    srctSource.Left=(short)i; srctSource.Top=(short)i;
    srctSource.Right=(short)i+22; srctSource.Bottom=(short)i+6;
    // Einen Teil des Bildschirms scrollen
    ScrollConsoleScreenBuffer(hOut,
      &srctSource, // Gre des Scrollbereichs
      NULL,  // Clipping-Rechteck, nicht verwendet
      coPos, // neue Position des Scrollbereichs
      &chi); // Fllzeichen und -attribut fr den freiwerdenen Bereich
    Sleep(40); // Ein wenig warten
  }


  GetConsoleCursorInfo(hOut,&cci); // Cursor-Information lesen
  cci.bVisible=FALSE; // Cursor unsichtbar machen
  SetConsoleCursorInfo(hOut,&cci); // Cursor-Information setzen

  coPos.X=999; coPos.Y=999;
  do {
    // Eingabe (INPUT_RECORD) lesen
    ReadConsoleInput(hIn,&ir,1,&dwRead);
    if (ir.EventType==MOUSE_EVENT) { // Mausaktivitt
      if (memcmp(&coPos,&ir.Event.MouseEvent.dwMousePosition,
        sizeof(COORD))) { // alte Mausposition ungleich neuer?
          // Ja: String an der alten Position mit Blanks berschreiben
          WriteConsoleOutputCharacter(hOut,szEmpty,_tcslen(szEmpty),
            coPos,&dwWritten);
          // Neue Position speichern
          coPos=ir.Event.MouseEvent.dwMousePosition;
          // und dort szHello ausgeben
          WriteConsoleOutputCharacter(hOut,szHello,_tcslen(szHello),
            coPos,&dwWritten);
      }
    }
  } while (ir.Event.KeyEvent.wVirtualKeyCode!=27); // bis escape kommt

  // Cursor wieder sichtbar machen
  cci.bVisible=TRUE;
  SetConsoleCursorInfo(hOut,&cci);

  return 0;
}

