#include "wpedit.hh"
#include "edit.h"
#include <somcls.hh>

// Finde den module handle heraus
HMODULE queryModuleHandle(void)
  {
  static HMODULE hmod=0;
  PSZ pathname;

  if (!hmod)
     {
     pathname=SOMClassMgrObject->somLocateClassFile(somIdFromString("WPEdit"), 1,2);
     DosQueryModuleHandle(pathname, &hmod);
     } /* endif: !hmod */
  return hmod;
  } /* queryModuleHandle */

// Klassenstil
ULONG M_WPEdit::wpclsQueryStyle()
  {
  return M_WPProgram::wpclsQueryStyle()|CLSSTYLE_NEVERTEMPLATE|CLSSTYLE_NEVERCOPY;
  } /* M_WPEdit::wpclsQueryStyle */

// Was ist der Default Title?
PSZ M_WPEdit::wpclsQueryTitle()
  {
  return "DTS-Editor";
  } /* M_WPEdit::wpclsQueryTitle */

// Session Page hinzufgen?!?
ULONG WPEdit::wpAddProgramSessionPage(HWND hwndNotebook)
  {
  // Parent NICHT aufrufen
  return SETTINGS_PAGE_REMOVED;
  } /* WPEdit::wpAddProgramSessionPage */

// Welche Punkte im Popup-Men?
BOOL WPEdit::wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr, ULONG iPosition)
  {
  // neuer Menpunkt
  wpInsertPopupMenuItems(hwndMenu, iPosition,
                         queryModuleHandle(),
                         ID_CONTEXTMENU, WPMENUID_OPEN);
  // Parent aufrufen fr alle anderen Menpunkte
  return WPProgram::wpModifyPopupMenu(hwndMenu, hwndCnr, iPosition);
  } /* WPEdit::wpModifyPopupMenu */

// ulMenuId wurde ausgewhlt, was tun?
BOOL WPEdit::wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId)
  {
  if (ulMenuId==ID_EDMODULE)
     {
     // eigener Menpunkt, Folder ffnen
     HOBJECT hobject;
     char *pPath;
     char path[CCHMAXPATH];

     // Pfad: Entweder Environment-Variable oder Unterverzeichnis
     if (!DosScanEnv("EDITMODPATH", (PCSZ*)&pPath))
        {
        strcpy(path, pPath);
        if (path[strlen(path)-1]!='\\')
           strcat(path, "\\");
        } /* endif: !DosScanEnv("EDITMODPATH", (PCSZ*)&pPath) */
     else
        {
        ULONG size;
        PROGDETAILS *progDetails;
        char *p;

        path[0]=0;
        wpQueryProgDetails(0, &size);
        progDetails=(PROGDETAILS *)wpAllocMem(size, 0);
        if (progDetails)
           {
           wpQueryProgDetails(progDetails, &size);
           if (progDetails->pszExecutable)
              strcpy(path, progDetails->pszExecutable);
           } /* endif: progDetails */
        p=path+strlen(path);
        while (p>path && *p!=':' && *p!='\\') --p;
        if (*p=='\\') *(p+1)='\0';
        } /* endelse */
     strcat(path, "MODULE");
     // Folder ffnen, _nicht_ SOM, dafr kurz
     hobject=WinQueryObject(path);
     WinSetObjectData(hobject, "ALWAYSSORT=YES;OPEN=DEFAULT");
     return TRUE;
     }
  // Parent aufrufen
  return WPProgram::wpMenuItemSelected(hwndFrame, ulMenuId);
  }
