#ifndef _EDITOR_H_
#define _EDITOR_H_

#include "common.h"
#include "action.h"
#include "string.h"
#include "toolbar.h"
#include "statbar.h"
#include "menu.h"
#include "edit.h"
#include "ctedit.h"
#include "api.h"
#include "sema4.h"
#include "thread.h"
#include "action.h"
#ifdef DTS_EDITDLL
  #include "bedit.hh"
#endif

class ActionList;

void initDefaultAction(ActionList& list);
extern void save(HWND hwnd, char *name);
extern int load(HWND hwnd, char *name);
BOOL loadMLE(HWND hwnd, char *name);

#define USER_OFFSET_ID 1000
#define PERMUSER_OFFSET_ID 900

#ifdef NO_VIRTUALFN
 #define virtual
#endif

struct Ini
  {
  FATTRS mfont;
  FATTRS pfont;
  BOOL   type;
  BOOL   toolbar;
  BOOL   quickmark;
  BOOL   indent;
  BOOL   wrap;
  int    bkColor;
  int    fgColor;
  };

#ifdef DTS_EDITDLL
class AppEditor : public Editor
#else
class AppEditor : public Thread
#endif
  {
#ifdef DTS_EDITDLL
#ifdef DTS_NOIDL
 #pragma SOMClassName(*, "SOMEditor")
#else
 #pragma SOMClassName(*, "AppEditor")
#endif
 #pragma SOMClassVersion(*,1,0)
#endif
    HWND       frame;
    HWND       toolbar;
    HWND       mle;
    HWND       statusbar;
    EString    name;
    ActionList actionlist;
    FATTRS     mfont;
    FATTRS     pfont;
    BOOL       font;                         /* monospaced oder proportional */
    BOOL       showToolbar;
    BOOL       indent;
    BOOL       quickmark;
    int        maxline;
    int        curline;
    int        modified;
    int        updateStatus;
    int        current_uid;
    int        current_id;
    int        current_cid;
    int        curcol;
    HWND       contextMenu;
  public:
    AppEditor();
    virtual ~AppEditor() {}
#ifndef DTS_EDITDLL
    typedef int (AppEditor::*ActionMemberFnPtr)();
#endif
// "interne" Informationen
            HWND       queryFrame()                   { return frame; }
            HWND       queryContextMenu()             { return contextMenu; }
            HWND       queryToolbar()                 { return toolbar; }
            HWND       queryMle()                     { return mle; }

// Datei (laden, speichern, exportieren, ...)
    virtual char      *queryName()                    { return (char *)name; }
    virtual char      *setName(char *x);
    virtual void       load(char *s);
    virtual void       save(char *s=0);
    virtual BOOL       getText(char *buffer, int length, int pos=0);
    virtual BOOL       getTextLine(char *buffer, int length, int line);
    virtual void       loadini();
    virtual void       saveini();

// Editieren (cut, paste, ...)
    virtual void       add(char *text, BOOL changeCurPos=FALSE, int offset=-1);  // Hinzufgen an der akt. Cursorpos
    virtual void       addLine(char *text, BOOL changeCurPos, int offset=-1);
            BOOL       isChanged();
    virtual void       clear();
    virtual void       clearAll() { setText(""); }
    virtual void       copy();
    virtual void       cut();
    virtual void       paste();
    virtual void       insert(char *text);
    virtual void       discard();     // delete marked text
    virtual void       undo();
    virtual void       markall();
            void       disableUpdate();
            void       enableUpdate();
    virtual void       setWordWrap(BOOL w=TRUE);
            BOOL       queryWordWrap();
            void       setReadOnly(BOOL set=TRUE);
            BOOL       queryReadOnly();
            void       setChangedFlag(BOOL c);
            void       resetChangedFlag() { setChangedFlag(FALSE); }
            void       removeLine(int line);
            int        queryNrOfLines();
            void       setText(char *);
            int        queryTextLength();

// Cursor
            int        queryCurrentLine();
            int        queryCurrentCol();
            int        queryCurrentCurPos();

            void       setCurrentLine(int line);
            void       setCurrentCol(int col);
            void       setCurrentCurPos(int pos);

// Features (Toolbar, ...)
    virtual void       setStatusText(char *s)
                          { WinSendMsg(statusbar, SB_SETTEXT, (MPARAM)s, 0); }
    virtual BOOL       queryIndent() { return indent; }
    virtual void       setIndent(BOOL b);
    virtual BOOL       queryQuickmark() { return quickmark; }
    virtual void       setQuickmark(BOOL b);
    virtual BOOL       queryHideToolbar();
    virtual void       hideToolbar(BOOL b);
    virtual ActionFnPtr addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                         int flag=MENU_TEMPITEM, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual ActionFnPtr addMenuItem(ActionFnPtr p, int mainmenu, char *s1, char *s2,
                         int flag=MENU_TEMPITEM, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual int        addContextMenu(ActionFnPtr p, int mainmenu, char *entry, char *description, int *ret_id=0);
#ifdef DTS_EDITDLL
    virtual ActionFnPtr addToolbarButton(ActionMemberFnPtr p, char *s1, char *s2,
                         int flag=MENU_TEMPITEM, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual ActionFnPtr addMenuItem(ActionMemberFnPtr p, int mainmenu, char *s1, char *s2,
                         int flag=MENU_TEMPITEM, HMODULE h=0, unsigned r=0, int *ret_id=0);
    virtual int        addContextMenu(ActionMemberFnPtr p, int mainmenu, char *entry, char *description, int *ret_id=0);
#endif
    virtual BOOL       doAction(int i);
    virtual BOOL       search(char *s, int offset=-1);

// Hilfsfunktionen
            void       setConditionalMenu(int submenuid, int defaultid)
                          { ::setConditionalMenu(frame, submenuid, defaultid); }
            void       setMenuChecked(int id, BOOL set=TRUE)
                          { ::setMenuChecked(frame, id, set); }
// Farbe
            void       setColor(int color)
                          { setBkColor(color); }
            unsigned   queryBkColor();
            void       setBkColor(unsigned color=CLR_WHITE);
            unsigned   queryFgColor();
            void       setFgColor(unsigned color=CLR_BLACK);

// Font
            void       setFonttype(BOOL b) { font=b; }
            BOOL       queryFonttype() { return font; }
            FATTRS&    queryMonoFont() { return mfont; }
            FATTRS&    queryPropFont() { return pfont; }
            void       setFont(char *name=0, int size=0, int monospaced=-1);
            void       setFont(FATTRS& f);

// "interne" Funktionen, sollten vorsichtig benutzt werden
            ActionBase *queryAction(unsigned id);
            char      *queryHelptext(unsigned id);
            void       setFrame(HWND h)               { frame=h; }
            void       setToolbar(HWND h)             { toolbar=h; }
            void       setStatusbar(HWND h)           { statusbar=h; }
            void       setMle(HWND h)                 { mle=h; }
            void       setMaxLine(int i)
                          { updateStatus=updateStatus || (i!=maxline); maxline=i; }
            void       setCurLine(int i)
                          { updateStatus=updateStatus || (i!=curline); curline=i; }
            void       setCurColumn(int i)
                          { updateStatus=updateStatus || (i!=curcol); curcol=i; }
            void       setModified(int i)
                          { updateStatus=updateStatus || (i!=modified); modified=i; }
            void       updateStatusline(int force=FALSE);
            void       cleanContextMenu();
    virtual void       setInitFile(char *s) { name=s; }
#ifdef DTS_EDITDLL
    virtual void       process(Editor *e);
#else
    virtual void       process(AppEditor *e);
#endif
    virtual void       threadEntry() { process(this); }
    virtual MRESULT    pmmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) { return 0; }

            int        open();
            int        saveas() { save("");  return TRUE; }
            int        quit() { WinPostMsg(frame, WM_QUIT, 0, 0); return TRUE; }
            int        print();
            int        dlgSearch();
            int        monoFont() { setFont(queryMonoFont()); return 0; }
            int        setMonoFont();
            int        propFont() { setFont(queryPropFont()); return 0; }
            int        setPropFont();
            int        fontToggle();
            int        colorPalette();
            int        wordWrapOn() { setWordWrap(TRUE); return 0; }
            int        wordWrapOff() { setWordWrap(FALSE); return 0; }
            int        toolbarToggle() { hideToolbar(!queryHideToolbar()); return 0; }
            int        autoIndentToggle() { setIndent(!queryIndent()); return 0; }
            int        quickmarkToggle() { setQuickmark(!queryQuickmark()); return 0; }
            int        about();
    virtual void       ctInitEditorWindow() {}
    virtual void       ctDeInitEditorWindow() {}
    virtual void       ctNewName(char *name) {}
    virtual void       ctContextMenu(char *name, char *selection) {}
  };
#ifdef virtual
 #undef virtual
#endif

#ifndef DTS_EDITDLL
 typedef AppEditor Editor;
 #define USE_EDITOR
#endif

#endif
