#ifndef _EDITAPI_H_
#define _EDITAPI_H_

#ifdef __cplusplus
  extern "C" {
#endif

typedef int (* APIENTRY FnPtr)();
typedef void *PEditor;
typedef int (* APIENTRY ActionFnPtr)(PEditor frame);

void APIENTRY EdInitialize(void *vtbl);
PEditor APIENTRY EdHandleFromHwnd(HWND hwnd);

ActionFnPtr APIENTRY EdAddToolbarButton(void *e, ActionFnPtr p, char *s1, char *s2,
           int flag, HMODULE h, unsigned r, int *ret_id);
int APIENTRY EdAddContextMenu(void *e, int id, ActionFnPtr p, char *s1, char *s2, int *ret_id);
ActionFnPtr APIENTRY EdAddMenuItem(void *e, int mainmenu, ActionFnPtr p, char *s1, char *s2,
           int flag, HMODULE h, unsigned r, int *ret_id);

void APIENTRY EdLoadFile(PEditor e, char *file);
void APIENTRY EdSaveFile(PEditor e);
void APIENTRY EdSaveFileAs(PEditor e, char *name);
int  APIENTRY EdGetText(PEditor e, char *buffer, int length);
int  APIENTRY EdGetTextOffset(PEditor e, char *buffer, int length, int offset);
int  APIENTRY EdGetTextLine(PEditor e, char *buffer, int length, int line);
void APIENTRY EdSaveIni(PEditor e);
void APIENTRY EdAddText(PEditor e, char *text);
void APIENTRY EdAddTextOffset(PEditor e, char *text, int offset);
void APIENTRY EdAddLine(PEditor e, char *text, int line);
BOOL APIENTRY EdIsChanged(PEditor e);
void APIENTRY EdClear(PEditor e);
void APIENTRY EdClearAll(PEditor e);
void APIENTRY EdCopy(PEditor e);
void APIENTRY EdCut(PEditor e);
void APIENTRY EdPaste(PEditor e);
void APIENTRY EdInsert(PEditor e, char *text);
void APIENTRY EdDelete(PEditor e);
void APIENTRY EdUndo(PEditor e);
void APIENTRY EdMarkall(PEditor e);
void APIENTRY EdDisableUpdate(PEditor e);
void APIENTRY EdEnableUpdate(PEditor e);
void APIENTRY EdSetWordWrap(PEditor e, BOOL b);
BOOL APIENTRY EdQueryWordWrap(PEditor e);
void APIENTRY EdSetReadOnly(PEditor e, BOOL b);
BOOL APIENTRY EdQueryReadOnly(PEditor e);
void APIENTRY EdSetChangedFlag(PEditor e, BOOL b);
void APIENTRY EdResetChangedFlag(PEditor e);
void APIENTRY EdRemoveLine(PEditor e, int line);
int  APIENTRY EdQueryNrOfLines(PEditor e);
void APIENTRY EdSetText(PEditor e, char *text);
int  APIENTRY EdQueryTextLength(PEditor e);
int  APIENTRY EdQueryCurrentLine(PEditor e);
int  APIENTRY EdQueryCurrentCol(PEditor e);
int  APIENTRY EdQueryCurrentCurPos(PEditor e);
void APIENTRY EdSetCurrentLine(PEditor e, int line);
void APIENTRY EdSetCurrentCol(PEditor e, int col);
void APIENTRY EdSetCurrentColPos(PEditor e, int pos);
void APIENTRY EdSetStatusText(PEditor e, char *text);
BOOL APIENTRY EdQueryIndent(PEditor e);
void APIENTRY EdSetIndent(PEditor e, BOOL b);
BOOL APIENTRY EdQueryQuickmark(PEditor e);
void APIENTRY EdSetQuickmark(PEditor e, BOOL b);
BOOL APIENTRY EdQueryToolbar(PEditor e);
void APIENTRY EdSetToolbar(PEditor e, BOOL b);
BOOL APIENTRY EdDoAction(PEditor e, int i);
BOOL APIENTRY EdSearch(PEditor e, char *s);
void APIENTRY EdSetConditionalMenu(PEditor e, int submenuid, int defaultid);
void APIENTRY EdSetMenuChecked(PEditor e, int id, BOOL b);
int  APIENTRY EdQueryBkColor(PEditor e);
void APIENTRY EdSetBkColor(PEditor e, int color);
int  APIENTRY EdQueryFgColor(PEditor e);
void APIENTRY EdSetFgColor(PEditor e, int color);
void APIENTRY EdSetFontName(PEditor e, char *name);
void APIENTRY EdSetFontSize(PEditor e, int size);
void APIENTRY EdSetFontType(PEditor e, int type);

#ifdef __cplusplus
  }
#endif

#endif
